/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.BarcodeParser;
import net.sf.picard.illumina.parser.BclParser;
import net.sf.picard.illumina.parser.CifParser;
import net.sf.picard.illumina.parser.CnfParser;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.FilterParser;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PosParser;
import net.sf.picard.illumina.parser.QseqParser;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class IlluminaDataProviderFactory {
    private static final Log log = Log.getInstance(IlluminaDataProviderFactory.class);
    private static final Map<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>> DATA_TYPE_TO_PREFERRED_FORMATS = new HashMap<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>>();
    private final File basecallDirectory;
    private final int lane;
    private final File intensitiesDirectory;
    private final Set<IlluminaDataType> dataTypes;
    protected final Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToDataTypes;
    private final IlluminaFileUtil fileUtil;
    private final List<Integer> availableTiles;
    private final OutputMapping outputMapping;

    public IlluminaDataProviderFactory(File basecallDirectory, int lane, ReadStructure readStructure, IlluminaDataType ... dataTypes) {
        this.basecallDirectory = basecallDirectory;
        this.intensitiesDirectory = basecallDirectory.getParentFile();
        this.lane = lane;
        this.dataTypes = Collections.unmodifiableSet(new HashSet<IlluminaDataType>(Arrays.asList(dataTypes)));
        if (this.dataTypes.isEmpty()) {
            throw new PicardException("No data types have been specified for basecall output " + basecallDirectory + ", lane " + lane);
        }
        this.fileUtil = new IlluminaFileUtil(basecallDirectory, lane);
        this.formatToDataTypes = IlluminaDataProviderFactory.determineFormats(this.dataTypes, this.fileUtil);
        Set<IlluminaDataType> unmatchedDataTypes = IlluminaDataProviderFactory.findUnmatchedTypes(this.dataTypes, this.formatToDataTypes);
        if (unmatchedDataTypes.size() > 0) {
            throw new PicardException("Could not find a format with available files for the following data types: " + StringUtil.join(", ", new ArrayList<IlluminaDataType>(unmatchedDataTypes)));
        }
        StringBuilder sb = new StringBuilder(400);
        sb.append("The following file formats will be used by IlluminaDataProvier: ");
        sb.append(StringUtil.join("," + this.formatToDataTypes.keySet(), new Object[0]));
        log.debug(sb.toString());
        this.availableTiles = this.fileUtil.getActualTiles(new ArrayList<IlluminaFileUtil.SupportedIlluminaFormat>(this.formatToDataTypes.keySet()));
        if (this.availableTiles.isEmpty()) {
            throw new PicardException("No available tiles were found, make sure that " + basecallDirectory.getAbsolutePath() + " has a lane " + lane);
        }
        this.outputMapping = new OutputMapping(readStructure);
    }

    public ReadStructure getOutputReadStructure() {
        return this.outputMapping.getOutputReadStructure();
    }

    public List<Integer> getAvailableTiles() {
        return this.availableTiles;
    }

    public IlluminaDataProvider makeDataProvider() {
        return this.makeDataProvider(null);
    }

    public IlluminaDataProvider makeDataProvider(List<Integer> requestedTiles) {
        if (requestedTiles == null) {
            requestedTiles = this.availableTiles;
        } else if (requestedTiles.size() == 0) {
            throw new PicardException("Zero length tile list supplied to makeDataProvider, you must specify at least 1 tile OR pass NULL to use all available tiles");
        }
        HashMap<IlluminaParser, Set<IlluminaDataType>> parsersToDataType = new HashMap<IlluminaParser, Set<IlluminaDataType>>();
        for (Map.Entry<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> fmToDt : this.formatToDataTypes.entrySet()) {
            parsersToDataType.put(this.makeParser(fmToDt.getKey(), requestedTiles), fmToDt.getValue());
        }
        StringBuilder sb = new StringBuilder(400);
        sb.append("The following parsers will be used by IlluminaDataProvier: ");
        sb.append(StringUtil.join("," + parsersToDataType.keySet(), new Object[0]));
        log.debug(sb.toString());
        return new IlluminaDataProvider(this.outputMapping, parsersToDataType, this.basecallDirectory, this.lane);
    }

    public static Set<IlluminaDataType> findUnmatchedTypes(Set<IlluminaDataType> requestedDataTypes, Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToMatchedTypes) {
        HashSet<IlluminaDataType> copiedTypes = new HashSet<IlluminaDataType>(requestedDataTypes);
        for (Set<IlluminaDataType> matchedTypes : formatToMatchedTypes.values()) {
            copiedTypes.removeAll(matchedTypes);
        }
        return copiedTypes;
    }

    public static Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> determineFormats(Set<IlluminaDataType> requestedDataTypes, IlluminaFileUtil fileUtil) {
        TreeSet<IlluminaDataType> toSupport = new TreeSet<IlluminaDataType>(requestedDataTypes);
        HashMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> fileTypeToDataTypes = new HashMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>>();
        HashMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat> dataTypeToFormat = new HashMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat>();
        boolean useQSeq = false;
        for (IlluminaDataType ts : toSupport) {
            IlluminaFileUtil.SupportedIlluminaFormat preferredFormat = IlluminaDataProviderFactory.findPreferredAvailableFormat(ts, fileUtil);
            if (preferredFormat == null) continue;
            useQSeq |= preferredFormat == IlluminaFileUtil.SupportedIlluminaFormat.Qseq;
            dataTypeToFormat.put(ts, preferredFormat);
        }
        if (useQSeq) {
            HashSet<IlluminaDataType> qseqProvidedTypes = new HashSet<IlluminaDataType>(QseqParser.SUPPORTED_TYPES);
            qseqProvidedTypes.retainAll(toSupport);
            toSupport.removeAll(qseqProvidedTypes);
            fileTypeToDataTypes.put(IlluminaFileUtil.SupportedIlluminaFormat.Qseq, qseqProvidedTypes);
        }
        for (IlluminaDataType dt : toSupport) {
            IlluminaFileUtil.SupportedIlluminaFormat format = (IlluminaFileUtil.SupportedIlluminaFormat)((Object)dataTypeToFormat.get((Object)dt));
            if (format == null) continue;
            if (fileTypeToDataTypes.containsKey((Object)format)) {
                ((Set)fileTypeToDataTypes.get((Object)format)).add(dt);
                continue;
            }
            fileTypeToDataTypes.put((IlluminaFileUtil.SupportedIlluminaFormat)((Object)dataTypeToFormat.get((Object)dt)), CollectionUtil.makeSet(dt));
        }
        return fileTypeToDataTypes;
    }

    public static IlluminaFileUtil.SupportedIlluminaFormat findPreferredAvailableFormat(IlluminaDataType dt, IlluminaFileUtil fileUtil) {
        List<IlluminaFileUtil.SupportedIlluminaFormat> preferredFormats = DATA_TYPE_TO_PREFERRED_FORMATS.get((Object)dt);
        IlluminaFileUtil.SupportedIlluminaFormat format = null;
        for (int i = 0; i < preferredFormats.size() && format == null; ++i) {
            if (!fileUtil.getUtil(preferredFormats.get(i)).filesAvailable()) continue;
            format = preferredFormats.get(i);
        }
        return format;
    }

    private IlluminaParser makeParser(IlluminaFileUtil.SupportedIlluminaFormat format, List<Integer> requestedTiles) {
        IlluminaParser<BarcodeData> parser;
        switch (format) {
            case Barcode: {
                parser = new BarcodeParser(this.fileUtil.barcode().getFiles(requestedTiles));
                break;
            }
            case Bcl: {
                CycleIlluminaFileMap bclFileMap = this.fileUtil.bcl().getFiles(requestedTiles, this.outputMapping.getOutputCycles());
                bclFileMap.assertValid(requestedTiles, this.outputMapping.getOutputCycles());
                parser = new BclParser(this.basecallDirectory, this.lane, bclFileMap, this.outputMapping);
                break;
            }
            case Cif: {
                CycleIlluminaFileMap cifFileMap = this.fileUtil.cif().getFiles(requestedTiles, this.outputMapping.getOutputCycles());
                cifFileMap.assertValid(requestedTiles, this.outputMapping.getOutputCycles());
                parser = new CifParser(this.intensitiesDirectory, this.lane, cifFileMap, this.outputMapping);
                break;
            }
            case Cnf: {
                CycleIlluminaFileMap cnfFileMap = this.fileUtil.cnf().getFiles(requestedTiles, this.outputMapping.getOutputCycles());
                cnfFileMap.assertValid(requestedTiles, this.outputMapping.getOutputCycles());
                parser = new CnfParser(this.intensitiesDirectory, this.lane, cnfFileMap, this.outputMapping);
                break;
            }
            case Filter: {
                IlluminaFileMap filterFileMap = this.fileUtil.filter().getFiles(requestedTiles);
                parser = new FilterParser(filterFileMap);
                break;
            }
            case Locs: 
            case Clocs: 
            case Pos: {
                IlluminaFileUtil.PerTileFileUtil fu = (IlluminaFileUtil.PerTileFileUtil)this.fileUtil.getUtil(format);
                parser = new PosParser(fu.getFiles(requestedTiles), format);
                break;
            }
            case Qseq: {
                List<IlluminaFileMap> readTileMap = this.fileUtil.qseq().getFiles(requestedTiles);
                parser = new QseqParser(this.lane, readTileMap, this.outputMapping);
                break;
            }
            default: {
                throw new PicardException("Unrecognized data type(" + (Object)((Object)format) + ") found by IlluminaDataProviderFactory!");
            }
        }
        return parser;
    }

    static {
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.BaseCalls, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Bcl, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.QualityScores, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Bcl, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.PF, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Filter, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Position, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Locs, IlluminaFileUtil.SupportedIlluminaFormat.Clocs, IlluminaFileUtil.SupportedIlluminaFormat.Pos, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Barcodes, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Barcode));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.RawIntensities, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Cif));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Noise, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Cnf));
    }
}

