/*
 * Decompiled with CFR 0.152.
 */
package prg.rbio.test;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import org.rbio.methyl.rrbs.prep.FastqBisulfiteBuilder;

public class MethylRecordReader {
    private BufferedReader ifq1 = null;
    private BufferedReader ifq2 = null;
    private SAMRecord old_rec = null;
    private SAMRecordIterator bam_itr = null;
    private ReadAl read = new ReadAl();

    public MethylRecordReader(String fq1, String bam) throws Exception {
        this.ifq1 = FastqBisulfiteBuilder.fqReader(fq1);
        SAMFileReader ibam = new SAMFileReader(new File(bam), false);
        ibam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.bam_itr = ibam.iterator();
    }

    public MethylRecordReader(String fq1, String fq2, String bam) throws Exception {
        this(fq1, fq2);
        this.ifq2 = FastqBisulfiteBuilder.fqReader(fq2);
    }

    public void getRead() throws Exception {
        String header1 = this.ifq1.readLine();
        if (header1 != null) {
            String read1 = this.ifq1.readLine();
            this.ifq1.readLine();
            this.ifq1.readLine();
            if (this.ifq2 != null) {
                String header2 = this.ifq2.readLine();
                String read2 = this.ifq2.readLine();
                this.ifq2.readLine();
                this.ifq2.readLine();
                header1 = header1.substring(1, header1.length() - 2);
                header2 = header2.substring(1, header2.length() - 2);
                if (header1.compareTo(header2) != 0) {
                    System.err.println("Reader header do not match for pe read : " + header1 + "\t" + header2);
                } else {
                    this.read.addRead(header1, read1, read2);
                }
            } else {
                this.read.addRead(header1.substring(1), read1, null);
            }
        }
    }

    public ReadAl nextRead() throws Exception {
        ReadAl res = null;
        this.read.reset();
        this.getRead();
        if (this.read.header != null) {
            if (this.old_rec != null) {
                if (this.old_rec.getReadName().compareTo(this.read.header) == 0) {
                    this.read.rec_lst.add(this.old_rec);
                } else {
                    System.err.println("read and record do not match : " + this.read.header + "\t" + this.old_rec);
                }
            }
            while (this.bam_itr.hasNext()) {
                SAMRecord rec = (SAMRecord)this.bam_itr.next();
                if (rec.getReadName().compareTo(this.read.header) == 0) {
                    this.read.rec_lst.add(rec);
                    continue;
                }
                this.old_rec = rec;
                break;
            }
            res = this.read;
        }
        return res;
    }

    public static class ReadAl {
        String header = null;
        String read1 = null;
        String read2 = null;
        List<SAMRecord> rec_lst = new ArrayList<SAMRecord>();

        public void reset() {
            this.header = null;
            this.read1 = null;
            this.read2 = null;
            this.rec_lst.clear();
        }

        public void addRead(String header, String read1, String read2) {
            this.header = header;
            this.read1 = read1;
            this.read2 = read2;
        }
    }
}

