/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.reflections.vfs.SystemFile;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemDir
implements Vfs.Dir {
    private final File file;

    public SystemDir(URL url) {
        this.file = new File(url.getFile());
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Stack<File> stack = new Stack();
                    {
                        this.stack.addAll(SystemDir.listFiles(SystemDir.this.file));
                    }

                    @Override
                    protected Vfs.File computeNext() {
                        while (!this.stack.isEmpty()) {
                            File file = this.stack.pop();
                            if (file.isDirectory()) {
                                this.stack.addAll(SystemDir.listFiles(file));
                                continue;
                            }
                            return new SystemFile(SystemDir.this, file);
                        }
                        return (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.file.toString();
    }

    private static List<File> listFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            return Lists.newArrayList(files);
        }
        return Lists.newArrayList();
    }
}

