/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

public class QualityUtils {
    public static final byte MAX_RECALIBRATED_Q_SCORE = 93;
    public static final byte MAX_QUAL_SCORE = 93;
    public static final double ERROR_RATE_OF_MAX_QUAL_SCORE;
    public static final double MIN_REASONABLE_ERROR = 1.0E-4;
    public static final byte MAX_REASONABLE_Q_SCORE = 40;
    public static final byte MIN_USABLE_Q_SCORE = 6;
    public static final int MAPPING_QUALITY_UNAVAILABLE = 255;
    private static double[] qualToErrorProbCache;
    private static double[] qualToErrorProbLog10Cache;
    private static double[] qualToProbLog10Cache;

    private QualityUtils() {
    }

    public static double qualToProb(byte qual) {
        return 1.0 - QualityUtils.qualToErrorProb(qual);
    }

    public static double qualToProb(double qual) {
        return 1.0 - Math.pow(10.0, qual / -10.0);
    }

    private static double qualToProbLog10Raw(int qual) {
        return Math.log10(1.0 - QualityUtils.qualToErrorProbRaw(qual));
    }

    public static double qualToProbLog10(byte qual) {
        return qualToProbLog10Cache[qual & 0xFF];
    }

    private static double qualToErrorProbRaw(int qual) {
        return Math.pow(10.0, (double)qual / -10.0);
    }

    public static double qualToErrorProb(byte qual) {
        return qualToErrorProbCache[qual & 0xFF];
    }

    private static double qualToErrorProbLog10Raw(int qual) {
        return (double)qual / -10.0;
    }

    public static double qualToErrorProbLog10(byte qual) {
        return qualToErrorProbLog10Cache[qual & 0xFF];
    }

    public static byte probToQual(double prob) {
        return QualityUtils.probToQual(prob, 1.0E-4);
    }

    public static byte probToQual(double prob, double eps) {
        double lp = Math.round(-10.0 * Math.log10(1.0 - prob + eps));
        return QualityUtils.boundQual((int)lp);
    }

    public static double phredScaleCorrectRate(double trueRate) {
        return QualityUtils.phredScaleErrorRate(1.0 - trueRate);
    }

    public static double phredScaleErrorRate(double errorRate) {
        return Math.abs(-10.0 * Math.log10(errorRate));
    }

    public static byte boundQual(int qual) {
        return QualityUtils.boundQual(qual, (byte)93);
    }

    public static byte boundQual(int qual, byte maxQual) {
        return (byte)Math.max(Math.min(qual, maxQual), 1);
    }

    static {
        int i;
        ERROR_RATE_OF_MAX_QUAL_SCORE = QualityUtils.qualToErrorProbRaw(93);
        qualToErrorProbCache = new double[256];
        for (i = 0; i < 256; ++i) {
            QualityUtils.qualToErrorProbCache[i] = QualityUtils.qualToErrorProbRaw(i);
        }
        qualToErrorProbLog10Cache = new double[256];
        for (i = 0; i < 256; ++i) {
            QualityUtils.qualToErrorProbLog10Cache[i] = QualityUtils.qualToErrorProbLog10Raw(i);
        }
        qualToProbLog10Cache = new double[256];
        for (i = 0; i < 256; ++i) {
            QualityUtils.qualToProbLog10Cache[i] = QualityUtils.qualToProbLog10Raw(i);
        }
    }
}

