/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class PhaseByTransmission
extends RodWalker<HashMap<Byte, Integer>, HashMap<Byte, Integer>> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Argument(shortName="mvf", required=false, fullName="MendelianViolationsFile", doc="File to output the mendelian violation details.")
    private PrintStream mvFile = null;
    @Argument(shortName="prior", required=false, fullName="DeNovoPrior", doc="Prior for de novo mutations. Default: 1e-8")
    private double deNovoPrior = 1.0E-8;
    @Argument(shortName="fatherAlleleFirst", required=false, fullName="FatherAlleleFirst", doc="Ouputs the father allele as the first allele in phased child genotype. i.e. father|mother rather than mother|father.")
    private boolean fatherFAlleleFirst = false;
    @Output
    protected VCFWriter vcfWriter = null;
    private final String TRANSMISSION_PROBABILITY_TAG_NAME = "TP";
    private final String SOURCE_NAME = "PhaseByTransmission";
    public final double NO_TRANSMISSION_PROB = -1.0;
    private ArrayList<Sample> trios = new ArrayList();
    private EnumMap<Genotype.Type, EnumMap<Genotype.Type, EnumMap<Genotype.Type, Integer>>> mvCountMatrix;
    private EnumMap<Genotype.Type, EnumMap<Genotype.Type, EnumMap<Genotype.Type, TrioPhase>>> transmissionMatrix;
    private final Byte NUM_TRIO_GENOTYPES_CALLED = 0;
    private final Byte NUM_TRIO_GENOTYPES_NOCALL = 1;
    private final Byte NUM_TRIO_GENOTYPES_PHASED = 2;
    private final Byte NUM_TRIO_HET_HET_HET = 3;
    private final Byte NUM_TRIO_VIOLATIONS = 4;
    private final Byte NUM_TRIO_DOUBLE_VIOLATIONS = 10;
    private final Byte NUM_PAIR_GENOTYPES_CALLED = 5;
    private final Byte NUM_PAIR_GENOTYPES_NOCALL = 6;
    private final Byte NUM_PAIR_GENOTYPES_PHASED = 7;
    private final Byte NUM_PAIR_HET_HET = 8;
    private final Byte NUM_PAIR_VIOLATIONS = 9;
    private final Byte NUM_GENOTYPES_MODIFIED = 11;
    private Random rand = new Random();

    @Override
    public void initialize() {
        ArrayList<String> rodNames = new ArrayList<String>();
        rodNames.add(this.variantCollection.variants.getName());
        Map<String, VCFHeader> vcfRods = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), rodNames);
        Set<String> vcfSamples = SampleUtils.getSampleList(vcfRods, VariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        this.setTrios();
        if (this.trios.size() < 1) {
            throw new UserException.BadInput("No PED file passed or no trios found in PED file. Aborted.");
        }
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        headerLines.addAll(VCFUtils.getHeaderFields(this.getToolkit()));
        headerLines.add(new VCFFormatHeaderLine("TP", 1, VCFHeaderLineType.Integer, "Phred score of the genotype combination and phase given that the genotypes are correct"));
        headerLines.add(new VCFHeaderLine("source", "PhaseByTransmission"));
        this.vcfWriter.writeHeader(new VCFHeader(headerLines, vcfSamples));
        this.buildMatrices();
        if (this.mvFile != null) {
            this.mvFile.println("#CHROM\tPOS\tFILTER\tAC\tFAMILY\tTP\tMOTHER_GT\tMOTHER_DP\tMOTHER_RAD\tMOTHER_AAD\tMOTHER_HRPL\tMOTHER_HETPL\tMOTHER_HAPL\tFATHER_GT\tFATHER_DP\tFATHER_RAD\tFATHER_AAD\tFATHER_HRPL\tFATHER_HETPL\tFATHER_HAPL\tCHILD_GT\tCHILD_DP\tCHILD_RAD\tCHILD_AAD\tCHILD_HRPL\tCHILD_HETPL\tCHILD_HAPL");
        }
    }

    private void setTrios() {
        Map<String, Set<Sample>> families = this.getSampleDB().getFamilies();
        block0: for (String familyID : families.keySet()) {
            Set<Sample> family = families.get(familyID);
            if (family.size() < 2 || family.size() > 3) {
                logger.info(String.format("Caution: Family %s has %d members; At the moment Phase By Transmission only supports trios and parent/child pairs. Family skipped.", familyID, family.size()));
                continue;
            }
            for (Sample familyMember : family) {
                ArrayList<Sample> parents = familyMember.getParents();
                if (parents.size() <= 0) continue;
                if (family.containsAll(parents)) {
                    this.trios.add(familyMember);
                    continue block0;
                }
                logger.info(String.format("Caution: Family %s skipped as it is not a trio nor a parent/child pair; At the moment Phase By Transmission only supports trios and parent/child pairs. Family skipped.", familyID));
                continue block0;
            }
        }
    }

    private void buildMatrices() {
        this.mvCountMatrix = new EnumMap(Genotype.Type.class);
        this.transmissionMatrix = new EnumMap(Genotype.Type.class);
        for (Genotype.Type mother : Genotype.Type.values()) {
            this.mvCountMatrix.put(mother, new EnumMap(Genotype.Type.class));
            this.transmissionMatrix.put(mother, new EnumMap(Genotype.Type.class));
            for (Genotype.Type father : Genotype.Type.values()) {
                this.mvCountMatrix.get((Object)mother).put(father, new EnumMap(Genotype.Type.class));
                this.transmissionMatrix.get((Object)mother).put(father, new EnumMap(Genotype.Type.class));
                for (Genotype.Type child : Genotype.Type.values()) {
                    this.mvCountMatrix.get((Object)mother).get((Object)father).put(child, this.getCombinationMVCount(mother, father, child));
                    this.transmissionMatrix.get((Object)mother).get((Object)father).put(child, new TrioPhase(mother, father, child));
                }
            }
        }
    }

    private int getCombinationMVCount(Genotype.Type mother, Genotype.Type father, Genotype.Type child) {
        if (child == Genotype.Type.NO_CALL || child == Genotype.Type.UNAVAILABLE) {
            return 0;
        }
        ArrayList<Genotype.Type> parents = new ArrayList<Genotype.Type>();
        if (mother != Genotype.Type.NO_CALL && mother != Genotype.Type.UNAVAILABLE) {
            parents.add(mother);
        }
        if (father != Genotype.Type.NO_CALL && father != Genotype.Type.UNAVAILABLE) {
            parents.add(father);
        }
        if (parents.isEmpty()) {
            return 0;
        }
        int parentsNumRefAlleles = 0;
        int parentsNumAltAlleles = 0;
        for (Genotype.Type parent : parents) {
            if (parent == Genotype.Type.HOM_REF) {
                ++parentsNumRefAlleles;
                continue;
            }
            if (parent == Genotype.Type.HET) {
                ++parentsNumRefAlleles;
                ++parentsNumAltAlleles;
                continue;
            }
            if (parent != Genotype.Type.HOM_VAR) continue;
            ++parentsNumAltAlleles;
        }
        if (child == Genotype.Type.HOM_REF) {
            if (parentsNumRefAlleles == parents.size()) {
                return 0;
            }
            return parents.size() - parentsNumRefAlleles;
        }
        if (child == Genotype.Type.HOM_VAR) {
            if (parentsNumAltAlleles == parents.size()) {
                return 0;
            }
            return parents.size() - parentsNumAltAlleles;
        }
        if (child == Genotype.Type.HET && (parentsNumRefAlleles > 0 && parentsNumAltAlleles > 0 || parents.size() < 2)) {
            return 0;
        }
        return 1;
    }

    private int countFamilyGenotypeDiff(Genotype.Type motherOriginal, Genotype.Type fatherOriginal, Genotype.Type childOriginal, Genotype.Type motherNew, Genotype.Type fatherNew, Genotype.Type childNew) {
        int count = 0;
        if (motherOriginal != motherNew) {
            ++count;
        }
        if (fatherOriginal != fatherNew) {
            ++count;
        }
        if (childOriginal != childNew) {
            ++count;
        }
        return count;
    }

    private EnumMap<Genotype.Type, Double> getLikelihoodsAsMapSafeNull(Genotype genotype) {
        if (genotype == null || !genotype.isCalled()) {
            EnumMap<Genotype.Type, Double> likelihoods = new EnumMap<Genotype.Type, Double>(Genotype.Type.class);
            likelihoods.put(Genotype.Type.HOM_REF, 0.3333333333333333);
            likelihoods.put(Genotype.Type.HET, 0.3333333333333333);
            likelihoods.put(Genotype.Type.HOM_VAR, 0.3333333333333333);
            return likelihoods;
        }
        return genotype.getLikelihoods().getAsMap(true);
    }

    private Genotype.Type getTypeSafeNull(Genotype genotype) {
        if (genotype == null) {
            return Genotype.Type.UNAVAILABLE;
        }
        return genotype.getType();
    }

    private int phaseTrioGenotypes(Allele ref, Allele alt, Genotype mother, Genotype father, Genotype child, ArrayList<Genotype> finalGenotypes) {
        EnumMap<Genotype.Type, Double> secondParentLikelihoods;
        EnumMap<Genotype.Type, Double> firstParentLikelihoods;
        int parentsCalled = 0;
        ArrayList<Genotype.Type> bestFirstParentGenotype = new ArrayList<Genotype.Type>();
        ArrayList<Genotype.Type> bestSecondParentGenotype = new ArrayList<Genotype.Type>();
        ArrayList<Genotype.Type> bestChildGenotype = new ArrayList<Genotype.Type>();
        Genotype.Type pairSecondParentGenotype = null;
        if (mother == null || !mother.isCalled()) {
            firstParentLikelihoods = this.getLikelihoodsAsMapSafeNull(father);
            secondParentLikelihoods = this.getLikelihoodsAsMapSafeNull(mother);
            bestFirstParentGenotype.add(this.getTypeSafeNull(father));
            bestSecondParentGenotype.add(this.getTypeSafeNull(mother));
            Genotype.Type type = pairSecondParentGenotype = mother == null ? Genotype.Type.UNAVAILABLE : mother.getType();
            if (father != null && father.isCalled()) {
                parentsCalled = 1;
            }
        } else {
            firstParentLikelihoods = this.getLikelihoodsAsMapSafeNull(mother);
            secondParentLikelihoods = this.getLikelihoodsAsMapSafeNull(father);
            bestFirstParentGenotype.add(this.getTypeSafeNull(mother));
            bestSecondParentGenotype.add(this.getTypeSafeNull(father));
            if (father == null || !father.isCalled()) {
                parentsCalled = 1;
                pairSecondParentGenotype = father == null ? Genotype.Type.UNAVAILABLE : father.getType();
            } else {
                parentsCalled = 2;
            }
        }
        EnumMap<Genotype.Type, Double> childLikelihoods = this.getLikelihoodsAsMapSafeNull(child);
        bestChildGenotype.add(this.getTypeSafeNull(child));
        double bestConfigurationLikelihood = 0.0;
        double norm = 0.0;
        int configuration_index = 0;
        ArrayList<Integer> bestMVCount = new ArrayList<Integer>();
        bestMVCount.add(0);
        if (child.isCalled() && parentsCalled > 0) {
            int cumulativeMVCount = 0;
            double configurationLikelihood = 0.0;
            for (Map.Entry childGenotype : childLikelihoods.entrySet()) {
                for (Map.Entry firstParentGenotype : firstParentLikelihoods.entrySet()) {
                    for (Map.Entry secondParentGenotype : secondParentLikelihoods.entrySet()) {
                        int mvCount = this.mvCountMatrix.get(firstParentGenotype.getKey()).get(secondParentGenotype.getKey()).get(childGenotype.getKey());
                        if (parentsCalled < 2) {
                            cumulativeMVCount += mvCount;
                            configurationLikelihood += mvCount > 0 ? Math.pow(this.deNovoPrior, mvCount) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue() : (1.0 - 11.0 * this.deNovoPrior) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue();
                            continue;
                        }
                        configurationLikelihood = mvCount > 0 ? Math.pow(this.deNovoPrior, mvCount) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue() : (1.0 - 11.0 * this.deNovoPrior) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue();
                        norm += configurationLikelihood;
                        if (configurationLikelihood > bestConfigurationLikelihood) {
                            bestConfigurationLikelihood = configurationLikelihood;
                            bestMVCount.clear();
                            bestMVCount.add(mvCount);
                            bestFirstParentGenotype.clear();
                            bestFirstParentGenotype.add((Genotype.Type)((Object)firstParentGenotype.getKey()));
                            bestSecondParentGenotype.clear();
                            bestSecondParentGenotype.add((Genotype.Type)((Object)secondParentGenotype.getKey()));
                            bestChildGenotype.clear();
                            bestChildGenotype.add((Genotype.Type)((Object)childGenotype.getKey()));
                            continue;
                        }
                        if (configurationLikelihood != bestConfigurationLikelihood) continue;
                        bestFirstParentGenotype.add((Genotype.Type)((Object)firstParentGenotype.getKey()));
                        bestSecondParentGenotype.add((Genotype.Type)((Object)secondParentGenotype.getKey()));
                        bestChildGenotype.add((Genotype.Type)((Object)childGenotype.getKey()));
                        bestMVCount.add(mvCount);
                    }
                    if (parentsCalled >= 2) continue;
                    norm += configurationLikelihood;
                    if (configurationLikelihood > bestConfigurationLikelihood) {
                        bestConfigurationLikelihood = configurationLikelihood;
                        bestMVCount.clear();
                        bestMVCount.add(cumulativeMVCount / 3);
                        bestChildGenotype.clear();
                        bestFirstParentGenotype.clear();
                        bestSecondParentGenotype.clear();
                        bestChildGenotype.add((Genotype.Type)((Object)childGenotype.getKey()));
                        bestFirstParentGenotype.add((Genotype.Type)((Object)firstParentGenotype.getKey()));
                        bestSecondParentGenotype.add(pairSecondParentGenotype);
                    } else if (configurationLikelihood == bestConfigurationLikelihood) {
                        bestFirstParentGenotype.add((Genotype.Type)((Object)firstParentGenotype.getKey()));
                        bestSecondParentGenotype.add(pairSecondParentGenotype);
                        bestChildGenotype.add((Genotype.Type)((Object)childGenotype.getKey()));
                        bestMVCount.add(cumulativeMVCount / 3);
                    }
                    configurationLikelihood = 0.0;
                }
            }
            bestConfigurationLikelihood /= norm;
            if (bestFirstParentGenotype.size() > 1) {
                configuration_index = this.rand.nextInt(bestFirstParentGenotype.size() - 1);
            }
        } else {
            bestConfigurationLikelihood = -1.0;
        }
        TrioPhase phasedTrioGenotypes = parentsCalled < 2 && mother == null || !mother.isCalled() ? this.transmissionMatrix.get(bestSecondParentGenotype.get(configuration_index)).get(bestFirstParentGenotype.get(configuration_index)).get(bestChildGenotype.get(configuration_index)) : this.transmissionMatrix.get(bestFirstParentGenotype.get(configuration_index)).get(bestSecondParentGenotype.get(configuration_index)).get(bestChildGenotype.get(configuration_index));
        phasedTrioGenotypes.getPhasedGenotypes(ref, alt, mother, father, child, bestConfigurationLikelihood, finalGenotypes);
        return (Integer)bestMVCount.get(configuration_index);
    }

    private void updatePairMetricsCounters(Genotype parent, Genotype child, int mvCount, HashMap<Byte, Integer> counters) {
        if (parent.isCalled() && child.isCalled()) {
            counters.put(this.NUM_PAIR_GENOTYPES_CALLED, counters.get(this.NUM_PAIR_GENOTYPES_CALLED) + 1);
            if (parent.isPhased()) {
                counters.put(this.NUM_PAIR_GENOTYPES_PHASED, counters.get(this.NUM_PAIR_GENOTYPES_PHASED) + 1);
            } else {
                counters.put(this.NUM_PAIR_VIOLATIONS, counters.get(this.NUM_PAIR_VIOLATIONS) + mvCount);
                if (parent.isHet() && child.isHet()) {
                    counters.put(this.NUM_PAIR_HET_HET, counters.get(this.NUM_PAIR_HET_HET) + 1);
                }
            }
        } else {
            counters.put(this.NUM_PAIR_GENOTYPES_NOCALL, counters.get(this.NUM_PAIR_GENOTYPES_NOCALL) + 1);
        }
    }

    private void updateTrioMetricsCounters(Genotype mother, Genotype father, Genotype child, int mvCount, HashMap<Byte, Integer> counters) {
        if (mother.isCalled() && father.isCalled() && child.isCalled()) {
            counters.put(this.NUM_TRIO_GENOTYPES_CALLED, counters.get(this.NUM_TRIO_GENOTYPES_CALLED) + 1);
            if (mother.isPhased()) {
                counters.put(this.NUM_TRIO_GENOTYPES_PHASED, counters.get(this.NUM_TRIO_GENOTYPES_PHASED) + 1);
            } else if (mvCount > 0) {
                if (mvCount > 1) {
                    counters.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, counters.get(this.NUM_TRIO_DOUBLE_VIOLATIONS) + 1);
                } else {
                    counters.put(this.NUM_TRIO_VIOLATIONS, counters.get(this.NUM_TRIO_VIOLATIONS) + 1);
                }
            } else if (mother.isHet() && father.isHet() && child.isHet()) {
                counters.put(this.NUM_TRIO_HET_HET_HET, counters.get(this.NUM_TRIO_HET_HET_HET) + 1);
            }
        } else {
            counters.put(this.NUM_TRIO_GENOTYPES_NOCALL, counters.get(this.NUM_TRIO_GENOTYPES_NOCALL) + 1);
        }
    }

    @Override
    public HashMap<Byte, Integer> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        HashMap<Byte, Integer> metricsCounters = new HashMap<Byte, Integer>(10);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_TRIO_HET_HET_HET, 0);
        metricsCounters.put(this.NUM_TRIO_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_PAIR_HET_HET, 0);
        metricsCounters.put(this.NUM_PAIR_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, 0);
        if (tracker == null) {
            return metricsCounters;
        }
        VariantContext vc = tracker.getFirstValue(this.variantCollection.variants, context.getLocation());
        if (vc == null) {
            return metricsCounters;
        }
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        GenotypesContext genotypesContext = GenotypesContext.copy(vc.getGenotypes());
        for (Sample sample : this.trios) {
            String mvfLine;
            Genotype mother = vc.getGenotype(sample.getMaternalID());
            Genotype father = vc.getGenotype(sample.getPaternalID());
            Genotype child = vc.getGenotype(sample.getID());
            if (mother == null && father == null || child == null) continue;
            ArrayList<Genotype> trioGenotypes = new ArrayList<Genotype>(3);
            int mvCount = this.phaseTrioGenotypes(vc.getReference(), vc.getAltAlleleWithHighestAlleleCount(), mother, father, child, trioGenotypes);
            Genotype phasedMother = trioGenotypes.get(0);
            Genotype phasedFather = trioGenotypes.get(1);
            Genotype phasedChild = trioGenotypes.get(2);
            genotypesContext.replace(phasedChild);
            if (mother != null) {
                genotypesContext.replace(phasedMother);
                if (father != null) {
                    genotypesContext.replace(phasedFather);
                    this.updateTrioMetricsCounters(phasedMother, phasedFather, phasedChild, mvCount, metricsCounters);
                    mvfLine = String.format("%s\t%d\t%s\t%s\t%s\t%s\t%s:%s:%s:%s\t%s:%s:%s:%s\t%s:%s:%s:%s", vc.getChr(), vc.getStart(), vc.getFilters(), vc.getAttribute("AC"), sample.toString(), phasedMother.getAttribute("TP"), phasedMother.getGenotypeString(), phasedMother.getAttribute("DP"), phasedMother.getAttribute("AD"), phasedMother.getLikelihoods().toString(), phasedFather.getGenotypeString(), phasedFather.getAttribute("DP"), phasedFather.getAttribute("AD"), phasedFather.getLikelihoods().toString(), phasedChild.getGenotypeString(), phasedChild.getAttribute("DP"), phasedChild.getAttribute("AD"), phasedChild.getLikelihoods().toString());
                    if (phasedMother.getType() != mother.getType() || phasedFather.getType() != father.getType() || phasedChild.getType() != child.getType()) {
                        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, metricsCounters.get(this.NUM_GENOTYPES_MODIFIED) + 1);
                    }
                } else {
                    this.updatePairMetricsCounters(phasedMother, phasedChild, mvCount, metricsCounters);
                    if (phasedMother.getType() != mother.getType() || phasedChild.getType() != child.getType()) {
                        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, metricsCounters.get(this.NUM_GENOTYPES_MODIFIED) + 1);
                    }
                    mvfLine = String.format("%s\t%d\t%s\t%s\t%s\t%s\t%s:%s:%s:%s\t.:.:.:.\t%s:%s:%s:%s", vc.getChr(), vc.getStart(), vc.getFilters(), vc.getAttribute("AC"), sample.toString(), phasedMother.getAttribute("TP"), phasedMother.getGenotypeString(), phasedMother.getAttribute("DP"), phasedMother.getAttribute("AD"), phasedMother.getLikelihoods().toString(), phasedChild.getGenotypeString(), phasedChild.getAttribute("DP"), phasedChild.getAttribute("AD"), phasedChild.getLikelihoods().toString());
                }
            } else {
                genotypesContext.replace(phasedFather);
                this.updatePairMetricsCounters(phasedFather, phasedChild, mvCount, metricsCounters);
                if (phasedFather.getType() != father.getType() || phasedChild.getType() != child.getType()) {
                    metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, metricsCounters.get(this.NUM_GENOTYPES_MODIFIED) + 1);
                }
                mvfLine = String.format("%s\t%d\t%s\t%s\t%s\t%s\t.:.:.:.\t%s:%s:%s:%s\t%s:%s:%s:%s", vc.getChr(), vc.getStart(), vc.getFilters(), vc.getAttribute("AC"), sample.toString(), phasedFather.getAttribute("TP"), phasedFather.getGenotypeString(), phasedFather.getAttribute("DP"), phasedFather.getAttribute("AD"), phasedFather.getLikelihoods().toString(), phasedChild.getGenotypeString(), phasedChild.getAttribute("DP"), phasedChild.getAttribute("AD"), phasedChild.getLikelihoods().toString());
            }
            if (mvCount <= 0 || this.mvFile == null) continue;
            this.mvFile.println(mvfLine);
        }
        builder.genotypes(genotypesContext);
        this.vcfWriter.add(builder.make());
        return metricsCounters;
    }

    @Override
    public HashMap<Byte, Integer> reduceInit() {
        HashMap<Byte, Integer> metricsCounters = new HashMap<Byte, Integer>(10);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_TRIO_HET_HET_HET, 0);
        metricsCounters.put(this.NUM_TRIO_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_PAIR_HET_HET, 0);
        metricsCounters.put(this.NUM_PAIR_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, 0);
        return metricsCounters;
    }

    @Override
    public HashMap<Byte, Integer> reduce(HashMap<Byte, Integer> value, HashMap<Byte, Integer> sum) {
        sum.put(this.NUM_TRIO_GENOTYPES_CALLED, value.get(this.NUM_TRIO_GENOTYPES_CALLED) + sum.get(this.NUM_TRIO_GENOTYPES_CALLED));
        sum.put(this.NUM_TRIO_GENOTYPES_NOCALL, value.get(this.NUM_TRIO_GENOTYPES_NOCALL) + sum.get(this.NUM_TRIO_GENOTYPES_NOCALL));
        sum.put(this.NUM_TRIO_GENOTYPES_PHASED, value.get(this.NUM_TRIO_GENOTYPES_PHASED) + sum.get(this.NUM_TRIO_GENOTYPES_PHASED));
        sum.put(this.NUM_TRIO_HET_HET_HET, value.get(this.NUM_TRIO_HET_HET_HET) + sum.get(this.NUM_TRIO_HET_HET_HET));
        sum.put(this.NUM_TRIO_VIOLATIONS, value.get(this.NUM_TRIO_VIOLATIONS) + sum.get(this.NUM_TRIO_VIOLATIONS));
        sum.put(this.NUM_PAIR_GENOTYPES_CALLED, value.get(this.NUM_PAIR_GENOTYPES_CALLED) + sum.get(this.NUM_PAIR_GENOTYPES_CALLED));
        sum.put(this.NUM_PAIR_GENOTYPES_NOCALL, value.get(this.NUM_PAIR_GENOTYPES_NOCALL) + sum.get(this.NUM_PAIR_GENOTYPES_NOCALL));
        sum.put(this.NUM_PAIR_GENOTYPES_PHASED, value.get(this.NUM_PAIR_GENOTYPES_PHASED) + sum.get(this.NUM_PAIR_GENOTYPES_PHASED));
        sum.put(this.NUM_PAIR_HET_HET, value.get(this.NUM_PAIR_HET_HET) + sum.get(this.NUM_PAIR_HET_HET));
        sum.put(this.NUM_PAIR_VIOLATIONS, value.get(this.NUM_PAIR_VIOLATIONS) + sum.get(this.NUM_PAIR_VIOLATIONS));
        sum.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, value.get(this.NUM_TRIO_DOUBLE_VIOLATIONS) + sum.get(this.NUM_TRIO_DOUBLE_VIOLATIONS));
        sum.put(this.NUM_GENOTYPES_MODIFIED, value.get(this.NUM_GENOTYPES_MODIFIED) + sum.get(this.NUM_GENOTYPES_MODIFIED));
        return sum;
    }

    @Override
    public void onTraversalDone(HashMap<Byte, Integer> result) {
        logger.info("Number of complete trio-genotypes: " + result.get(this.NUM_TRIO_GENOTYPES_CALLED));
        logger.info("Number of trio-genotypes containing no call(s): " + result.get(this.NUM_TRIO_GENOTYPES_NOCALL));
        logger.info("Number of trio-genotypes phased: " + result.get(this.NUM_TRIO_GENOTYPES_PHASED));
        logger.info("Number of resulting Het/Het/Het trios: " + result.get(this.NUM_TRIO_HET_HET_HET));
        logger.info("Number of remaining single mendelian violations in trios: " + result.get(this.NUM_TRIO_VIOLATIONS));
        logger.info("Number of remaining double mendelian violations in trios: " + result.get(this.NUM_TRIO_DOUBLE_VIOLATIONS));
        logger.info("Number of complete pair-genotypes: " + result.get(this.NUM_PAIR_GENOTYPES_CALLED));
        logger.info("Number of pair-genotypes containing no call(s): " + result.get(this.NUM_PAIR_GENOTYPES_NOCALL));
        logger.info("Number of pair-genotypes phased: " + result.get(this.NUM_PAIR_GENOTYPES_PHASED));
        logger.info("Number of resulting Het/Het pairs: " + result.get(this.NUM_PAIR_HET_HET));
        logger.info("Number of remaining mendelian violations in pairs: " + result.get(this.NUM_PAIR_VIOLATIONS));
        logger.info("Number of genotypes updated: " + result.get(this.NUM_GENOTYPES_MODIFIED));
    }

    private class TrioPhase {
        private final Allele REF = Allele.create("A", true);
        private final Allele VAR = Allele.create("A", false);
        private final Allele NO_CALL = Allele.create(".", false);
        private final String DUMMY_NAME = "DummySample";
        private EnumMap<FamilyMember, Genotype> trioPhasedGenotypes = new EnumMap(FamilyMember.class);

        private ArrayList<Allele> getAlleles(Genotype.Type genotype) {
            ArrayList<Allele> alleles = new ArrayList<Allele>(2);
            if (genotype == Genotype.Type.HOM_REF) {
                alleles.add(this.REF);
                alleles.add(this.REF);
            } else if (genotype == Genotype.Type.HET) {
                alleles.add(this.REF);
                alleles.add(this.VAR);
            } else if (genotype == Genotype.Type.HOM_VAR) {
                alleles.add(this.VAR);
                alleles.add(this.VAR);
            } else {
                return null;
            }
            return alleles;
        }

        private boolean isPhasable(Genotype.Type genotype) {
            return genotype == Genotype.Type.HOM_REF || genotype == Genotype.Type.HET || genotype == Genotype.Type.HOM_VAR;
        }

        private void phaseSingleIndividualAlleles(Genotype.Type genotype, FamilyMember familyMember) {
            if (genotype == Genotype.Type.HOM_REF || genotype == Genotype.Type.HOM_VAR) {
                this.trioPhasedGenotypes.put(familyMember, new Genotype("DummySample", this.getAlleles(genotype), 1.0, null, null, true));
            } else {
                this.trioPhasedGenotypes.put(familyMember, new Genotype("DummySample", this.getAlleles(genotype), 1.0, null, null, false));
            }
        }

        private void phasePairAlleles(Genotype.Type parentGenotype, Genotype.Type childGenotype, FamilyMember parent) {
            if (parentGenotype == Genotype.Type.HET && childGenotype == Genotype.Type.HET) {
                this.trioPhasedGenotypes.put(parent, new Genotype("DummySample", this.getAlleles(parentGenotype), 1.0, null, null, false));
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", this.getAlleles(childGenotype), 1.0, null, null, false));
                return;
            }
            ArrayList<Allele> parentAlleles = this.getAlleles(parentGenotype);
            ArrayList<Allele> childAlleles = this.getAlleles(childGenotype);
            ArrayList<Allele> parentPhasedAlleles = new ArrayList<Allele>(2);
            ArrayList<Allele> childPhasedAlleles = new ArrayList<Allele>(2);
            int childTransmittedAlleleIndex = childAlleles.indexOf(parentAlleles.get(0));
            if (childTransmittedAlleleIndex > -1) {
                this.trioPhasedGenotypes.put(parent, new Genotype("DummySample", parentAlleles, 1.0, null, null, true));
                childPhasedAlleles.add(childAlleles.remove(childTransmittedAlleleIndex));
                if (parent.equals((Object)FamilyMember.MOTHER)) {
                    childPhasedAlleles.add(childAlleles.get(0));
                } else {
                    childPhasedAlleles.add(0, childAlleles.get(0));
                }
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", childPhasedAlleles, 1.0, null, null, true));
            } else {
                childTransmittedAlleleIndex = childAlleles.indexOf(parentAlleles.get(1));
                if (childTransmittedAlleleIndex > -1) {
                    parentPhasedAlleles.add(parentAlleles.get(1));
                    parentPhasedAlleles.add(parentAlleles.get(0));
                    this.trioPhasedGenotypes.put(parent, new Genotype("DummySample", parentPhasedAlleles, 1.0, null, null, true));
                    childPhasedAlleles.add(childAlleles.remove(childTransmittedAlleleIndex));
                    if (parent.equals((Object)FamilyMember.MOTHER)) {
                        childPhasedAlleles.add(childAlleles.get(0));
                    } else {
                        childPhasedAlleles.add(0, childAlleles.get(0));
                    }
                    this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", childPhasedAlleles, 1.0, null, null, true));
                } else {
                    this.trioPhasedGenotypes.put(parent, new Genotype("DummySample", this.getAlleles(parentGenotype), 1.0, null, null, false));
                    this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", this.getAlleles(childGenotype), 1.0, null, null, false));
                }
            }
        }

        private void phaseFamilyAlleles(Genotype.Type mother, Genotype.Type father, Genotype.Type child) {
            HashSet possiblePhasedChildGenotypes = new HashSet();
            ArrayList<Allele> motherAlleles = this.getAlleles(mother);
            ArrayList<Allele> fatherAlleles = this.getAlleles(father);
            ArrayList<Allele> childAlleles = this.getAlleles(child);
            for (Allele allele : motherAlleles) {
                for (Allele fatherAllele : fatherAlleles) {
                    ArrayList<Allele> possiblePhasedChildAlleles = new ArrayList<Allele>(2);
                    possiblePhasedChildAlleles.add(allele);
                    possiblePhasedChildAlleles.add(fatherAllele);
                    possiblePhasedChildGenotypes.add(possiblePhasedChildAlleles);
                }
            }
            for (ArrayList arrayList : possiblePhasedChildGenotypes) {
                int secondAlleleIndex;
                int firstAlleleIndex = arrayList.indexOf(childAlleles.get(0));
                if (firstAlleleIndex == (secondAlleleIndex = arrayList.lastIndexOf(childAlleles.get(1))) || firstAlleleIndex <= -1 || secondAlleleIndex <= -1) continue;
                ArrayList<Allele> motherPhasedAlleles = new ArrayList<Allele>(2);
                motherPhasedAlleles.add((Allele)arrayList.get(0));
                if (motherAlleles.get(0) != motherPhasedAlleles.get(0)) {
                    motherPhasedAlleles.add(motherAlleles.get(0));
                } else {
                    motherPhasedAlleles.add(motherAlleles.get(1));
                }
                this.trioPhasedGenotypes.put(FamilyMember.MOTHER, new Genotype("DummySample", motherPhasedAlleles, 1.0, null, null, true));
                ArrayList<Allele> fatherPhasedAlleles = new ArrayList<Allele>(2);
                fatherPhasedAlleles.add((Allele)arrayList.get(1));
                if (fatherAlleles.get(0) != fatherPhasedAlleles.get(0)) {
                    fatherPhasedAlleles.add(fatherAlleles.get(0));
                } else {
                    fatherPhasedAlleles.add(fatherAlleles.get(1));
                }
                this.trioPhasedGenotypes.put(FamilyMember.FATHER, new Genotype("DummySample", fatherPhasedAlleles, 1.0, null, null, true));
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", arrayList, 1.0, null, null, true));
                return;
            }
            this.trioPhasedGenotypes.put(FamilyMember.MOTHER, new Genotype("DummySample", this.getAlleles(mother), 1.0, null, null, false));
            this.trioPhasedGenotypes.put(FamilyMember.FATHER, new Genotype("DummySample", this.getAlleles(father), 1.0, null, null, false));
            this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", this.getAlleles(child), 1.0, null, null, false));
        }

        public TrioPhase(Genotype.Type mother, Genotype.Type father, Genotype.Type child) {
            if (!this.isPhasable(child)) {
                this.phaseSingleIndividualAlleles(mother, FamilyMember.MOTHER);
                this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
                this.phaseSingleIndividualAlleles(child, FamilyMember.CHILD);
            } else if (!this.isPhasable(mother)) {
                this.phaseSingleIndividualAlleles(mother, FamilyMember.MOTHER);
                if (!this.isPhasable(father)) {
                    this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
                    this.phaseSingleIndividualAlleles(child, FamilyMember.CHILD);
                } else {
                    this.phasePairAlleles(father, child, FamilyMember.FATHER);
                }
            } else if (!this.isPhasable(father)) {
                this.phasePairAlleles(mother, child, FamilyMember.MOTHER);
                this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
            } else if (mother == Genotype.Type.HET && father == Genotype.Type.HET && child == Genotype.Type.HET) {
                this.phaseSingleIndividualAlleles(mother, FamilyMember.MOTHER);
                this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
                this.phaseSingleIndividualAlleles(child, FamilyMember.CHILD);
            } else {
                this.phaseFamilyAlleles(mother, father, child);
            }
            if (PhaseByTransmission.this.fatherFAlleleFirst && this.trioPhasedGenotypes.get((Object)FamilyMember.CHILD).isPhased()) {
                ArrayList<Allele> childAlleles = new ArrayList<Allele>(this.trioPhasedGenotypes.get((Object)FamilyMember.CHILD).getAlleles());
                childAlleles.add(childAlleles.remove(0));
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, new Genotype("DummySample", childAlleles, 1.0, null, null, true));
            }
        }

        public void getPhasedGenotypes(Allele ref, Allele alt, Genotype motherGenotype, Genotype fatherGenotype, Genotype childGenotype, double transmissionProb, ArrayList<Genotype> phasedGenotypes) {
            phasedGenotypes.add(this.getPhasedGenotype(ref, alt, motherGenotype, transmissionProb, this.trioPhasedGenotypes.get((Object)FamilyMember.MOTHER)));
            phasedGenotypes.add(this.getPhasedGenotype(ref, alt, fatherGenotype, transmissionProb, this.trioPhasedGenotypes.get((Object)FamilyMember.FATHER)));
            phasedGenotypes.add(this.getPhasedGenotype(ref, alt, childGenotype, transmissionProb, this.trioPhasedGenotypes.get((Object)FamilyMember.CHILD)));
        }

        private Genotype getPhasedGenotype(Allele refAllele, Allele altAllele, Genotype genotype, double transmissionProb, Genotype phasedGenotype) {
            int phredScoreTransmission = -1;
            if (transmissionProb != -1.0) {
                phredScoreTransmission = MathUtils.probabilityToPhredScale(1.0 - transmissionProb);
            }
            if (phredScoreTransmission == 0 || genotype == null || !this.isPhasable(genotype.getType())) {
                return genotype;
            }
            HashMap<String, Object> genotypeAttributes = new HashMap<String, Object>();
            genotypeAttributes.putAll(genotype.getAttributes());
            if (transmissionProb > -1.0) {
                genotypeAttributes.put("TP", phredScoreTransmission);
            }
            ArrayList<Allele> phasedAlleles = new ArrayList<Allele>(2);
            for (Allele allele : phasedGenotype.getAlleles()) {
                if (allele.isReference()) {
                    phasedAlleles.add(refAllele);
                    continue;
                }
                if (allele.isNonReference()) {
                    phasedAlleles.add(altAllele);
                    continue;
                }
                throw new UserException(String.format("BUG: Unexpected allele: %s. Please report.", allele.toString()));
            }
            double log10Error = genotype.getType() == phasedGenotype.getType() ? genotype.getLog10PError() : genotype.getLikelihoods().getLog10GQ(phasedGenotype.getType());
            return new Genotype(genotype.getSampleName(), phasedAlleles, log10Error, null, genotypeAttributes, phasedGenotype.isPhased());
        }
    }

    private static enum FamilyMember {
        MOTHER,
        FATHER,
        CHILD;

    }
}

