/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.BitSet;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RequiredCovariate;
import org.broadinstitute.sting.utils.BitSetUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class QualityScoreCovariate
implements RequiredCovariate {
    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public CovariateValues getValues(GATKSAMRecord read) {
        int readLength = read.getReadLength();
        BitSet[] mismatches = new BitSet[readLength];
        BitSet[] insertions = new BitSet[readLength];
        BitSet[] deletions = new BitSet[readLength];
        byte[] baseQualities = read.getBaseQualities();
        byte[] baseInsertionQualities = read.getBaseInsertionQualities();
        byte[] baseDeletionQualities = read.getBaseDeletionQualities();
        for (int i = 0; i < baseQualities.length; ++i) {
            mismatches[i] = BitSetUtils.bitSetFrom(baseQualities[i]);
            insertions[i] = BitSetUtils.bitSetFrom(baseInsertionQualities[i]);
            deletions[i] = BitSetUtils.bitSetFrom(baseDeletionQualities[i]);
        }
        return new CovariateValues(mismatches, insertions, deletions);
    }

    @Override
    public final Object getValue(String str) {
        return Byte.parseByte(str);
    }

    @Override
    public String keyFromBitSet(BitSet key) {
        return String.format("%d", BitSetUtils.longFrom(key));
    }

    @Override
    public BitSet bitSetFromKey(Object key) {
        return key instanceof String ? BitSetUtils.bitSetFrom(Byte.parseByte((String)key)) : BitSetUtils.bitSetFrom(((Byte)key).byteValue());
    }

    @Override
    public int numberOfBits() {
        return BitSetUtils.numberOfBitsToRepresent(93L);
    }
}

