/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.HashMap;
import java.util.Map;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Tags;

public final class RodBinding<T extends Feature> {
    protected static final String UNBOUND_VARIABLE_NAME = "";
    protected static final String UNBOUND_SOURCE = "UNBOUND";
    protected static final String UNBOUND_TRIBBLE_TYPE = "";
    private final String name;
    private final String source;
    private final String tribbleType;
    private final Tags tags;
    private final Class<T> type;
    private final boolean bound;
    private static final Map<String, Integer> nameCounter = new HashMap<String, Integer>();

    @Requires(value={"type != null"})
    protected static final <T extends Feature> RodBinding<T> makeUnbound(Class<T> type) {
        return new RodBinding<T>(type);
    }

    public static final void resetNameCounter() {
        nameCounter.clear();
    }

    @Requires(value={"rawName != null"})
    @Ensures(value={"result != null"})
    private static final synchronized String countedVariableName(String rawName) {
        Integer count = nameCounter.get(rawName);
        if (count == null) {
            nameCounter.put(rawName, 1);
            return rawName;
        }
        nameCounter.put(rawName, count + 1);
        return rawName + (count + 1);
    }

    @Requires(value={"type != null", "rawName != null", "source != null", "tribbleType != null", "tags != null"})
    public RodBinding(Class<T> type, String rawName, String source, String tribbleType, Tags tags) {
        this.type = type;
        this.name = RodBinding.countedVariableName(rawName);
        this.source = source;
        this.tribbleType = tribbleType;
        this.tags = tags;
        this.bound = true;
    }

    @Requires(value={"type != null"})
    private RodBinding(Class<T> type) {
        this.type = type;
        this.name = "";
        this.source = UNBOUND_SOURCE;
        this.tribbleType = "";
        this.tags = new Tags();
        this.bound = false;
    }

    public final boolean isBound() {
        return this.bound;
    }

    @Ensures(value={"result != null"})
    public final String getName() {
        return this.name;
    }

    @Ensures(value={"result != null"})
    public final Class<T> getType() {
        return this.type;
    }

    @Ensures(value={"result != null"})
    public final String getSource() {
        return this.source;
    }

    @Ensures(value={"result != null"})
    public final Tags getTags() {
        return this.tags;
    }

    @Ensures(value={"result != null"})
    public final String getTribbleType() {
        return this.tribbleType;
    }

    public String toString() {
        return String.format("(RodBinding name=%s source=%s)", this.getName(), this.getSource());
    }
}

