/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa.c;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.BWAAligner;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.BWTFiles;
import org.broadinstitute.sting.alignment.bwa.c.BWAPath;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BWACAligner
extends BWAAligner {
    private long thunkPointer = 0L;

    public BWACAligner(BWTFiles bwtFiles, BWAConfiguration configuration) {
        super(bwtFiles, configuration);
        if (this.thunkPointer != 0L) {
            throw new ReviewedStingException("BWA/C attempting to reinitialize.");
        }
        if (!bwtFiles.annFile.exists()) {
            throw new ReviewedStingException("ANN file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        if (!bwtFiles.ambFile.exists()) {
            throw new ReviewedStingException("AMB file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        if (!bwtFiles.pacFile.exists()) {
            throw new ReviewedStingException("PAC file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        if (!bwtFiles.forwardBWTFile.exists()) {
            throw new ReviewedStingException("Forward BWT file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        if (!bwtFiles.forwardSAFile.exists()) {
            throw new ReviewedStingException("Forward SA file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        if (!bwtFiles.reverseBWTFile.exists()) {
            throw new ReviewedStingException("Reverse BWT file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        if (!bwtFiles.reverseSAFile.exists()) {
            throw new ReviewedStingException("Reverse SA file is missing; please rerun 'bwa aln' to regenerate it.");
        }
        this.thunkPointer = this.create(bwtFiles, configuration);
    }

    public BWACAligner(byte[] referenceSequence, BWAConfiguration configuration) {
        this(BWTFiles.createFromReferenceSequence(referenceSequence), configuration);
        this.bwtFiles.close();
    }

    @Override
    public void updateConfiguration(BWAConfiguration configuration) {
        if (this.thunkPointer == 0L) {
            throw new ReviewedStingException("BWA/C: attempting to update configuration of uninitialized aligner.");
        }
        this.updateConfiguration(this.thunkPointer, configuration);
    }

    @Override
    public void close() {
        if (this.thunkPointer == 0L) {
            throw new ReviewedStingException("BWA/C close attempted, but BWA/C is not properly initialized.");
        }
        this.destroy(this.thunkPointer);
    }

    @Override
    public Alignment getBestAlignment(byte[] bases) {
        if (this.thunkPointer == 0L) {
            throw new ReviewedStingException("BWA/C getBestAlignment attempted, but BWA/C is not properly initialized.");
        }
        return this.getBestAlignment(this.thunkPointer, bases);
    }

    @Override
    public SAMRecord align(SAMRecord read, SAMFileHeader newHeader) {
        if (this.bwtFiles.autogenerated) {
            throw new UnsupportedOperationException("Cannot create target alignment; source contig was generated ad-hoc and is not reliable");
        }
        return Alignment.convertToRead(this.getBestAlignment(read.getReadBases()), read, newHeader);
    }

    @Override
    public Iterable<Alignment[]> getAllAlignments(final byte[] bases) {
        final BWAPath[] paths = this.getPaths(bases);
        return new Iterable<Alignment[]>(){

            @Override
            public Iterator<Alignment[]> iterator() {
                return new Iterator<Alignment[]>(){
                    private int position = 0;

                    @Override
                    public boolean hasNext() {
                        return this.position < paths.length;
                    }

                    @Override
                    public Alignment[] next() {
                        if (this.position >= paths.length) {
                            throw new UnsupportedOperationException("Out of alignments to return.");
                        }
                        int score = paths[this.position].score;
                        int startingPosition = this.position;
                        while (this.position < paths.length && paths[this.position].score == score) {
                            ++this.position;
                        }
                        return BWACAligner.this.convertPathsToAlignments(bases, Arrays.copyOfRange(paths, startingPosition, this.position));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove from an alignment iterator");
                    }
                };
            }
        };
    }

    @Override
    public Iterable<SAMRecord[]> alignAll(final SAMRecord read, final SAMFileHeader newHeader) {
        if (this.bwtFiles.autogenerated) {
            throw new UnsupportedOperationException("Cannot create target alignment; source contig was generated ad-hoc and is not reliable");
        }
        final Iterable<Alignment[]> alignments = this.getAllAlignments(read.getReadBases());
        return new Iterable<SAMRecord[]>(){

            @Override
            public Iterator<SAMRecord[]> iterator() {
                final Iterator alignmentIterator = alignments.iterator();
                return new Iterator<SAMRecord[]>(){

                    @Override
                    public boolean hasNext() {
                        return alignmentIterator.hasNext();
                    }

                    @Override
                    public SAMRecord[] next() {
                        Alignment[] alignmentsOfQuality = (Alignment[])alignmentIterator.next();
                        SAMRecord[] reads = new SAMRecord[alignmentsOfQuality.length];
                        for (int i = 0; i < alignmentsOfQuality.length; ++i) {
                            reads[i] = Alignment.convertToRead(alignmentsOfQuality[i], read, newHeader);
                        }
                        return reads;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove from an alignment iterator");
                    }
                };
            }
        };
    }

    public BWAPath[] getPaths(byte[] bases) {
        if (this.thunkPointer == 0L) {
            throw new ReviewedStingException("BWA/C getPaths attempted, but BWA/C is not properly initialized.");
        }
        return this.getPaths(this.thunkPointer, bases);
    }

    protected native long create(BWTFiles var1, BWAConfiguration var2);

    protected native void updateConfiguration(long var1, BWAConfiguration var3);

    protected native void destroy(long var1);

    protected Alignment[] convertPathsToAlignments(byte[] bases, BWAPath[] paths) {
        if (this.thunkPointer == 0L) {
            throw new ReviewedStingException("BWA/C convertPathsToAlignments attempted, but BWA/C is not properly initialized.");
        }
        return this.convertPathsToAlignments(this.thunkPointer, bases, paths);
    }

    protected native BWAPath[] getPaths(long var1, byte[] var3);

    protected native Alignment[] convertPathsToAlignments(long var1, byte[] var3, BWAPath[] var4);

    protected native Alignment getBestAlignment(long var1, byte[] var3);

    static {
        System.loadLibrary("bwa");
    }
}

