/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.StratNodeIterator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.Stratifier;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

@Invariant(value={"(isLeaf() && stratifier == null && subnodes.isEmpty()) || (!isLeaf() && stratifier != null && !subnodes.isEmpty())"})
class StratNode<T extends Stratifier>
implements Iterable<StratNode<T>> {
    int key = -1;
    final T stratifier;
    final Map<Object, StratNode<T>> subnodes;

    protected StratNode() {
        this.subnodes = Collections.emptyMap();
        this.stratifier = null;
    }

    protected StratNode(T stratifier, Map<Object, StratNode<T>> subnodes) {
        this.stratifier = stratifier;
        this.subnodes = Collections.unmodifiableMap(new HashMap<Object, StratNode<T>>(subnodes));
    }

    @Requires(value={"key >= 0"})
    public void setKey(int key) {
        if (!this.isLeaf()) {
            throw new ReviewedStingException("Cannot set key of non-leaf node");
        }
        this.key = key;
    }

    @Requires(value={"states != null", "offset >= 0", "offset <= states.size()"})
    public int find(List<Object> states, int offset) {
        if (this.isLeaf()) {
            return this.key;
        }
        Object state = states.get(offset);
        StratNode<T> subnode = this.subnodes.get(state);
        if (subnode == null) {
            return -1;
        }
        return subnode.find(states, offset + 1);
    }

    @Requires(value={"multipleStates != null", "offset >= 0", "offset <= multipleStates.size()", "keys != null", "offset == multipleStates.size() || multipleStates.get(offset) != null"})
    public void find(List<List<Object>> multipleStates, int offset, HashSet<Integer> keys) {
        if (this.isLeaf()) {
            keys.add(this.key);
        } else {
            for (Object state : multipleStates.get(offset)) {
                StratNode<T> subnode = this.subnodes.get(state);
                if (subnode == null) {
                    throw new ReviewedStingException("Couldn't find state for " + state + " at node " + this);
                }
                subnode.find(multipleStates, offset + 1, keys);
            }
        }
    }

    @Ensures(value={"result >= 0"})
    public int getKey() {
        if (!this.isLeaf()) {
            throw new ReviewedStingException("Cannot get key of non-leaf node");
        }
        return this.key;
    }

    protected Map<Object, StratNode<T>> getSubnodes() {
        return this.subnodes;
    }

    @Ensures(value={"result >= 0"})
    public int size() {
        if (this.isLeaf()) {
            return 1;
        }
        return this.subnodes.values().iterator().next().size() * this.subnodes.size();
    }

    public T getSetOfStates() {
        return this.stratifier;
    }

    public boolean isLeaf() {
        return this.stratifier == null;
    }

    @Override
    @Ensures(value={"result != null"})
    public Iterator<StratNode<T>> iterator() {
        return new StratNodeIterator(this);
    }
}

