/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotationInterfaceManager;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class VariantAnnotatorEngine {
    private List<InfoFieldAnnotation> requestedInfoAnnotations;
    private List<GenotypeAnnotation> requestedGenotypeAnnotations;
    private List<VAExpression> requestedExpressions = new ArrayList<VAExpression>();
    private final HashMap<RodBinding<VariantContext>, String> dbAnnotations = new HashMap();
    private final AnnotatorCompatibleWalker walker;
    private final GenomeAnalysisEngine toolkit;
    private boolean requireStrictAlleleMatch = false;

    public VariantAnnotatorEngine(List<String> annotationsToExclude, AnnotatorCompatibleWalker walker, GenomeAnalysisEngine toolkit) {
        this.walker = walker;
        this.toolkit = toolkit;
        this.requestedInfoAnnotations = AnnotationInterfaceManager.createAllInfoFieldAnnotations();
        this.requestedGenotypeAnnotations = AnnotationInterfaceManager.createAllGenotypeAnnotations();
        this.excludeAnnotations(annotationsToExclude);
        this.initializeDBs();
    }

    public VariantAnnotatorEngine(List<String> annotationGroupsToUse, List<String> annotationsToUse, List<String> annotationsToExclude, AnnotatorCompatibleWalker walker, GenomeAnalysisEngine toolkit) {
        this.walker = walker;
        this.toolkit = toolkit;
        this.initializeAnnotations(annotationGroupsToUse, annotationsToUse, annotationsToExclude);
        this.initializeDBs();
    }

    public VariantAnnotatorEngine(GenomeAnalysisEngine toolkit) {
        this.walker = null;
        this.toolkit = toolkit;
        this.requestedInfoAnnotations = AnnotationInterfaceManager.createInfoFieldAnnotations(Arrays.asList("ActiveRegionBasedAnnotation"), Collections.<String>emptyList());
    }

    public void initializeExpressions(List<String> expressionsToUse) {
        for (String expression : expressionsToUse) {
            this.requestedExpressions.add(new VAExpression(expression, this.walker.getResourceRodBindings()));
        }
    }

    protected List<VAExpression> getRequestedExpressions() {
        return this.requestedExpressions;
    }

    private void initializeAnnotations(List<String> annotationGroupsToUse, List<String> annotationsToUse, List<String> annotationsToExclude) {
        AnnotationInterfaceManager.validateAnnotations(annotationGroupsToUse, annotationsToUse);
        this.requestedInfoAnnotations = AnnotationInterfaceManager.createInfoFieldAnnotations(annotationGroupsToUse, annotationsToUse);
        this.requestedGenotypeAnnotations = AnnotationInterfaceManager.createGenotypeAnnotations(annotationGroupsToUse, annotationsToUse);
        this.excludeAnnotations(annotationsToExclude);
    }

    private void excludeAnnotations(List<String> annotationsToExclude) {
        if (annotationsToExclude.size() == 0) {
            return;
        }
        ArrayList<InfoFieldAnnotation> tempRequestedInfoAnnotations = new ArrayList<InfoFieldAnnotation>(this.requestedInfoAnnotations.size());
        for (InfoFieldAnnotation annotation : this.requestedInfoAnnotations) {
            if (annotationsToExclude.contains(annotation.getClass().getSimpleName())) continue;
            tempRequestedInfoAnnotations.add(annotation);
        }
        this.requestedInfoAnnotations = tempRequestedInfoAnnotations;
        ArrayList<GenotypeAnnotation> tempRequestedGenotypeAnnotations = new ArrayList<GenotypeAnnotation>(this.requestedGenotypeAnnotations.size());
        for (GenotypeAnnotation annotation : this.requestedGenotypeAnnotations) {
            if (annotationsToExclude.contains(annotation.getClass().getSimpleName())) continue;
            tempRequestedGenotypeAnnotations.add(annotation);
        }
        this.requestedGenotypeAnnotations = tempRequestedGenotypeAnnotations;
    }

    private void initializeDBs() {
        RodBinding<VariantContext> dbsnp = this.walker.getDbsnpRodBinding();
        if (dbsnp != null && dbsnp.isBound()) {
            this.dbAnnotations.put(dbsnp, "DB");
        }
        List<RodBinding<VariantContext>> comps = this.walker.getCompRodBindings();
        for (RodBinding<VariantContext> rod : comps) {
            this.dbAnnotations.put(rod, rod.getName());
        }
    }

    public void invokeAnnotationInitializationMethods(Set<VCFHeaderLine> headerLines) {
        for (InfoFieldAnnotation infoFieldAnnotation : this.requestedInfoAnnotations) {
            infoFieldAnnotation.initialize(this.walker, this.toolkit, headerLines);
        }
        for (GenotypeAnnotation genotypeAnnotation : this.requestedGenotypeAnnotations) {
            genotypeAnnotation.initialize(this.walker, this.toolkit, headerLines);
        }
    }

    public Set<VCFHeaderLine> getVCFAnnotationDescriptions() {
        HashSet<VCFHeaderLine> descriptions = new HashSet<VCFHeaderLine>();
        for (InfoFieldAnnotation infoFieldAnnotation : this.requestedInfoAnnotations) {
            descriptions.addAll(infoFieldAnnotation.getDescriptions());
        }
        for (GenotypeAnnotation genotypeAnnotation : this.requestedGenotypeAnnotations) {
            descriptions.addAll(genotypeAnnotation.getDescriptions());
        }
        for (String string : this.dbAnnotations.values()) {
            descriptions.add(new VCFInfoHeaderLine(string, 0, VCFHeaderLineType.Flag, (string.equals("DB") ? "dbSNP" : string) + " Membership"));
        }
        return descriptions;
    }

    public void setRequireStrictAlleleMatch(boolean requireStrictAlleleMatch) {
        this.requireStrictAlleleMatch = requireStrictAlleleMatch;
    }

    public VariantContext annotateContext(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        LinkedHashMap<String, Object> infoAnnotations = new LinkedHashMap<String, Object>(vc.getAttributes());
        vc = this.annotateDBs(tracker, ref, vc, infoAnnotations);
        this.annotateExpressions(tracker, ref, infoAnnotations);
        for (InfoFieldAnnotation annotationType : this.requestedInfoAnnotations) {
            Map<String, Object> annotationsFromCurrentType = annotationType.annotate(tracker, this.walker, ref, stratifiedContexts, vc);
            if (annotationsFromCurrentType == null) continue;
            infoAnnotations.putAll(annotationsFromCurrentType);
        }
        VariantContextBuilder builder = new VariantContextBuilder(vc).attributes(infoAnnotations);
        return builder.genotypes(this.annotateGenotypes(tracker, ref, stratifiedContexts, vc)).make();
    }

    public VariantContext annotateContext(Map<String, Map<Allele, List<GATKSAMRecord>>> stratifiedContexts, VariantContext vc) {
        LinkedHashMap<String, Object> infoAnnotations = new LinkedHashMap<String, Object>(vc.getAttributes());
        for (InfoFieldAnnotation annotationType : this.requestedInfoAnnotations) {
            Map<String, Object> annotationsFromCurrentType = ((ActiveRegionBasedAnnotation)((Object)annotationType)).annotate(stratifiedContexts, vc);
            if (annotationsFromCurrentType == null) continue;
            infoAnnotations.putAll(annotationsFromCurrentType);
        }
        return new VariantContextBuilder(vc).attributes(infoAnnotations).make();
    }

    private VariantContext annotateDBs(RefMetaDataTracker tracker, ReferenceContext ref, VariantContext vc, Map<String, Object> infoAnnotations) {
        for (Map.Entry<RodBinding<VariantContext>, String> dbSet : this.dbAnnotations.entrySet()) {
            if (dbSet.getValue().equals("DB")) {
                String rsID = VCFUtils.rsIDOfFirstRealVariant(tracker.getValues(dbSet.getKey(), ref.getLocus()), vc.getType());
                infoAnnotations.put("DB", rsID != null);
                if (rsID == null) continue;
                if (vc.emptyID()) {
                    vc = new VariantContextBuilder(vc).id(rsID).make();
                    continue;
                }
                if (!this.walker.alwaysAppendDbsnpId() || vc.getID().indexOf(rsID) != -1) continue;
                String newRsID = vc.getID() + ";" + rsID;
                vc = new VariantContextBuilder(vc).id(newRsID).make();
                continue;
            }
            boolean overlapsComp = false;
            for (VariantContext comp : tracker.getValues(dbSet.getKey(), ref.getLocus())) {
                if (comp.isFiltered() || this.requireStrictAlleleMatch && !((Object)comp.getAlleles()).equals(vc.getAlleles())) continue;
                overlapsComp = true;
                break;
            }
            infoAnnotations.put(dbSet.getValue(), overlapsComp);
        }
        return vc;
    }

    private void annotateExpressions(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, Object> infoAnnotations) {
        for (VAExpression expression : this.requestedExpressions) {
            List<VariantContext> VCs = tracker.getValues(expression.binding, ref.getLocus());
            if (VCs.size() == 0) continue;
            VariantContext vc = (VariantContext)VCs.iterator().next();
            if (expression.fieldName.equals("ID")) {
                if (!vc.hasID()) continue;
                infoAnnotations.put(expression.fullName, vc.getID());
                continue;
            }
            if (!vc.hasAttribute(expression.fieldName)) continue;
            infoAnnotations.put(expression.fullName, vc.getAttribute(expression.fieldName));
        }
    }

    private GenotypesContext annotateGenotypes(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (this.requestedGenotypeAnnotations.size() == 0) {
            return vc.getGenotypes();
        }
        GenotypesContext genotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            AlignmentContext context = stratifiedContexts.get(genotype.getSampleName());
            if (context == null) {
                genotypes.add(genotype);
                continue;
            }
            HashMap<String, Object> genotypeAnnotations = new HashMap<String, Object>(genotype.getAttributes());
            for (GenotypeAnnotation annotation : this.requestedGenotypeAnnotations) {
                Map<String, Object> result = annotation.annotate(tracker, this.walker, ref, context, vc, genotype);
                if (result == null) continue;
                genotypeAnnotations.putAll(result);
            }
            genotypes.add(new Genotype(genotype.getSampleName(), genotype.getAlleles(), genotype.getLog10PError(), genotype.getFilters(), genotypeAnnotations, genotype.isPhased()));
        }
        return genotypes;
    }

    protected static class VAExpression {
        public String fullName;
        public String fieldName;
        public RodBinding<VariantContext> binding;

        public VAExpression(String fullExpression, List<RodBinding<VariantContext>> bindings) {
            int indexOfDot = fullExpression.lastIndexOf(".");
            if (indexOfDot == -1) {
                throw new UserException.BadArgumentValue(fullExpression, "it should be in rodname.value format");
            }
            this.fullName = fullExpression;
            this.fieldName = fullExpression.substring(indexOfDot + 1);
            String bindingName = fullExpression.substring(0, indexOfDot);
            for (RodBinding<VariantContext> rod : bindings) {
                if (!rod.getName().equals(bindingName)) continue;
                this.binding = rod;
                break;
            }
        }
    }
}

