/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.report.GATKReportVersion;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class GATKReport {
    public static final String GATKREPORT_HEADER_PREFIX = "#:GATKReport.";
    public static final GATKReportVersion LATEST_REPORT_VERSION = GATKReportVersion.V1_0;
    private static final String SEPARATOR = ":";
    private GATKReportVersion version = LATEST_REPORT_VERSION;
    private final TreeMap<String, GATKReportTable> tables = new TreeMap();

    public GATKReport() {
    }

    public GATKReport(String filename) {
        this(new File(filename));
    }

    public GATKReport(File file) {
        this.loadReport(file);
    }

    public GATKReport(GATKReportTable ... tables) {
        for (GATKReportTable table : tables) {
            this.addTable(table);
        }
    }

    private void loadReport(File file) {
        String reportHeader;
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(file));
            reportHeader = reader.readLine();
        }
        catch (FileNotFoundException e) {
            throw new ReviewedStingException("Could not open file : " + file);
        }
        catch (IOException e) {
            throw new ReviewedStingException("Could not read file : " + file);
        }
        this.version = GATKReportVersion.fromHeader(reportHeader);
        if (this.version.equals(GATKReportVersion.V0_1) || this.version.equals(GATKReportVersion.V0_2)) {
            throw new UserException("The GATK no longer supports reading legacy GATK Reports. Please use v1.0 or newer.");
        }
        int nTables = Integer.parseInt(reportHeader.split(SEPARATOR)[2]);
        for (int i = 0; i < nTables; ++i) {
            this.addTable(new GATKReportTable(reader, this.version));
        }
    }

    public void addTable(String tableName, String tableDescription) {
        this.addTable(tableName, tableDescription, true);
    }

    public void addTable(String tableName, String tableDescription, boolean sortByPrimaryKey) {
        GATKReportTable table = new GATKReportTable(tableName, tableDescription, sortByPrimaryKey);
        this.tables.put(tableName, table);
    }

    public void addTable(GATKReportTable table) {
        this.tables.put(table.getTableName(), table);
    }

    public void addTables(List<GATKReportTable> gatkReportTables) {
        for (GATKReportTable table : gatkReportTables) {
            this.addTable(table);
        }
    }

    public boolean hasTable(String tableName) {
        return this.tables.containsKey(tableName);
    }

    public GATKReportTable getTable(String tableName) {
        GATKReportTable table = this.tables.get(tableName);
        if (table == null) {
            throw new ReviewedStingException("Table is not in GATKReport: " + tableName);
        }
        return table;
    }

    public void print(PrintStream out) {
        out.println(GATKREPORT_HEADER_PREFIX + this.getVersion().toString() + SEPARATOR + this.getTables().size());
        for (GATKReportTable table : this.tables.values()) {
            table.write(out);
        }
    }

    public Collection<GATKReportTable> getTables() {
        return this.tables.values();
    }

    public void combineWith(GATKReport input) {
        if (!this.isSameFormat(input)) {
            throw new ReviewedStingException("Failed to combine GATKReport, format doesn't match!");
        }
        for (String tableName : input.tables.keySet()) {
            this.tables.get(tableName).combineWith(input.getTable(tableName));
        }
    }

    public GATKReportVersion getVersion() {
        return this.version;
    }

    public boolean isSameFormat(GATKReport report) {
        if (!this.version.equals(report.version)) {
            return false;
        }
        if (!((Object)this.tables.keySet()).equals(report.tables.keySet())) {
            return false;
        }
        for (String tableName : this.tables.keySet()) {
            if (this.getTable(tableName).isSameFormat(report.getTable(tableName))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(GATKReport report) {
        if (!this.version.equals(report.version)) {
            return false;
        }
        if (!((Object)this.tables.keySet()).equals(report.tables.keySet())) {
            return false;
        }
        for (String tableName : this.tables.keySet()) {
            if (this.getTable(tableName).equals(report.getTable(tableName))) continue;
            return false;
        }
        return true;
    }

    public static GATKReport newSimpleReport(String tableName, String ... columns) {
        GATKReportTable table = new GATKReportTable(tableName, "A simplified GATK table report");
        table.addPrimaryKey("id", false);
        for (String column : columns) {
            table.addColumn(column, "");
        }
        GATKReport output = new GATKReport();
        output.addTable(table);
        return output;
    }

    public void addRow(Object ... values) {
        if (this.isSimpleReport()) {
            GATKReportTable table = this.tables.firstEntry().getValue();
            if (table.getColumns().size() != values.length) {
                throw new StingException("The number of arguments in addRow() must match the number of columns in the table");
            }
            int counter = table.getNumRows() + 1;
            int i = 0;
            for (String columnName : table.getColumns().keySet()) {
                table.set(counter, columnName, values[i]);
                ++i;
            }
        } else {
            throw new StingException("Cannot add a Row to a non-Simplified GATK Report");
        }
    }

    private boolean isSimpleReport() {
        if (this.tables.size() != 1) {
            return false;
        }
        GATKReportTable table = this.tables.firstEntry().getValue();
        return table.getPrimaryKeyName().equals("id");
    }
}

