/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.IlluminaBasecallsToSamConverter;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.FileChannelJDKBugWorkAround;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.util.TabbedTextFileWithHeaderParser;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.PeekIterator;
import net.sf.samtools.util.SortingCollection;
import net.sf.samtools.util.StringUtil;

public class IlluminaBasecallsToSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generate a SAM or BAM file from data in an Illumina basecalls output directory.\n";
    @Option(doc="The basecalls output directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The output SAM or BAM file. Format is determined by extension.", shortName="O", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public File OUTPUT;
    @Option(doc="Prefixed to read names.")
    public String RUN_BARCODE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced sample", shortName="ALIAS", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String SAMPLE_ALIAS;
    @Option(doc="ID used to link RG header record with RG tag in SAM record.  If these are unique in SAM files that get merged, merge performance is better.  If not specified, READ_GROUP_ID = <first 5 chars of RUN_BARCODE>.<LANE> .", shortName="RG", optional=true)
    public String READ_GROUP_ID;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced library", shortName="LIB", optional=true, mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String LIBRARY_NAME;
    @Option(doc="The name of the sequencing center that produced the reads to fill in the RG.CN tag.", optional=true)
    public String SEQUENCING_CENTER = "BI";
    @Option(doc="The start date of the run.", optional=true)
    public Date RUN_START_DATE;
    @Option(doc="The name of the sequencing technology that produced the read.", optional=true)
    public String PLATFORM = "illumina";
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  Tab-separated file for creating all output BAMs for barcoded run with single IlluminaBasecallsToSam invocation.  Columns are BARCODE, OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME.  Row with BARCODE=N is used to specify a file for no barcode match", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "LIBRARY_PARAMS"})
    public File BARCODE_PARAMS;
    @Option(doc="Tab-separated file for creating all output BAMs for a run with single IlluminaBasecallsToSam invocation.  TheColumns are OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME, BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1=N is used to specify a file for no barcode match.  You may also provide any 2 letter RG header attributes (excluding PU, CN, PL, and DT)  as columns in this file and the values for those columns will be inserted into the RG tag for the BAM file created for a given row.", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "BARCODE_PARAMS"})
    public File LIBRARY_PARAMS;
    @Option(doc="Which adapters to look for in the read.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(Arrays.asList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.NEXTERA_V2));
    @Option(doc="Run this many threads in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Option(doc="If set, this is the first tile to be processed (for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Option(doc="If set, process no more than this many tiles (for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Option(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.  Default: true.", optional=true)
    public Boolean FORCE_GC = true;
    @Option(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    private final Map<String, SAMFileWriter> barcodeSamWriterMap = new HashMap<String, SAMFileWriter>();
    private IlluminaBasecallsToSamConverter converter;
    private IlluminaDataProviderFactory factory;
    private ReadStructure readStructure;
    private int numThreads;
    private final Comparator<SAMRecord> samRecordQueryNameComparator = new SAMRecordQueryNameComparator();
    private List<Integer> tiles;
    public static final IlluminaDataType[] DATA_TYPES_NO_BARCODE = new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF};
    private static final IlluminaDataType[] DATA_TYPES_WITH_BARCODE = Arrays.copyOf(DATA_TYPES_NO_BARCODE, DATA_TYPES_NO_BARCODE.length + 1);
    private static final Log log = Log.getInstance(IlluminaBasecallsToSam.class);
    private final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    private final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer integer1, Integer integer2) {
            String s1 = integer1.toString();
            String s2 = integer2.toString();
            if (s1.length() < s2.length()) {
                if (s2.startsWith(s1)) {
                    return 1;
                }
            } else if (s2.length() < s1.length() && s1.startsWith(s2)) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    };

    @Override
    protected int doWork() {
        this.initialize();
        this.doTileProcessing();
        this.finalise();
        return 0;
    }

    private void finalise() {
        for (Map.Entry<String, SAMFileWriter> entry : this.barcodeSamWriterMap.entrySet()) {
            SAMFileWriter writer = entry.getValue();
            log.debug(String.format("Closing file for barcode %s.", entry.getKey()));
            writer.close();
        }
    }

    private void initialize() {
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        }
        if (this.LIBRARY_PARAMS != null) {
            IoUtil.assertFileIsReadable(this.LIBRARY_PARAMS);
        }
        if (this.FORCE_GC.booleanValue()) {
            Timer gcTimer = new Timer(true);
            long delay = 300000L;
            gcTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    System.out.println("Before explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    System.gc();
                    System.runFinalization();
                    System.out.println("After explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                }
            }, 300000L, 300000L);
        }
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        this.factory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, this.readStructure, IlluminaBasecallsToSam.getDataTypesFromReadStructure(this.readStructure));
        log.info("DONE_READING STRUCTURE IS " + this.readStructure.toString());
        this.tiles = new ArrayList<Integer>(this.factory.getAvailableTiles());
        Collections.sort(this.tiles, TILE_NUMBER_COMPARATOR);
        if (this.FIRST_TILE != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != this.FIRST_TILE.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != this.FIRST_TILE.intValue()) {
                throw new PicardException("FIRST_TILE=" + this.FIRST_TILE + ", but that tile was not found.");
            }
        }
        if (this.TILE_LIMIT != null && this.tiles.size() > this.TILE_LIMIT) {
            this.tiles = this.tiles.subList(0, this.TILE_LIMIT);
        }
        if (this.OUTPUT != null) {
            this.barcodeSamWriterMap.put(null, this.buildSamFileWriter(this.OUTPUT, this.SAMPLE_ALIAS, this.LIBRARY_NAME, this.buildSamHeaderParameters(null)));
        } else {
            this.populateWritersFromLibraryParams();
        }
        this.converter = new IlluminaBasecallsToSamConverter(this.RUN_BARCODE, this.READ_GROUP_ID, this.factory.getOutputReadStructure(), this.ADAPTERS_TO_CHECK);
        this.numThreads = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        this.numThreads = Math.max(1, Math.min(this.numThreads, this.tiles.size()));
    }

    private void doTileProcessing() {
        FileChannelJDKBugWorkAround.doBugWorkAround();
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (Integer tileNumber : this.tiles) {
            tiles.add(new Tile(tileNumber));
        }
        TileReadAggregator tileReadAggregator = new TileReadAggregator(tiles);
        tileReadAggregator.submit();
        try {
            tileReadAggregator.awaitWorkComplete();
        }
        catch (InterruptedException e) {
            log.error(e, "Attempting to shut down worker threads ...");
            tileReadAggregator.shutdown();
            throw new PicardException(String.format("Main thread interrupted: %s.", e.getMessage()));
        }
    }

    private Set<String> findAndFilterExpectedColumns(Set<String> actualCols, Set<String> expectedCols) {
        HashSet<String> missingColumns = new HashSet<String>(expectedCols);
        missingColumns.removeAll(actualCols);
        if (missingColumns.size() > 0) {
            throw new PicardException(String.format("LIBRARY_PARAMS file %s is missing the following columns: %s.", this.LIBRARY_PARAMS.getAbsolutePath(), StringUtil.join(", ", missingColumns)));
        }
        HashSet<String> remainingColumns = new HashSet<String>(actualCols);
        remainingColumns.removeAll(expectedCols);
        return remainingColumns;
    }

    private void checkRgTagColumns(Set<String> rgTagColumns) {
        Set<String> forbiddenHeaders = this.buildSamHeaderParameters(null).keySet();
        forbiddenHeaders.retainAll(rgTagColumns);
        if (forbiddenHeaders.size() > 0) {
            throw new PicardException("Illegal ReadGroup tags in library params(barcode params) file(" + this.LIBRARY_PARAMS.getAbsolutePath() + ") Offending headers = " + StringUtil.join(", ", forbiddenHeaders));
        }
        for (String column : rgTagColumns) {
            if (column.length() <= 2) continue;
            throw new PicardException("Column label (" + column + ") unrecognized.  Library params(barcode params) can only contain the columns " + "(OUTPUT, LIBRARY_NAME, SAMPLE_ALIAS, BARCODE, BARCODE_<X> where X is a positive integer) OR two letter RG tags!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateWritersFromLibraryParams() {
        TabbedTextFileWithHeaderParser libraryParamsParser = new TabbedTextFileWithHeaderParser(this.LIBRARY_PARAMS);
        Set<String> expectedColumnLabels = CollectionUtil.makeSet("OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME");
        ArrayList<String> barcodeColumnLabels = new ArrayList<String>();
        if (this.readStructure.barcodes.length() == 1) {
            if (libraryParamsParser.hasColumn("BARCODE")) {
                barcodeColumnLabels.add("BARCODE");
            } else {
                if (!libraryParamsParser.hasColumn("BARCODE_1")) throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does not have column BARCODE or BARCODE_1.");
                barcodeColumnLabels.add("BARCODE_1");
            }
        } else {
            for (int i = 1; i <= this.readStructure.barcodes.length(); ++i) {
                barcodeColumnLabels.add("BARCODE_" + i);
            }
        }
        expectedColumnLabels.addAll(barcodeColumnLabels);
        Set<String> rgTagColumns = this.findAndFilterExpectedColumns(libraryParamsParser.columnLabels(), expectedColumnLabels);
        this.checkRgTagColumns(rgTagColumns);
        for (TabbedTextFileWithHeaderParser.Row row : libraryParamsParser) {
            String key;
            ArrayList<String> barcodeValues = null;
            if (barcodeColumnLabels.size() > 0) {
                barcodeValues = new ArrayList<String>();
                for (String barcodeLabel : barcodeColumnLabels) {
                    barcodeValues.add(row.getField(barcodeLabel));
                }
            }
            String string = key = barcodeValues == null || barcodeValues.contains("N") ? null : StringUtil.join("", barcodeValues);
            if (this.barcodeSamWriterMap.containsKey(key)) {
                throw new PicardException("Row for barcode " + key + " appears more than once in LIBRARY_PARAMS or BARCODE_PARAMS file " + this.LIBRARY_PARAMS);
            }
            Map<String, String> samHeaderParams = this.buildSamHeaderParameters(barcodeValues);
            for (String tagName : rgTagColumns) {
                samHeaderParams.put(tagName, row.getField(tagName));
            }
            SAMFileWriter writer = this.buildSamFileWriter(new File(row.getField("OUTPUT")), row.getField("SAMPLE_ALIAS"), row.getField("LIBRARY_NAME"), samHeaderParams);
            this.barcodeSamWriterMap.put(key, writer);
        }
        if (!this.barcodeSamWriterMap.isEmpty()) return;
        throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does have any data rows.");
    }

    private Map<String, String> buildSamHeaderParameters(List<String> barcodes) {
        HashMap<String, String> params = new HashMap<String, String>();
        String platformUnit = this.RUN_BARCODE + "." + this.LANE;
        if (barcodes != null) {
            platformUnit = platformUnit + "." + IlluminaUtil.barcodeSeqsToString(barcodes);
        }
        params.put("PU", platformUnit);
        params.put("CN", this.SEQUENCING_CENTER);
        params.put("PL", this.PLATFORM);
        if (this.RUN_START_DATE != null) {
            Iso8601Date date = new Iso8601Date(this.RUN_START_DATE);
            params.put("DT", date.toString());
        } else {
            params.put("DT", null);
        }
        return params;
    }

    private SAMFileWriter buildSamFileWriter(File output, String sampleAlias, String libraryName, Map<String, String> headerParameters) {
        IoUtil.assertFileIsWritable(output);
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.READ_GROUP_ID);
        rg.setSample(sampleAlias);
        if (libraryName != null) {
            rg.setLibrary(libraryName);
        }
        for (Map.Entry<String, String> tagNameToValue : headerParameters.entrySet()) {
            if (tagNameToValue.getValue() == null) continue;
            rg.setAttribute(tagNameToValue.getKey(), tagNameToValue.getValue());
        }
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        header.addReadGroup(rg);
        return new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, output);
    }

    public static void main(String[] args) {
        System.exit(new IlluminaBasecallsToSam().instanceMain(args));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.BARCODE_PARAMS != null) {
            this.LIBRARY_PARAMS = this.BARCODE_PARAMS;
        }
        ArrayList<String> messages = new ArrayList<String>();
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (!this.readStructure.barcodes.isEmpty() && this.LIBRARY_PARAMS == null) {
            messages.add("BARCODE_PARAMS or LIBRARY_PARAMS is missing.  If READ_STRUCTURE contains a B (barcode) then either LIBRARY_PARAMS or BARCODE_PARAMS(deprecated) must be provided!");
        }
        if (this.READ_GROUP_ID == null) {
            this.READ_GROUP_ID = this.RUN_BARCODE.substring(0, 5) + "." + this.LANE;
        }
        if (messages.size() == 0) {
            return null;
        }
        return messages.toArray(new String[messages.size()]);
    }

    private static IlluminaDataType[] getDataTypesFromReadStructure(ReadStructure readStructure) {
        if (readStructure.barcodes.isEmpty()) {
            return DATA_TYPES_NO_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    static /* synthetic */ int access$600(IlluminaBasecallsToSam x0) {
        return x0.numThreads;
    }

    static {
        IlluminaBasecallsToSam.DATA_TYPES_WITH_BARCODE[IlluminaBasecallsToSam.DATA_TYPES_WITH_BARCODE.length - 1] = IlluminaDataType.Barcodes;
    }

    private abstract class PriorityRunnable
    implements Runnable {
        private final int priority;

        public PriorityRunnable() {
            this(1);
        }

        public PriorityRunnable(int priority) {
            this.priority = priority;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private class TileReadAggregator {
        private final Map<Tile, TileProcessingRecord> tileRecords = new TreeMap<Tile, TileProcessingRecord>();
        private final ExecutorService prioritizingThreadPool = new ThreadPoolExecutor(IlluminaBasecallsToSam.access$600(IlluminaBasecallsToSam.this), IlluminaBasecallsToSam.access$600(IlluminaBasecallsToSam.this), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(5, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                return ((PriorityRunnable)o2).getPriority() - ((PriorityRunnable)o1).getPriority();
            }
        }));
        private final Object completionLatch = new Object();
        private Thread parentThread;
        private final Object workEnqueueMonitor = new Object();
        private final AtomicBoolean submitted = new AtomicBoolean(false);

        public TileReadAggregator(Collection<Tile> tiles) {
            for (Tile t : tiles) {
                this.tileRecords.put(t, new TileProcessingRecord());
            }
        }

        public void submit() {
            if (!this.submitted.compareAndSet(false, true)) {
                throw new IllegalStateException("The submit() method may not be called more than once.");
            }
            this.parentThread = Thread.currentThread();
            int priority = 0;
            for (Tile tile : this.tileRecords.keySet()) {
                final TileReader reader = new TileReader(tile, this, this.tileRecords.get(tile));
                this.prioritizingThreadPool.execute(new PriorityRunnable(--priority){

                    @Override
                    public void run() {
                        reader.process();
                    }
                });
            }
        }

        private void completeTile(Tile tile) {
            TileProcessingRecord tileRecord = this.tileRecords.get(tile);
            if (tileRecord.getState() == TileProcessingState.DONE_READING) {
                throw new IllegalStateException("This tile is already in the completed state.");
            }
            for (String barcode : tileRecord.getBarcodes()) {
                tileRecord.setBarcodeState(barcode, TileBarcodeProcessingState.READ);
            }
            tileRecord.setState(TileProcessingState.DONE_READING);
            log.debug(String.format("Completed reading tile %s; collected %s reads spanning %s barcodes.", tile.getNumber(), tileRecord.getRecordCount(), tileRecord.getBarcodeCount()));
            this.findAndEnqueueWorkOrSignalCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitWorkComplete() throws InterruptedException {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalWorkComplete() {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findAndEnqueueWorkOrSignalCompletion() {
            Object object = this.workEnqueueMonitor;
            synchronized (object) {
                if (this.isWorkCompleted()) {
                    this.signalWorkComplete();
                } else {
                    LinkedList<PriorityRunnable> tasks = new LinkedList<PriorityRunnable>();
                    block8: for (String string : IlluminaBasecallsToSam.this.barcodeSamWriterMap.keySet()) {
                        block9: for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                            Tile tile = entry.getKey();
                            TileProcessingRecord tileRecord = entry.getValue();
                            if (tileRecord.getState() != TileProcessingState.DONE_READING) continue block8;
                            switch (tileRecord.getBarcodeState(string)) {
                                case NA: 
                                case WRITTEN: {
                                    continue block9;
                                }
                                case QUEUED_FOR_WRITE: {
                                    continue block8;
                                }
                                case READ: {
                                    tileRecord.setBarcodeState(string, TileBarcodeProcessingState.QUEUED_FOR_WRITE);
                                    log.debug(String.format("Enqueuing work for tile %s and barcode %s.", tile.getNumber(), string));
                                    tasks.add(this.newBarcodeWorkInstance(tile, tileRecord, string));
                                    continue block8;
                                }
                            }
                        }
                    }
                    for (Runnable runnable : tasks) {
                        this.prioritizingThreadPool.execute(runnable);
                    }
                }
            }
        }

        private PriorityRunnable newBarcodeWorkInstance(final Tile tile, final TileProcessingRecord tileRecord, final String barcode) {
            return new PriorityRunnable(){

                @Override
                public void run() {
                    try {
                        SortingCollection<SAMRecord> records = tileRecord.getBarcodeRecords().get(barcode);
                        SAMFileWriter writer = (SAMFileWriter)IlluminaBasecallsToSam.this.barcodeSamWriterMap.get(barcode);
                        log.debug(String.format("Writing records from tile %s with barcode %s ...", tile.getNumber(), barcode));
                        PeekIterator it = new PeekIterator(records.iterator());
                        while (it.hasNext()) {
                            SAMRecord rec = (SAMRecord)it.next();
                            if (it.hasNext()) {
                                SAMRecord lookAhead = (SAMRecord)it.peek();
                                if (!rec.getReadUnmappedFlag() || !lookAhead.getReadUnmappedFlag()) {
                                    throw new IllegalStateException("Should not have mapped reads.");
                                }
                                if (IlluminaBasecallsToSam.this.samRecordQueryNameComparator.compare(rec, lookAhead) == 0) {
                                    it.next();
                                    log.info("Skipping reads with identical read names: " + rec.getReadName());
                                    continue;
                                }
                            }
                            writer.addAlignment(rec);
                            IlluminaBasecallsToSam.this.writeProgressLogger.record(rec);
                        }
                        tileRecord.setBarcodeState(barcode, TileBarcodeProcessingState.WRITTEN);
                        TileReadAggregator.this.findAndEnqueueWorkOrSignalCompletion();
                    }
                    catch (RuntimeException e) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw e;
                    }
                }
            };
        }

        public boolean isWorkCompleted() {
            for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                TileProcessingRecord tileProcessingRecord = entry.getValue();
                if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) {
                    return false;
                }
                for (TileBarcodeProcessingState barcodeProcessingState : tileProcessingRecord.barcodeToProcessingState.values()) {
                    if (barcodeProcessingState == TileBarcodeProcessingState.WRITTEN) continue;
                    return false;
                }
            }
            return true;
        }

        public void shutdown() {
            this.prioritizingThreadPool.shutdownNow();
        }
    }

    private class TileProcessingRecord {
        private final Map<String, SortingCollection<SAMRecord>> barcodeToRecordCollection = new HashMap<String, SortingCollection<SAMRecord>>();
        private final Map<String, TileBarcodeProcessingState> barcodeToProcessingState = new HashMap<String, TileBarcodeProcessingState>();
        private TileProcessingState state = TileProcessingState.NOT_DONE_READING;
        private long recordCount = 0L;

        private TileProcessingRecord() {
        }

        public TileProcessingState getState() {
            return this.state;
        }

        public void setState(TileProcessingState state) {
            this.state = state;
        }

        public void addRecord(String barcode, SAMRecord ... records) {
            this.recordCount += (long)records.length;
            SortingCollection<SAMRecord> recordCollection = this.barcodeToRecordCollection.get(barcode);
            if (recordCollection == null) {
                recordCollection = this.newSortingCollection();
                this.barcodeToRecordCollection.put(barcode, recordCollection);
                this.barcodeToProcessingState.put(barcode, null);
            }
            for (SAMRecord record : records) {
                recordCollection.add(record);
            }
        }

        private SortingCollection<SAMRecord> newSortingCollection() {
            int maxRecordsInRam = IlluminaBasecallsToSam.this.MAX_READS_IN_RAM_PER_TILE / IlluminaBasecallsToSam.this.barcodeSamWriterMap.size();
            return SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(null), new SAMRecordQueryNameComparator(), maxRecordsInRam, IlluminaBasecallsToSam.this.TMP_DIR);
        }

        public long getBarcodeCount() {
            return this.barcodeToRecordCollection.size();
        }

        public long getRecordCount() {
            return this.recordCount;
        }

        public Map<String, SortingCollection<SAMRecord>> getBarcodeRecords() {
            return this.barcodeToRecordCollection;
        }

        public TileBarcodeProcessingState getBarcodeState(String barcode) {
            if (this.getState() == TileProcessingState.NOT_DONE_READING) {
                throw new IllegalStateException("A tile's barcode data's state cannot be queried until the tile has been completely read.");
            }
            if (this.barcodeToProcessingState.containsKey(barcode)) {
                return this.barcodeToProcessingState.get(barcode);
            }
            return TileBarcodeProcessingState.NA;
        }

        public void setBarcodeState(String barcode, TileBarcodeProcessingState state) {
            if (!this.barcodeToProcessingState.containsKey(barcode)) {
                throw new NoSuchElementException(String.format("No record of the provided barcode, %s.", barcode));
            }
            this.barcodeToProcessingState.put(barcode, state);
        }

        public Set<String> getBarcodes() {
            return this.getBarcodeRecords().keySet();
        }
    }

    private class TileReader {
        private final Tile tile;
        private final TileReadAggregator handler;
        private final TileProcessingRecord processingRecord;

        public TileReader(Tile tile, TileReadAggregator handler, TileProcessingRecord processingRecord) {
            this.tile = tile;
            this.handler = handler;
            this.processingRecord = processingRecord;
        }

        public void process() {
            IlluminaDataProvider dataProvider = IlluminaBasecallsToSam.this.factory.makeDataProvider(Arrays.asList(this.tile.getNumber()));
            SAMRecord[] recordContainer = new SAMRecord[IlluminaBasecallsToSam.this.converter.getNumRecordsPerCluster()];
            log.debug(String.format("Reading data from tile %s ...", this.tile.getNumber()));
            while (dataProvider.hasNext()) {
                ClusterData cluster = dataProvider.next();
                String barcode = cluster.getMatchedBarcode();
                IlluminaBasecallsToSam.this.converter.createSamRecords(cluster, null, recordContainer);
                for (SAMRecord record : recordContainer) {
                    IlluminaBasecallsToSam.this.readProgressLogger.record(record);
                    this.processingRecord.addRecord(barcode, record);
                }
            }
            this.handler.completeTile(this.tile);
        }
    }

    private class Tile
    implements Comparable<Tile> {
        private final int tileNumber;

        public Tile(int i) {
            this.tileNumber = i;
        }

        public int getNumber() {
            return this.tileNumber;
        }

        public boolean equals(Object o) {
            return o instanceof Tile && this.getNumber() == ((Tile)o).getNumber();
        }

        @Override
        public int compareTo(Tile o) {
            return TILE_NUMBER_COMPARATOR.compare(this.getNumber(), o.getNumber());
        }
    }

    private static enum TileProcessingState {
        NOT_DONE_READING,
        DONE_READING;

    }

    private static enum TileBarcodeProcessingState {
        NA,
        READ,
        QUEUED_FOR_WRITE,
        WRITTEN;

    }
}

