/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.fastq.BamToBfqWriter;

public class BamToBfq
extends CommandLineProgram {
    private static final String PROGRAM_VERSION = "1.0";
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Create BFQ files for use by the Maq aligner.";
    @Option(doc="The BAM file to parse.", shortName="I")
    public File INPUT;
    @Option(doc="The analysis directory for the binary output file. ")
    public File ANALYSIS_DIR;
    @Option(doc="Flowcell barcode (e.g. 30PYMAAXX).  ", shortName="F", mutex={"OUTPUT_FILE_PREFIX"})
    public String FLOWCELL_BARCODE;
    @Option(doc="Lane number. ", shortName="L", optional=true, mutex={"OUTPUT_FILE_PREFIX"})
    public Integer LANE;
    @Option(doc="Prefix for all output files", mutex={"FLOWCELL_BARCODE", "LANE"})
    public String OUTPUT_FILE_PREFIX;
    @Option(doc="Number of reads to align (null = all).", shortName="NUM", optional=true)
    public Integer READS_TO_ALIGN;
    @Option(doc="Number of reads to break into individual groups for alignment", shortName="CHUNK")
    public Integer READ_CHUNK_SIZE = 2000000;
    @Option(doc="Whether this is a paired-end run. ", shortName="PE")
    public Boolean PAIRED_RUN;
    @Option(doc="Deprecated option; use READ_NAME_PREFIX instead", mutex={"READ_NAME_PREFIX"}, shortName="RB", optional=true)
    public String RUN_BARCODE;
    @Option(doc="Prefix to be stripped off the beginning of all read names  (to make them short enough to run in Maq)", optional=true)
    public String READ_NAME_PREFIX;
    @Option(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public Boolean INCLUDE_NON_PF_READS = false;
    @Option(doc="Whether to clip adapters from the reads")
    public boolean CLIP_ADAPTERS = true;
    @Option(doc="The number of bases from each read to write to the bfq file.  If this is non-null, then only the first BASES_TO_WRITE bases from each read will be written.", optional=true)
    public Integer BASES_TO_WRITE = null;

    @Override
    protected int doWork() {
        String outputPrefix = this.ANALYSIS_DIR.getAbsolutePath();
        if (!outputPrefix.endsWith("/")) {
            outputPrefix = outputPrefix + "/";
        }
        outputPrefix = outputPrefix + this.OUTPUT_FILE_PREFIX + ".";
        BamToBfqWriter writer = new BamToBfqWriter(this.INPUT, outputPrefix, this.READS_TO_ALIGN, this.READ_CHUNK_SIZE, this.PAIRED_RUN, this.READ_NAME_PREFIX, this.INCLUDE_NON_PF_READS, this.CLIP_ADAPTERS, this.BASES_TO_WRITE);
        writer.writeBfqFiles();
        return 0;
    }

    public static void main(String[] argv) {
        System.exit(new BamToBfq().instanceMain(argv));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.OUTPUT_FILE_PREFIX == null) {
            this.OUTPUT_FILE_PREFIX = this.FLOWCELL_BARCODE + "." + this.LANE;
        }
        if (this.READ_NAME_PREFIX == null) {
            this.READ_NAME_PREFIX = this.RUN_BARCODE + ":";
        }
        return null;
    }
}

