/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.caller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Map;
import java.util.TreeMap;
import net.sf.samtools.SAMRecord;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.rbio.methyl.rrbs.caller.RecordReader;
import org.rbio.methyl.rrbs.caller.UniqueFilter;
import org.rbio.methyl.rrbs.util.Fragment;
import org.rbio.methyl.rrbs.util.MethylTable;

public class MethylCaller {
    @Option(name="-in_fq1", usage="input fastq end 1", required=true)
    private String in_fq1;
    @Option(name="-in_fq2", usage="input fastq end 2 [optional]", required=false)
    private String in_fq2 = null;
    @Option(name="-in_bam", usage="input paired end BAM file", required=true)
    private String in_bam;
    @Option(name="-frag_fa", usage="fragment fasta file [not bisulfite converted] ", required=true)
    private String ref_fa;
    @Option(name="-out_prefix", usage="output file prefix", required=true)
    private String out_prefix;
    Map<String, Fragment> frag_tab = null;
    Map<String, BufferedWriter> obuf_tab = new TreeMap<String, BufferedWriter>();

    public static void main(String[] args) throws Exception {
        MethylCaller call = new MethylCaller();
        CmdLineParser parser = new CmdLineParser(call);
        try {
            parser.parseArgument(args);
            call.process();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Call the C status on an RRBS sam/bam file");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        this.frag_tab = Fragment.read(this.ref_fa);
        System.out.println("fragments loaded");
        this.call();
        this.collate();
        this.concat();
    }

    public void call() throws Exception {
        RecordReader reader = new RecordReader(this.in_bam, this.in_fq1, this.in_fq2);
        int cntr = 0;
        RecordReader.ReadAlignment read_al = null;
        while ((read_al = reader.getNextReadAlignment()) != null) {
            UniqueFilter.UniqueRecord uniq_rec = null;
            uniq_rec = this.in_fq2 == null ? UniqueFilter.getUniqueSERecord(read_al.rec_lst1, this.frag_tab) : UniqueFilter.getUniquePERecord(read_al.rec_lst1, read_al.rec_lst2, this.frag_tab);
            if (uniq_rec != null) {
                Fragment frag = this.frag_tab.get(uniq_rec.rec1.getReferenceName());
                String ref = frag.getRef();
                BufferedWriter obuf = this.obuf_tab.get(ref);
                if (obuf == null) {
                    obuf = new BufferedWriter(new FileWriter(String.valueOf(this.out_prefix) + "." + ref + ".stat.txt"));
                    this.obuf_tab.put(ref, obuf);
                }
                MethylCaller.addStats(uniq_rec.rec1, read_al.read_info.read1, true, frag, obuf);
                if (this.in_fq2 != null) {
                    MethylCaller.addStats(uniq_rec.rec2, read_al.read_info.read2, false, frag, obuf);
                }
            }
            if (++cntr % 1000000 != 0) continue;
            System.out.println("Step 1 : " + cntr);
        }
        for (BufferedWriter obuf : this.obuf_tab.values()) {
            obuf.close();
        }
        System.out.println("done!");
    }

    public static void addStats(SAMRecord rec, String read_str, boolean is_first, Fragment frag, BufferedWriter obuf) throws Exception {
        int end;
        int read_len = rec.getReadLength();
        int start = 0;
        int n = end = frag.length() >= read_len ? read_len - 1 : frag.length() - 1;
        if (!is_first) {
            end = frag.length() - 1;
            int n2 = start = end - read_len + 1 >= read_len ? end - read_len + 1 : read_len;
        }
        if (is_first) {
            obuf.write("#\t" + rec.getReadName() + "/1" + "\t" + frag.getHeader() + "\n");
        } else {
            obuf.write("#\t" + rec.getReadName() + "/2" + "\t" + frag.getHeader() + "\n");
        }
        for (int pos : frag.getCList()) {
            if (pos < start || pos > end) continue;
            char bp = '$';
            if (is_first) {
                bp = read_str.charAt(pos);
            } else {
                bp = read_str.charAt(frag.length() - pos - 1);
                switch (bp) {
                    case 'G': {
                        bp = 'C';
                        break;
                    }
                    case 'C': {
                        bp = 'G';
                        break;
                    }
                    case 'A': {
                        bp = 'T';
                        break;
                    }
                    case 'T': {
                        bp = 'A';
                    }
                }
            }
            obuf.write(String.valueOf(pos) + "\t" + bp + "\n");
        }
        obuf.write("*\n");
    }

    public void collate() throws Exception {
        for (String ref : this.obuf_tab.keySet()) {
            Map<String, Map<Character, Map<Integer, MethylTable.CpG>>> cpg_tab = MethylTable.build(this.frag_tab, String.valueOf(this.out_prefix) + "." + ref + ".stat.txt");
            MethylTable.write(cpg_tab, this.frag_tab, String.valueOf(this.out_prefix) + "." + ref + ".meth.txt");
        }
    }

    public void concat() throws Exception {
        BufferedWriter obuf = new BufferedWriter(new FileWriter(String.valueOf(this.out_prefix) + ".meth.txt"));
        boolean header_added = false;
        for (String ref : this.obuf_tab.keySet()) {
            BufferedReader ibuf = new BufferedReader(new FileReader(String.valueOf(this.out_prefix) + "." + ref + ".meth.txt"));
            boolean is_first_line = true;
            String line = null;
            while ((line = ibuf.readLine()) != null) {
                if (is_first_line) {
                    if (!header_added) {
                        obuf.write(String.valueOf(line) + "\n");
                        header_added = true;
                    }
                    is_first_line = false;
                    continue;
                }
                obuf.write(String.valueOf(line) + "\n");
            }
            ibuf.close();
        }
        obuf.close();
    }
}

