/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.annotation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class CpGShore2SQL {
    @Option(name="-ifname", usage="UCSC Input CpG island file", required=true)
    public static String ifname;
    @Option(name="-dist", usage="Extent of the shore from either side of island", required=true)
    public static int dist;
    @Option(name="-ofname", usage="Output shore file", required=true)
    public static String ofname;

    public static void main(String[] args) throws Exception {
        CpGShore2SQL shore_builder = new CpGShore2SQL();
        CmdLineParser parser = new CmdLineParser(shore_builder);
        try {
            parser.parseArgument(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Make CpG shores from UCSC CpG island file");
            parser.printUsage(System.err);
        }
        CpGShore2SQL.process();
    }

    public static void process() throws Exception {
        LinkedHashMap<String, TreeSet<Interval>> isl_tab = new LinkedHashMap<String, TreeSet<Interval>>();
        BufferedReader ibuf = new BufferedReader(new FileReader(ifname));
        String line = ibuf.readLine();
        while ((line = ibuf.readLine()) != null) {
            String[] arr = line.split("\t");
            String ref = arr[1];
            int start = Integer.parseInt(arr[2]);
            int end = Integer.parseInt(arr[3]);
            TreeSet<Interval> ref_set = (TreeSet<Interval>)isl_tab.get(ref);
            if (ref_set == null) {
                ref_set = new TreeSet<Interval>();
                isl_tab.put(ref, ref_set);
            }
            ref_set.add(new Interval(start, end));
        }
        ibuf.close();
        BufferedWriter obuf = new BufferedWriter(new FileWriter(ofname));
        obuf.write("ref\tstart\tend\tdist\n");
        for (String ref : isl_tab.keySet()) {
            LinkedList isl_lst = new LinkedList((Collection)isl_tab.get(ref));
            isl_lst.addFirst(null);
            isl_lst.addLast(null);
            int i = 0;
            while (i < isl_lst.size() - 1) {
                for (Interval shore : CpGShore2SQL.buildShore((Interval)isl_lst.get(i), (Interval)isl_lst.get(i + 1))) {
                    obuf.write(String.valueOf(ref) + "\t" + shore.getStart() + "\t" + shore.getEnd() + "\t" + dist + "\n");
                }
                ++i;
            }
        }
        obuf.close();
    }

    public static List<Interval> buildShore(Interval isl1, Interval isl2) {
        ArrayList<Interval> shore_lst = new ArrayList<Interval>();
        Interval shore1 = null;
        Interval shore2 = null;
        if (isl1 != null) {
            shore1 = new Interval(isl1.getEnd() + 1, isl1.getEnd() + dist + 1);
        }
        if (isl2 != null) {
            shore2 = new Interval(isl2.getStart() - dist - 1, isl2.getStart() - 1);
        }
        if (isl1 == null) {
            shore_lst.add(shore2);
        } else if (isl2 == null) {
            shore_lst.add(shore1);
        } else if (shore1.getEnd() >= shore2.getStart()) {
            shore_lst.add(new Interval(shore1.getStart(), shore2.getEnd()));
        } else {
            shore_lst.add(shore1);
            shore_lst.add(shore2);
        }
        return shore_lst;
    }

    public static class Interval
    implements Comparable<Interval> {
        private int start;
        private int end;

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(Interval that) {
            int res = -1;
            if (this.start > that.start) {
                res = 1;
            }
            return res;
        }
    }
}

