/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotype;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.utils.MathUtils;

@Deprecated
public class DiploidSNPGenotypePriors
implements GenotypePriors {
    public static final double HUMAN_HETEROZYGOSITY = 0.001;
    public static final double CEU_HETEROZYGOSITY = 0.001;
    public static final double YRI_HETEROZYGOSITY = 0.001176470588235294;
    public static final double PROB_OF_REFERENCE_ERROR = 1.0E-6;
    private static final double[] flatPriors = new double[DiploidGenotype.values().length];
    private double[] priors = null;
    public static final boolean requirePriorSumToOne = false;

    public DiploidSNPGenotypePriors() {
        this.priors = (double[])flatPriors.clone();
    }

    public DiploidSNPGenotypePriors(byte ref, double heterozygosity, double probOfTriStateGenotype) {
        this.priors = DiploidSNPGenotypePriors.getReferencePolarizedPriors(ref, heterozygosity, probOfTriStateGenotype);
    }

    public DiploidSNPGenotypePriors(double[] log10Priors) {
        this.priors = (double[])log10Priors.clone();
    }

    @Override
    public double[] getPriors() {
        return this.priors;
    }

    public double getPrior(DiploidGenotype g) {
        return this.getPriors()[g.ordinal()];
    }

    @Override
    public double getHeterozygosity() {
        return 0.001;
    }

    @Override
    public boolean validate(boolean throwException) {
        try {
            for (DiploidGenotype g : DiploidGenotype.values()) {
                int i = g.ordinal();
                if (MathUtils.wellFormedDouble(this.priors[i]) && MathUtils.isNegativeOrZero(this.priors[i])) continue;
                String bad = String.format("Prior %f is badly formed %b", this.priors[i], MathUtils.isNegativeOrZero(this.priors[i]));
                throw new IllegalStateException(String.format("At %s: %s", g.toString(), bad));
            }
        }
        catch (IllegalStateException e) {
            if (throwException) {
                throw new RuntimeException(e);
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static double[] heterozygosity2DiploidProbabilities(double h) {
        double[] pdbls = new double[]{DiploidSNPGenotypePriors.heterozygosity2HomRefProbability(h), DiploidSNPGenotypePriors.heterozygosity2HetProbability(h), DiploidSNPGenotypePriors.heterozygosity2HomVarProbability(h)};
        return pdbls;
    }

    public static double heterozygosity2HomRefProbability(double h) {
        if (MathUtils.isNegative(h)) {
            throw new RuntimeException(String.format("Heterozygous value is bad %f", h));
        }
        double v = 1.0 - 3.0 * h / 2.0;
        if (MathUtils.isNegative(v)) {
            throw new RuntimeException(String.format("Heterozygous value is bad %f", h));
        }
        return v;
    }

    public static double heterozygosity2HetProbability(double h) {
        if (MathUtils.isNegative(h)) {
            throw new RuntimeException(String.format("Heterozygous value is bad %f", h));
        }
        return h;
    }

    public static double heterozygosity2HomVarProbability(double h) {
        if (MathUtils.isNegative(h)) {
            throw new RuntimeException(String.format("Heterozygous value is bad %f", h));
        }
        return h / 2.0;
    }

    public static double[] getReferencePolarizedPriors(byte ref, double heterozyosity, double pRefError) {
        double pHomVar;
        double pHet;
        if (!MathUtils.isBounded(pRefError, 0.0, 0.01)) {
            throw new RuntimeException(String.format("BUG: p Reference error is out of bounds (0.0 - 0.01) is allow range %f", pRefError));
        }
        double pTriStateGenotype = heterozyosity * pRefError;
        double pHomRef = DiploidSNPGenotypePriors.heterozygosity2HomRefProbability(heterozyosity);
        if (MathUtils.compareDoubles(pHomRef + (pHet = DiploidSNPGenotypePriors.heterozygosity2HetProbability(heterozyosity)) + (pHomVar = DiploidSNPGenotypePriors.heterozygosity2HomVarProbability(heterozyosity)), 1.0) != 0) {
            throw new RuntimeException(String.format("BUG: Prior probabilities don't sum to one => %f, %f, %f", pHomRef, pHet, pHomVar));
        }
        double[] priors = new double[DiploidGenotype.values().length];
        for (DiploidGenotype g : DiploidGenotype.values()) {
            double nOnRefHets = 3.0;
            double nOffRefHets = 3.0;
            double nHomVars = 3.0;
            double POfG = g.isHomRef(ref) ? pHomRef : (g.isHomVar(ref) ? pHomVar / 3.0 : (g.isHetRef(ref) ? (pHet - pTriStateGenotype) / 3.0 : pTriStateGenotype / 3.0));
            priors[g.ordinal()] = Math.log10(POfG);
        }
        return priors;
    }

    static {
        for (DiploidGenotype g : DiploidGenotype.values()) {
            DiploidSNPGenotypePriors.flatPriors[g.ordinal()] = Math.log10(1.0 / (double)DiploidGenotype.values().length);
        }
    }
}

