/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RequiredCovariate;
import org.broadinstitute.sting.utils.BitSetUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadGroupCovariate
implements RequiredCovariate {
    private final HashMap<String, Short> readGroupLookupTable = new HashMap();
    private final HashMap<Short, String> readGroupReverseLookupTable = new HashMap();
    private short nextId = 0;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public CovariateValues getValues(GATKSAMRecord read) {
        int l = read.getReadLength();
        String readGroupId = this.readGroupValueFromRG(read.getReadGroup());
        BitSet rg = this.bitSetForReadGroup(readGroupId);
        Object[] readGroups = new BitSet[l];
        Arrays.fill(readGroups, rg);
        return new CovariateValues((BitSet[])readGroups, (BitSet[])readGroups, (BitSet[])readGroups);
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    @Override
    public String keyFromBitSet(BitSet key) {
        return this.decodeReadGroup((short)BitSetUtils.longFrom(key));
    }

    @Override
    public BitSet bitSetFromKey(Object key) {
        return this.bitSetForReadGroup((String)key);
    }

    @Override
    public int numberOfBits() {
        return BitSetUtils.numberOfBitsToRepresent(32767L);
    }

    private String decodeReadGroup(short id) {
        return this.readGroupReverseLookupTable.get(id);
    }

    private BitSet bitSetForReadGroup(String readGroupId) {
        short shortId;
        if (this.readGroupLookupTable.containsKey(readGroupId)) {
            shortId = this.readGroupLookupTable.get(readGroupId);
        } else {
            shortId = this.nextId;
            this.readGroupLookupTable.put(readGroupId, this.nextId);
            this.readGroupReverseLookupTable.put(this.nextId, readGroupId);
            this.nextId = (short)(this.nextId + 1);
        }
        return BitSetUtils.bitSetFrom(shortId);
    }

    private String readGroupValueFromRG(GATKSAMReadGroupRecord rg) {
        String platformUnit = rg.getPlatformUnit();
        return platformUnit == null ? rg.getId() : platformUnit;
    }
}

