/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.bqsr.Covariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.EventType;
import org.broadinstitute.sting.utils.BitSetUtils;

public class BQSRKeyManager {
    private final List<RequiredCovariateInfo> requiredCovariates;
    private final List<OptionalCovariateInfo> optionalCovariates;
    private final Map<String, Short> covariateNameToIDMap;
    private int nRequiredBits;
    private int nOptionalBits;
    private final int nOptionalIDBits;
    private final int totalNumberOfBits;
    private final BitSet optionalCovariateMask;
    private final BitSet optionalCovariateIDMask;

    public BQSRKeyManager(List<Covariate> requiredCovariates, List<Covariate> optionalCovariates) {
        this.requiredCovariates = new ArrayList<RequiredCovariateInfo>(requiredCovariates.size());
        this.optionalCovariates = new ArrayList<OptionalCovariateInfo>(optionalCovariates.size());
        this.covariateNameToIDMap = new HashMap<String, Short>(optionalCovariates.size() * 2);
        this.nRequiredBits = 0;
        for (Covariate required : requiredCovariates) {
            int nBits = required.numberOfBits();
            BitSet mask = this.genericMask(this.nRequiredBits, nBits);
            this.requiredCovariates.add(new RequiredCovariateInfo(this.nRequiredBits, mask, required));
            this.nRequiredBits += nBits;
        }
        short id = 0;
        this.nOptionalBits = 0;
        for (Covariate optional : optionalCovariates) {
            int nBits = optional.numberOfBits();
            this.nOptionalBits = Math.max(this.nOptionalBits, nBits);
            BitSet optionalID = BitSetUtils.bitSetFrom(id);
            this.optionalCovariates.add(new OptionalCovariateInfo(optionalID, optional));
            String covariateName = optional.getClass().getSimpleName().split("Covariate")[0];
            this.covariateNameToIDMap.put(covariateName, id);
            id = (short)(id + 1);
        }
        this.nOptionalIDBits = BitSetUtils.numberOfBitsToRepresent(optionalCovariates.size());
        this.optionalCovariateMask = this.genericMask(this.nRequiredBits, this.nOptionalBits);
        this.optionalCovariateIDMask = this.genericMask(this.nRequiredBits + this.nOptionalBits, this.nOptionalIDBits);
        this.totalNumberOfBits = this.nRequiredBits + this.nOptionalBits + this.nOptionalIDBits + this.bitsInEventType();
    }

    public List<BitSet> bitSetsFromAllKeys(BitSet[] allKeys, EventType eventType) {
        LinkedList<BitSet> allBitSets = new LinkedList<BitSet>();
        BitSet eventBitSet = BitSetUtils.bitSetFrom(eventType.index);
        int eventTypeBitIndex = this.nRequiredBits + this.nOptionalBits + this.nOptionalIDBits;
        int covariateIndex = 0;
        BitSet requiredKey = new BitSet(this.nRequiredBits);
        for (RequiredCovariateInfo infoRequired : this.requiredCovariates) {
            this.addBitSetToKeyAtLocation(requiredKey, allKeys[covariateIndex++], infoRequired.bitsBefore);
        }
        for (OptionalCovariateInfo infoOptional : this.optionalCovariates) {
            BitSet covariateKey;
            if ((covariateKey = allKeys[covariateIndex++]) == null) continue;
            BitSet optionalKey = new BitSet(this.totalNumberOfBits);
            optionalKey.or(requiredKey);
            this.addBitSetToKeyAtLocation(optionalKey, covariateKey, this.nRequiredBits);
            this.addBitSetToKeyAtLocation(optionalKey, infoOptional.covariateID, this.nRequiredBits + this.nOptionalBits);
            this.addBitSetToKeyAtLocation(optionalKey, eventBitSet, eventTypeBitIndex);
            allBitSets.add(optionalKey);
        }
        if (this.optionalCovariates.size() == 0) {
            this.addBitSetToKeyAtLocation(requiredKey, eventBitSet, eventTypeBitIndex);
            allBitSets.add(requiredKey);
        }
        return allBitSets;
    }

    public BitSet bitSetFromKey(Object[] key) {
        BitSet bitSetKey = new BitSet(this.totalNumberOfBits);
        int requiredCovariate = 0;
        for (RequiredCovariateInfo infoRequired : this.requiredCovariates) {
            BitSet covariateBitSet = infoRequired.covariate.bitSetFromKey(key[requiredCovariate++]);
            this.addBitSetToKeyAtLocation(bitSetKey, covariateBitSet, infoRequired.bitsBefore);
        }
        if (this.optionalCovariates.size() > 0) {
            int optionalCovariate = this.requiredCovariates.size();
            int covariateIDIndex = optionalCovariate + 1;
            short covariateID = this.parseCovariateID(key[covariateIDIndex]);
            OptionalCovariateInfo infoOptional = this.optionalCovariates.get(covariateID);
            BitSet covariateBitSet = infoOptional.covariate.bitSetFromKey(key[optionalCovariate]);
            this.addBitSetToKeyAtLocation(bitSetKey, covariateBitSet, this.nRequiredBits);
            this.addBitSetToKeyAtLocation(bitSetKey, infoOptional.covariateID, this.nRequiredBits + this.nOptionalBits);
        }
        int eventIndex = key.length - 1;
        int eventTypeBitIndex = this.nRequiredBits + this.nOptionalBits + this.nOptionalIDBits;
        BitSet eventBitSet = this.bitSetFromEvent((EventType)((Object)key[eventIndex]));
        this.addBitSetToKeyAtLocation(bitSetKey, eventBitSet, eventTypeBitIndex);
        return bitSetKey;
    }

    private short parseCovariateID(Object id) {
        return id instanceof String ? this.covariateNameToIDMap.get(id.toString()) : (Short)id;
    }

    public List<Object> keySetFrom(BitSet key) {
        ArrayList<Object> objectKeys = new ArrayList<Object>();
        for (RequiredCovariateInfo info : this.requiredCovariates) {
            BitSet covariateBitSet = this.extractBitSetFromKey(key, info.mask, info.bitsBefore);
            objectKeys.add(info.covariate.keyFromBitSet(covariateBitSet));
        }
        if (this.optionalCovariates.size() > 0) {
            BitSet covBitSet = this.extractBitSetFromKey(key, this.optionalCovariateMask, this.nRequiredBits);
            BitSet idbs = this.extractBitSetFromKey(key, this.optionalCovariateIDMask, this.nRequiredBits + this.nOptionalBits);
            short id = BitSetUtils.shortFrom(idbs);
            Covariate covariate = this.optionalCovariates.get((int)id).covariate;
            objectKeys.add(covariate.keyFromBitSet(covBitSet));
            objectKeys.add(covariate.getClass().getSimpleName().split("Covariate")[0]);
        }
        objectKeys.add((Object)this.eventFromBitSet(key));
        return objectKeys;
    }

    public List<Covariate> getRequiredCovariates() {
        ArrayList<Covariate> list = new ArrayList<Covariate>(this.requiredCovariates.size());
        for (RequiredCovariateInfo info : this.requiredCovariates) {
            list.add(info.covariate);
        }
        return list;
    }

    public List<Covariate> getOptionalCovariates() {
        ArrayList<Covariate> list = new ArrayList<Covariate>(this.optionalCovariates.size());
        for (OptionalCovariateInfo info : this.optionalCovariates) {
            list.add(info.covariate);
        }
        return list;
    }

    private BitSet chopNBitsFrom(BitSet key, int n) {
        BitSet choppedKey = new BitSet();
        int i = key.nextSetBit(0);
        while (i >= 0) {
            choppedKey.set(i - n);
            i = key.nextSetBit(i + 1);
        }
        return choppedKey;
    }

    private BitSet genericMask(int leadingBits, int nBits) {
        BitSet mask = new BitSet(leadingBits + nBits);
        mask.set(leadingBits, leadingBits + nBits);
        return mask;
    }

    private EventType eventFromBitSet(BitSet fullKey) {
        BitSet eventKey = new BitSet();
        int firstBitIndex = this.nRequiredBits + this.nOptionalBits + this.nOptionalIDBits;
        int i = fullKey.nextSetBit(firstBitIndex);
        while (i >= 0) {
            eventKey.set(i - firstBitIndex);
            i = fullKey.nextSetBit(i + 1);
        }
        return EventType.eventFrom(BitSetUtils.shortFrom(eventKey));
    }

    private BitSet bitSetFromEvent(EventType eventType) {
        return BitSetUtils.bitSetFrom(eventType.index);
    }

    private int bitsInEventType() {
        return BitSetUtils.numberOfBitsToRepresent(EventType.values().length);
    }

    private void addBitSetToKeyAtLocation(BitSet key, BitSet bitSet, int location) {
        int j = bitSet.nextSetBit(0);
        while (j >= 0) {
            key.set(j + location);
            j = bitSet.nextSetBit(j + 1);
        }
    }

    private BitSet extractBitSetFromKey(BitSet key, BitSet mask, int leadingBits) {
        BitSet bitSet = (BitSet)key.clone();
        bitSet.and(mask);
        return this.chopNBitsFrom(bitSet, leadingBits);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BQSRKeyManager)) {
            return false;
        }
        BQSRKeyManager other = (BQSRKeyManager)o;
        if (this == other) {
            return true;
        }
        if (this.requiredCovariates.size() != other.requiredCovariates.size() || this.optionalCovariates.size() != other.optionalCovariates.size()) {
            return false;
        }
        Iterator<RequiredCovariateInfo> otherRequiredIterator = other.requiredCovariates.iterator();
        for (RequiredCovariateInfo thisInfo : this.requiredCovariates) {
            String otherName;
            RequiredCovariateInfo otherInfo = otherRequiredIterator.next();
            String thisName = thisInfo.covariate.getClass().getSimpleName();
            if (thisName.equals(otherName = otherInfo.covariate.getClass().getSimpleName())) continue;
            return false;
        }
        Iterator<OptionalCovariateInfo> otherOptionalIterator = other.optionalCovariates.iterator();
        for (OptionalCovariateInfo thisInfo : this.optionalCovariates) {
            String otherName;
            OptionalCovariateInfo otherInfo = otherOptionalIterator.next();
            String thisName = thisInfo.covariate.getClass().getSimpleName();
            if (thisName.equals(otherName = otherInfo.covariate.getClass().getSimpleName())) continue;
            return false;
        }
        return true;
    }

    class OptionalCovariateInfo {
        public final BitSet covariateID;
        public final Covariate covariate;

        OptionalCovariateInfo(BitSet covariateID, Covariate covariate) {
            this.covariateID = covariateID;
            this.covariate = covariate;
        }
    }

    class RequiredCovariateInfo {
        public final int bitsBefore;
        public final BitSet mask;
        public final Covariate covariate;

        RequiredCovariateInfo(int bitsBefore, BitSet mask, Covariate covariate) {
            this.bitsBefore = bitsBefore;
            this.mask = mask;
            this.covariate = covariate;
        }
    }
}

