/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.broadinstitute.sting.gatk.report.GATKReportColumnFormat;
import org.broadinstitute.sting.gatk.report.GATKReportDataType;

public class GATKReportColumn
extends LinkedHashMap<Object, Object> {
    private final String columnName;
    private final Object defaultValue;
    private final String format;
    private final boolean display;
    private final GATKReportDataType dataType;
    private GATKReportColumnFormat columnFormat;
    private GATKReportColumnFormat.Alignment alignment = GATKReportColumnFormat.Alignment.RIGHT;
    private int maxWidth = 0;
    private static final Collection<String> RIGHT_ALIGN_STRINGS = Arrays.asList("null", "NA", String.valueOf(Double.POSITIVE_INFINITY), String.valueOf(Double.NEGATIVE_INFINITY), String.valueOf(Double.NaN));

    public GATKReportColumn(String columnName, Object defaultValue, boolean display, String format) {
        this.columnName = columnName;
        this.maxWidth = columnName.length();
        this.display = display;
        if (format.equals("")) {
            this.format = "%s";
            this.dataType = GATKReportDataType.Unknown;
            this.defaultValue = defaultValue != null ? defaultValue : "";
        } else {
            this.format = format;
            this.dataType = GATKReportDataType.fromFormatString(format);
            this.defaultValue = defaultValue != null ? defaultValue : this.dataType.getDefaultValue();
        }
    }

    public void initialize(Object primaryKey) {
        this.put(primaryKey, this.defaultValue);
    }

    private Object getWithoutSideEffects(Object primaryKey) {
        if (!this.containsKey(primaryKey)) {
            return this.defaultValue;
        }
        return this.get(primaryKey);
    }

    public String getStringValue(Object primaryKey) {
        return this.formatValue(this.getWithoutSideEffects(primaryKey));
    }

    public boolean isDisplayable() {
        return this.display;
    }

    public GATKReportColumnFormat getColumnFormat() {
        if (this.columnFormat != null) {
            return this.columnFormat;
        }
        this.columnFormat = new GATKReportColumnFormat(this.maxWidth, this.alignment);
        return this.columnFormat;
    }

    protected static boolean isRightAlign(String value) {
        return value == null || RIGHT_ALIGN_STRINGS.contains(value) || NumberUtils.isNumber(value.trim());
    }

    private String formatValue(Object obj) {
        String value = obj == null ? "null" : (this.dataType.equals((Object)GATKReportDataType.Unknown) && (obj instanceof Double || obj instanceof Float) ? String.format("%.8f", obj) : String.format(this.format, obj));
        return value;
    }

    public GATKReportDataType getDataType() {
        return this.dataType;
    }

    public boolean isSameFormat(GATKReportColumn that) {
        return this.dataType.equals((Object)that.dataType) && this.columnName.equals(that.columnName) && this.display == that.display && this.format.equals(that.format) && this.defaultValue.equals(that.defaultValue);
    }

    boolean equals(GATKReportColumn that) {
        if (!((Object)this.keySet()).equals(that.keySet())) {
            return false;
        }
        for (Object key : this.keySet()) {
            Object ValueB;
            Object ValueA = this.get(key);
            if (this.dataType.isEqual(ValueA, ValueB = that.get(key))) continue;
            return false;
        }
        return true;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFormat() {
        if (this.dataType.equals((Object)GATKReportDataType.Unknown)) {
            return "";
        }
        return this.format;
    }

    @Override
    public Object put(Object key, Object value) {
        String formatted;
        if (value != null && !(formatted = this.formatValue(value)).equals("")) {
            this.updateMaxWidth(formatted);
            this.updateFormat(formatted);
        }
        return super.put(key, value);
    }

    private void updateMaxWidth(String formatted) {
        this.maxWidth = Math.max(formatted.length(), this.maxWidth);
    }

    private void updateFormat(String formatted) {
        if (this.alignment == GATKReportColumnFormat.Alignment.RIGHT) {
            this.alignment = GATKReportColumn.isRightAlign(formatted) ? GATKReportColumnFormat.Alignment.RIGHT : GATKReportColumnFormat.Alignment.LEFT;
        }
    }
}

