/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

public class FastqReader
implements Iterator<FastqRecord>,
Iterable<FastqRecord>,
Closeable {
    private final File fastqFile;
    private final BufferedReader reader;
    private FastqRecord nextRecord;
    private int line = 1;

    public FastqReader(File file) {
        try {
            this.fastqFile = file;
            this.reader = IoUtil.openFileForBufferedReading(this.fastqFile);
            this.nextRecord = this.readNextRecord();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    private FastqRecord readNextRecord() {
        try {
            String seqHeader = this.reader.readLine();
            if (seqHeader == null) {
                return null;
            }
            if (StringUtil.isBlank(seqHeader)) {
                throw new PicardException(this.error("Missing sequence header"));
            }
            if (!seqHeader.startsWith("@")) {
                throw new PicardException(this.error("Sequence header must start with @: " + seqHeader));
            }
            String seqLine = this.reader.readLine();
            this.checkLine(seqLine, "sequence line");
            String qualHeader = this.reader.readLine();
            this.checkLine(qualHeader, "quality header");
            if (!qualHeader.startsWith("+")) {
                throw new PicardException(this.error("Quality header must start with +: " + qualHeader));
            }
            String qualLine = this.reader.readLine();
            this.checkLine(qualLine, "quality line");
            if (seqLine.length() != qualLine.length()) {
                throw new PicardException(this.error("Sequence and quality line must be the same length"));
            }
            FastqRecord frec = new FastqRecord(seqHeader.substring(1, seqHeader.length()), seqLine, qualHeader.substring(1, qualHeader.length()), qualLine);
            this.line += 4;
            return frec;
        }
        catch (IOException e) {
            throw new PicardException(String.format("Error reading '%s'", this.fastqFile.getAbsolutePath()), e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public FastqRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when !hasNext()");
        }
        FastqRecord rec = this.nextRecord;
        this.nextRecord = this.readNextRecord();
        return rec;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public Iterator<FastqRecord> iterator() {
        return this;
    }

    public int getLineNumber() {
        return this.line;
    }

    public File getFile() {
        return this.fastqFile;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new PicardException("IO problem in file " + this.fastqFile.getAbsolutePath(), e);
        }
    }

    private void checkLine(String line, String kind) {
        if (line == null) {
            throw new PicardException(this.error("File is too short - missing " + kind + " line"));
        }
        if (StringUtil.isBlank(line)) {
            throw new PicardException(this.error("Missing " + kind));
        }
    }

    private String error(String msg) {
        return msg + " at line " + this.line + " in " + this.fastqFile.getAbsolutePath();
    }
}

