/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.gcf;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.codecs.vcf.StandardVCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.gcf.GCFGenotype;
import org.broadinstitute.sting.utils.gcf.GCFHeader;
import org.broadinstitute.sting.utils.gcf.GCFHeaderBuilder;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class GCF {
    private static final int RECORD_TERMINATOR = 123456789;
    private int chromOffset;
    private int start;
    private int stop;
    private String id;
    private List<Allele> alleleMap;
    private int[] alleleOffsets;
    private float qual;
    private byte refPad;
    private String info;
    private int filterOffset;
    private List<GCFGenotype> genotypes = Collections.emptyList();
    protected static final int BUFFER_SIZE = 0x100000;

    public GCF(GCFHeaderBuilder GCFHeaderBuilder2, VariantContext vc, boolean skipGenotypes) {
        this.chromOffset = GCFHeaderBuilder2.encodeString(vc.getChr());
        this.start = vc.getStart();
        this.stop = vc.getEnd();
        this.refPad = vc.hasReferenceBaseForIndel() ? vc.getReferenceBaseForIndel() : (byte)0;
        this.id = vc.getID();
        this.alleleMap = new ArrayList<Allele>(vc.getNAlleles());
        this.alleleOffsets = new int[vc.getNAlleles()];
        this.alleleMap.add(vc.getReference());
        this.alleleOffsets[0] = GCFHeaderBuilder2.encodeAllele(vc.getReference());
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            this.alleleMap.add(vc.getAlternateAllele(i));
            this.alleleOffsets[i + 1] = GCFHeaderBuilder2.encodeAllele(vc.getAlternateAllele(i));
        }
        this.qual = (float)vc.getLog10PError();
        this.info = this.infoFieldString(vc, GCFHeaderBuilder2);
        this.filterOffset = GCFHeaderBuilder2.encodeString(StandardVCFWriter.getFilterString(vc));
        if (!skipGenotypes) {
            this.genotypes = this.encodeGenotypes(GCFHeaderBuilder2, vc);
        }
    }

    public GCF(DataInputStream inputStream, boolean skipGenotypes) throws IOException, EOFException {
        this.chromOffset = inputStream.readInt();
        if (this.chromOffset == -1) {
            throw new EOFException();
        }
        this.start = inputStream.readInt();
        this.stop = inputStream.readInt();
        this.id = inputStream.readUTF();
        this.refPad = inputStream.readByte();
        this.alleleOffsets = GCF.readIntArray(inputStream);
        this.qual = inputStream.readFloat();
        this.info = inputStream.readUTF();
        this.filterOffset = inputStream.readInt();
        int nGenotypes = inputStream.readInt();
        int sizeOfGenotypes = inputStream.readInt();
        if (skipGenotypes) {
            this.genotypes = Collections.emptyList();
            inputStream.skipBytes(sizeOfGenotypes);
        } else {
            this.genotypes = new ArrayList<GCFGenotype>(nGenotypes);
            for (int i = 0; i < nGenotypes; ++i) {
                this.genotypes.add(new GCFGenotype(this, inputStream));
            }
        }
        int recordDone = inputStream.readInt();
        if (recordDone != 123456789) {
            throw new UserException.MalformedFile("Record not terminated by RECORD_TERMINATOR key");
        }
    }

    public int write(DataOutputStream outputStream) throws IOException {
        int startSize = outputStream.size();
        outputStream.writeInt(this.chromOffset);
        outputStream.writeInt(this.start);
        outputStream.writeInt(this.stop);
        outputStream.writeUTF(this.id);
        outputStream.writeByte(this.refPad);
        GCF.writeIntArray(this.alleleOffsets, outputStream, true);
        outputStream.writeFloat(this.qual);
        outputStream.writeUTF(this.info);
        outputStream.writeInt(this.filterOffset);
        int nGenotypes = this.genotypes.size();
        int expectedSizeOfGenotypes = nGenotypes == 0 ? 0 : this.genotypes.get(0).sizeInBytes() * nGenotypes;
        outputStream.writeInt(nGenotypes);
        outputStream.writeInt(expectedSizeOfGenotypes);
        int obsSizeOfGenotypes = 0;
        for (GCFGenotype g : this.genotypes) {
            obsSizeOfGenotypes += g.write(outputStream);
        }
        if (obsSizeOfGenotypes != expectedSizeOfGenotypes) {
            throw new RuntimeException("Expect and observed genotype sizes disagree! expect = " + expectedSizeOfGenotypes + " obs =" + obsSizeOfGenotypes);
        }
        outputStream.writeInt(123456789);
        return outputStream.size() - startSize;
    }

    public VariantContext decode(String source, GCFHeader header) {
        String contig = header.getString(this.chromOffset);
        this.alleleMap = header.getAlleles(this.alleleOffsets);
        VariantContextBuilder builder = new VariantContextBuilder(source, contig, this.start, this.stop, this.alleleMap);
        builder.genotypes(this.decodeGenotypes(header));
        builder.log10PError(this.qual);
        builder.filters(header.getFilters(this.filterOffset));
        builder.attribute("INFO", this.info);
        builder.referenceBaseForIndel(this.refPad == 0 ? null : Byte.valueOf(this.refPad));
        return builder.make();
    }

    private GenotypesContext decodeGenotypes(GCFHeader header) {
        if (this.genotypes.isEmpty()) {
            return VariantContext.NO_GENOTYPES;
        }
        GenotypesContext map = GenotypesContext.create(this.genotypes.size());
        for (int i = 0; i < this.genotypes.size(); ++i) {
            String sampleName = header.getSample(i);
            Genotype g = this.genotypes.get(i).decode(sampleName, header, this, this.alleleMap);
            map.add(g);
        }
        return map;
    }

    private List<GCFGenotype> encodeGenotypes(GCFHeaderBuilder GCFHeaderBuilder2, VariantContext vc) {
        int nGenotypes = vc.getNSamples();
        if (nGenotypes > 0) {
            ArrayList<GCFGenotype> genotypes = new ArrayList<GCFGenotype>(nGenotypes);
            for (int i = 0; i < nGenotypes; ++i) {
                genotypes.add(null);
            }
            for (Genotype g : vc.getGenotypes()) {
                int i = GCFHeaderBuilder2.encodeSample(g.getSampleName());
                genotypes.set(i, new GCFGenotype(GCFHeaderBuilder2, this.alleleMap, g));
            }
            return genotypes;
        }
        return Collections.emptyList();
    }

    public int getNAlleles() {
        return this.alleleOffsets.length;
    }

    private final String infoFieldString(VariantContext vc, GCFHeaderBuilder GCFHeaderBuilder2) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Object> field : vc.getAttributes().entrySet()) {
            String key = field.getKey();
            int stringIndex = GCFHeaderBuilder2.encodeString(key);
            String outputValue = StandardVCFWriter.formatVCFField(field.getValue());
            if (outputValue == null) continue;
            if (!first) {
                s.append(";");
            }
            s.append(stringIndex).append("=").append(outputValue);
            first = false;
        }
        return s.toString();
    }

    public static DataInputStream createDataInputStream(InputStream stream) {
        return new DataInputStream(new BufferedInputStream(stream, 0x100000));
    }

    public static FileInputStream createFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    protected static final int[] readIntArray(DataInputStream inputStream) throws IOException {
        return GCF.readIntArray(inputStream, inputStream.readInt());
    }

    protected static final int[] readIntArray(DataInputStream inputStream, int size) throws IOException {
        int[] array = new int[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = inputStream.readInt();
        }
        return array;
    }

    protected static final void writeIntArray(int[] array, DataOutputStream outputStream, boolean writeSize) throws IOException {
        if (writeSize) {
            outputStream.writeInt(array.length);
        }
        for (int i : array) {
            outputStream.writeInt(i);
        }
    }

    protected static final byte[] readByteArray(DataInputStream inputStream) throws IOException {
        return GCF.readByteArray(inputStream, inputStream.readInt());
    }

    protected static final byte[] readByteArray(DataInputStream inputStream, int size) throws IOException {
        byte[] array = new byte[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = inputStream.readByte();
        }
        return array;
    }

    protected static final void writeByteArray(byte[] array, DataOutputStream outputStream, boolean writeSize) throws IOException {
        if (writeSize) {
            outputStream.writeInt(array.length);
        }
        for (byte i : array) {
            outputStream.writeByte(i);
        }
    }

    protected static final byte qualToByte(double phredScaledQual) {
        return (byte)Math.round(Math.min(phredScaledQual, 255.0));
    }
}

