/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.sf.samtools.Cigar;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class Haplotype {
    protected final byte[] bases;
    protected final double[] quals;
    private GenomeLoc genomeLocation = null;
    private HashMap<String, double[]> readLikelihoodsPerSample = null;
    private HashMap<Integer, VariantContext> eventMap = null;
    private boolean isRef = false;
    private Cigar cigar;
    private int alignmentStartHapwrtRef;

    public Haplotype(byte[] bases, int qual) {
        this.bases = bases;
        this.quals = new double[bases.length];
        Arrays.fill(this.quals, (double)qual);
    }

    public Haplotype(byte[] bases, double[] quals) {
        this.bases = bases;
        this.quals = quals;
    }

    public Haplotype(byte[] bases) {
        this(bases, 0);
    }

    public Haplotype(byte[] bases, GenomeLoc loc) {
        this(bases);
        this.genomeLocation = loc;
    }

    public boolean equals(Object h) {
        return h instanceof Haplotype && Arrays.equals(this.bases, ((Haplotype)h).bases);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bases);
    }

    public void addReadLikelihoods(String sample, double[] readLikelihoods) {
        if (this.readLikelihoodsPerSample == null) {
            this.readLikelihoodsPerSample = new HashMap();
        }
        this.readLikelihoodsPerSample.put(sample, readLikelihoods);
    }

    @Ensures(value={"result != null"})
    public double[] getReadLikelihoods(String sample) {
        return this.readLikelihoodsPerSample.get(sample);
    }

    public Set<String> getSampleKeySet() {
        return this.readLikelihoodsPerSample.keySet();
    }

    public HashMap<Integer, VariantContext> getEventMap() {
        return this.eventMap;
    }

    public void setEventMap(HashMap<Integer, VariantContext> eventMap) {
        this.eventMap = eventMap;
    }

    public boolean isReference() {
        return this.isRef;
    }

    public void setIsReference(boolean isRef) {
        this.isRef = isRef;
    }

    public double getQualitySum() {
        double s = 0.0;
        for (int k = 0; k < this.bases.length; ++k) {
            s += this.quals[k];
        }
        return s;
    }

    public String toString() {
        return new String(this.bases);
    }

    public double[] getQuals() {
        return this.quals;
    }

    public byte[] getBases() {
        return this.bases;
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getStop();
    }

    public int getAlignmentStartHapwrtRef() {
        return this.alignmentStartHapwrtRef;
    }

    public void setAlignmentStartHapwrtRef(int alignmentStartHapwrtRef) {
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
    }

    public Cigar getCigar() {
        return this.cigar;
    }

    public void setCigar(Cigar cigar) {
        this.cigar = cigar;
    }

    @Requires(value={"refInsertLocation >= 0"})
    public byte[] insertAllele(Allele refAllele, Allele altAllele, int refInsertLocation) {
        byte[] newHaplotype;
        int haplotypeInsertLocation;
        if (refAllele.length() != altAllele.length()) {
            ++refInsertLocation;
        }
        if ((haplotypeInsertLocation = ReadUtils.getReadCoordinateForReferenceCoordinate(this.alignmentStartHapwrtRef, this.cigar, refInsertLocation, ReadUtils.ClippingTail.RIGHT_TAIL, true)) == -1) {
            return (byte[])this.bases.clone();
        }
        try {
            if (refAllele.length() == altAllele.length()) {
                newHaplotype = (byte[])this.bases.clone();
                for (int iii = 0; iii < altAllele.length(); ++iii) {
                    newHaplotype[haplotypeInsertLocation + iii] = altAllele.getBases()[iii];
                }
            } else if (refAllele.length() < altAllele.length()) {
                int iii;
                int altAlleleLength = altAllele.length();
                newHaplotype = new byte[this.bases.length + altAlleleLength];
                for (iii = 0; iii < this.bases.length; ++iii) {
                    newHaplotype[iii] = this.bases[iii];
                }
                for (iii = newHaplotype.length - 1; iii > haplotypeInsertLocation + altAlleleLength - 1; --iii) {
                    newHaplotype[iii] = newHaplotype[iii - altAlleleLength];
                }
                for (iii = 0; iii < altAlleleLength; ++iii) {
                    newHaplotype[haplotypeInsertLocation + iii] = altAllele.getBases()[iii];
                }
            } else {
                int iii;
                int shift = refAllele.length() - altAllele.length();
                newHaplotype = new byte[this.bases.length - shift];
                for (iii = 0; iii < haplotypeInsertLocation + altAllele.length(); ++iii) {
                    newHaplotype[iii] = this.bases[iii];
                }
                for (iii = haplotypeInsertLocation + altAllele.length(); iii < newHaplotype.length; ++iii) {
                    newHaplotype[iii] = this.bases[iii + shift];
                }
            }
        }
        catch (Exception e) {
            return (byte[])this.bases.clone();
        }
        return newHaplotype;
    }

    public static LinkedHashMap<Allele, Haplotype> makeHaplotypeListFromAlleles(List<Allele> alleleList, int startPos, ReferenceContext ref, int haplotypeSize, int numPrefBases) {
        LinkedHashMap<Allele, Haplotype> haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
        Allele refAllele = null;
        for (Allele a : alleleList) {
            if (!a.isReference()) continue;
            refAllele = a;
            break;
        }
        if (refAllele == null) {
            throw new ReviewedStingException("BUG: no ref alleles in input to makeHaplotypeListfrom Alleles at loc: " + startPos);
        }
        byte[] refBases = ref.getBases();
        int startIdxInReference = 1 + startPos - numPrefBases - ref.getWindow().getStart();
        byte[] basesBeforeVariant = Arrays.copyOfRange(refBases, startIdxInReference, startIdxInReference + numPrefBases);
        int startAfter = startIdxInReference + numPrefBases + refAllele.getBases().length;
        if (startAfter > refBases.length) {
            startAfter = refBases.length;
        }
        byte[] basesAfterVariant = Arrays.copyOfRange(refBases, startAfter, refBases.length);
        int startLoc = ref.getWindow().getStart() + startIdxInReference;
        int stopLoc = startLoc + haplotypeSize - 1;
        GenomeLoc locus = ref.getGenomeLocParser().createGenomeLoc(ref.getLocus().getContig(), startLoc, stopLoc);
        for (Allele a : alleleList) {
            byte[] alleleBases = a.getBases();
            String haplotypeString = new String(basesBeforeVariant) + new String(alleleBases) + new String(basesAfterVariant);
            haplotypeString = haplotypeString.substring(0, haplotypeSize);
            haplotypeMap.put(a, new Haplotype(haplotypeString.getBytes(), locus));
        }
        return haplotypeMap;
    }
}

