/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;

class MultipleBaseCounts {
    private Map<Integer, Integer> baseCounts = new HashMap<Integer, Integer>();
    private GenomeLoc phasingLocus;

    public MultipleBaseCounts(GenomeLoc phasingLoc) {
        this.phasingLocus = phasingLoc;
    }

    public boolean samePhasingLocAs(GenomeLoc loc) {
        return this.phasingLocus.equals(loc);
    }

    public void incrementBaseCount(byte base) {
        int baseIndex = BaseUtils.simpleBaseToBaseIndex(base);
        Integer cnt = this.baseCounts.get(baseIndex);
        if (cnt == null) {
            cnt = 0;
        }
        this.baseCounts.put(baseIndex, cnt + 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Base counts");
        for (Map.Entry<Integer, Integer> baseCountEntry : this.baseCounts.entrySet()) {
            byte base = BaseUtils.baseIndexToSimpleBase(baseCountEntry.getKey());
            int cnt = baseCountEntry.getValue();
            sb.append("\t" + (char)base + ": " + cnt);
        }
        return sb.toString();
    }
}

