/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.exome.mutect;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.TreeMap;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class MakeMutectTableA {
    @Option(name="-i", usage="mutect folder result dir", required=true)
    private String idir;
    @Option(name="-o", usage="output file prefix", required=true)
    private String oprefix;

    public void process() throws Exception {
        TreeMap<String, Boolean> ref_map = new TreeMap<String, Boolean>();
        int i = 1;
        while (i < 25) {
            ref_map.put("chr" + i, true);
            ++i;
        }
        ref_map.put("chrX", true);
        ref_map.put("chrY", true);
        BufferedWriter obuf1 = new BufferedWriter(new FileWriter(String.valueOf(this.oprefix) + ".parse.txt"));
        BufferedWriter obuf2 = new BufferedWriter(new FileWriter(String.valueOf(this.oprefix) + ".polyphen.input.txt"));
        File dir = new File(this.idir);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fname = file.getName();
            if (fname.endsWith("out")) {
                String pt = fname.substring(0, 2);
                BufferedReader ibuf = new BufferedReader(new FileReader(file));
                String line = ibuf.readLine();
                ibuf.readLine();
                while ((line = ibuf.readLine()) != null) {
                    String[] arr = line.split("\t");
                    if (arr[arr.length - 1].compareTo("KEEP") != 0) continue;
                    String ref = arr[0];
                    String pos = arr[1];
                    String ref_bp = arr[2].toUpperCase();
                    String mut_bp = arr[3].toUpperCase();
                    if (!ref_map.containsKey(ref)) continue;
                    obuf1.write(String.valueOf(pt) + "\t" + line + "\n");
                    obuf2.write(String.valueOf(ref) + ":" + pos + " " + ref_bp + "/" + mut_bp + "\n");
                }
                ibuf.close();
            }
            ++n2;
        }
        obuf1.close();
        obuf2.close();
    }

    public static void main(String[] args) {
        MakeMutectTableA cargs = new MakeMutectTableA();
        CmdLineParser parser = new CmdLineParser(cargs);
        try {
            parser.parseArgument(args);
            cargs.process();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Mutect table [dataset A]");
            parser.printUsage(System.err);
            return;
        }
    }
}

