/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.gcf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class GCFHeader {
    protected static final Logger logger = Logger.getLogger(GCFHeader.class);
    public static final int GCF_VERSION = 1;
    public static final byte[] GCF_FILE_START_MARKER = "GCF\u0001".getBytes();
    public static final int FOOTER_START_MARKER = -1;
    public static final long HEADER_FORWARD_REFERENCE_OFFSET = GCF_FILE_START_MARKER.length + 4;
    final int version;
    long footerPosition;
    final List<Allele> alleles;
    final List<String> strings;
    final List<String> samples;
    final List<Set<String>> filters;

    public GCFHeader(Map<Allele, Integer> allelesIn, Map<String, Integer> stringIn, Map<String, Integer> samplesIn) {
        this.version = 1;
        this.footerPosition = 0L;
        this.alleles = GCFHeader.linearize(allelesIn);
        this.strings = GCFHeader.linearize(stringIn);
        this.samples = GCFHeader.linearize(samplesIn);
        this.filters = null;
    }

    public GCFHeader(FileInputStream fileInputStream) throws IOException {
        DataInputStream inputStream = new DataInputStream(fileInputStream);
        byte[] headerTest = new byte[GCF_FILE_START_MARKER.length];
        inputStream.read(headerTest);
        if (!Arrays.equals(headerTest, GCF_FILE_START_MARKER)) {
            throw new UserException("Could not read GVCF file.  GCF_FILE_START_MARKER missing.  Saw " + new String(headerTest));
        }
        this.version = inputStream.readInt();
        logger.info("Read GCF version " + this.version);
        this.footerPosition = inputStream.readLong();
        logger.info("Read footer position of " + this.footerPosition);
        long lastPos = fileInputStream.getChannel().position();
        logger.info("  Last position is " + lastPos);
        fileInputStream.getChannel().position(this.footerPosition);
        if (inputStream.readInt() != -1) {
            throw new UserException.MalformedFile("Malformed GCF file: couldn't find the footer marker");
        }
        this.alleles = GCFHeader.stringsToAlleles(GCFHeader.readStrings(inputStream));
        this.strings = GCFHeader.readStrings(inputStream);
        this.samples = GCFHeader.readStrings(inputStream);
        logger.info(String.format("Allele map of %d elements", this.alleles.size()));
        logger.info(String.format("String map of %d elements", this.strings.size()));
        logger.info(String.format("Sample map of %d elements", this.samples.size()));
        this.filters = this.initializeFilterCache();
        fileInputStream.getChannel().position(lastPos);
    }

    public static int writeHeader(DataOutputStream outputStream) throws IOException {
        int startBytes = outputStream.size();
        outputStream.write(GCF_FILE_START_MARKER);
        outputStream.writeInt(1);
        outputStream.writeLong(0L);
        return outputStream.size() - startBytes;
    }

    public int writeFooter(DataOutputStream outputStream) throws IOException {
        int startBytes = outputStream.size();
        outputStream.writeInt(-1);
        this.write(outputStream, this.allelesToStrings(this.alleles));
        this.write(outputStream, this.strings);
        this.write(outputStream, this.samples);
        return outputStream.size() - startBytes;
    }

    private void write(DataOutputStream outputStream, List<String> l) throws IOException {
        outputStream.writeInt(l.size());
        for (String elt : l) {
            outputStream.writeUTF(elt);
        }
    }

    private List<String> allelesToStrings(List<Allele> alleles) {
        ArrayList<String> strings = new ArrayList<String>(alleles.size());
        for (Allele allele : alleles) {
            strings.add(allele.toString());
        }
        return strings;
    }

    private List<Set<String>> initializeFilterCache() {
        ArrayList<Set<String>> l = new ArrayList<Set<String>>(this.strings.size());
        for (int i = 0; i < this.strings.size(); ++i) {
            l.add(null);
        }
        return l;
    }

    private static List<Allele> stringsToAlleles(List<String> strings) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(strings.size());
        for (String string : strings) {
            boolean isRef = string.endsWith("*");
            if (isRef) {
                string = string.substring(0, string.length() - 1);
            }
            alleles.add(Allele.create(string, isRef));
        }
        return alleles;
    }

    private static List<String> readStrings(DataInputStream inputStream) throws IOException {
        int nStrings = inputStream.readInt();
        ArrayList<String> strings = new ArrayList<String>(nStrings);
        for (int i = 0; i < nStrings; ++i) {
            strings.add(inputStream.readUTF());
        }
        return strings;
    }

    private static <T> List<T> linearize(Map<T, Integer> map) {
        ArrayList<T> l = new ArrayList<T>(map.size());
        for (int i = 0; i < map.size(); ++i) {
            l.add(null);
        }
        for (Map.Entry<T, Integer> elt : map.entrySet()) {
            l.set(elt.getValue(), elt.getKey());
        }
        return l;
    }

    public String getSample(int offset) {
        return this.samples.get(offset);
    }

    public String getString(int offset) {
        return this.strings.get(offset);
    }

    public Allele getAllele(int offset) {
        return this.alleles.get(offset);
    }

    public List<Allele> getAlleles(int[] offsets) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(offsets.length);
        for (int i : offsets) {
            alleles.add(this.getAllele(i));
        }
        return alleles;
    }

    public Set<String> getFilters(int offset) {
        Set<String> cached = this.filters.get(offset);
        if (cached != null) {
            return cached;
        }
        String filterString = this.getString(offset);
        if (filterString.equals(".")) {
            return null;
        }
        Set<String> set = VCFCodec.parseFilters(null, -1, filterString);
        this.filters.set(offset, set);
        return set;
    }
}

