/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class AllelePair {
    private Allele top;
    private Allele bottom;

    public AllelePair(Genotype gt) {
        if (gt.getPloidy() != 2) {
            throw new ReviewedStingException("AllelePair must have ploidy of 2! incoming gt was" + gt.toBriefString());
        }
        this.top = gt.getAllele(0);
        this.bottom = gt.getAllele(1);
    }

    public Allele getTopAllele() {
        return this.top;
    }

    public Allele getBottomAllele() {
        return this.bottom;
    }

    public void swapAlleles() {
        Allele tmp = this.top;
        this.top = this.bottom;
        this.bottom = tmp;
    }

    public List<Allele> getAllelesAsList() {
        ArrayList<Allele> allList = new ArrayList<Allele>(2);
        allList.add(0, this.top);
        allList.add(1, this.bottom);
        return allList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Top:\t" + this.top.getBaseString() + "\n");
        sb.append("Bot:\t" + this.bottom.getBaseString() + "\n");
        return sb.toString();
    }
}

