/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.SampleStatistics;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class IntervalStatistics {
    private final Map<String, SampleStatistics> samples;
    private final GenomeLoc interval;
    private int preComputedTotalCoverage = -1;

    public IntervalStatistics(Set<String> samples, GenomeLoc interval, int minimumCoverageThreshold, int maximumCoverageThreshold, int minimumMappingQuality, int minimumBaseQuality) {
        this.interval = interval;
        this.samples = new HashMap<String, SampleStatistics>(samples.size());
        for (String sample : samples) {
            this.samples.put(sample, new SampleStatistics(interval, minimumCoverageThreshold, maximumCoverageThreshold, minimumMappingQuality, minimumBaseQuality));
        }
    }

    public SampleStatistics getSample(String sample) {
        return this.samples.get(sample);
    }

    public GenomeLoc getInterval() {
        return this.interval;
    }

    public void addLocus(AlignmentContext context) {
        ReadBackedPileup pileup = context.getBasePileup();
        Map<String, ReadBackedPileup> samplePileups = pileup.getPileupsForSamples(this.samples.keySet());
        for (Map.Entry<String, ReadBackedPileup> entry : samplePileups.entrySet()) {
            String sample = entry.getKey();
            ReadBackedPileup samplePileup = entry.getValue();
            SampleStatistics sampleStatistics = this.samples.get(sample);
            if (sampleStatistics == null) {
                throw new ReviewedStingException(String.format("Trying to add locus statistics to a sample (%s) that doesn't exist in the Interval.", sample));
            }
            sampleStatistics.addLocus(context.getLocation(), samplePileup);
        }
    }

    public double averageCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return (double)this.preComputedTotalCoverage / (double)this.interval.size();
    }

    private void calculateTotalCoverage() {
        this.preComputedTotalCoverage = 0;
        for (SampleStatistics sample : this.samples.values()) {
            this.preComputedTotalCoverage = (int)((long)this.preComputedTotalCoverage + sample.totalCoverage());
        }
    }

    public Set<CallableStatus> callableStatuses() {
        HashSet<CallableStatus> output = new HashSet<CallableStatus>();
        for (SampleStatistics sample : this.samples.values()) {
            output.addAll(sample.getCallableStatuses());
        }
        return output;
    }
}

