/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.IlluminaBasecallsToSam;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class CheckIlluminaDirectory
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CheckIlluminaDirectory.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Check that the files to provide the data specified by DATA_TYPES are available, exist, and are reasonably sized for every tile/cycle.  " + "Reasonably sized means non-zero sized for files that exist per tile and equal size for binary files that exist per cycle/per tile. " + "CheckIlluminaDirectory  DOES NOT check that the individual records in a file are well-formed.\n";
    @Option(doc="The basecalls output directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="The data types that should be available for each tile/cycle.  If this value remains null then the data types that are used inIlluminaBaseCallsToSam which is a superset of those used in ExtractIlluminaBarcodes.  These data types vary slightly depending onwhether or not the run is barcoded so READ_STRUCTURE should be the same as that passed to IlluminaBaseCallsToSam.  Therefore, if you omit this option and IlluminaDirIntegrityChecker passes then both those programs should complete UNLESS the individual records of the files themselves are spurious. ", shortName="DT", optional=true)
    public final Set<IlluminaDataType> DATA_TYPES = new TreeSet<IlluminaDataType>();
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.  Note:  If you want to check whether or not a future IlluminaBasecallsToSam or ExtractIlluminaBarcodes run will fail then be sure to use the exact same READ_STRUCTURE that you would pass to these programs for this run.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Lane number. ", shortName="L", minElements=1)
    public List<Integer> LANES;

    public static void main(String[] argv) {
        new CheckIlluminaDirectory().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        ReadStructure readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.DATA_TYPES.size() == 0) {
            this.DATA_TYPES.addAll(Arrays.asList(IlluminaBasecallsToSam.DATA_TYPES_NO_BARCODE));
        }
        ArrayList<Integer> failingLanes = new ArrayList<Integer>();
        int totalFailures = 0;
        int[] expectedCycles = new OutputMapping(readStructure).getOutputCycles();
        log.info("Checking lanes(" + StringUtil.join(",", this.LANES) + " in basecalls directory (" + this.BASECALLS_DIR.getAbsolutePath() + ")\n");
        log.info("Expected cycles: " + StringUtil.intValuesToString(expectedCycles));
        for (Integer lane : this.LANES) {
            IlluminaFileUtil fileUtil = new IlluminaFileUtil(this.BASECALLS_DIR, lane);
            List<Integer> expectedTiles = fileUtil.getExpectedTiles();
            log.info("Checking lane " + lane);
            log.info("Expected tiles: " + StringUtil.join(", ", expectedTiles));
            int numFailures = CheckIlluminaDirectory.verifyLane(fileUtil, expectedTiles, expectedCycles, this.DATA_TYPES);
            if (numFailures > 0) {
                log.info("Lane " + lane + " FAILED " + " Total Errors: " + numFailures);
                failingLanes.add(lane);
                totalFailures += numFailures;
                continue;
            }
            log.info("Lane " + lane + " SUCCEEDED ");
        }
        int status = 0;
        if (totalFailures == 0) {
            log.info("SUCCEEDED!  All required files are present and non-empty.");
        } else {
            status = totalFailures;
            log.info("FAILED! There were " + totalFailures + " in the following lanes: " + StringUtil.join(", ", failingLanes));
        }
        return status;
    }

    private static final int verifyLane(IlluminaFileUtil fileUtil, List<Integer> expectedTiles, int[] cycles, Set<IlluminaDataType> dataTypes) {
        if (expectedTiles.size() == 0) {
            throw new PicardException("0 input tiles were specified!  Check to make sure this lane is in the InterOp file!");
        }
        if (cycles.length == 0) {
            throw new PicardException("0 output cycles were specified!");
        }
        int numFailures = 0;
        Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToDataTypes = IlluminaDataProviderFactory.determineFormats(dataTypes, fileUtil);
        Set<IlluminaDataType> unmatchedDataTypes = IlluminaDataProviderFactory.findUnmatchedTypes(dataTypes, formatToDataTypes);
        if (unmatchedDataTypes.size() > 0) {
            log.info("Could not find a format with available files for the following data types: " + StringUtil.join(", ", new ArrayList<IlluminaDataType>(unmatchedDataTypes)));
            numFailures += unmatchedDataTypes.size();
        }
        for (IlluminaFileUtil.SupportedIlluminaFormat format : formatToDataTypes.keySet()) {
            List<String> failures = fileUtil.getUtil(format).verify(expectedTiles, cycles);
            numFailures += failures.size();
            for (String failure : failures) {
                log.info(failure);
            }
        }
        return numFailures;
    }

    @Override
    protected String[] customCommandLineValidation() {
        IoUtil.assertDirectoryIsReadable(this.BASECALLS_DIR);
        ArrayList<String> errors = new ArrayList<String>();
        for (Integer lane : this.LANES) {
            if (lane >= 1) continue;
            errors.add("LANES must be greater than or equal to 1.  LANES passed in " + StringUtil.join(", ", this.LANES));
            break;
        }
        if (errors.size() == 0) {
            return null;
        }
        return errors.toArray(new String[errors.size()]);
    }
}

