/*
 * Decompiled with CFR 0.152.
 */
package prg.rbio.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.rbio.methyl.rrbs.util.Fragment;

public class UniqueRecordFilter {
    UniqueRecord uniq_rec = new UniqueRecord();
    List<SAMRecord> lst1 = new ArrayList<SAMRecord>();
    List<SAMRecord> lst2 = new ArrayList<SAMRecord>();

    public void updateRecList(List<SAMRecord> rec_lst, boolean is_pe) {
        this.lst1.clear();
        this.lst2.clear();
        if (is_pe) {
            for (SAMRecord rec : rec_lst) {
                if (rec.getFirstOfPairFlag()) {
                    this.lst1.add(rec);
                    continue;
                }
                this.lst2.add(rec);
            }
        } else {
            this.lst1 = rec_lst;
        }
    }

    public UniqueRecord getUniquePERecord(List<SAMRecord> rec_lst, Map<String, Fragment> frag_tab) {
        this.updateRecList(rec_lst, true);
        SAMRecord uniq_rec1 = null;
        SAMRecord uniq_rec2 = null;
        int paired_align_cntr = 0;
        for (SAMRecord rec1 : this.lst1) {
            if (rec1.getReadUnmappedFlag()) continue;
            for (SAMRecord rec2 : this.lst2) {
                if (rec2.getReadUnmappedFlag() || rec1.getReferenceName().compareTo(rec2.getReferenceName()) != 0) continue;
                Fragment frag = frag_tab.get(rec2.getReferenceName());
                int adapter_len = frag.adapterLength(rec2.getReadLength());
                if (rec1.getAlignmentStart() != adapter_len + 1 || rec2.getAlignmentEnd() != frag.length() + adapter_len) continue;
                uniq_rec1 = rec1;
                uniq_rec2 = rec2;
                ++paired_align_cntr;
            }
            if (paired_align_cntr > 1) break;
        }
        this.uniq_rec.reset();
        if (paired_align_cntr == 1) {
            this.uniq_rec.rec1 = uniq_rec1;
            this.uniq_rec.rec2 = uniq_rec2;
        }
        return this.uniq_rec;
    }

    public UniqueRecord getUniqueSERecord(List<SAMRecord> rec_lst, Map<String, Fragment> frag_tab) {
        this.updateRecList(rec_lst, false);
        SAMRecord uniq_rec1 = null;
        int se_align_cntr = 0;
        for (SAMRecord rec1 : this.lst1) {
            if (rec1.getReadUnmappedFlag()) continue;
            Fragment frag = frag_tab.get(rec1.getReferenceName());
            int adapter_len = frag.adapterLength(rec1.getReadLength());
            if (rec1.getAlignmentStart() == adapter_len + 1) {
                uniq_rec1 = rec1;
                ++se_align_cntr;
            }
            if (se_align_cntr > 1) break;
        }
        this.uniq_rec.reset();
        if (se_align_cntr == 1) {
            this.uniq_rec.rec1 = uniq_rec1;
        }
        return this.uniq_rec;
    }

    public class UniqueRecord {
        public SAMRecord rec1 = null;
        public SAMRecord rec2 = null;

        public void reset() {
            this.rec1 = null;
            this.rec2 = null;
        }
    }
}

