/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.paper.rrbscaller.simulator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.rbio.methyl.rrbs.util.Fragment;
import org.rbio.paper.rrbscaller.simulator.RRBSSimulator;
import org.rbio.util.GStringUtil;

public class RRBSReadSimulator {
    RRBSSimulator sim;

    public RRBSReadSimulator(RRBSSimulator sim) {
        this.sim = sim;
    }

    public void makeReads(Map<String, Fragment> frag_tab) throws Exception {
        Random rnd_gen = new Random(this.sim.rnd_seed);
        TreeMap<Integer, ArrayList<Fragment>> frag_len_tab = new TreeMap<Integer, ArrayList<Fragment>>();
        for (Fragment frag : frag_tab.values()) {
            int len = frag.length();
            ArrayList<Fragment> frag_lst = (ArrayList<Fragment>)frag_len_tab.get(len);
            if (frag_lst == null) {
                frag_lst = new ArrayList<Fragment>();
                frag_len_tab.put(len, frag_lst);
            }
            frag_lst.add(frag);
        }
        BufferedWriter obuf_end1 = new BufferedWriter(new FileWriter(String.valueOf(this.sim.oprefix) + "_end1.fastq"));
        BufferedWriter obuf_end2 = new BufferedWriter(new FileWriter(String.valueOf(this.sim.oprefix) + "_end2.fastq"));
        BufferedWriter obuf_se_stat = new BufferedWriter(new FileWriter(String.valueOf(this.sim.oprefix) + "_stat_se.txt"));
        BufferedWriter obuf_pe_stat = new BufferedWriter(new FileWriter(String.valueOf(this.sim.oprefix) + "_stat_pe.txt"));
        BufferedWriter obuf_frag_len = new BufferedWriter(new FileWriter(String.valueOf(this.sim.oprefix) + "_frag_len.txt"));
        StringBuilder qual = new StringBuilder();
        int i = 0;
        while (i < this.sim.read_len) {
            qual.append('e');
            ++i;
        }
        i = 0;
        while (i < this.sim.num_read) {
            List frag_lst;
            int rnd_len = (int)(rnd_gen.nextGaussian() * (double)this.sim.sd_frag_len + (double)this.sim.mean_frag_len);
            if (rnd_len < this.sim.min_frag_len || rnd_len > this.sim.max_frag_len || (frag_lst = (List)frag_len_tab.get(rnd_len)) == null) continue;
            Fragment frag = (Fragment)frag_lst.get(rnd_gen.nextInt(frag_lst.size()));
            StringBuilder meth_frag_str = new StringBuilder(frag.getFragString());
            for (Integer pos : frag.getCList()) {
                double meth_trial = rnd_gen.nextDouble();
                meth_frag_str.setCharAt(pos, 'T');
                if (!(meth_trial <= this.sim.prob)) continue;
                meth_frag_str.setCharAt(pos, 'C');
            }
            this.addEnd1(frag, meth_frag_str, obuf_end1, obuf_se_stat, obuf_pe_stat, i, qual);
            this.addEnd2(frag, meth_frag_str, obuf_end2, obuf_pe_stat, i, qual);
            obuf_frag_len.write(String.valueOf(frag.length()) + "\n");
            ++i;
        }
        obuf_end1.close();
        obuf_end2.close();
        obuf_se_stat.close();
        obuf_pe_stat.close();
        obuf_frag_len.close();
    }

    public void addEnd1(Fragment frag, StringBuilder meth_frag_str, BufferedWriter obuf_end1, BufferedWriter obuf_se_stat, BufferedWriter obuf_pe_stat, int header, StringBuilder qual) throws Exception {
        String stat_header = "#\t" + header + "/1\t" + frag.getHeader() + "\n";
        obuf_se_stat.write(stat_header);
        obuf_pe_stat.write(stat_header);
        for (Integer C_pos : frag.getCList()) {
            if (C_pos >= this.sim.read_len) continue;
            String val = C_pos + "\t" + meth_frag_str.charAt(C_pos) + "\n";
            obuf_se_stat.write(val);
            obuf_pe_stat.write(val);
        }
        obuf_se_stat.write("*\n");
        obuf_pe_stat.write("*\n");
        String read = "";
        read = meth_frag_str.length() >= this.sim.read_len ? meth_frag_str.substring(0, this.sim.read_len) : String.valueOf(meth_frag_str.toString()) + this.sim.adapter_3.subSequence(0, this.sim.read_len - meth_frag_str.length());
        this.write2Fastq(String.valueOf(Integer.toString(header)) + ":" + frag.getHeader() + ":", read, qual, "/1", obuf_end1);
    }

    public void addEnd2(Fragment frag, StringBuilder meth_frag_str, BufferedWriter obuf_end2, BufferedWriter obuf_pe_stat, int header, StringBuilder qual) throws Exception {
        obuf_pe_stat.write("#\t" + header + "/2\t" + frag.getHeader() + "\n");
        int end = frag.length() - this.sim.read_len >= this.sim.read_len ? frag.length() - this.sim.read_len : this.sim.read_len;
        for (Integer C_pos : frag.getCList()) {
            if (C_pos < end) continue;
            obuf_pe_stat.write(C_pos + "\t" + meth_frag_str.charAt(C_pos) + "\n");
        }
        obuf_pe_stat.write("*\n");
        String read = "";
        read = meth_frag_str.length() >= this.sim.read_len ? GStringUtil.reverseComplement(meth_frag_str.substring(frag.length() - this.sim.read_len)) : String.valueOf(GStringUtil.reverseComplement(meth_frag_str.toString())) + this.sim.adapter_5.subSequence(0, this.sim.read_len - meth_frag_str.length());
        this.write2Fastq(String.valueOf(Integer.toString(header)) + ":" + frag.getHeader() + ":", read, qual, "/2", obuf_end2);
    }

    public void write2Fastq(String header, String read, StringBuilder qual, String end, BufferedWriter obuf) throws Exception {
        obuf.write("@" + header + end + "\n");
        obuf.write(String.valueOf(read) + "\n");
        obuf.write("+" + header + end + "\n");
        obuf.write(qual + "\n");
    }
}

