/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.paper.rrbscaller.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class AutoCorrelation {
    public static void main(String[] args) throws Exception {
        BufferedReader ibuf = new BufferedReader(new FileReader("/media/methylation/papers/rrbscaller/real.data/rrbscaller/callpe/l5.err.meth.txt"));
        TreeMap<String, ArrayList<CpG>> cpg_tab = new TreeMap<String, ArrayList<CpG>>();
        String line = ibuf.readLine();
        while ((line = ibuf.readLine()) != null) {
            int nread;
            String[] arr = line.split("\t");
            ArrayList<CpG> cpg_lst = (List)cpg_tab.get(arr[0]);
            int mread = Integer.parseInt(arr[4]);
            if (mread + (nread = Integer.parseInt(arr[5])) < 10 || !arr[3].startsWith("CG")) continue;
            if (cpg_lst == null) {
                cpg_lst = new ArrayList<CpG>();
                cpg_tab.put(arr[0], cpg_lst);
            }
            cpg_lst.add(new CpG(arr[0], Integer.parseInt(arr[2]), mread, nread));
        }
        ibuf.close();
        for (List cpg_lst : cpg_tab.values()) {
            Collections.sort(cpg_lst);
        }
        TreeMap<Integer, ArrayList<CpGPair>> pair_tab = new TreeMap<Integer, ArrayList<CpGPair>>();
        for (String ref : cpg_tab.keySet()) {
            List cpg_lst = (List)cpg_tab.get(ref);
            int i = 0;
            while (i < cpg_lst.size() - 1) {
                CpG cpg1 = (CpG)cpg_lst.get(i);
                int j = i + 1;
                while (j < cpg_lst.size()) {
                    CpG cpg2 = (CpG)cpg_lst.get(j);
                    int pos_diff = cpg2.pos - cpg1.pos;
                    if (pos_diff >= 200) break;
                    ArrayList<CpGPair> pair_lst = (ArrayList<CpGPair>)pair_tab.get(pos_diff);
                    if (pair_lst == null) {
                        pair_lst = new ArrayList<CpGPair>();
                        pair_tab.put(pos_diff, pair_lst);
                    }
                    pair_lst.add(new CpGPair(cpg1, cpg2));
                    ++j;
                }
                ++i;
            }
            System.out.println(String.valueOf(ref) + " done");
        }
        BufferedWriter obuf = new BufferedWriter(new FileWriter("/media/methylation/papers/rrbscaller/real.data/rrbscaller/callpe/l5.err.cor.txt"));
        obuf.write("diff\tmeth1\tmeth2\n");
        for (Integer diff : pair_tab.keySet()) {
            for (CpGPair pair : (List)pair_tab.get(diff)) {
                obuf.write(diff + "\t" + pair.cpg1.meth + "\t" + pair.cpg2.meth + "\n");
            }
        }
        obuf.close();
    }

    public static class CpG
    implements Comparable<CpG> {
        String ref;
        int pos;
        int mread;
        int nread;
        double meth;

        public CpG(String ref, int pos, int mread, int nread) {
            this.ref = ref;
            this.pos = pos;
            this.meth = mread;
            this.nread = nread;
            this.meth = (double)nread * 1.0 / (double)(nread + mread);
        }

        @Override
        public int compareTo(CpG that) {
            int res = 0;
            if (this.pos > that.pos) {
                res = 1;
            } else if (this.pos < that.pos) {
                res = -1;
            }
            return res;
        }
    }

    public static class CpGPair {
        CpG cpg1;
        CpG cpg2;

        public CpGPair(CpG cpg1, CpG cpg2) {
            this.cpg1 = cpg1;
            this.cpg2 = cpg2;
        }
    }
}

