/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.queue.extensions.gatk;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.SAMFileWriter;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentIOType;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.Gather;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.queue.extensions.gatk.ArgumentField;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;

public abstract class ArgumentDefinitionField
extends ArgumentField {
    protected final ArgumentDefinition argumentDefinition;
    protected static final String REQUIRED_TEMPLATE = " + required(\"%1$s\", %3$s, spaceSeparated=true, escape=true, format=%2$s)";
    protected static final String REPEAT_TEMPLATE = " + repeat(\"%1$s\", %3$s, spaceSeparated=true, escape=true, format=%2$s)";
    protected static final String OPTIONAL_TEMPLATE = " + optional(\"%1$s\", %3$s, spaceSeparated=true, escape=true, format=%2$s)";
    protected static final String FLAG_TEMPLATE = " + conditional(%3$s, \"%1$s\", escape=true, format=%2$s)";
    private static final List<String> intervalFields = Arrays.asList("intervals", "excludeIntervals", "targetIntervals");

    protected ArgumentDefinitionField(ArgumentDefinition argumentDefinition) {
        this.argumentDefinition = argumentDefinition;
    }

    @Override
    protected String getRawFieldName() {
        return this.argumentDefinition.fullName;
    }

    @Override
    protected Class<? extends Annotation> getAnnotationIOClass() {
        return this.argumentDefinition.ioType.annotationClass;
    }

    @Override
    protected String getDoc() {
        return ArgumentDefinitionField.escape(this.argumentDefinition.doc);
    }

    @Override
    protected String getFullName() {
        return ArgumentDefinitionField.escape(this.argumentDefinition.fullName);
    }

    @Override
    protected String getShortName() {
        return ArgumentDefinitionField.escape(this.argumentDefinition.shortName);
    }

    @Override
    protected boolean isRequired() {
        return this.argumentDefinition.required;
    }

    @Override
    protected String getExclusiveOf() {
        return ArgumentDefinitionField.escape(this.argumentDefinition.exclusiveOf);
    }

    @Override
    protected String getValidation() {
        return ArgumentDefinitionField.escape(this.argumentDefinition.validation);
    }

    protected boolean isFlag() {
        return this.argumentDefinition.isFlag;
    }

    protected boolean isMultiValued() {
        return this.argumentDefinition.isMultiValued;
    }

    protected final String getShortFieldGetter() {
        return ArgumentDefinitionField.getFieldName(this.getRawShortFieldName());
    }

    protected final String getShortFieldSetter() {
        return ArgumentDefinitionField.getFieldName(this.getRawShortFieldName() + "_=");
    }

    protected String getRawShortFieldName() {
        return this.argumentDefinition.shortName;
    }

    @Override
    protected String getDefineAddition() {
        if (this.argumentDefinition.shortName == null) {
            return "";
        }
        if (this.getShortFieldGetter().equals(this.getFieldName())) {
            return "";
        }
        return String.format("%n/**%n * Short name of %1$s%n * @return Short name of %1$s%n */%n%5$sdef %3$s = this.%1$s%n%n/**%n * Short name of %1$s%n * @param value Short name of %1$s%n */%n%5$sdef %4$s(value: %2$s) { this.%1$s = value }%n", this.getFieldName(), this.getFieldType(), this.getShortFieldGetter(), this.getShortFieldSetter(), this.getPrivacy());
    }

    @Override
    public final String getCommandLineAddition() {
        return String.format(this.getCommandLineTemplate(), this.getCommandLineParam(), this.getCommandLineFormat(), this.getFieldName());
    }

    protected String getCommandLineParam() {
        return this.argumentDefinition.shortName != null ? "-" + this.argumentDefinition.shortName : "--" + this.argumentDefinition.fullName;
    }

    protected String getCommandLineFormat() {
        return "\"%s\"";
    }

    @Override
    protected String getGatherAnnotation() {
        return "";
    }

    protected String getCommandLineTemplate() {
        if (this.isFlag()) {
            return FLAG_TEMPLATE;
        }
        if (this.isMultiValued()) {
            return REPEAT_TEMPLATE;
        }
        if (this.isRequired()) {
            return REQUIRED_TEMPLATE;
        }
        return OPTIONAL_TEMPLATE;
    }

    public static List<? extends ArgumentField> getArgumentFields(ParsingEngine parsingEngine, Class<?> classType) {
        ArrayList<? extends ArgumentField> argumentFields = new ArrayList<ArgumentField>();
        for (ArgumentSource argumentSource : parsingEngine.extractArgumentSources(classType)) {
            if (argumentSource.isDeprecated()) continue;
            Class gatherer = null;
            if (argumentSource.field.isAnnotationPresent(Gather.class)) {
                gatherer = argumentSource.field.getAnnotation(Gather.class).value();
            }
            for (ArgumentDefinition argumentDefinition : argumentSource.createArgumentDefinitions()) {
                argumentFields.addAll(ArgumentDefinitionField.getArgumentFields(argumentDefinition, gatherer));
            }
        }
        return argumentFields;
    }

    private static List<? extends ArgumentField> getArgumentFields(ArgumentDefinition argumentDefinition, Class<?> gatherer) {
        if (intervalFields.contains(argumentDefinition.fullName) && argumentDefinition.ioType == ArgumentIOType.INPUT) {
            return Arrays.asList(new IntervalFileArgumentField(argumentDefinition), new IntervalStringArgumentField(argumentDefinition));
        }
        if ("num_threads".equals(argumentDefinition.fullName)) {
            return Arrays.asList(new NumThreadsArgumentField(argumentDefinition));
        }
        if ("input_file".equals(argumentDefinition.fullName) && argumentDefinition.ioType == ArgumentIOType.INPUT) {
            return Arrays.asList(new InputTaggedFileDefinitionField(argumentDefinition), new InputIndexesArgumentField(argumentDefinition, ".bai", ".bam"));
        }
        if ((RodBinding.class.equals((Object)argumentDefinition.argumentType) || RodBinding.class.equals((Object)argumentDefinition.componentType)) && argumentDefinition.ioType == ArgumentIOType.INPUT) {
            return Arrays.asList(new InputTaggedFileDefinitionField(argumentDefinition), new InputIndexesArgumentField(argumentDefinition, ".idx"));
        }
        if (argumentDefinition.ioType == ArgumentIOType.INPUT) {
            return Collections.singletonList(new InputArgumentField(argumentDefinition));
        }
        if (argumentDefinition.ioType == ArgumentIOType.OUTPUT) {
            ArrayList<ArgumentField> fields = new ArrayList<ArgumentField>();
            String gatherClass = gatherer != null ? gatherer.getName() : (SAMFileWriter.class.isAssignableFrom(argumentDefinition.argumentType) ? "BamGatherFunction" : (VCFWriter.class.isAssignableFrom(argumentDefinition.argumentType) ? "VcfGatherFunction" : "org.broadinstitute.sting.queue.function.scattergather.SimpleTextGatherFunction"));
            fields.add(new OutputArgumentField(argumentDefinition, gatherClass));
            if (SAMFileWriter.class.isAssignableFrom(argumentDefinition.argumentType)) {
                fields.add(new SAMFileWriterIndexArgumentField(argumentDefinition));
                fields.add(new SAMFileWriterMD5ArgumentField(argumentDefinition));
            } else if (VCFWriter.class.isAssignableFrom(argumentDefinition.argumentType)) {
                fields.add(new VCFWriterIndexArgumentField(argumentDefinition));
            }
            return fields;
        }
        if (argumentDefinition.isFlag) {
            return Collections.singletonList(new FlagArgumentField(argumentDefinition));
        }
        if (argumentDefinition.isMultiValued) {
            return Collections.singletonList(new MultiValuedArgumentField(argumentDefinition));
        }
        if (!argumentDefinition.required && ArgumentDefinitionField.useOption(argumentDefinition.argumentType)) {
            boolean useFormat = ArgumentDefinitionField.useFormatter(argumentDefinition.argumentType);
            ArrayList<ArgumentField> fields = new ArrayList<ArgumentField>();
            OptionedArgumentField field = new OptionedArgumentField(argumentDefinition, useFormat);
            fields.add(field);
            if (useFormat) {
                fields.add(new FormatterArgumentField(field));
            }
            return fields;
        }
        boolean useFormat = ArgumentDefinitionField.useFormatter(argumentDefinition.argumentType);
        ArrayList<ArgumentField> fields = new ArrayList<ArgumentField>();
        DefaultArgumentField field = new DefaultArgumentField(argumentDefinition, useFormat);
        fields.add(field);
        if (useFormat) {
            fields.add(new FormatterArgumentField(field));
        }
        return fields;
    }

    private static class FormatterArgumentField
    extends ArgumentField {
        private final ArgumentField argumentField;

        public FormatterArgumentField(ArgumentField argumentField) {
            this.argumentField = argumentField;
        }

        @Override
        protected Class<? extends Annotation> getAnnotationIOClass() {
            return Argument.class;
        }

        @Override
        public String getCommandLineAddition() {
            return "";
        }

        @Override
        protected String getDoc() {
            return "Format string for " + this.argumentField.getFullName();
        }

        @Override
        protected String getFullName() {
            return this.argumentField.getFullName() + "Format";
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        protected String getFieldType() {
            return "String";
        }

        @Override
        protected String getDefaultValue() {
            return "\"%s\"";
        }

        @Override
        protected Class<?> getInnerType() {
            return String.class;
        }

        @Override
        protected String getRawFieldName() {
            return this.argumentField.getRawFieldName() + "Format";
        }
    }

    private static class SAMFileWriterMD5ArgumentField
    extends AuxilliaryOutputArgumentField {
        public SAMFileWriterMD5ArgumentField(ArgumentDefinition originalArgumentDefinition) {
            super(originalArgumentDefinition, "MD5");
        }

        @Override
        protected String getFreezeFields() {
            return String.format("if (%2$s != null && !org.broadinstitute.sting.utils.io.IOUtils.isSpecialFile(%2$s))%n  if (%3$s)%n    %1$s = new File(%2$s.getPath + \"%4$s\")%n", this.auxFieldName, this.originalFieldName, "generate_md5", ".md5");
        }
    }

    private static class SAMFileWriterIndexArgumentField
    extends AuxilliaryOutputArgumentField {
        public SAMFileWriterIndexArgumentField(ArgumentDefinition originalArgumentDefinition) {
            super(originalArgumentDefinition, "Index");
        }

        @Override
        protected String getFreezeFields() {
            return String.format("if (%2$s != null && !org.broadinstitute.sting.utils.io.IOUtils.isSpecialFile(%2$s))%n  if (!%3$s)%n    %1$s = new File(%2$s.getPath.stripSuffix(\".bam\") + \"%4$s\")%n", this.auxFieldName, this.originalFieldName, "disable_bam_indexing", ".bai");
        }
    }

    private static class VCFWriterIndexArgumentField
    extends AuxilliaryOutputArgumentField {
        public VCFWriterIndexArgumentField(ArgumentDefinition originalArgumentDefinition) {
            super(originalArgumentDefinition, "Index");
        }

        @Override
        protected String getFreezeFields() {
            return String.format("if (%2$s != null && !org.broadinstitute.sting.utils.io.IOUtils.isSpecialFile(%2$s))%n  if (!org.broadinstitute.sting.gatk.io.stubs.VCFWriterArgumentTypeDescriptor.isCompressed(%2$s.getPath))%n    %1$s = new File(%2$s.getPath + \"%3$s\")%n", this.auxFieldName, this.originalFieldName, ".idx");
        }
    }

    private static abstract class AuxilliaryOutputArgumentField
    extends ArgumentField {
        protected final String originalFieldName;
        protected final String auxFieldName;
        protected final String auxFieldLabel;

        public AuxilliaryOutputArgumentField(ArgumentDefinition originalArgumentDefinition, String auxFieldLabel) {
            this.originalFieldName = originalArgumentDefinition.fullName;
            this.auxFieldName = originalArgumentDefinition.fullName + auxFieldLabel;
            this.auxFieldLabel = auxFieldLabel;
        }

        @Override
        protected Class<? extends Annotation> getAnnotationIOClass() {
            return Output.class;
        }

        @Override
        public String getCommandLineAddition() {
            return "";
        }

        @Override
        protected String getDoc() {
            return String.format("Automatically generated %s for %s", this.auxFieldLabel.toLowerCase(), this.originalFieldName);
        }

        @Override
        protected String getFullName() {
            return this.auxFieldName;
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        protected String getFieldType() {
            return "File";
        }

        @Override
        protected String getDefaultValue() {
            return "_";
        }

        @Override
        protected Class<?> getInnerType() {
            return File.class;
        }

        @Override
        protected String getRawFieldName() {
            return this.auxFieldName;
        }

        @Override
        protected String getPrivacy() {
            return "private ";
        }

        @Override
        public boolean isGather() {
            return true;
        }

        @Override
        protected String getGatherAnnotation() {
            return String.format("@Gather(enabled=false)%n", new Object[0]);
        }
    }

    private static class InputIndexesArgumentField
    extends ArgumentField {
        private final boolean originalIsMultiValued;
        private final String indexFieldName;
        private final String originalFieldName;
        private final String indexSuffix;
        private final String originalSuffix;

        public InputIndexesArgumentField(ArgumentDefinition originalArgumentDefinition, String indexSuffix) {
            this(originalArgumentDefinition, indexSuffix, null);
        }

        public InputIndexesArgumentField(ArgumentDefinition originalArgumentDefinition, String indexSuffix, String originalSuffix) {
            this.originalIsMultiValued = originalArgumentDefinition.isMultiValued;
            this.indexFieldName = originalArgumentDefinition.fullName + "Index" + (this.originalIsMultiValued ? "es" : "");
            this.originalFieldName = originalArgumentDefinition.fullName;
            this.indexSuffix = indexSuffix;
            this.originalSuffix = originalSuffix;
        }

        @Override
        protected Class<? extends Annotation> getAnnotationIOClass() {
            return Input.class;
        }

        @Override
        public String getCommandLineAddition() {
            return "";
        }

        @Override
        protected String getDoc() {
            return this.originalIsMultiValued ? "Dependencies on any indexes of " + this.originalFieldName : "Dependencies on the index of " + this.originalFieldName;
        }

        @Override
        protected String getFullName() {
            return this.indexFieldName;
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        protected String getFieldType() {
            return "Seq[File]";
        }

        @Override
        protected String getDefaultValue() {
            return "Nil";
        }

        @Override
        protected Class<?> getInnerType() {
            return File.class;
        }

        @Override
        protected String getRawFieldName() {
            return this.indexFieldName;
        }

        @Override
        protected String getPrivacy() {
            return "private ";
        }

        @Override
        protected String getFreezeFields() {
            if (this.originalIsMultiValued) {
                if (this.originalSuffix == null) {
                    return String.format("%1$s ++= %2$s.filter(orig => orig != null).map(orig => new File(orig.getPath + \"%3$s\"))%n", this.indexFieldName, this.originalFieldName, this.indexSuffix);
                }
                return String.format("%1$s ++= %2$s.filter(orig => orig != null && orig.getName.endsWith(\"%4$s\")).flatMap(orig => Array( new File(orig.getPath + \"%3$s\"), new File(orig.getPath.stripSuffix(\"%4$s\") + \"%3$s\") ))%n", this.indexFieldName, this.originalFieldName, this.indexSuffix, this.originalSuffix);
            }
            if (this.originalSuffix == null) {
                return String.format("if (%2$s != null)%n  %1$s :+= new File(%2$s.getPath + \"%3$s\")%n", this.indexFieldName, this.originalFieldName, this.indexSuffix);
            }
            return String.format("if (%2$s != null && %2$s.getName.endsWith(\"%4$s\"))%n  %1$s ++= Array( new File(%2$s.getPath + \"%3$s\"), new File(%2$s.getPath.stripSuffix(\"%4$s\") + \"%3$s\") )%n", this.indexFieldName, this.originalFieldName, this.indexSuffix, this.originalSuffix);
        }
    }

    public static class InputTaggedFileDefinitionField
    extends ArgumentDefinitionField {
        public InputTaggedFileDefinitionField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition);
        }

        @Override
        protected Class<?> getInnerType() {
            return null;
        }

        @Override
        protected String getFieldType() {
            return this.argumentDefinition.isMultiValued ? "Seq[File]" : "File";
        }

        @Override
        protected String getDefaultValue() {
            return this.argumentDefinition.isMultiValued ? "Nil" : "_";
        }

        @Override
        protected String getCommandLineTemplate() {
            if (this.argumentDefinition.isMultiValued) {
                return " + repeat(\"%1$s\", %3$s, formatPrefix=TaggedFile.formatCommandLineParameter, spaceSeparated=true, escape=true, format=%2$s)";
            }
            if (!this.argumentDefinition.required) {
                return " + optional(TaggedFile.formatCommandLineParameter(\"%1$s\", %3$s), %3$s, spaceSeparated=true, escape=true, format=%2$s)";
            }
            return " + required(TaggedFile.formatCommandLineParameter(\"%1$s\", %3$s), %3$s, spaceSeparated=true, escape=true, format=%2$s)";
        }
    }

    public static class NumThreadsArgumentField
    extends OptionedArgumentField {
        public static final String NUM_THREADS_FIELD = "num_threads";

        public NumThreadsArgumentField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition, false);
        }

        @Override
        protected String getFreezeFields() {
            return String.format("if (num_threads.isDefined) nCoresRequest = num_threads%n", new Object[0]);
        }
    }

    private static class DefaultArgumentField
    extends ArgumentDefinitionField {
        private final boolean useFormatter;

        public DefaultArgumentField(ArgumentDefinition argumentDefinition, boolean useFormatter) {
            super(argumentDefinition);
            this.useFormatter = useFormatter;
        }

        @Override
        protected Class<?> getInnerType() {
            return DefaultArgumentField.mapType(this.argumentDefinition.argumentType);
        }

        @Override
        protected String getFieldType() {
            return DefaultArgumentField.getType(this.getInnerType());
        }

        @Override
        protected String getDefaultValue() {
            return "_";
        }

        @Override
        protected String getCommandLineFormat() {
            return this.useFormatter ? DefaultArgumentField.getFieldName(this.getRawFieldName() + "Format") : super.getCommandLineFormat();
        }
    }

    private static class OptionedArgumentField
    extends ArgumentDefinitionField {
        private final boolean useFormatter;

        public OptionedArgumentField(ArgumentDefinition argumentDefinition, boolean useFormatter) {
            super(argumentDefinition);
            this.useFormatter = useFormatter;
        }

        @Override
        protected Class<?> getInnerType() {
            return OptionedArgumentField.mapType(this.argumentDefinition.argumentType);
        }

        @Override
        protected String getFieldType() {
            return String.format("Option[%s]", OptionedArgumentField.getType(this.getInnerType()));
        }

        @Override
        protected String getDefaultValue() {
            return "None";
        }

        @Override
        protected String getCommandLineTemplate() {
            return ArgumentDefinitionField.OPTIONAL_TEMPLATE;
        }

        @Override
        protected String getCommandLineFormat() {
            return this.useFormatter ? OptionedArgumentField.getFieldName(this.getRawFieldName() + "Format") : super.getCommandLineFormat();
        }
    }

    private static class MultiValuedArgumentField
    extends ArgumentDefinitionField {
        public MultiValuedArgumentField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition);
        }

        @Override
        protected Class<?> getInnerType() {
            return MultiValuedArgumentField.mapType(this.argumentDefinition.componentType);
        }

        @Override
        protected String getFieldType() {
            return String.format("Seq[%s]", MultiValuedArgumentField.getType(this.getInnerType()));
        }

        @Override
        protected String getDefaultValue() {
            return "Nil";
        }

        @Override
        protected String getCommandLineTemplate() {
            return ArgumentDefinitionField.REPEAT_TEMPLATE;
        }
    }

    private static class FlagArgumentField
    extends ArgumentDefinitionField {
        public FlagArgumentField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition);
        }

        @Override
        protected Class<?> getInnerType() {
            return Boolean.TYPE;
        }

        @Override
        protected String getFieldType() {
            return "Boolean";
        }

        @Override
        protected String getDefaultValue() {
            return "_";
        }

        @Override
        protected String getCommandLineTemplate() {
            return ArgumentDefinitionField.FLAG_TEMPLATE;
        }
    }

    private static class OutputArgumentField
    extends ArgumentDefinitionField {
        private final String gatherClass;

        public OutputArgumentField(ArgumentDefinition argumentDefinition, String gatherClass) {
            super(argumentDefinition);
            this.gatherClass = gatherClass;
        }

        @Override
        protected Class<?> getInnerType() {
            return File.class;
        }

        @Override
        protected String getFieldType() {
            return "File";
        }

        @Override
        protected String getDefaultValue() {
            return "_";
        }

        @Override
        public boolean isGather() {
            return true;
        }

        @Override
        protected String getGatherAnnotation() {
            return String.format("@Gather(classOf[%s])%n", this.gatherClass);
        }
    }

    private static class InputArgumentField
    extends ArgumentDefinitionField {
        public InputArgumentField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition);
        }

        @Override
        protected Class<?> getInnerType() {
            return File.class;
        }

        @Override
        protected String getFieldType() {
            return this.isMultiValued() ? "Seq[File]" : "File";
        }

        @Override
        protected String getDefaultValue() {
            return this.isMultiValued() ? "Nil" : "_";
        }
    }

    private static class IntervalStringArgumentField
    extends ArgumentDefinitionField {
        public IntervalStringArgumentField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition);
        }

        @Override
        protected Class<? extends Annotation> getAnnotationIOClass() {
            return Argument.class;
        }

        @Override
        protected Class<?> getInnerType() {
            return String.class;
        }

        @Override
        protected String getRawFieldName() {
            return super.getRawFieldName() + "String";
        }

        @Override
        protected String getFullName() {
            return super.getFullName() + "String";
        }

        @Override
        protected String getRawShortFieldName() {
            return super.getRawShortFieldName() + "String";
        }

        @Override
        protected String getFieldType() {
            return "Seq[String]";
        }

        @Override
        protected String getDefaultValue() {
            return "Nil";
        }

        @Override
        public String getCommandLineTemplate() {
            return ArgumentDefinitionField.REPEAT_TEMPLATE;
        }

        @Override
        protected String getExclusiveOf() {
            StringBuilder exclusiveOf = new StringBuilder(super.getExclusiveOf());
            if (exclusiveOf.length() > 0) {
                exclusiveOf.append(",");
            }
            exclusiveOf.append(IntervalStringArgumentField.escape(this.argumentDefinition.fullName));
            return exclusiveOf.toString();
        }
    }

    private static class IntervalFileArgumentField
    extends InputArgumentField {
        public IntervalFileArgumentField(ArgumentDefinition argumentDefinition) {
            super(argumentDefinition);
        }

        @Override
        protected String getExclusiveOf() {
            StringBuilder exclusiveOf = new StringBuilder(super.getExclusiveOf());
            if (exclusiveOf.length() > 0) {
                exclusiveOf.append(",");
            }
            exclusiveOf.append(IntervalFileArgumentField.escape(this.argumentDefinition.fullName)).append("String");
            return exclusiveOf.toString();
        }
    }
}

