/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.ConsensusAlleleCounter;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class IndelGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    private final int HAPLOTYPE_SIZE;
    private final boolean getAlleleListFromVCF;
    private boolean DEBUG = false;
    private boolean ignoreSNPAllelesWhenGenotypingIndels = false;
    private PairHMMIndelErrorModel pairModel;
    private static ThreadLocal<HashMap<PileupElement, LinkedHashMap<Allele, Double>>> indelLikelihoodMap = new ThreadLocal<HashMap<PileupElement, LinkedHashMap<Allele, Double>>>(){

        @Override
        protected synchronized HashMap<PileupElement, LinkedHashMap<Allele, Double>> initialValue() {
            return new HashMap<PileupElement, LinkedHashMap<Allele, Double>>();
        }
    };
    private LinkedHashMap<Allele, Haplotype> haplotypeMap;
    private GenomeLoc lastSiteVisited;
    private List<Allele> alleleList = new ArrayList<Allele>();
    private static final EnumSet<VariantContext.Type> allowableTypes;

    protected IndelGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, !UAC.DONT_DO_BANDED_INDEL_COMPUTATION);
        this.getAlleleListFromVCF = UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
        this.HAPLOTYPE_SIZE = UAC.INDEL_HAPLOTYPE_SIZE;
        this.DEBUG = UAC.OUTPUT_DEBUG_INDEL_INFO;
        this.haplotypeMap = new LinkedHashMap();
        this.ignoreSNPAllelesWhenGenotypingIndels = UAC.IGNORE_SNP_ALLELES;
    }

    protected List<Allele> computeConsensusAlleles(ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenomeLocParser locParser) {
        ConsensusAlleleCounter counter = new ConsensusAlleleCounter(locParser, true, this.UAC.MIN_INDEL_COUNT_FOR_GENOTYPING, this.UAC.MIN_INDEL_FRACTION_PER_SAMPLE);
        return counter.computeConsensusAlleles(ref, contexts, contextType);
    }

    @Override
    public VariantContext getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, List<Allele> alternateAllelesToUse, boolean useBAQedPileup, GenomeLocParser locParser) {
        if (tracker == null) {
            return null;
        }
        GenomeLoc loc = ref.getLocus();
        VariantContext vc = null;
        boolean allelesArePadded = true;
        if (!ref.getLocus().equals(this.lastSiteVisited)) {
            this.alleleList.clear();
            this.lastSiteVisited = ref.getLocus();
            indelLikelihoodMap.set(new HashMap());
            this.haplotypeMap.clear();
            if (this.getAlleleListFromVCF) {
                for (VariantContext vc_input : tracker.getValues(this.UAC.alleles, loc)) {
                    if (vc_input == null || !allowableTypes.contains((Object)vc_input.getType()) || ref.getLocus().getStart() != vc_input.getStart()) continue;
                    vc = vc_input;
                    break;
                }
                if (vc == null) {
                    return null;
                }
                this.alleleList.clear();
                if (this.ignoreSNPAllelesWhenGenotypingIndels) {
                    for (Allele a : vc.getAlleles()) {
                        if (a.isNonReference() && a.getBases().length == vc.getReference().getBases().length) continue;
                        this.alleleList.add(a);
                    }
                } else {
                    for (Allele a : vc.getAlleles()) {
                        this.alleleList.add(a);
                    }
                }
                if (vc.getReference().getBases().length == vc.getEnd() - vc.getStart() + 1) {
                    allelesArePadded = false;
                }
            } else {
                this.alleleList = this.computeConsensusAlleles(ref, contexts, contextType, locParser);
                if (this.alleleList.isEmpty()) {
                    return null;
                }
            }
        }
        if (loc.getStart() <= this.HAPLOTYPE_SIZE) {
            return null;
        }
        if (ref.getWindow().getStop() < loc.getStop() + this.HAPLOTYPE_SIZE) {
            return null;
        }
        if (this.alleleList.isEmpty()) {
            return null;
        }
        Allele refAllele = this.alleleList.get(0);
        Allele altAllele = this.alleleList.get(1);
        int maxLenDiff = 0;
        for (Allele a : this.alleleList) {
            int lenDiff;
            if (!a.isNonReference() || (lenDiff = Math.abs(a.getBaseString().length() - refAllele.getBaseString().length())) <= maxLenDiff) continue;
            maxLenDiff = lenDiff;
            altAllele = a;
        }
        int eventLength = altAllele.getBaseString().length() - refAllele.getBaseString().length();
        int hsize = ref.getWindow().size() - Math.abs(eventLength) - 1;
        int numPrefBases = ref.getLocus().getStart() - ref.getWindow().getStart() + 1;
        if (hsize <= 0) {
            this.logger.warn(String.format("Warning: event at location %s can't be genotyped, skipping", loc.toString()));
            return null;
        }
        this.haplotypeMap = Haplotype.makeHaplotypeListFromAlleles(this.alleleList, loc.getStart(), ref, hsize, numPrefBases);
        int endLoc = loc.getStart() + refAllele.length() - 1;
        if (allelesArePadded) {
            ++endLoc;
        }
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), endLoc, this.alleleList).referenceBaseForIndel(ref.getBase());
        GenotypesContext genotypes = GenotypesContext.create();
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            ReadBackedPileup pileup;
            AlignmentContext context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            if (!context.hasBasePileup() || (pileup = context.getBasePileup()) == null) continue;
            double[] genotypeLikelihoods = this.pairModel.computeReadHaplotypeLikelihoods(pileup, this.haplotypeMap, ref, eventLength, IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap());
            GenotypeLikelihoods likelihoods = GenotypeLikelihoods.fromLog10Likelihoods(genotypeLikelihoods);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("DP", this.getFilteredDepth(pileup));
            attributes.put("PL", likelihoods);
            genotypes.add(new Genotype(sample.getKey(), noCall, 1.0, null, attributes, false));
            if (!this.DEBUG) continue;
            System.out.format("Sample:%s Alleles:%s GL:", sample.getKey(), this.alleleList.toString());
            for (int k = 0; k < genotypeLikelihoods.length; ++k) {
                System.out.format("%1.4f ", genotypeLikelihoods[k]);
            }
            System.out.println();
        }
        return builder.genotypes(genotypes).make();
    }

    public static HashMap<PileupElement, LinkedHashMap<Allele, Double>> getIndelLikelihoodMap() {
        return indelLikelihoodMap.get();
    }

    @Override
    protected int getFilteredDepth(ReadBackedPileup pileup) {
        int count = 0;
        for (PileupElement p : pileup) {
            if (!p.isDeletion() && !p.isInsertionAtBeginningOfRead() && !BaseUtils.isRegularBase(p.getBase())) continue;
            ++count;
        }
        return count;
    }

    static {
        indelLikelihoodMap.set(new HashMap());
        allowableTypes = EnumSet.of(VariantContext.Type.INDEL, VariantContext.Type.MIXED);
    }
}

