/**
 * 
 */
package test.edu.mayo.genotype;

import junit.framework.TestCase;

/**
 * @author Hugues Sicotte
 *
 */
public class TestUtils extends TestCase {

	/**
	 * @param name
	 */
	public TestUtils(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#uniq(java.lang.String[])}.
	 */
	public final void testUniq() {
		String[] s = {"1234","1234"};
		String[] so = edu.mayo.genotype.Utils.uniq(s);
		assertEquals( 1,so.length);
		String[] s2 = {"1234","1234","2","3","3","3"};
		so = edu.mayo.genotype.Utils.uniq(s2);
		assertEquals(3,so.length);
		assertEquals( "3",so[0]);// "Utils.uniq fails to put most frequent string first"
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#append(java.lang.String[], java.lang.String[])}.
	 */
	public final void testAppend() {
		//fail("Not yet implemented"); // TODO
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#join(java.lang.String, java.lang.String[])}.
	 */
	public final void testJoin() {
		//fail("Not yet implemented"); // TODO
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#isAPosNumberGTZero(java.lang.String)}.
	 */
	public final void testIsAPosNumberGTZero() {
		//fail("Not yet implemented"); // TODO
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#countBits(int)}.
	 */
	public final void testSplitFile() {
		String f1 = "C:\\Doc\\filename.txt";
		String[] split_f1 = new String[3];
		split_f1[0] = "C:\\Doc\\";
		split_f1[1] = "filename";
		split_f1[2] = "txt";
		String[] splitFile = edu.mayo.genotype.Utils.splitFile(f1);
/*		System.out.println("2nd and 3rd characters:-"+f1.substring(2, 3)+"-- --"+f1.substring(3,4)+"--");
		String msg = "splitFile = --"+splitFile[0]+"-- --"+splitFile[1]+"-- --"+splitFile[2]+"--";
		System.out.println(msg);
		String msg2 = "split_f1 = --"+split_f1[0]+"-- --"+split_f1[1]+"-- --"+split_f1[2]+"--";
		System.out.println(msg2);*/

		assertTrue(split_f1[0].equals(splitFile[0]));
		assertTrue(split_f1[1].equals(splitFile[1]));
		assertTrue(split_f1[2].equals(splitFile[2]));

		String f2 = "/mnt/people.bozo/filename.long.txt";
		String[] split_f2 = new String[3];
		split_f2[0] = "/mnt/people.bozo/";
		split_f2[1] = "filename.long";
		split_f2[2] = "txt";
		String[] splitFile2 = edu.mayo.genotype.Utils.splitFile(f2);


		assertTrue(split_f2[0].equals(splitFile2[0]));
		assertTrue(split_f2[1].equals(splitFile2[1]));
		assertTrue(split_f2[2].equals(splitFile2[2]));

		
	}
	
	
	/**
	 * Test method for {@link edu.mayo.genotype.Utils#countBits(int)}.
	 */
	public final void testCountBitsInt() {
		assertEquals(0,edu.mayo.genotype.Utils.countBits(0));
		assertEquals(16,edu.mayo.genotype.Utils.countBits((int) 0xffff));
		assertEquals(20,edu.mayo.genotype.Utils.countBits((int) 0xfffff));
		assertEquals(4,edu.mayo.genotype.Utils.countBits((int) 0x1111));
		assertEquals(8,edu.mayo.genotype.Utils.countBits((int) 0x11111111));
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#countBits(long)}.
	 */
	public final void testCountBitsLong() {
		assertEquals(20,edu.mayo.genotype.Utils.countBits((long) 0xfffffL));
		assertEquals(32,edu.mayo.genotype.Utils.countBits((long) 0xffffffffL));
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#tooManyBitsSetInMask(long, int[], int[])}.
	 */
	public final void testTooManyBitsSetInMask() {
		int[] numBits = {1,4,4,4};
		int[] maxSet = {0,1,2,4};
		assertEquals(1+3+2,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x1fffL,numBits,maxSet));
		assertEquals(0,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x0124L,numBits,maxSet));
		assertEquals(0,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0L,numBits,maxSet));
		assertEquals(1,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x123FL,numBits,maxSet));
		assertEquals(1,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x033FL,numBits,maxSet));
		assertEquals(1,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x047FL,numBits,maxSet));
		assertEquals(3,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x06FFL,numBits,maxSet));
		assertEquals(1,edu.mayo.genotype.Utils.tooManyBitsSetInMask(0x066FL,numBits,maxSet));
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#mapBits(int, int[], int[])}.
	 */
	public final void testMapBitsIntIntArrayIntArray() {
		int[] fromBit = {0,1,2,3,4};
		int[] fromBit1 = {1,1,1,1,1};

		int[] toBitR = {4,3,2,1,0};
		int[] toBit0 = {0,0,0,0,0};
		int[] toBitF = {0,1,2,3,4};

		
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(0, fromBit, toBitR));
		assertEquals(0x1FL,edu.mayo.genotype.Utils.mapBits(0x1F, fromBit, toBitR));
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(0, fromBit, toBitF));
		assertEquals(23L,edu.mayo.genotype.Utils.mapBits(23, fromBit, toBitF));
		assertEquals(31L,edu.mayo.genotype.Utils.mapBits(31, fromBit, toBitF));
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(32, fromBit, toBitF));
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(0, fromBit1, toBit0));
		assertEquals(1L,edu.mayo.genotype.Utils.mapBits(2, fromBit1, toBit0));
		
	}

	/**
	 * Test method for {@link edu.mayo.genotype.Utils#mapBits(long, int[], int[])}.
	 */
	public final void testMapBitsLongIntArrayIntArray() {
		int[] fromBit = {0,1,2,3,4};
		int[] fromBit1 = {1,1,1,1,1};

		int[] toBitR = {4,3,2,1,0};
		int[] toBit0 = {0,0,0,0,0};
		int[] toBitF = {0,1,2,3,4};

		
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(0L, fromBit, toBitR));
		assertEquals(0x1FL,edu.mayo.genotype.Utils.mapBits(0x1FL, fromBit, toBitR));
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(0L, fromBit, toBitF));
		assertEquals(23L,edu.mayo.genotype.Utils.mapBits(23L, fromBit, toBitF));
		assertEquals(31L,edu.mayo.genotype.Utils.mapBits(31L, fromBit, toBitF));
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(32L, fromBit, toBitF));
		assertEquals(0L,edu.mayo.genotype.Utils.mapBits(0L, fromBit1, toBit0));
		assertEquals(1L,edu.mayo.genotype.Utils.mapBits(2L, fromBit1, toBit0));
	}

}
