package test.edu.mayo.genotype;
import java.util.ArrayList;

import edu.mayo.genotype.*;
import junit.framework.*;

/*
assertEquals(expected, actual) 
assertEquals(message, expected, actual) 
assertEquals(expected, actual, delta) - used on doubles or floats, where delta is the difference in precision 
assertEquals(message, expected, actual, delta) - used on doubles or floats, where delta is the difference in precision 
assertFalse(condition) 
assertFalse(message, condition) 
assertNotNull(object) 
assertNotNull(message, object) 
assertNotSame(expected, actual) 
assertNotSame(message, expected, actual) 
assertNull(object) 
assertNull(message, object) 
assertSame(expected, actual) 
assertSame(message, expected, actual) 
assertTrue(condition) 
assertTrue(message, condition) 
fail() 
fail(message) 
failNotEquals(message, expected, actual) 
failNotSame(message, expected, actual) 
failSame(message) 

 */
public class SnpTest extends TestCase {

	public SnpTest(String name) {
		super(name);
	}
	public static boolean wassetup=false;
	
	protected void readData() throws Exception {
		Population p1 = new Population();
		p1.setName("POP1");
		Population p2 = new Population();
		p2.setName("POP2");
		Population p3 = new Population();
		p3.setName("POP3");

		
		SNPPicker.processScoreFile("X:\\sicotteh\\PI support\\Kullo\\code\\Test\\testSps.csv");
		SNPPicker.readLDSelectTagzilla(p1,"X:\\sicotteh\\PI support\\Kullo\\code\\Test\\sicotte\\junit1.tagzilla","0" ,true,null);
		SNPPicker.readLDSelectTagzilla(p2,"X:\\sicotteh\\PI support\\Kullo\\code\\Test\\sicotte\\junit2.tagzilla","0" ,true,null);
		SNPPicker.readLDSelectTagzilla(p3,"X:\\sicotteh\\PI support\\Kullo\\code\\Test\\sicotte\\junit3.tagzilla","0" ,true,null);
		System.out.println("read 3 files");
		
	}
	protected void setUp() throws Exception {

		readData();
		Snp.computeSNPProbs();
		// Compute NSB for each bin.
		SNPPicker.processNSBRules(SNPPicker.getNSBRules());
		Snp.processMinScore();
		
		super.setUp();
	}
	protected void clearData() {
		Snp.clear(true); // delete all snps, bins, and bin edges.
		Bin.clear(); // clean up and delete bins without Snps
		Population.clear();
	}
	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testFindContigousSNPIntBooleanBooleanInt() {
		boolean obligateOrSelected=false;
		boolean ignoreExcluded=true;

		
		ArrayList res0 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 0);
		ArrayList res1 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 1);
		ArrayList res2 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 2);
		ArrayList res3 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 3);
		ArrayList res4 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 4);
		ArrayList res6 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 6);
		ArrayList res7 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 7);


		int nsnps = Snp.getNsnps();
		System.out.println("nsnps="+nsnps);

		System.out.println("res0="+res0.size());
		System.out.println("res1="+res1.size());
		System.out.println("res2="+res2.size());
		System.out.println("res3="+res3.size());
		System.out.println("res4="+res4.size());
		System.out.println("res6="+res6.size());
		System.out.println("res7="+res7.size());
		System.out.flush();
		
		assertEquals(0,Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, -1).size());
		assertEquals(res0.size(),res1.size());
		assertEquals(4,res0.size());
		assertEquals(4,res1.size());
		assertEquals(1,res2.size());
		assertEquals(1,res3.size());
		assertEquals(1,res4.size());// clusters up to 4 OK.
		assertEquals(1,res6.size());
		assertEquals(0,res7.size());

		assertEquals(7,((ArrayList)res6.get(0)).size());
		
	}


	public void testClusterSnpCluster() {
		boolean obligateOrSelected=false;
		boolean ignoreExcluded=true;

		
		ArrayList res0 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 0);
		ArrayList res1 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 1);
		ArrayList res2 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 2);
		ArrayList res3 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 3);
		ArrayList res4 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 4);
		ArrayList res6 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 6);
		ArrayList res7 = Snp.findContigousSNP(60, obligateOrSelected, ignoreExcluded, 7);

		ArrayList c0 = Snp.clusterSnpCluster(res0);
		ArrayList c1 = Snp.clusterSnpCluster(res1);
		ArrayList c2 = Snp.clusterSnpCluster(res2);
		assertEquals(1,c0.size());
		assertEquals(1,c1.size());
		assertEquals(1,c2.size());

		assertEquals(7,((ArrayList)c2.get(0)).size());
		assertEquals(13,((ArrayList)c0.get(0)).size());
		assertEquals(13,((ArrayList)c1.get(0)).size());
		
		
	}

	public void testProcessSnpTooClose() {
		try{
			
			ArrayList c = Snp.processSnpTooClose(60,2,true);
			int nClusters = c.size();
			boolean foundSoln=false;
			if(nClusters==1) {
					ArrayList snpList = (ArrayList)c.get(0);
					int lsize = snpList.size();
					if(lsize==7) {
						
						for(int j=0;(!foundSoln) && j<lsize;j++) {
							Snp s = (Snp)snpList.get(j);
							if(s.getSnpName().equals("rs28546637")) {
								for(int k=0;k<lsize;k++) {
									Snp s2 = (Snp)snpList.get(k);
									if(s2.getSnpName().equals("rs28630560")) { 
										foundSoln=true;
										break;
									}
								}
							}
						}
					}
					assertTrue(foundSoln);
			} else {
				fail("failed testProcessSnpTooClose  because failed earlier tests");
			}
		} catch (Exception e) {
			e.printStackTrace();System.out.flush();
			fail("fail because of Exception "+e.getMessage());
		}
	}


	
	
}
