package edu.mayo.genotype;
import java.util.Iterator;
import java.util.List;
import java.lang.Exception;
import java.lang.UnsupportedOperationException;
import java.util.NoSuchElementException;
/*
 * 
 * This Class implemented as int for speed.
 * 
 * author Hugues Sicotte
 * algorithm adapted from http://big-o.nl/demos/math/combinationgenerator/index.html
 * http://big-o.nl/demos/math/combinationgenerator/comb.zip
 * There was no license or copyright information
 * 
 * The web page was copyrighted Bart Kiers bkiers@gmail.com 
 * */
public class binomialCombinations implements Iterator<int[]> , Iterable<int[]> {


	    private int[] currentIdxs;
	    private final int[] lastIdxs;
	    private int n;
	    private int k;
	    public  binomialCombinations(int _k, int _n) throws Exception {
	    	this.k=_k;
	    	this.n=_n;
	        if(k < 0 || k > n) {
	            throw new Exception("edu.mayo.genotype.binomialCoeficient: k="+k+" out of range: needs to be between 0 and "+n);
	        }
	        this.currentIdxs = new int[k];
	        this.lastIdxs = new int[k];
	        for(int i = 0; i < k; i++) {
	            this.currentIdxs[i] = i;
	            this.lastIdxs[i] =n - k + i;
	        }
	        if(k==0) {currentIdxs=null;}

	    }

	    public boolean hasNext() {
	        return currentIdxs != null;
	    }

	    public Iterator<int[]> iterator() {
	        return this;
	    }
	    
	    public int[] next() {
	        if(!hasNext()) {
	            throw new NoSuchElementException();
	        }
	        int[] currentCombination = new int[n];
	        for(int i : currentIdxs) {
	            currentCombination[i]=1;
	        }
	        setNextIndexes();
	        return currentCombination;
	    }

	    public void remove() {
	        throw new UnsupportedOperationException();
	    }
	    
	    private void setNextIndexes() {
	        for(int i = currentIdxs.length-1, j = n-1; i >= 0; i--, j--) {
	            if(currentIdxs[i] != j) {
	                currentIdxs[i]++;
	                for(int k = i+1; k < currentIdxs.length; k++) {
	                    currentIdxs[k] = currentIdxs[k-1]+1;
	                }
	                return;
	            }
	        }
	        currentIdxs = null;
	    }

}
