package edu.mayo.genotype;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
public class Utils {
	public static String[] uniq(String[] in) {
		if(in==null || in.length==0) {
			return null;
		}
		HashMap<String,Integer> h = new HashMap<String,Integer> ();
		for(int i=0;i<in.length;i++) {
			String temp = in[i];
			if(temp!=null && temp.length() > 0) {
				Integer I;
				if(h.containsKey(temp)) {
					Integer oldI = (Integer)h.get(temp);
					int oldi = oldI.intValue();
					I = Integer.valueOf(oldi+1);
				} else {
					I = Integer.valueOf(1);
				}
				h.put(temp, I);
			}
		}

		edu.mayo.genotype.ComparatorWithHash bycount = new CountFromHashComparator();
		bycount.setHash(h);
		TreeSet<String> set = new TreeSet<String>(bycount);
		for(int i=0;i<in.length;i++) {
				String temp = in[i];
				if(temp!=null && temp.length() > 0 && !set.contains(temp)) {
					set.add(temp);
				}
		}
		int nuniq = set.size();
		String[] out = new String[nuniq];
		Iterator<String> it = set.iterator();
		int i=0;
		while(it.hasNext()) {
			out[i++]=(String)it.next();
		}
		return out; // most frequent first.
	}

	/*
	 * Split function that returns n+1 fields, if there are n separators.
	 * This is in contrast to the Regex Split that skips the last empty field.
	 * Special, ultrafast method when split character is 
	 */
	public static String[] split(String source, char split_char) {
		int n=0;
		String empty="";		
		if(source==null || source.length()==0) {
			String[] ret = new String[1];
			ret[0]=empty;
		}
		int len = source.length();
		for(int i=0;i<len;i++) {
			if(source.charAt(i)==split_char) {
				n++;
			}
		}
		String[] ret = new String[n+1];
		int start=0;
		n=0;
		for(int i=0;i<len;i++) {
			if(source.charAt(i)==split_char) {
				if(i>start) {
					ret[n] = source.substring(start,i);
				} else {
					ret[n]=empty;
				}
				start=i+1;
				n++;
			} 
		}
		if(len>start) {
			ret[n] = source.substring(start,len);
		} else {
			ret[n]=empty;
		}
		return ret;
	}
	/*
	 * Split function that returns n+1 fields, if there are n separators.
	 * This is in contrast to the Regex Split that skips the last empty field.
	 */
	public static String[] splitRegexp(String source, String regexp) {
		Pattern separator = Pattern.compile(regexp);
		return splitPattern(source,separator);
	}
	/*
	 * Split function that returns n+1 fields, if there are n separators.
	 * This is in contrast to the Regex Split that skips the last empty field.
	 */
	public static String[] splitPattern(String source, Pattern separator) {
		
		String empty="";		
		if(source==null || source.length()==0) {
			String[] ret = new String[1];
			ret[0]=empty;
		}
		Matcher m = separator.matcher(source);


		int n=0;
		while(m.find()) {
			n++;
		}
		if(n==0) { // does not contain split regexp
			String[] ret = new String[1];
			ret[0]=source;
			return ret;
		}
		String[] ret = new String[n+1];
		m.reset(source);

		int len = source.length();

		n=0;
		int stringStart=0;
		int stop=-1;
		while(m.find()) {
			int start = m.start();
			stop = m.end()-1;
			if(stop<-1) {
				stop = len;
			}
			if(start == stringStart) {
				ret[n] = empty;
			} else {
				ret[n] = source.substring(stringStart,start);
			}
			stringStart = stop+1;
			n++;
		}
		if(len>stop+1) {
			ret[n] = source.substring(stop+1,len);
		} else {
			ret[n]=empty;
		}
		return ret;
	}
	
	/*
	 * Split a file in 3 parts
	 * [0] Directory Path
	 * [1] Filename 
	 * [Suffix]
	 */
	public static String[] splitFile(String filename) {
		Pattern filePat = Pattern.compile("[/,\\\\]");
		Matcher fileMatch = filePat.matcher(filename);
		int lastMatch=0;
		while(fileMatch.find()) {
			lastMatch = fileMatch.end();
		}
		String path="";
		String file="";
		String prefix="";
		String suffix="";
		if(lastMatch>=filename.length()) {
			System.out.println(" no filename, just a path");
			path=filename;
		} else {
			path = filename.substring(0,lastMatch);
			file = filename.substring(lastMatch);
			Pattern dotPat = Pattern.compile("\\.");
			Matcher dotMatch = dotPat.matcher(file);
			int dlastMatch=0;
			while(dotMatch.find()) {
				dlastMatch = dotMatch.end();
			}
			if(dlastMatch>0) {
				prefix = file.substring(0,dlastMatch-1);
				suffix = file.substring(dlastMatch);
			} else {
				prefix = filename;
			}
		}
		String[] retString = new String[3];
		retString[0]=path;
		retString[1]=prefix;
		retString[2]=suffix;
		return retString;
	}
	

	
	public static String[] append(String[] in1,String[] in2) {
		if(in2==null || in2.length==0) {
			return in1;
		}
		if(in1==null || in1.length==0) {
			return in2;
		}
		String[] in12 = new String[in1.length+in2.length];
		for(int i=0;i<in1.length;i++) {
			in12[i]=in1[i];
		}
		for(int i=0;i<in2.length;i++) {
			in12[i+in1.length]=in2[i];
		}
		return in12;
	}
	public static String join(String joiner,String[] in) {
		if(in==null || in.length==0) {
			return "";
		}
		if(in.length==1) {
			return in[0];
		}
		StringBuffer concat = new StringBuffer(in[0]);

		for(int i=1;i<in.length;i++) {
			concat.append(",");
			concat.append(in[i]);
		}
		return concat.toString();
	}
	
	public static boolean isAPosNumberGTZero(String integerAsSring) {
		int pos=-1;
		try {
			pos = Integer.parseInt( integerAsSring);
		} catch (NumberFormatException ef) {
			return false;
		}
		if(pos>0) {
			return true;
		}
		return false;
	}
	
	/**
	 * bit counting algorithm based on http://gurmeetsingh.wordpress.com/2008/08/05/fast-bit-counting-routines/
	 * code written by Hugues Sicotte
	 */
	static int[] numbits= new int[1 << 16] ;      
	static boolean bits_initialized=false;
	
	private static void initializeNumBits() {
		for(int i=0;i<numbits.length;i++) {
			int nb=0;
			int k=i;
			while(k!=0) {
				if( (k&1) ==1) {nb++;}
				k >>>= 1;
			}
			numbits[i]=nb;
		}
	}
	public static int countBits (int n)  {// int are 32 bits in java
		if(!bits_initialized) {
			initializeNumBits();
			bits_initialized=true;
		}

	   
	   return numbits [n         & 0xffff]
	       +  numbits [(n >>> 16) & 0xffff] ;
	}
	public static int countBits (long n)  {// long are 32 bits in java
		if(!bits_initialized) {
			initializeNumBits();
			bits_initialized=true;
		}
	   return numbits [(int)(n & 0xffffL)] 
	       +  numbits [(int)((n >>> 16) & 0xffffL)] 
	       +  numbits [(int)((n >>> 32) & 0xffffL)] 
	       +  numbits [(int)((n >>> 48) & 0xffffL)];
	}

	/*
	 * Function to compare a number against a mask
	 * THe mask is a series of bit lengths(most significant to least significant -- but pushed as far "right" (LSB) as possible) and the number of bits allowed
	 *   on in each segment.
	 *   @author Hugues Sicotte
	 */
	public static int tooManyBitsSetInMask(long  n, int[] numbits, int[] numbitson) {
		if(numbits==null || numbitson==null) {
			return 0;
		}
		int nextra=0;

		for(int i=numbits.length-1;i>=0;i--) {
			int nb=0;
			int k=numbits[i];
			assert k==0 : "Invalid number of bits in Utils.fitMask function";
			while(k>0) {
				if((n&1L)==1L) {
					nb++;
				}
				n>>>=1;
				k--;
			}
			int diff = nb-numbitson[i];
			if(diff>0) {
				nextra+=diff;
			}
		}
		return nextra;
	}
	
	/*
	 * Functions to map each bit in a different order.
	 * This function allows one bit to be mapped in multiple locations.
	 * User is responsible for making sure that multiple bits are not mapped to the same location.
	 */
	private static final int[] intbitmask = {1,1<<1,1<<2,1<<3,1<<4,1<<5,1<<6,1<<7,1<<8,1<<9,1<<10,1<<11,
						1<<12,1<<13,1<<14,1<<15,1<<16,1<<17,1<<18,1<<19,1<<20,1<<21,1<<22,
						1<<23,1<<24,1<<25,1<<26,1<<27,1<<28,1<<29,1<<30,1<<31};
	private static final long[] longbitmask = {1L,1L<<1,1L<<2,1L<<3,1L<<4,1L<<5,1L<<6,1L<<7,1L<<8,1L<<9,1L<<10,1L<<11,
		1L<<12,1L<<13,1L<<14,1L<<15,1L<<16,1L<<17,1L<<18,1L<<19,1L<<20,1L<<21,1L<<22,
		1L<<23,1L<<24,1L<<25,1L<<26,1L<<27,1L<<28,1L<<29,1L<<30,1L<<31,1L<<32,1L<<33,1L<<34
		,1L<<35,1L<<36,1L<<37,1L<<38,1L<<39,1L<<40,1L<<41,1L<<42,1L<<43,1L<<44,1L<<45,1L<<46,1L<<47,1L<<48
		,1L<<49,1L<<50,1L<<51,1L<<52,1L<<53,1L<<54,1L<<55,1L<<56,1L<<57,1L<<58,1L<<59,1L<<60
		,1L<<61,1L<<62,1L<<63	};

	/*
	 * Functions to map each bit in a different order.
	 * This function allows one bit to be mapped in multiple locations.
	 * User is responsible for making sure that multiple bits are not mapped to the same location.
	 * @returns reshuffled input.
	 */
	public static long mapBits(int n, int[] fromBit, int[] toBit) {
		if(fromBit==null || toBit==null) {
			return n; // no mapping
		}
		long newval=0L;
		for(int i=fromBit.length-1;i>=0;i--) {
			int diff = fromBit[i]-toBit[i];
			if(diff>0) {
				newval |= ((n&longbitmask[fromBit[i]])>>> diff);
			} else if(diff<0) {
				newval |= ((n&longbitmask[fromBit[i]])<<(-diff));
			} else {
				newval |= n&longbitmask[fromBit[i]];
			}
		}
		return newval;
}
		
	/*
	 * Functions to map each bit in a different order.
	 * This function allows one bit to be mapped in multiple locations.
	 * User is responsible for making sure that multiple bits are not mapped to the same location.
	 */
	public static  long mapBits(long n,int[] fromBit, int[] toBit) {
		if(fromBit==null || toBit==null) {
			return n; // no mapping
		}
		long newval=0L;
		for(int i=fromBit.length-1;i>=0;i--) {
			int diff = fromBit[i]-toBit[i];
			if(diff>0) {
				newval |= ((n&longbitmask[fromBit[i]])>>>diff);
			} else if(diff<0) {
				newval |= ((n&longbitmask[fromBit[i]])<<(-diff));
			} else {
				newval |= n&longbitmask[fromBit[i]];
			}
		}
		return newval;
	}
	public static int sumGT0(int[] intarr) {
		int totsum=0;
		if(intarr==null) {
			return totsum;
		}
		for(int i=0;i<intarr.length;i++) {
			totsum+=Math.max(0,intarr[i]);
		}
		return totsum;
	}
	
	
}
