package edu.mayo.genotype;

import java.util.Comparator;

public class SnpUtilityComparator implements Comparator<Snp> {

	public int compare(Snp s1, Snp s2) {
		if(s1==null && s2==null) {
			return 0;
		} else if(s1==null) {
			return 1;
		} else if (s2==null) {
			return -1;
		}
		boolean s1oblig = (s1.isObligate()  || s1.isObligateButNotGenotyped()) && !s1.isExcluded();
		boolean s2oblig = (s2.isObligate()  || s2.isObligateButNotGenotyped()) && !s2.isExcluded();
		
		// obligates are more useful than non-obligates.
		if(s1oblig != s2oblig) {
			if(s1oblig) {
				return -1;
			} else {
				return 1;
			}
		} 
		double u1 = s1.getCurrentUtility();
		double u2 = s2.getCurrentUtility();
		if(u1>u2) {
			return -1;
		} else if (u1<u2) {
			return 1;
		} else {
			double p1 = s1.getSuccessProb();
			double p2 = s2.getSuccessProb();
			if(p1>p2) {
				return -1; // s1 is better (earlier)
			} else if (p1<p2) {
				return 1;
			} else {
				int np1 = s1.getNPop();
				int np2 = s2.getNPop();
				if(np1>np2) {
					return -1;
				} else if (np1<np2) {
					return 1;
				} else { 
					// Since already selected Pops --> deals with 
					// Multiple sources overlapping bins.
					int nb1 = s1.getNbins();
					int nb2 = s2.getNbins();
					if(nb1>nb2) {
						return -1;
					} else if (nb1<nb2) {
						return 1;
					} else {
						boolean uni1 = s1.isUniquelyCovers();
						boolean uni2 = s2.isUniquelyCovers();
						if(uni1 && !uni2) {
							return -1;
						} else if (uni2 && !uni2) {
							return 1;
						} else {
							// higher location class is better.
							int c1 = s1.getLocation_class();
							int c2 = s2.getLocation_class();
							if(c1>c2) {
								return -1;
							} else if (c1<c2) {
								return 1;
							} else {
								// raw probability score.
								double sc1 = s1.getScore();
								double sc2 = s2.getScore();
								if(sc1>sc2) {
									return -1;
								} else if (sc1<sc2) {
									return 1;
								} else {
									// tie-breaker.
									// XXX- Could do better,
									// e.g. look at choices SNP provides.
									if(s1.getId()<s2.getId()) {
										return -1;
									} else {
										return 1;
									}
								}
								// cannot have the same id.
							}
						}
					}
				}
			}
		}

	}
}