package edu.mayo.genotype;

import java.util.Comparator;

public class SnpSelectionOrderComparator implements Comparator<Snp> {

		  public int compare(Snp s1,Snp s2) {
			  if(s1==null && s2==null) {
				  return 0;
			  } else if (s1==null) {
				  return 1;
			  } else if (s2==null) {
				  return -1;
			  } else {
				  int so1 = s1.getSelectionOrder();
				  int so2 = s2.getSelectionOrder();
				  if(so1==so2) {
					  if(s1.getScore()>s2.getScore()) {
						  return -1;
					  } else if (s1.getScore()==s2.getScore()) {
						  return 0;
					  }
					  double s1locscore = SnpScorer.getLocationClassScore(s1.getLocation());
					  double s2locscore = SnpScorer.getLocationClassScore(s2.getLocation());
					  if(s1locscore>s2locscore) {
						  return -1;
					  } else if (s1locscore<s2locscore) {
						  return 1;
					  } else {
						  if(s1.getId()<s2.getId()) {
							  return -1;
						  } else {
							  return 1;
						  }
					  }
				  } else if (so1<so2) {
					  return -1;
				  } else {
					  return 1;
				  }
			  }
		  }		  
}
