/**
 * 
 */
package edu.mayo.genotype;


/**
 * @author hugues sicotte
 *
 * Class to keep track of SNPs grouped together.
 */
public class SnpGroup {


	// List of possible types (all prime numbers .. so can specify multiple)
	public static final long UNDEFINED=0;
	public static final long POPPATTERN=3; // SNPs covering the same bin pattern
    public static final long POPCOUNT=5; // SNPs covering the same number of bins.
    public static final long PROBABILITY=7; // SNPS with the same probability
    public static final long INSOLUTION=11; // SNPS in the solution
    public static final long NOTINSOLUTION=13; // SNPS not in the solution
    public static final long OBLIGATE=17; // OBLIGATE SNPS as per input
    public static final long EXCLUDE = 19; // FORCE EXCLUDE SNPS
    public static final long INCLUDE = 23; // FORCE INCLUDE SNPS
    
    public static final long TOOCLOSE=29; // Fixed or excluded by Too-close Algotirhm (use with EXCLUDE/INCLUDE)
    public static final long ESSENTIAL=31; // Group of SNPs covering some population Bins not covered by any other SNPs (and not excluded for some other reason)
    public static final long OVERLAP=37; // These SNPs overlap in Bin Pattern across populations.
    
    public long type = UNDEFINED; 
	
    Snp[] snps=null;

    int[] snpids=null;
    int length=0;
	public boolean isType(int category) {
		if(category == type) {
			return true;
		} else if (type == UNDEFINED) {
			return false;
		} else if (type>category && (type %  category ==0)) {
			return true;
		} else {
			return false;
		}
	}

	public long idSum() {
		long ids=0;
		for(int i=0;i<snps.length;i++) {
			ids+=(long)snpids[i];
		}
		return ids;
	}
	
	/**
	 * Empty Constructor
	 *
	 */
	public SnpGroup() {
		
	}
	public SnpGroup(Snp[] snps,long type) {
		this.type=type;
		if(snps==null) {
			return;
		}
		this.snps = snps;
		this.length=snps.length;
		this.snpids = new int[snps.length];
		for(int i=0;i<snps.length;i++) {
			snpids[i]=snps[i].getId();
		}
	}
	public SnpGroup(int[] snpids,long type) {
		this.type=type;
		if(snpids==null) {
			return;
		}
		this.snpids = snpids;
		this.length=snpids.length;
		this.snps = new Snp[snpids.length];
		for(int i=0;i<snpids.length;i++) {
			snps[i]=Snp.getSnpById(snpids[i]);
		}
	}
	public void addSnp(int snpid) {
		addSnp(Snp.getSnpById(snpid));
	}
	public void addSnp(Snp s) {
		if(s==null) {
			return;
		}
		{
			boolean found=false;
			if(this.length>0) {
				int sid=s.getId();
				for(int i=0;i<this.length;i++) {
					if(this.snpids[i]==sid) {
						found=true;
						break;
					}
				}
			}
			if(found) {
				return;
			}
		}
		if(this.snps == null) {
			this.snps = new Snp[10];
			this.length=0;
			this.snpids = new int[10];
		} else if((this.snpids.length % 10)==0) {
			Snp[] newSnps = new Snp[this.length+10];
			int[] newSnpids = new int[this.length+10];
			for(int i=0;i<this.length;i++) {
				newSnpids[i]=this.snpids[i];
				newSnps[i]=this.snps[i];
			}
			this.snps=newSnps;
			this.snpids=newSnpids;
		}

		this.snps[this.length]=s;
		this.snpids[this.length]=s.getId();
		this.length++;
	}
	
	
	public void delSnp(Snp s) {
		if(s==null) {
			return;
		}
		int indx=0;
		{
			boolean found=false;
			if(this.length>0) {
				int sid=s.getId();
				for(int i=0;i<this.length;i++) {
					if(this.snpids[i]==sid) {
						found=true;
						indx=0;
						break;
					}
				}
			}
			if(!found) {
				return;
			}
		}
		
		if(indx<this.length-1) { // If not the last one
			for(int i=indx;i<this.length-1;i++) {
				this.snps[i]=this.snps[i+1];
				this.snpids[i]=this.snpids[i+1];
			}
			this.snps[this.length-1]=null; // to free up obj reference.
		}
		this.length--;
	}
	
	public boolean equals(Object obj) {

		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SnpGroup other = (SnpGroup) obj;
		if(this.length==other.length && this.idSum()==other.idSum()) {
			if(this.hashCode()==other.hashCode()) {
				System.err.println("SnpGroup.equals not fullly implemented\n");
				System.err.flush();
				System.out.flush();
				System.exit(-1);
				return true;//
			} else {
				return false;
			}
		} else {
			return false;
		}
		
	}
	public int getLength() {
		return length;
	}

	public int[] getSnpids() {
		return snpids;
	}

	public Snp[] getSnps() {
		return snps;
	}

	public long getType() {
		return type;
	}
	public void setType(long type) {
		this.type = type;
	}


	
	
}
