package edu.mayo.genotype;
	
	import java.io.File;
	import java.io.FileReader;
	import java.io.PrintStream;
	import java.io.FileOutputStream;
	import java.io.BufferedOutputStream;
	import java.io.BufferedReader;
	import java.io.InputStreamReader;
	import java.io.FileInputStream;
	import java.io.FileNotFoundException;
	import java.util.regex.Pattern;
	import java.util.regex.Matcher;
	import java.io.IOException;
	import java.util.ArrayList;
	import java.util.Iterator;
	import java.util.HashMap;
	import java.util.LinkedList;
	import java.util.Map;
	import java.util.Set;
	import java.util.HashSet;

	import java.util.Properties;
	
	/*
	 This selects common tag-snps for single-marker tagging strategy,
	 e.g. ldselect,tagzilla, and tagger(in single marker mode only)
	
	
	 Input formats:
	
	 Snp score file (only matters for tag snps)
	 snpid\tscore_between 0 and 1 (default score is 0.5, transformed internally to 0-100)
	
	 If you have "obligate-snps", prefilter input to only allow that snp as the tag for the bin.
	
	 */
	
	public class SNPPicker {
		static boolean verbose = false;
		static int N = 0; // Number of Populations
	
		static int Nsnp = 0; // Number of snps
		
		static int nbins = 0; // number of bins
		static int maxBinPop=30; // Maximum number of populations, including dummies: Needed for bins[] vector in Snp object.
		static int minBin =1; // Only select bins with at least that many sites.
		
		static int nclusters = 0;// number of clusters
	
		private static int[] clusterids;
	
		static int tooClose = 60; // snp_pos2-snp_pos1>tooClose  default is for Illumina.
	
		static double defaultScore = -1; // SNPs not in the annotation files will have this default.
		static double minMAF=0.05;
		
		static String defaultValidationClass = "1";
		static double riskFactor = 0.0d; // Risk-averse Factor. Set to Negative (e.g. -1.0) to avoid choosing less tag-SNPS over quality.
		static String chromosome=null; // If set, becomes default chromosome assignment if not in annotation files.
		
		static String configFile = null;
	
		static int maxCPU = 500000; // 3000 secs (50min)/ cluster
	
		static int nOPA = 1; // 0 means to reject all SNPS too close, -1  skips SNP too close processing.

		

		// 
		
		static int snpUnderProbeDistance=0;// If set,  don't pick as tag-snp any SNP that has SNPs within this many bp
		static int oneSidedFloat =0; //
		
		static boolean greedy=false; // If true, optimal seed solution is the greedy one.
		
		static boolean optimal = true;
	
		static Population[] pops;
		static int obligates_cnt=0;
		static boolean ObligatesNotInPanel = false; // If obligates have already been genotyped, then they do not need to participate in SNPsTooClose
		static LinkedList<String> scorefiles = new LinkedList<String>();
		static double minScore=-99.0d;
		static double rsquare=0.8d;
		static double minP=1.0; // Set to less than 1.0 if want to allow less tagSNPs than hardcoded counts based on
							    // probability so far.
		static boolean infinium=false; // set to true to use bead type info (from alleles)
	
		static String obligateIncludeFile = null;
		static String obligateIncludeNGFile = null; // Obligates that will not be genotyped.
		static boolean obligateIncludeNGFileOverRule=false; // obligates that will not been genotyped this time have already been genotyped, so bins containing those only need a single SNP.
		static String obligateExcludeFile = null;
		
		// Rules for how many tagsnps to take as a function of the number of sites in the bin.
		private static  String NSBRules = "1-9=1,10-19=2,11-Inf=3";
		private static boolean doNotOptimize=false;
		// Illumina Defaults (Will be able to change them by Properties File)
		
	
		static int SNPID_COL=0;
		static String SNPID_STRING = "SNP_Name";
		static String HEADER_LINE = SNPID_STRING; // beginning of header line.
		static int DBSNPID_COL=0;
		static String DBSNPID_STRING = "SNP_Name";
		static int SEQUENCE_COL = 1;
		static String SEQUENCE_STRING = "Sequence";
		static String allelePattern = "[A-Z,a-z]+\\Q[\\E([A-Z,a-z,/]+)\\Q]\\E[a-z,A-Z]+";
		static int BUILD_COL =2;
		static String BUILD_STRING="Genome_Build_Version";
		static int CHR_COL=3;
		static String CHR_STRING = "Chr";
		static int POS_COL=4;
		static String POS_STRING = "Coordinate";
		static int SCORE_COL=11;
		static String SCORE_STRING = "SNP_Score";
		static int VALCLASS_COL=14;
		static String VALCLASS_STRING = "Validation_Class";
		static int LOC_TYPE_COL=40;
		static String LOC_TYPE_STRING = "Location";
		static int LOC_SUBTYPE_COL=42;
		static String LOC_SUBTYPE_STRING = "Coding_status";
		static int GENE_ID_COL = 39;
		static String GENE_ID_STRING = "Gene_ID";
		static int GENE_SYMBOL_COL = 38;
		static String GENE_SYMBOL_STRING = "GeneSymbol";
		static int GENE_SYMBOL_ALT_COL =40 ;
		static String GENE_SYMBOL_ALT_STRING = "Gene_symbol";
		static int GENE_SYMBOL_ALT2_COL =10 ;
		static String GENE_SYMBOL_ALT2_STRING = "Customer_Annotation";
		
		
		static String COMMENT_CHAR="#";
		static String NULLLOC="-99";
		static String BADSCORE = "-99"; // Scores that cannot be upgraded from default;
		static double badscore_double = -99.0;
		static String UNKNOWNSCORE = "-1"; // Score with this value (or NULL/empty) can be upgraded to default score.

		static  double DEFAULT_FAIL_PROB = 0.26;
		
		private static HashMap<String,String> ldsLoc2Loc = new HashMap<String,String>(); // ld-select location class single-character codes mappings.
	
		private static PrintStream tagStream = null;
	//	private static PrintStream emptyStream = null;
		
		private static String switches ="-it-il-im-iz"; // valid switched for input bin files.
		
		// If this option is set, read somebody else's solution
		// and print in utility-sorted order.
		static boolean computeUtilityOnly=false;
		static boolean obligateUtilityOnly=false;
		static boolean doNotPick = false;

		private static Properties properties = new Properties();
	
		static HashMap<String,String> GENEID2GENE = new HashMap<String,String>();
		static HashMap<String,String> GENE2GENEID = new HashMap<String,String>();

		
		// These options will be hidden from the public.
		// they are for the paper development only.
		static double optimizedScore=0.0d; // Score of first nSNPsToPick Snps.
		static double bestRandomScore=0.0d;
		static int nRandom=0; // set to >0 to enable random solutions (e.g. 10000000)
		static int nRandomComplex=100000;//100000;// Permute Random Complex Solutions
		static boolean multipleRandomSnpsPerBin=false; // Whether to select multiple solutions Per Bin.
		static int nBetterSolutions=0; // Number of random solutions that are better.
		static boolean[] randomlyPickedBin; // index by binid. - Keep Track of Bins Picked. (each Bin is only "visited" once.. though multiple tag SNPs could be selected).
		static boolean[] randomlyPickedSnp; // index by SNPid - Keep Track of Snps Picked (each SNP is only picked once, even when across bins).

		static int nRandomlyPicked=0; // Keep Track of Snps Picked.
		//
		//
		//
		
		static String dumpBinProbFile = "";	
		static String foutname=null;// outputfilename
		
		public static void main(String[] args) {
			{
				HashMap<String,String>  ldselectMapping = new HashMap<String,String>();
				ldselectMapping.put("F","flanking");
				ldselectMapping.put("U","utr");
				ldselectMapping.put("I","intron");
				ldselectMapping.put("S","coding-synon");
				ldselectMapping.put("N","coding-nonsyn");
				ldselectMapping.put("T","indel");
				ldselectMapping.put("X","unknown");

				Properties funcScores = new Properties();
				Set <String> ldselectKeys = ldselectMapping.keySet();
				try {
					funcScores.load(new FileInputStream("SNPPicker_functional_Scores.property"));
					ldselectMapping = SnpScorer.readClassMappings(funcScores,ldselectKeys);
					ldselectMapping = ProbabilityFromScore.readClassMappings(funcScores,ldselectKeys);
				} catch (Exception e) {
					System.err.println(e.getMessage());
				}
				// Set up location for ld-select format.
				ldsLoc2Loc = ldselectMapping;
			}

			if (args.length == 0) {
				usage();
				System.out.flush();
				System.exit(1);
			}
			
			int nfiles=0;
			// Count Different Populations
			{
				HashSet<String> indepPops=new HashSet<String>();
				for (int i = 0; i < args.length; i++) {
					if (args[i].equals("-p")) {
						i++;
						if(i<args.length && !args[i].startsWith("-")) {
							indepPops.add(args[i]);
						} else {
							System.err.println("SNPPicker:ERROR: Invalid format for -p parameters\n");
							System.err.flush();
							System.out.flush();
							System.exit(-1);
						}
					} else if(args[i].startsWith("-i") && switches.indexOf(args[i])>=0) {
						nfiles++;
						i++;
					} 
				}
				N=indepPops.size();
				SNPPicker.maxBinPop=Math.max(SNPPicker.maxBinPop, 2*(Math.max(indepPops.size(),nfiles)+1)); // guess: size needed for vector of bins in Snp +1 for obligates
			}
			pops = new Population[SNPPicker.maxBinPop];
			for (int i = 0; i < pops.length; i++) {
				pops[i] = null;
			} // not guaranteed to be null in JVM contract
			Population t_pop = null;
			int N_cur = 0;
			int N_pop = 0;
			for (int i = 0; i < args.length; i++) {
				if(args[i]==null || args[i].length()==0 || args[i].equals(" ")) {
					continue;
				}
				// If this option is set, read somebody else's solution
				// and print in utility-sorted order.
				if (args[i].equals("-computeutilityonly")) {
					SNPPicker.computeUtilityOnly=true;
				}
			}
			for (int i = 0; i < args.length - 1; i++) {
				if(args[i]==null || args[i].length()==0 || args[i].equals(" ")) {
					continue;
				}
				try {
					if (args[i].equals("-p")) {//-p popname		String with population name
						String popname =checkArg(args[++i]);
						t_pop = Population.getPopByName(popname);
						if (t_pop == null) {
							pops[N_pop++] = t_pop = new Population(popname);
						}
					} else if (args[i].startsWith("-i") && switches.indexOf(args[i])>=0) {//-i file 		ld-select or tagzilla input format file
						String format="ld-select";
						if(args[i].equals("-iz")) {
							format="tagzilla";
						} else if(args[i].equals("-il")) {
							format="ld-select";
						} else if(args[i].equals("-it")) {
							format="tagger";
						} else if(args[i].equals("-im")) {// Dave Rider's Tabular format
							format="mayotabular";
						}
						if(t_pop==null) {
							System.err.println("SNPPicker:ERROR: Must specify at least one population (e.g. -p CEU) before any filename (e.g. -i[t|l|z] binfile");
							System.err.flush();System.out.flush();
							System.exit(-1);
						}
						t_pop.addFileName(checkArg(args[++i]),format);
						N_cur++;
					} /*else if (args[i].equals("-l")) {//	    		[-l filename    ld_info file, File containing the pairwise r^2, to use with -optimal]
						if (pops[N_r2] == null) {
							pops[N_r2++] = t_pop = new Population();
						}
						t_pop.setR2File(checkArg(args[++i]));
					} */
					else if (args[i].equals("-L")) {
						try {
							System.setOut(new PrintStream(new BufferedOutputStream(
									new FileOutputStream(checkArg(args[++i])))));
						} catch (FileNotFoundException e) {
							System.err.println("SNPPicker:ERROR: Could not find file :" + args[i]);
							System.err.flush();System.out.flush();
							System.exit(-1);
						}
					} else if (args[i].equals("-o")) {
						try {
							foutname=checkArg(args[++i]);
							//String fempty = foutname + ".empty";
							tagStream = new PrintStream(new BufferedOutputStream(
									new FileOutputStream(foutname)));
							//emptyStream = new PrintStream(new BufferedOutputStream(
							//		new FileOutputStream(fempty)));
						} catch (Exception e) {
							System.err.println(e.getMessage());
							System.err.println("SNPPicker:ERROR: Could not open file for output " + args[i]);
							System.err.flush();System.out.flush();
							System.exit(-1);
						}
					} else if (args[i].equals("-e")) {
						try {
							System.setErr(new PrintStream(new BufferedOutputStream(
									new FileOutputStream(checkArg(args[++i])))));
						} catch (Exception e) {
							System.err.println(e.getMessage());
							System.err.println("SNPPicker:ERROR: Could not find file for output:" + args[i]);
							System.err.flush();System.out.flush();
							System.exit(-1);
						}
					} else if (args[i].equals("-s")) {//contains the snpid, a designability flag (0,0.5,1), and a position. If a SNP is not in this file, it assumes the default score]
						SNPPicker.scorefiles.add(checkArg(args[++i]));
					} else if (args[i].equals("-f")) {//   		[-f obligate_include_file (f=forced in) file containing snp ids of snps that must be included]   a SNP cannot be both obligate include and exclude.
						SNPPicker.obligateIncludeFile = checkArg(args[++i]);
					} else if (args[i].equals("-obligatesnotinpanel")) {//   		
						SNPPicker.obligateIncludeNGFile = checkArg(args[++i]);
					} else if (args[i].equals("-obligatesnotinpanl_done")) {//   		
						SNPPicker.obligateIncludeNGFileOverRule=true;
					} else if (args[i].equals("-x")) {//[-x obligate_exclude file containing snp ids of snps that must never be picked. a SNP cannot be both obligate include and exclude
						SNPPicker.obligateExcludeFile = checkArg(args[++i]);
					} else if (args[i].equals("-S")) {//default score, if a SNP is not in the scorefile. 
						SNPPicker.defaultScore = Double.parseDouble(checkArg(args[++i]));
					} else if (args[i].equals("-V")) {//default validation class .. string]
						SNPPicker.defaultValidationClass = checkArg(args[++i]);
					} else if (args[i].equals("-c")) {//config file listing the rules for picking multiple SNPS/bin, and for assigning Probabilities to Scores (Default is Illumina)
						SNPPicker.configFile = checkArg(args[++i]);
						BufferedReader config = new BufferedReader(new InputStreamReader(new FileInputStream(SNPPicker.configFile)));
						String line="";
						while((line=config.readLine())!=null) {
							if(line.indexOf("<PROBABILITIES>")>0) {
								ProbabilityFromScore.parseParameters(config);
							}
						}
					} else if (args[i].equals("-cpu")) {//maximum CPU limit in ms per cluster of too close .. or for refinement.
						String cputime = checkArg(args[++i]);
						SNPPicker.maxCPU = Integer.parseInt(cputime);
					} else if (args[i].equals("-X")) {//where nn is the minimum number of base pairs between SNPS 60.. unless they can be assigned to multiple OPA's]
						SNPPicker.tooClose = Integer.parseInt(checkArg(args[++i]));
					} else if (args[i].equals("-nOPA")) {//cNumber of different assay batches (OPA's for Illumina) where the overlapping SNPS can be distributed] -1 does nothing and 0 rejects all overlapping SNPS
						SNPPicker.nOPA = Integer.parseInt(checkArg(args[++i]));
					} else if (args[i].equals("-minscore")) {//Minimum score to consider for a tagsnp
						SNPPicker.minScore=Double.parseDouble(checkArg(args[++i]));
						// used by Snp.addScore() function
					} else if (args[i].equals("-defaultscore")) {// Default Score for SNPs with no information
						SNPPicker.defaultScore=Double.parseDouble(checkArg(args[++i]));
						// used by Snp.addScore() function
					} else if (args[i].equals("-rsquare")) {//Minimum r^2  to consider for a tagsnp
						SNPPicker.rsquare=Double.parseDouble(checkArg(args[++i]));
						// used by Snp.addScore() function
					} else if (args[i].equals("-r")) {// rules for Number of Snp/bin format "1-9=1,10-19=2,11-Inf=3"
						SNPPicker.NSBRules = checkArg(args[++i]);
					} else if (args[i].equals("-minP")) {// Minimum probability for multiple tagSNPs per bin.
						SNPPicker.minP = Double.parseDouble(checkArg(args[++i]));
					} else if (args[i].equals("-maf")) {// Minimum minor allele frequency (only works for Mayo Tabular format)
						SNPPicker.minMAF = Double.parseDouble(checkArg(args[++i]));
					} else if (args[i].equals("-g")) {// T of F (TRUE or FALSE): If T, start by minimizing number of total tags, otherwise pick most assayable tags first. Default T
						greedy = Boolean.valueOf(checkArg(args[++i])).booleanValue();
					} else if (args[i].equals("-maxpop")) {// Maximum Number of Population, including Dummies for overlapping data.
						SNPPicker.maxBinPop = 1+Integer.parseInt(checkArg(args[++i]));
					} else if (args[i].equals("-minbinsize")) {// Only selects bins with at least that many sites
						SNPPicker.minBin = Integer.parseInt(checkArg(args[++i]));
					} else if (args[i].equals("-randomcheck")) {// check approximate solution using random solutions
						SNPPicker.nRandomComplex = Integer.parseInt(checkArg(args[++i]));
						
						
					} else if (args[i].equals("-riskFactor")) {// set to Negative Number
						SNPPicker.riskFactor = Double.parseDouble(checkArg(args[++i]));
					} else if (args[i].equals("-chr")) {// Fix Chromosome Default.
						SNPPicker.chromosome =  checkArg(args[++i]);
					} else if (args[i].equals("-snpunderprobe")) {// if>0, reject ANY snps that has snps too close.
						SNPPicker.snpUnderProbeDistance = Integer.parseInt(checkArg(args[++i]));
					}else if (args[i].equals("-onesidedfloat")) {// if>0, allow one side to have one SNP within that distance.
						SNPPicker.oneSidedFloat = Integer.parseInt(checkArg(args[++i]));
					} else if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("--help")) {
						usage();
						System.out.flush();
						System.err.flush();
						System.exit(0);
					} else if (args[i].equals("-infinium2")) { // used in Bin->getScore && getTmpScore
						SNPPicker.infinium=true;
					} else if (args[i].equals("-nooptimal")) {// Default is to optimize (used in Cluster.java:findOptimal)
						SNPPicker.optimal=false;
					} else if (args[i].equals("-computeutilityonly")) {
						SNPPicker.computeUtilityOnly=true;
					} else if (args[i].equals("-obligateutilityonly")) {
						SNPPicker.computeUtilityOnly=true;			
						SNPPicker.obligateUtilityOnly=true;
					} else if (args[i].equals("-verbose")) {
						SNPPicker.verbose=true; // For multiple populations log files can become several Gigs!
					} else if (args[i].equals("-donotpick")) {
						SNPPicker.doNotPick=true; 
					} else if (args[i].equals("-noopt")) {
						SNPPicker.doNotOptimize=true; 
					} else if (args[i].equals("-propertyfile" )) {
						String pfile = args[++i];
						// Read properties file.
						try {
							properties.load(new FileInputStream(pfile));
							SNPID_COL = Integer.parseInt(properties.getProperty("SNPID_COL",Integer.toString(SNPID_COL)));
							SNPID_STRING = properties.getProperty("SNPID_STRING",SNPID_STRING);
							HEADER_LINE = properties.getProperty("HEADER_LINE",HEADER_LINE);
							DBSNPID_COL = Integer.parseInt(properties.getProperty("DBSNPID_COL",Integer.toString(DBSNPID_COL)));
							DBSNPID_STRING = properties.getProperty("DBSNPID_STRING",DBSNPID_STRING);
							SEQUENCE_COL = Integer.parseInt(properties.getProperty("SEQUENCE_COL",Integer.toString(SEQUENCE_COL)));
							SEQUENCE_STRING = properties.getProperty("SEQUENCE_STRING",SEQUENCE_STRING);
							BUILD_COL = Integer.parseInt(properties.getProperty("BUILD_COL",Integer.toString(BUILD_COL)));
							BUILD_STRING = properties.getProperty("BUILD_STRING",BUILD_STRING);
							CHR_COL = Integer.parseInt(properties.getProperty("CHR_COL",Integer.toString(CHR_COL)));
							CHR_STRING = properties.getProperty("CHR_STRING",CHR_STRING);
							POS_COL = Integer.parseInt(properties.getProperty("POS_COL",Integer.toString(POS_COL)));
							POS_STRING = properties.getProperty("POS_STRING",POS_STRING);
							SCORE_COL = Integer.parseInt(properties.getProperty("SCORE_COL",Integer.toString(SCORE_COL)));
							SCORE_STRING = properties.getProperty("SCORE_STRING",SCORE_STRING);
							VALCLASS_COL = Integer.parseInt(properties.getProperty("VALCLASS_COL",Integer.toString(VALCLASS_COL)));
							VALCLASS_STRING = properties.getProperty("VALCLASS_STRING",VALCLASS_STRING);
							LOC_TYPE_COL = Integer.parseInt(properties.getProperty("LOC_TYPE_COL",Integer.toString(LOC_TYPE_COL)));
							LOC_TYPE_STRING = properties.getProperty("LOC_TYPE_STRING",LOC_TYPE_STRING);
							LOC_SUBTYPE_COL = Integer.parseInt(properties.getProperty("LOC_SUBTYPE_COL",Integer.toString(LOC_SUBTYPE_COL)));
							LOC_SUBTYPE_STRING = properties.getProperty("LOC_SUBTYPE_STRING",LOC_SUBTYPE_STRING);
							GENE_SYMBOL_COL = Integer.parseInt(properties.getProperty("GENE_SYMBOL_COL",Integer.toString(GENE_SYMBOL_COL)));
							GENE_SYMBOL_STRING = properties.getProperty("GENE_SYMBOL_STRING",GENE_SYMBOL_STRING);
							GENE_ID_COL = Integer.parseInt(properties.getProperty("GENE_ID_COL",Integer.toString(GENE_ID_COL)));
							GENE_ID_STRING = properties.getProperty("GENE_ID_STRING",GENE_ID_STRING);
							GENE_SYMBOL_ALT_COL = Integer.parseInt(properties.getProperty("GENE_SYMBOL_ALT_COL",Integer.toString(GENE_SYMBOL_ALT_COL)));
							GENE_SYMBOL_ALT_STRING = properties.getProperty("GENE_SYMBOL_ALT_STRING",GENE_SYMBOL_ALT_STRING);
							GENE_SYMBOL_ALT2_COL = Integer.parseInt(properties.getProperty("GENE_SYMBOL_ALT2_COL",Integer.toString(GENE_SYMBOL_ALT2_COL)));
							GENE_SYMBOL_ALT2_STRING = properties.getProperty("GENE_SYMBOL_ALT2_STRING",GENE_SYMBOL_ALT2_STRING);
							COMMENT_CHAR=properties.getProperty("COMMENT_CHAR",COMMENT_CHAR);
							NULLLOC=properties.getProperty("NULLLOC",NULLLOC);



						} catch (IOException e) {
							System.err.println(e.getMessage());
							System.err.println("Invalid javaproperty file "+pfile);
							System.err.flush();
							System.exit(-1);
						}
						// Undocumented Options					    
						// Options for the paper development only.
						// 
					} else if(args[i].equals("-nR")) {
						SNPPicker.nRandom=Integer.parseInt(checkArg(args[++i])); // if >0, turn this on
					} else if(args[i].equals("-randommulti")) {
						SNPPicker.multipleRandomSnpsPerBin = true;
					} else if(args[i].equals("-dumpBinProb")) {
						dumpBinProbFile = args[++i];
					}
					else {
						System.err.println("SNPPicker:ERROR: unrecognized option "+args[i]);
						System.err.flush();System.out.flush();
						System.exit(-1);
					}
				} catch(Exception e) {
					e.printStackTrace();
					System.err.println(e.getMessage());
					System.err.println("SNPPicker: Error while processing input parameters");
					System.err.flush();System.out.flush();
					System.exit(-1);
				}
			} // end of loop over parameters

			if(tagStream==null) {
				System.err.println("SNPPicker:ERROR: No output filename provided (-o)\n");
				usage();System.out.flush();
				System.exit(-1);
			}

			//
			//			Process ScoreFiles
			//

			Iterator<String> its = SNPPicker.scorefiles.iterator();
			while(its.hasNext()) {
				String scorefile = its.next();
				// scorefile should only contains SNPs relevant for the population of interest, but
				// should contain SNPs with freq>0 (and thus above user cut-off) if they need to be
				// considered for snpUnderProbeDistance>0 tooClose test
				try {
					//	Read Scores, position, and annotation
					System.out.println("About to read scorefile "+scorefile);
					System.out.println("Currently have "+Snp.getSnpCount()+" SNPs out of "+Snp.getNsnps()+" read SNPs");
					System.out.flush();
					if(scorefile!=null) {
						processScoreFile(scorefile);
						// also takes care of excluding SNPs that have a SNP under the probe
						// Have to run it AFTER obligates inclusion/exclusion
					}
					System.out.println("Finished reading scorefile");
					System.out.println("Now have "+Snp.getSnpCount()+" SNPs, and read a total of "+Snp.getNsnps()+" SNPs");
					System.out.flush();

				} catch (Exception e) {
					// exit if IO error or collision.
					e.printStackTrace();
					System.err.println(e.getMessage());
					System.err.flush();System.out.flush();
					return;
				}
			}
			// Validate parameters for Snp under the probe (XXX not yet fully implemented)
			if(snpUnderProbeDistance>0) {
				// Need SNP scorefile to get list of all SNPS in area
				if (scorefiles.size()==0) {
					System.err.println("SNPPicker:WARNING: To use the snpUnderProbeDistance feature, we need the scorefile: All SNPs in area must be in that file");
					System.err.flush();
				}
			}


			System.out.println("Processed parameters");System.out.flush();
			//
			// Read Bin files and create snp and bins objects
			//
			HashMap<String,String> haveFileId = new HashMap<String,String>();
			try {
				for (int i = 0; i < N; i++) {
					t_pop = pops[i];
					ArrayList<String> formats = t_pop.getFormats();
					ArrayList<String> filenames = t_pop.getFileNames();
					//String popname = t_pop.getName();
					for(int j=0;j<formats.size();j++) {
						String fileformat = formats.get(j);
						String binfname = filenames.get(j);
						String fileid0 = Integer.toString(j);
						String fileid = filenameToFileId(binfname);
						if(haveFileId.containsKey(fileid)) {
							fileid = fileid+"_"+fileid0;
						}
						haveFileId.put(fileid,binfname);
						if(fileformat.equals("ld-select")) {

							String mapfile = "rsid_pos_map.txt";
							
							String mapdir=(new File(binfname)).getParentFile().getAbsolutePath();
							mapfile=mapdir+File.separator+mapfile;

							readLDSelectTagzilla(t_pop,binfname,fileid ,false,mapfile);
							System.out.println("Read ld-select file "+binfname);System.out.flush();
						} else if(fileformat.equals("tagzilla")) {
							System.out.println("Reading Tagzilla file "+binfname);System.out.flush();
							readLDSelectTagzilla(t_pop,binfname,fileid ,true,null);
							System.out.println("Read Tagzilla file "+binfname);System.out.flush();
						} else if(fileformat.equals("tagger")) {
							readTagger(t_pop,binfname,fileid );
							System.out.println("Read Taggger file "+binfname);System.out.flush();
						}else if(fileformat.equals("mayotabular")) {
							readMayoTabular(t_pop,binfname,fileid);
							System.out.println("Read Mayo file "+binfname);System.out.flush();
						}
						System.out.println("Now have "+Snp.getSnpCount()+" SNPs");
						System.out.flush();

					}
				} } catch (Exception e ) {
					e.printStackTrace();
					System.err.println(e.getMessage());
					System.err.flush();
					System.out.flush();
					System.exit(-1);
				}
				System.out.println("Read Bins data");System.out.flush();
				//
				// if a default value for the chromosome field is provided
				// ==> validate that all SNPs in input are on the same chromosome... or all unknown.
				//
				try {
					int nSnpsIndex = Snp.getSnpIndex().length;
					for(int i=1;i<=nSnpsIndex;i++) { //
						Snp s = Snp.getSnpById(i);
						if(s!=null) {
							int nbins = s.getNbins();
							if(nbins>0) {
								String chr = s.getChromosome();
								if(chr!=null && chr.length()>0) {
									if(chr.equals("-99")) {
										s.setExcluded(true); // Exclude because chromosome -99 means that this SNP will not assay on Illumina.
										s.setFixed(true);
									} else if(chromosome!=null && chromosome.length()>0 && !chr.equalsIgnoreCase(chromosome)) {
										System.err.println("SNPPicker:ERROR: Snp "+s.getSnpName()+" on chromosome "+chr+ " instead of chromosome "+chromosome);
										System.err.flush();System.out.flush();
										System.exit(-1);
									}
								}
							}
						}
					}
					System.out.println("Processed Chromosome Filtering");System.out.flush();
				} catch (Exception se) {
					se.printStackTrace();
					System.err.println(se.getMessage());
					System.err.flush();
					System.out.flush();
					System.exit(-1);
				}
				System.out.println("Processed obligates Included genotyped on another platform.");System.out.flush();





				long cpustart = System.currentTimeMillis();
				try {
					Snp.computeSNPProbs();
					System.out.println("Processed SNP probabilities");System.out.flush();

					// Compute NSB for each bin.
					processNSBRules(NSBRules);
					System.out.println("Processed SNP rules");System.out.flush();

					if(snpUnderProbeDistance>0) {
						// mark as fixed excluded any SNPs with other SNps within
						// use oneSidedFloat, if >0 allow one side to have a close SNP (x1)
						// |--60bp----|1-20|
						// /----------T---X1-------O/
						//            |---60bp-----|
						// Can have any number of "X1" snps within the float.

						// Infinium requires no SNP under probe for at least one side, so set Float==TooClose==50


						System.err.println("SNPPicker:ERROR: Snpsunderprobe filtering option not Yet implemented- use nOPA==0 instead \n");
						System.err.flush();System.out.flush();
						System.exit(-1);
						// Sort SNPs by position.. (see if methods in SNP or cluster)
						// Look one SNP at a time and look left or right.

						// also not clear on how to deal with rare SNPs. Ideal would be to have Haplotypes.

					}

					// Process the Obligates that may cause NSB to be ==1
					if(obligateIncludeNGFile!=null) {
						try{
							// These non-genotyped obligates do not cause
							// bins to be created.
							processObligateInclude(obligateIncludeNGFile,true);
						} catch (Exception e) {
							System.err.println(e.getMessage());
							e.printStackTrace();System.out.flush();
							System.err.flush();
							System.exit(-1);
						}
					}


					if((!SNPPicker.computeUtilityOnly)) {
						System.out.println("Remove low-scoring SNPS");System.out.flush();
						Snp.processMinScore(); // Exclude SNPs below minimum score threshold.
					}



					//
					//  Compute Basic Snp Probability of failing to be successfully being converted to an assay (does not include Bin Prob)
					//

					System.out.println("Computing bin-edge data");System.out.flush();
					Bin.buildMaxinums(); // Build all maximum for Scores
					BinEdge.buildMaximums(); 
					System.out.println("Cached data");System.out.flush();

				} catch (Exception eb) {
					eb.printStackTrace();
					System.err.println(eb.getMessage());
					System.err.flush();
					System.out.flush();
					System.exit(-1);
				}
				//
				// Have to Process Obligate after build Clusters so Can have Obligate-based info in bins???
				// also Obligate loading creates fake bins& bin-edge(if the obligates do not overlap existing SNPs)
				//  so we do not want to build clusters around not-binned SNPs.
				//
				System.out.println("About to Process obligates");System.out.flush();

				// Mark Obligate
				// must have NSB computed before "selecting" obligates ( so can mark SNPs as full)

				//
				// 		Obligates Processing		
				//

				if(obligateIncludeFile!=null) {
					try{
						processObligateInclude(obligateIncludeFile,false); // Mark Obligate
					} catch (Exception e) {
						System.err.println(e.getMessage());
						e.printStackTrace();System.out.flush();
						System.err.flush();
						System.exit(-1);
					}
				}
				System.out.println("Processed obligates Includes that may be in the panel.");System.out.flush();


				if(obligateExcludeFile!=null) {
					try{
						processObligateExclude(obligateExcludeFile);
					}catch (Exception e) {
						System.err.println(e.getMessage());
						e.printStackTrace();
						System.err.flush();System.out.flush();
						System.exit(-1);
					}
				}
				System.out.println("Processed excluded");System.out.flush();
				Snp.outHeader(tagStream);
				if(SNPPicker.nOPA!=0 || SNPPicker.computeUtilityOnly){
					try {
						// Delete Obligates without bins IF these obligates are not to be genotyped.
						int nSnpsIndex = Snp.getSnpIndex().length;
						System.out.println("Now have "+Snp.getSnpCount()+" SNPs before deleting not in panel obligate SNPs without bins");
						System.out.flush();
						for(int i=1;i<=nSnpsIndex;i++) { //
							Snp s = Snp.getSnpById(i);
							if(s!=null) {
								int nb= s.getNbins();
								int nrealbins=0;
								if (nb>0) {
									int[] binids =s.getBins();
									if(binids!=null) {
										for(int k=0;k<binids.length;k++) {
											int bid = binids[k];
											if(bid>0) {
												Bin b = Bin.getBinById(bid);
												if(b!=null) {
													int bpopid = b.getPopid();
													Population binpop = Population.getPopById(bpopid);
													if(binpop!=null) {
														String pname = binpop.getName();
														if(pname!=null && (!(pname.toLowerCase().indexOf("obligate")>=0))) {
															nrealbins++;
														}
													}
												}
											}
										}
									}  
								}
								if(nrealbins==0 && (s.isObligate() || s.isObligateButNotGenotyped())) {// i.e. not TagSNPs, but in the bin.
									s.out(tagStream);
									Snp.deleteByName(s.getSnpName(),true);// Need to delete fake bin as well.
									System.out.println("O");
									System.out.flush();
								}
							}
						}
						System.out.println("Now have "+Snp.getSnpCount()+" SNPs");
						System.out.flush();
					} catch(Exception e) {
						e.printStackTrace();
						System.err.println(e.getMessage());
						System.err.flush();
						System.out.flush();
						System.exit(-1);
					}
				}





				if((!SNPPicker.computeUtilityOnly) && tooClose>0 && nOPA>=0){ // Check for Obligate Include that are too close. nOPA==-1 means to skip proximity checking
					System.out.println("SNPPicker: Looking for Obligates too close to each other");System.out.flush();		

					try{
						ArrayList<ArrayList<Snp>> al = Snp.findContigousSNP(tooClose,true,true,nOPA);// Test only obligate Include and don't cluster with Excluded.
						if(al!=null && al.size()>0) {
							if(nOPA>=0) {
								StringBuffer tooCloseObligates = new StringBuffer("");
								for(int k=0;k<al.size();k++) {
									ArrayList<Snp> alg =al.get(k);
									if(alg!=null) {
										if(alg.size()>nOPA) {
											// First, remove low-scoring obligates.
											for(int l=alg.size()-1;l>=0;l--) {
												Snp s = alg.get(l);
												if(s!=null) {
													if(s.getScore()<=SNPPicker.minScore) {
														s.setFixed(false);
														s.setSelected(false,true); // unselect.
														s.setExcluded(true); // Exclude
														s.setFixed(true);
														alg.remove(l);
														System.err.println("SNPPicker:WARNING: Excluding low-scoring obligate "+s.getSnpName()+", score="+s.getScore());
														System.err.flush();
													}
												} else {
													alg.remove(l);
												}
											} //for
											int nproblems=0;
											if(alg!=null && alg.size()>nOPA) {
												// Is there still a problem?
												for(int l=0;l<alg.size();l++) {
													Snp s = alg.get(l);
													tooCloseObligates.append(";");
													tooCloseObligates.append(s.getSnpName());
													tooCloseObligates.append("(pos=");					
													tooCloseObligates.append(s.getPosition());
													tooCloseObligates.append(")");
													if(s.getNbins()==0){

														// create a fake bin for these obligate SNPs so can choose them.
														Population obligatePop = Population.getPopByName("obligates");
														if(obligatePop==null) {
															obligatePop = new Population("obligates");
														}
														SNPPicker.obligates_cnt++;
														String binname="obligates-1:"+(Integer.valueOf(SNPPicker.obligates_cnt)).toString();
														int currpopid =obligatePop.getId();
														Snp.addSnpEdge(s.getSnpName(), binname, currpopid);
														s.setObligate(true); // so can mark bin.
													}
													nproblems++;
													s.setFixed(false);
													s.setSelected(false,true); // unselect both obligates and let algorithm pick best choice.
												}
												if(nproblems>0) {
													tooCloseObligates.append(" || " );
												}
											} // alg!=null alg.size>nOPA
										} // alg.size>nOPA
									}
								}
								if(tooCloseObligates.length()>1) {
									System.err.println("SNPPicker: Some ObligateInclude are too close to each other, so the code will unset them and pick the optimal set. "+tooCloseObligates.substring(1));		
									System.err.flush();
									if(nOPA==0) {// NO SNPS allowed close to each other.
										System.out.flush();
										System.exit(-1);
									}
								}
							}
						}
					} catch (Exception et) {
						et.printStackTrace();
						System.out.println(et.getMessage());
						System.out.println("Encountered an Exception while Processing Obligates/excludes");
						System.out.flush();
						System.err.flush();
						System.exit(-1);
					}
				}
				System.out.println("Validated obligates");System.out.flush();



				// Delete small bins if requested by user.
				// 	This does not delete the tag SNPs, just the bins.
				// 
				if((!SNPPicker.computeUtilityOnly) && SNPPicker.minBin>1) {
					// Delete bins that are too small 
					try {
						System.out.println("Deleting Bins Smaller than "+SNPPicker.minBin); System.out.flush();
						Bin.deleteSmallBins(SNPPicker.minBin);
						System.out.println("Deleted Small Bins"); System.out.flush();
					} catch(Exception e) {
						e.printStackTrace();
						System.err.println(e.getMessage());
						System.err.flush();
						System.out.flush();
						System.exit(-1);
					}
				}

				//
				// Fix SNPs too close and link clusters if needed.
				//

				if(1==1) {
					// resolve SNPs that are too close.
					System.out.println("Started with "+Snp.getSnpCount()+" SNPs");
					System.out.flush();
					try {
						System.out.println("SNPPicker:INFO: Fixing Obligs.");System.out.flush();
						Snp.fixObligates(); // Fix Obligates even if Type II and -infinium
						if(tooClose>0 && nOPA>=0) {
							System.out.println("SNPPicker:INFO: Looking for tagSNPs+obligates too close to each other");System.out.flush();		
							boolean fixall=true; // XXX 2010-4-01 Do not need to set this to true for SNPPicker2, we just need the clusters linked.
							if(SNPPicker.computeUtilityOnly) {
									fixall=false;
							}
							ArrayList<ArrayList<Snp>> c = Snp.processSnpTooClose(tooClose,nOPA,fixall); 
//							if(fixall && nOPA>0) {// nOPA>0 only for Golden Gate Assay
//								int nfixed =Snp.fixSnpsInWindows(c); // Temporary, not part of initial solution search
//								System.out.println("SNPPicker:INFO: Too Close SNPs fixed " + nfixed + " tag SNPs"); System.out.flush();
//							}
							int nadded = Snp.addBinEdgesForTooCloseGroups(c);
							System.out.println("SNPPicker:INFO: Too Close SNPs added " + nadded + " edges for clustering"); System.out.flush();
						}
						if(SNPPicker.infinium && !SNPPicker.computeUtilityOnly) {// fix and unselect type II
							int nfixedII = Snp.fixAndUnselectTypeII();
							System.out.println("SNPPicker:INFO: Fixed  " + nfixedII + " beadtype II SNPs"); System.out.flush();
						}
						// unless nOPA<=0, all non-in-bin snps will be deleted.
						// Now have Selected or Excluded SNPs that are too close. They are marked as "fixed"
					} catch (Exception e) {
						System.err.println(e.getMessage());
						e.printStackTrace();
						System.err.flush();System.out.flush();
						System.exit(-1);
					}
					System.out.println("Processed too close Snps"); 
					System.out.println("Now have "+Snp.getSnpCount()+" SNPs");
					System.out.flush();
				}


				// Delete Snps without bins. 
				// They were only needed for the SNPUnderProbe test and SnpTooClose tests (if nOPA==0)
				// and fix selected SNPs
				{
					try{
						int nSnpsIndex = Snp.getSnpIndex().length;
						System.out.println("SNPPicker:INFO: Now have "+Snp.getSnpCount()+" SNPs before deleting SNPs without bins");
						System.out.flush();
						for(int i=1;i<=nSnpsIndex;i++) { //
							Snp s = Snp.getSnpById(i);
							if(s!=null) {
								int nb= s.getNbins();
								int nrealbins=0;
								if (nb>0) {
									int[] binids =s.getBins();
									if(binids!=null) {
										for(int k=0;k<binids.length;k++) {
											int bid = binids[k];
											if(bid>0) {
												Bin b = Bin.getBinById(bid);
												if(b!=null) {
													int bpopid = b.getPopid();
													Population binpop = Population.getPopById(bpopid);
													if(binpop!=null) {
														String pname = binpop.getName();
														if(pname!=null && (!(pname.toLowerCase().indexOf("obligate")>=0))) {
															nrealbins++;
														}
													}
												}
											}
										}
									}  
								}
								if(nrealbins==0 && (!(s.isSelected()|| s.isFixed()))  && (s.isObligateButNotGenotyped() || (!s.isObligate()) || (s.isObligate() && SNPPicker.chromosome!=null && s.getChromosome()!=null && s.getChromosome().length()>0 && !s.getChromosome().toLowerCase().equals(SNPPicker.chromosome.toLowerCase())))) {// i.e. not TagSNPs, but in the bin.
									Snp.deleteByName(s.getSnpName(), false); // Allow deletion of obligates Not genotyped, obligates on other chromosomes (if chromosome is specified)
								} else if(nrealbins==0 && s.isObligate()) {
									s.out(tagStream);
									System.out.println("T");System.out.flush();
									Snp.deleteByName(s.getSnpName(), false);
								}
							}
						}
						System.out.println("Now have "+Snp.getSnpCount()+" SNPs");
						System.out.flush();
					} catch(Exception e) {
						e.printStackTrace();
						System.err.println(e.getMessage());
						System.err.flush();
						System.out.flush();
						System.exit(-1);
					}
				}
				long cpend=cpustart;
				try {
					BinEdge.computeIsReal();
					Cluster.buildClusters(); // Build Clusters from BinEdges
					Snp.populateTooClose();  // So that scoring Functions can figure out nOPA
				} catch(Exception e) {
					e.printStackTrace();
					System.err.println(e.getMessage());
					System.err.flush();
					System.out.flush();
					System.exit(-1);
				}
				if(!SNPPicker.computeUtilityOnly) {
					try {
						// We can now process each Cluster 
						System.out.println("Picking Clusters"); System.out.flush();

						int nPickedClusters = Cluster.pickAll(true, false, false,(SNPPicker.isOptimal() || SNPPicker.infinium || (SNPPicker.tooClose>0 && SNPPicker.nOPA>-1) )==false); // Basic SNP picking of non-fixed SNPs
						System.out.println("Optimizing "+nPickedClusters+" Clusters\n");System.out.flush();
						if(SNPPicker.infinium || (SNPPicker.tooClose>0 && SNPPicker.nOPA>-1)) {
							// Search for better solution by including or swapping in fixed SNPs (Type II if(infinium2)  and Proximity Excluded if(nOPA>=0))
							// May not have to swap out any SNPs to swap in this kind of SNPs.
							// Do not (yet) swap back in SNPs already rejected by standard picking. 
							// unfixing is a committal Step. Cannot be undone.
							// The solution will not be optimal because we are not considering the not-in-solution.

							Cluster.pickAll(false, true/*unfix */, false /* not global optimal */,!SNPPicker.isOptimal()); 
						}
						if(SNPPicker.isOptimal()) {
							// user requested we find optimal solution (default)
							// all SNPs not in solution (of any category of type) are now free to be swapped in.
							Cluster.pickAll(false, true , true /* true,true = unfix all, andglobal optimal */,true); 
						}

					} catch (Exception ce) {
						System.err.println(ce.getMessage());
						ce.printStackTrace();
						System.err.flush();System.out.flush();
						System.exit(-1);
					}
				}
				System.out.println("Outputting results"); System.out.flush();
				Snp.outAll(tagStream); // Since one SNP can tag multiple Bins, better to output 1 tag-snp/Snp
				System.out.println("Outputting Empty Bins"); System.out.flush();
				Bin.outEmpty(tagStream); // Output 1 line for each empty bins.
				
				if(dumpBinProbFile.length()>0) {
					Bin.dumpBinProbFile(dumpBinProbFile);
				}
				tagStream.close();
				//emptyStream.close();
				int nsnps = Snp.getNsnps();
				int snpcount = Snp.getSnpCount();
				int nbins = Bin.getNbins();
				cpend = System.currentTimeMillis();
				System.out.println("Processed nsnps= "+nsnps+" , nbins= "+nbins+", leftover snps="+snpcount+" in non-IO clock time= "+(cpend-cpustart)+" ms");System.out.flush();
				System.out.flush();
				System.err.flush();

				System.out.println("nRandom ="+SNPPicker.nRandom+"\n");
				if(SNPPicker.nRandom>0) {

					
					
					int nPanel=Snp.countSelected();

					nBetterSolutions=0;
					int nOutSolutions=0;
					// initialize
					nsnps = Snp.getNsnps();
				
					nbins = Bin.getNbins();
					randomlyPickedBin = new boolean[nbins]; // index by binid. - Keep Track of Bins Picked. (each Bin is only "visited" once.. though multiple tag SNPs could be selected).
					randomlyPickedSnp = new boolean[nsnps]; // index by SNPid - Keep Track of Snps Picked (each SNP is only picked once, even when across bins).

					String[] splitFile=null;
					if(foutname!=null) {
						splitFile = Utils.splitFile(foutname);
					} else {
						splitFile = Utils.splitFile("SNPPickerBetterRandomSolution.txt");

					}
					int[] excludedIndex = Snp.getExcludedIndex();// snpid is 1+index
					int[] obligateIndex =  Snp.getObligatesIndex();
					int[] obligateNotGenotypedIndex = Snp.getObligatesNotGenotypedIndex();

					// Save current optimized solution
					// Gotta copy the solution to TMP in order to score it.

					Bin[] binsToPickList = Bin.getAllBins();
					HashMap<Bin,Integer> binsToPick = new HashMap<Bin,Integer>();
					for(int ib=0;ib<binsToPickList.length;ib++) {
						Bin bb= binsToPickList[ib];
						if(bb!=null) {
							bb.resetTmpSolution(true);
							Snp[] sss =bb.getSnps();
							if(sss!=null && sss.length>0) {
								int nselectable =0;
								for(int is=0;is<sss.length;is++) {
									Snp ss = sss[is];
									if(ss!=null && !(ss.isExcluded() || (ss.isFixed() && ss.getScore()<SNPPicker.minScore)) ) {
										nselectable++;
									}
								}
								binsToPick.put(bb,Integer.valueOf(Math.min(bb.getNSB(),nselectable)));
								// XXX - Should also Math.max() over bins with multiple obligates.. but
								// we don't know if we can optimize that many in the bin.
							}
						}
					}
					
					
					SolutionTracker bestSolution = new SolutionTracker();
					SolutionTracker.updateTmpScore(binsToPick,bestSolution);
					// Figure out score for top nPanel SNPs.
					optimizedScore=bestSolution.getScore(); // Score of first nSNPsToPick Snps.
					int bestCoverage = bestSolution.getNbins();
					int bestNMissing = bestSolution.getNMissing();
					int optimNecessaryNotPicked = bestSolution.getNNecessaryButNotPicked();
					int optimObligates = bestSolution.getNObligates();
					System.out.println("Optim score=" + optimizedScore);
					System.out.println("Optim nsnps=  " +nPanel);
					System.out.println("Optim Coverage=" +bestCoverage);
					System.out.println("Optim Obligates=" +optimObligates);
					System.out.println("Optim NMissing=" +bestNMissing);
					
					
					java.util.Random randg = new java.util.Random();
					
					String randomScoreFile =splitFile[0]+splitFile[1]+ "_randomscores."+splitFile[2];
					PrintStream randomTagStream=null;
					try {
						randomTagStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(randomScoreFile)));
					} catch (FileNotFoundException fnfe) {
						String sele = fnfe.getMessage();
						System.err.println(sele);
						System.err.flush();
						System.exit(-1);
					}
					randomTagStream.println(Double.toString(optimizedScore)+","+Integer.toString(nPanel)+","+Integer.toString(bestCoverage)+","+Integer.toString(bestNMissing));
					java.util.Random randbin=new java.util.Random();
					long cpustart_random = System.currentTimeMillis();
					for(int i=0;i<SNPPicker.nRandom;i++) {
						
						nRandomlyPicked=0;
						//reset solutions and counter
						Bin.resetAll(); // Reset All Solutions (keep obligates and excluded by Score)
						for(int ib=0;ib<nbins;ib++) {
							randomlyPickedBin[ib]=false;
						}
						for(int is=0;is<nsnps;is++) {
							randomlyPickedSnp[is]=false;
						}
						try {
							// Pick Obligates, Exclude Excluded
							for(int ii=0;ii<excludedIndex.length;ii++) {
								int snpindex = excludedIndex[ii];
								Snp s = Snp.getSnpById(snpindex+1);
								s.setExcluded(true);
								randomlyPickedSnp[snpindex]=true; // Just means we cannot pick it.
							}
							for(int ii=0;ii<obligateIndex.length;ii++) {
								int snpindex = obligateIndex[ii];
								Snp s = Snp.getSnpById(snpindex+1);
								
								s.setObligate(true);
								s.setSelected(true, true);
								s.setTmpSelected(true, true);
								randomlyPickedSnp[snpindex]=true; // Just means we cannot pick it.
								nRandomlyPicked++;
							}					
							for(int ii=0;ii<obligateNotGenotypedIndex.length;ii++) {
								int snpindex = obligateNotGenotypedIndex[ii];
								Snp s = Snp.getSnpById(snpindex+1);
								s.setObligateButNotGenotyped(true);
								s.setSelected(true, true);
								s.setTmpSelected(true, true);
								randomlyPickedSnp[snpindex]=true; // Just means we cannot pick it.
							}
						} catch (Exception e) {
							e.printStackTrace();
							String sele = e.getMessage();
							System.err.println(sele);
							System.err.flush();
							System.exit(-1);
						}
						{ // Shuffle all the bins
							if(nbins>0 && binsToPickList!=null && binsToPickList.length>0) {
								for(int ir =0;ir<binsToPickList.length;ir++) {
									int jj = randg.nextInt(binsToPickList.length);
									Bin tmpB = binsToPickList[jj];
									binsToPickList[jj]=binsToPickList[ir];
									binsToPickList[ir]=tmpB;
								}
							} 
						}
						int ii=0;
						int[] topick =null;
						int nreshuffle=0;
						while(ii<binsToPickList.length && nRandomlyPicked<nPanel) {
							if(randomlyPickedBin[ii]==false) {
								randomlyPickedBin[ii]=true; // only visit each bin once.
								Bin b = binsToPickList[ii];
								if(b!=null) { // could be full from obligates or from overlapping
									topick = b.getAvailableSnpIds(true);
									int needed = b.getNSB();
									int nsel = b.getTmpNSelected();
									int nToSel =0;

									int irandom=0;
									if(SNPPicker.multipleRandomSnpsPerBin) {
										nToSel = Math.min(Math.min(needed-nsel,topick.length),nPanel-nRandomlyPicked);
										if(nToSel>0 && topick.length>0) {
											irandom = randbin.nextInt(topick.length);
										} else {
											nToSel=0;
										}
									} else if (nsel==0) {// if none selected, pick at least one
										if(topick.length>0) {
											nToSel=Math.min(1,needed);
											irandom = randbin.nextInt(topick.length);
										} else {
											nToSel=0;
										}
									}
									while(nToSel>=1) {
										if(topick.length>0) {
											Snp s = Snp.getSnpById(topick[irandom]);
											if(s!=null && !s.isTmpSelected()) {
												try {
													 if(s.canISelect(true)) {// check for tooClose
														s.setTmpSelected(true,true);
														nRandomlyPicked++;
														nToSel--;
													 } else {
														 s.setFixed(true);
													 }
													topick=b.getAvailableSnpIds(true);
												} catch (Exception e) {
													e.printStackTrace();
													String sele = e.getMessage();
													System.err.println(sele);
													System.err.flush();
													System.exit(-1);
												}
											} else {
												topick=b.getAvailableSnpIds(true);
											}
											if(topick.length==0) {
												nToSel=0;
											} else {
												irandom = randbin.nextInt(topick.length);
											}
										} else {
											nToSel=0;
										}
									}
								}
							}
							ii++;
							if(ii==binsToPickList.length && nRandomlyPicked<nPanel && nreshuffle<10) {
								nreshuffle++;
								if(nbins>0 && binsToPickList!=null && binsToPickList.length>0) {
									for(int ir =0;ir<binsToPickList.length;ir++) {
										int jj = randg.nextInt(binsToPickList.length);
										Bin tmpB = binsToPickList[jj];
										binsToPickList[jj]=binsToPickList[ir];
										binsToPickList[ir]=tmpB;
									}
								}
								for(int ib=0;ib<nbins;ib++) {
									randomlyPickedBin[ib]=false;
								}
								for(int is=0;is<nsnps;is++) {
									randomlyPickedSnp[is]=false;
								}
							}
						}
						if(i==SNPPicker.nRandom || Math.round(i/10000)*10000 ==i  ) {
							System.out.print("Rand " + i+" ");
							System.out.println("Picked "+nRandomlyPicked);
							System.out.flush();
						}
						SolutionTracker randomSolution = new SolutionTracker();
						SolutionTracker.updateTmpScore(binsToPick,randomSolution);
						// Figure out score for top nPanel SNPs.
						double randomScore=				randomSolution.getScore(); // Score of first nSNPsToPick Snps.
						int randomCoverage = 			randomSolution.getNbins();
						int randomNMissing = 			randomSolution.getNMissing();
//						int randomNecessaryNotPicked =	randomSolution.getNNecessaryButNotPicked();
						int randomObligates = 			randomSolution.getNObligates();
						if(randomCoverage>=bestCoverage && randomNMissing<=bestNMissing && nRandomlyPicked==nPanel &&   randomScore>optimizedScore 
//								&& randomNecessaryNotPicked <=optimNecessaryNotPicked 
								&& randomObligates >=optimObligates) {
							int retcode = SolutionTracker.updateTmpScore(binsToPick,bestSolution);
							nBetterSolutions++;
							if(retcode==1) {
								System.out.println("Random score=" + randomScore);
								System.out.println("Random nsnps=" +nRandomlyPicked);
								System.out.println("Random Coverage=" +randomCoverage);
								System.out.println("Random Obligates=" +randomObligates);
								System.out.println("Random NMissing=" +randomNMissing);
								
								nOutSolutions++;
								if(randomScore>bestRandomScore) {
									bestRandomScore=randomScore;
									// open new tagSream
									Snp.tmpToSelected();
									String betterFile =splitFile[0]+splitFile[1]+ "_"+Integer.toString(nOutSolutions)+"."+splitFile[2];
									PrintStream betterTagStream=null;
									try {
										betterTagStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(betterFile)));
									} catch (Exception fnfe) { // Should only be FileNotFoundException, but make more general
										fnfe.printStackTrace();
										String sele = fnfe.getMessage();
										System.err.println(sele);
										System.err.flush();
										System.exit(-1);
									}
									Snp.outHeader(betterTagStream);
									Snp.outAll(betterTagStream); // Since one SNP can tag multiple Bins, better to output 1 tag-snp/Snp
									betterTagStream.close();
								}
							}
						}

						randomTagStream.println(Double.toString(randomScore)+","+Integer.toString(nRandomlyPicked)+","+Integer.toString(randomCoverage)+","+Integer.toString(randomNMissing));

					}
					if(bestRandomScore>0.0d) {
						System.out.println("Best random Score =" +bestRandomScore);
					}
					long cpuend_random = System.currentTimeMillis();
					System.out.println("Number of better (coverage and score) =" +nBetterSolutions+ " in "+(cpuend_random-cpustart_random)+" milliseconds");
					randomTagStream.flush();
					randomTagStream.close();
				}
				System.out.flush();
				
				
		}
		
		public static String filenameToFileId(String fname) {
			if(fname==null || fname.length()==0) {
				return "";
			}
			StringBuffer fileid = new StringBuffer(fname.length());
			for(int i=0;i<fname.length();i++) {
				String c = fname.substring(i,i+1);
				int pos = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789._".indexOf(c);
				if(pos>=0) {
					fileid.append(c);
				}
			}
			return fileid.toString();
		}
	
		/**
		 * @return the clusterids
		 */
		public static int[] getClusterids() {
			return SNPPicker.clusterids;
		}
	
		/**
		 * @param clusterids the clusterids to set
		 */
		public static void setClusterids(int[] clusterids) {
			SNPPicker.clusterids = clusterids;
		}
	
		/**
		 * @return the optimal flag
		 */
		public static boolean isOptimal() {
			return optimal;
		}
	
		/**
		 * @return the configFile
		 */
		public static String getConfigFile() {
			return configFile;
		}
	
		/**
		 * @return the obligateExcludeFile
		 */
		public static String getObligateExcludeFile() {
			return obligateExcludeFile;
		}
	
		/**
		 * @return the obligateIncludeFile
		 */
		public static String getObligateIncludeFile() {
			return obligateIncludeFile;
		}
	
		/**
		 * @return the defaultScore
		 */
		public static double getDefaultScore() {
			return defaultScore;
		}
	
		/**
		 * @return the defaultValidationClass
		 */
		public static String getDefaultValidationClass() {
			return defaultValidationClass;
		}
	
		/**
		 * @return the maxCPU
		 */
		public static int getMaxCPU() {
			return maxCPU;
		}
	
		/**
		 * @return the n
		 */
		public static int getN() {
			return N;
		}
	
		/**
		 * @return the nbins
		 */
		public static int getNbins() {
			return nbins;
		}
	
		/**
		 * @return the nclusters
		 */
		public static int getNclusters() {
			return nclusters;
		}
	
		/**
		 * @return the nOPA
		 */
		public static int getNOPA() {
			return nOPA;
		}
	
		/**
		 * @return the nsnp
		 */
		public static int getNsnp() {
			return Nsnp;
		}
	
	
	
		/**
		 * @return the pops
		 */
		public static Population[] getPops() {
			return SNPPicker.pops;
		}
	
		/**
		 * @return the scorefile
		 */
		public static LinkedList<String> getScorefile() {
			return SNPPicker.scorefiles;
		}
	
		/**
		 * @return the tooClose
		 */
		public static int getTooClose() {
			return tooClose;
		}
		public static String checkArg(String s) throws Exception {
			if(s==null || s.startsWith("-")) {
				try {
					Double.parseDouble(s);
				} catch (Exception nfe) {
					throw new Exception("Invalid input format, got a "+(s ==null ? "": s) +" where expected a parameter");
				}
			}
			
			return s;
		}
		private static int checkHeader(String[] sline,int column_index,String column_label) {
			if(sline==null || sline.length==0 || column_label==null || column_label.length()==0) {
				return column_index;
			}
			boolean foundit=false;
			int found_pos=-1;
			for(int i=0;i<sline.length;i++) {
				if(sline[i].equals(column_label)) {
					foundit=true;
					// In case there are multiple columns with the same label
					// favor cases where the column label matches the column_index.
					if(i!=column_index && found_pos==-1) {
						found_pos=i;
					} else if (i==column_index) {
						found_pos=column_index;
					}
				}
			}
			if(!foundit) {
				for(int i=0;i<sline.length;i++) {
					if(sline[i].equalsIgnoreCase(column_label)) {
						foundit=true;
						if(i!=column_index && found_pos==-1) {
							found_pos=column_index;
						} else if (i==column_index) {
							found_pos=column_index;
						}
					}
				}
			}
			if(!foundit) {
				for(int i=0;i<sline.length;i++) {
					if(sline[i].startsWith(column_label)) {
						foundit=true;
						if(i!=column_index && found_pos==-1) {
							found_pos=column_index;
						} else if (i==column_index) {
							found_pos=column_index;
						}
					}
				}
			}
			if(!foundit) {
				for(int i=0;i<sline.length;i++) {
					if(sline[i].toUpperCase().startsWith(column_label.toUpperCase())) {
						foundit=true;
						if(i!=column_index && found_pos==-1) {
							found_pos=column_index;
						} else if (i==column_index) {
							found_pos=column_index;
						}
					}
				}
			}
			if(!foundit) {
				for(int i=0;i<sline.length;i++) {
					if(sline[i].toUpperCase().indexOf(column_label.toUpperCase())>=0) {
						foundit=true;
						if(i!=column_index && found_pos==-1) {
							found_pos=column_index;
						} else if (i==column_index) {
							found_pos=column_index;
						}
					}
				}
			}
			if(foundit) {
				if(found_pos!=column_index) {
					System.err.println("SNPPicker:WARNING: annotation file: Column header in different column("+found_pos+") than configured("+column_index+"):"+column_label);
					System.err.flush();
				}
				return found_pos;
			} else {
				System.err.println("SNPPicker:WARNING: annotation file: Could not find column header "+column_label);
				System.err.flush();
				return -1;
			}
			
			
		}
		
		
		/**
		 * File to load annotation. Should be loaded before loading the bin information, so we can match by name.
		 * 
		 * @param scorefile
		 */
		public static void processScoreFile(String scorefile) {
			BufferedReader in = null;
			Pattern p = Pattern.compile(allelePattern);
			Pattern Syn = Pattern.compile("^SeqNotFound: Merged to (rs[0-9]+)$");
			HashMap<String,Integer> loc2class = ProbabilityFromScore.getLocationClass();
			int iSNPID_COL=SNPID_COL;
			int iDBSNPID_COL=DBSNPID_COL;
			int iGENE_SYMBOL_COL=GENE_SYMBOL_COL;
			int iGENE_ID_COL=GENE_ID_COL;
			int iGENE_SYMBOL_ALT2_COL=GENE_SYMBOL_ALT2_COL;
			int iSEQUENCE_COL=SEQUENCE_COL ;
			int iBUILD_COL=BUILD_COL;
			int iCHR_COL=CHR_COL;
			int iPOS_COL=POS_COL;
			int iSCORE_COL=SCORE_COL;
			int iVALCLASS_COL=VALCLASS_COL;
			int iLOC_TYPE_COL=LOC_TYPE_COL;
			int iLOC_SUBTYPE_COL=LOC_SUBTYPE_COL;
			int nerrors=0; // Do not tolerate parsing errors for non-Illumina format.
			
			
			try {
				File f = new File(scorefile);
				//use buffering, reading one line at a time
				//FileReader always assumes default encoding is OK!
				in = new BufferedReader(new FileReader(f));
				try {	
					String l = null;

//					float s1 = (float) 1.0;
					boolean IlluminaFile = false;
					while (!IlluminaFile && (l = in.readLine()) != null ) {
						if (l.startsWith(HEADER_LINE)) {
							IlluminaFile = true;
							String[] sline = Utils.split(l,',');
							iSNPID_COL = checkHeader(sline,SNPID_COL,SNPID_STRING);
							iDBSNPID_COL = checkHeader(sline,DBSNPID_COL,DBSNPID_STRING);
							iSEQUENCE_COL = checkHeader(sline,SEQUENCE_COL,SEQUENCE_STRING);
							iBUILD_COL = checkHeader(sline,BUILD_COL,BUILD_STRING);
							iCHR_COL = checkHeader(sline,CHR_COL,CHR_STRING);
							iPOS_COL = checkHeader(sline,POS_COL,POS_STRING);
							iSCORE_COL = checkHeader(sline,SCORE_COL,SCORE_STRING);
							iVALCLASS_COL = checkHeader(sline,VALCLASS_COL,VALCLASS_STRING);
							iLOC_TYPE_COL = checkHeader(sline,LOC_TYPE_COL,LOC_TYPE_STRING);
							iLOC_SUBTYPE_COL = checkHeader(sline,LOC_SUBTYPE_COL,LOC_SUBTYPE_STRING);
							iGENE_ID_COL = checkHeader(sline,GENE_ID_COL,GENE_ID_STRING);
							iGENE_SYMBOL_COL = checkHeader(sline,GENE_SYMBOL_COL,GENE_SYMBOL_STRING);
							iGENE_SYMBOL_ALT2_COL = checkHeader(sline,GENE_SYMBOL_ALT2_COL,GENE_SYMBOL_ALT2_STRING);
							if(iGENE_SYMBOL_COL==-1){
								iGENE_SYMBOL_COL = checkHeader(sline,GENE_SYMBOL_ALT_COL,GENE_SYMBOL_ALT_STRING);
								if(iGENE_SYMBOL_COL==-1){
									if(iGENE_SYMBOL_ALT2_COL==-1) {
										System.err.println("SNPPicker:WARNING: annotation file: Could not find any column for Gene Symbol");									
										System.err.flush();
										System.out.flush();
									} else {
										iGENE_SYMBOL_COL = iGENE_SYMBOL_ALT2_COL;
										System.err.println("SNPPicker:WARNING: annotation file: Could not find column header "+GENE_SYMBOL_STRING+", used "+GENE_SYMBOL_ALT2_STRING+" instead");
									}
								} else {
									System.err.println("SNPPicker:WARNING: annotation file: Could not find column header "+GENE_SYMBOL_STRING+", used "+GENE_SYMBOL_ALT_STRING+" instead");
								}
							}
						}
					}
					if (!IlluminaFile) {
						in.close();
						in = null;
						in = new BufferedReader(new FileReader(new File(scorefile))); // Read From Start.
					}
					
					while ((l = in.readLine()) != null) {
	//					System.out.println(l);
						if (!l.startsWith(COMMENT_CHAR)) {
							String[] la = Utils.split(l,',');
							if (IlluminaFile && la!=null && la.length>iPOS_COL) {
	//							System.out.println( la[0] +" : "  + la[1] + " : "  + la[iSCORE_COL]+" : "+la[iCHR_COL]);
	//							System.out.flush();
	 							{
	 								String rssynonym=null;
									String snpid = la[iSNPID_COL];
									snpid= (snpid==null ? "" : snpid.toLowerCase());
									snpid = snpid.trim();
									String chr=null;
									if(iCHR_COL>-1 && la.length>iCHR_COL && la[iCHR_COL].length()>0 ) {
										chr = la[iCHR_COL];
										if(chr!=null && chr.toLowerCase().startsWith("chr")) {
											chr = chr.substring(3);
										}
									}
									String posStr = la[iPOS_COL];
									if(posStr!=null) {
										posStr=posStr.trim();
									}
									int pos=0;
									try {
										pos = Integer.parseInt(la[iPOS_COL]);
									} catch (NumberFormatException ef) {
										nerrors++;
									}
									// Catch the error message from Illumina that maps rsid to another one.
									if(iSEQUENCE_COL>-1 && la.length>iSEQUENCE_COL && la[iSEQUENCE_COL].length()>0) {
										Matcher synMatcher = Syn.matcher(la[iSEQUENCE_COL].trim());
										if(synMatcher.find()) {
											rssynonym = synMatcher.group(1).toLowerCase();
											System.out.println("SNPPicker:processScoreFile: INFO: SNP "+snpid+" is redirected to a synonym "+rssynonym);
											Snp s = Snp.getSnpByName(snpid);
											if(s!=null) {
													Snp.addSnpNameSynonym(s,rssynonym);
													s.setDbsnpid(rssynonym);
											} else {
												s = Snp.getSnpByName(rssynonym);
												if(s!=null) {
													Snp.addSnpNameSynonym(s,snpid);
													s.setDbsnpid(rssynonym);
												}
											}
											if(s==null) {
												s =new Snp(-1,rssynonym,-1);
												s.setDbsnpid(rssynonym);
												Snp.addSnpNameSynonym(s,snpid);
											}
										}
									}
									
	//								System.out.println("About to filter by Chrom for chr="+chr+", and chromosome="+SNPPicker.chromosome);
	//								System.out.flush();
									// Filter by Chromosome if annot present and if filter/default is set.
									if(rssynonym==null && ((SNPPicker.obligateIncludeFile!=null || SNPPicker.obligateIncludeNGFile!=null)  || SNPPicker.chromosome==null || chr==null || chr.length()==0 || SNPPicker.chromosome.length()==0 || chr.equalsIgnoreCase(SNPPicker.chromosome) )) {
										Snp s = Snp.getSnpByName(snpid);
										if(s==null) {
											if(pos>0) {
												s = Snp.getSnpByPos(pos, chr);
												if(s!=null) { // potential name/position conflict.
													String currentName = s.getSnpName();
													String pos_chr = s.getChromosome();
													if(pos_chr!=null && pos_chr.length()>0) {
														if(chr!=null && chr.length()>0) {
															if(pos_chr.equalsIgnoreCase(chr)) {
																if(idLooksLikePos(snpid,pos,10) && !idLooksLikePos(currentName,pos,10)) {
																	// keep current name.
																} else if ((!idLooksLikePos(snpid,pos,10)) && idLooksLikePos(currentName,pos,10)) {
																	s.setSnpName(snpid);
																} else if (!(idLooksLikePos(snpid,pos,10) || idLooksLikePos(currentName,pos,10))) {
																	if(snpid.toLowerCase().startsWith("rs") && ! currentName.toLowerCase().startsWith("rs")) {// new one is better.
																		s.setSnpName(snpid);
																		Snp.addSnpNameSynonym(s,currentName);
																	} else {// don't overwrite current name unless new one is an rsid.
																		Snp.addSnpNameSynonym(s,snpid);
																	}
																}
															}
														}
													}
												}//s!=null
											} // pos>=0 (Illumina sets unknown pos to -99)
											if(s==null && snpid!=null) {
												// new SNP
												s=new Snp(-1,snpid,-1);
											}
										} else { // previously loaded, check for position conflict.
											String old_chr = s.getChromosome();
											int oldpos=s.getPosition();
											String old_pos = String.valueOf(oldpos);
											if(old_chr==null || (!old_pos.equals(posStr)) || !old_chr.equals(chr)) {
												if(old_chr!=null && old_chr.length()>0 && chr!=null && chr.length()>0 && (!old_chr.equals(chr)) ) {
													System.err.println("SNPPicker: WARNING: processScoreFile: Snp "+snpid+" was previously loaded but has two different chromosome (will keep first instance)!: old_chrom = "+old_chr+", new_chrom = "+chr);
													continue; // Skip this SNP
												}
												// Different positions, but same name..
												if(Utils.isAPosNumberGTZero(posStr)) {
													int newpos = Integer.valueOf(posStr);
													if(Math.abs(newpos-s.getPosition())<2) { // that happens a lot...
														System.err.println("SNPPicker: processScoreFile: SNP loaded twice with no chromosome, but very slightly off positions (old pos="+s.getPosition()+", new pos="+posStr +") for "+snpid+" -- will keep first position ");
														pos=oldpos;
													} else {
														if(old_chr !=null && chr!=null && old_chr.length()>0 && chr.length()>0) {
														// Two different chromosome and two different locations
														// Since we are loading the annotation first, we will skip the second version.
															if(oldpos>0) {
																System.err.println("SNPPicker: WARNING: processScoreFile: SNP loaded twice but very different positions (keeping old pos)for "+snpid+" (old pos="+s.getPosition()+", new pos="+posStr+") on chromosome="+chr);
																pos=oldpos;
															} else {
																// nothing to do.. later code will automatically take new position.
																// s.setPosition(newpos);
															}
														} else {
															if((old_chr==null || old_chr.length()==0) && chr!=null && chr.length()>0) {
																// nothing to do.. later code will automatically take new position.
															} else if ((old_chr!=null && old_chr.length()>0) && (chr==null || chr.length()==0)) {
																chr = old_chr;
																if(oldpos>0) {
																	pos = oldpos; // keep old one
																}
															} else {
																// Both Chromosome locations are null.. so
																// take default chromosome location.. (will happen down below).
																System.err.println("SNPPicker: processScoreFile: SNP loaded twice with no chromosome, but very different positions for "+snpid+" -- will assign default chromosome and keep latest position ");
																if(SNPPicker.chromosome==null || SNPPicker.chromosome.length()==0) {
																	pos=oldpos;// Skip this SNP-- keep first position.
																}
															}
														}
													}
												}
												
											}
											
										} // s==null .. else
	//									System.out.println("About to Read annot for "+snpid+", snp="+s);
	//									System.out.flush();
										if(s!=null) {
											// Make this robust against multiple instances of annotation for a SNP
											// with some having no annotation.
	
											double sco = s.getScore();
											if(la[iSCORE_COL]!=null) {
												String scoreString = la[iSCORE_COL];
												// only take score if old one was a default score.
												if ((sco== SNPPicker.defaultScore) && scoreString.equalsIgnoreCase(BADSCORE)) {
													sco=-99;
												} else if((sco == SNPPicker.defaultScore)&& (scoreString.length() ==0 || scoreString.equalsIgnoreCase(UNKNOWNSCORE) )) {
													sco = SNPPicker.defaultScore;
												} else {
														try {
															if(la[iSCORE_COL].length()!=0) {
																sco = Double.parseDouble(la[iSCORE_COL]);
															}
														} catch (NumberFormatException ex) {
															nerrors++;
															ex.printStackTrace();
															System.err.println("SNPPicker:WARNING: parsing Error for score for line :"+ l+" while reading score file -- using default");
															System.err.flush();
															sco = SNPPicker.defaultScore;
														}
												}
											}
											s.setScore(sco);
											String sequence = "";
											String allele=s.getAlleles();
											if(iSEQUENCE_COL>-1 && la.length>iSEQUENCE_COL && la[iSEQUENCE_COL].length()>0) {
												sequence =la[iSEQUENCE_COL];
												Matcher alMatcher = p.matcher(sequence);
												if(alMatcher.find()) {
													allele = alMatcher.group(1);
													s.setAlleles(allele);
												}
											}
											
											
											if(chr==null || chr.length()==0) {
												chr = s.getChromosome();
												if(chr==null || chr.length()==0) {
													chr=SNPPicker.chromosome;
												}
											}
	
											String location = s.getLocation();
											if(location!=null) {
												location = location.toLowerCase();
											}
											if (iLOC_TYPE_COL!=-1 && (la.length > iLOC_TYPE_COL) && (la[iLOC_TYPE_COL].length()>0) && (!NULLLOC.equals(la[iLOC_TYPE_COL]))) {
												location = la[iLOC_TYPE_COL].toLowerCase();
												if ("coding".equals(location)) {
													if (iLOC_SUBTYPE_COL>=0 && (la.length > iLOC_SUBTYPE_COL) && (la[iLOC_SUBTYPE_COL].length()>0) && (!NULLLOC.equals(la[iLOC_SUBTYPE_COL]))) {
														String syntype = la[iLOC_SUBTYPE_COL].toLowerCase(); // e.g. SYNON vs NONSYN
														if(syntype!=null && syntype.length()>0) {
															location = location + "-" + syntype;
														}
													}
												}
											}
											String gene_symbol=s.getGene();
											if(iGENE_SYMBOL_COL!=-1 && la.length>iGENE_SYMBOL_COL && la[iGENE_SYMBOL_COL].length()>0 && !"-99".equals(la[iGENE_SYMBOL_COL])) {
												gene_symbol = la[iGENE_SYMBOL_COL];
											}
											if(("unknown".equalsIgnoreCase(gene_symbol) ||  "-99".equalsIgnoreCase(gene_symbol) || gene_symbol == null || gene_symbol.length()==0)&& (la.length>iGENE_SYMBOL_ALT2_COL) && (la[iGENE_SYMBOL_ALT2_COL].length()>0) && !"-99".equals(la[iGENE_SYMBOL_ALT2_COL])) {
												gene_symbol = la[iGENE_SYMBOL_ALT2_COL];
											}
											s.setGene(gene_symbol);
											String gene_id = s.getGene();
											if(iGENE_ID_COL!=-1 && la.length>iGENE_ID_COL && la[iGENE_ID_COL].length()>0 && !"-99".equals(la[iGENE_ID_COL])) {
												gene_id = la[iGENE_ID_COL];
											}
											s.setGeneId(gene_id);
											Gene.put(gene_symbol, gene_id);
											
											if(gene_id!=null && gene_id.length()>0 && gene_symbol!=null && gene_symbol.length()>0) {
												SNPPicker.GENE2GENEID.put(gene_symbol, gene_id);
												SNPPicker.GENEID2GENE.put(gene_id, gene_symbol);
											}
											
											String val_class = s.getValidationClass();
											if(iVALCLASS_COL>-1 && la.length>iVALCLASS_COL && la[iVALCLASS_COL].length()>0 && !"-99".equals(la[iVALCLASS_COL])) {
												val_class =la[iVALCLASS_COL];// higher is better
											}
											String build = s.getBuild();
											if(la.length>iBUILD_COL && iBUILD_COL!=-1 && la[iBUILD_COL].length()>0 && !"-99".equals(la[iBUILD_COL])) {
												build=la[iBUILD_COL];
											}
											// Mark this SNP as excluded if Score is below mininum.
											//System.out.println(snpid +" position="+pos);
											Snp.addScore(snpid.toLowerCase(), sco); // Only Add Score if snp exists
	
											s.setChromosome(chr);
											s.setPosition(pos);
											s.setLocation(location);
											try {
												int vc_val = Integer.parseInt(val_class);
												if(vc_val>5) {
													val_class="5";
													System.err.println("SNPPicker: WARNING: New validation class>5! for SNP at chrom="+chr+", pos="+pos+" please notify authors. Setting val class to 5");
												}
											} catch (Exception nfe) {
												nerrors++;
												nfe=null;
											}
											if(ProbabilityFromScore.validateValidationClass(val_class)) {
												s.setValidationClass(val_class);
											}
											Integer ilc = (Integer)loc2class.get(location);
											if(ilc!=null) {
												s.setLocation_class(ilc.intValue());
											}
											
											
											s.setBuild(build);
											String dbsnpid = la[iDBSNPID_COL];
											if(dbsnpid!=null && dbsnpid.toLowerCase().startsWith("rs") && dbsnpid.length()>2) {
												try {
													Integer.parseInt(dbsnpid.substring(2));
													s.setDbsnpid(dbsnpid.toLowerCase());// looks like a dbsnpid.									
												} catch (Exception e) {
													e=null;// Just validating the dbsnpid format
												}
											}
										} //s!=null
									} //rssynonym==null
								} // passHeader
							}else {
									// not an illumina file.
									if (la!=null && la.length >=2) {
										try {
											float sco = Float.parseFloat(la[1]);
											Snp s = Snp.getSnpByName(la[0].toLowerCase());
											if(s==null) {// add all SNPs
												s=new Snp(-1,la[0].toLowerCase(),-1); 
											}
											Snp.addScore(la[0].toLowerCase(), sco); // Only Add Score if snp exists
											if(la.length >=3 ) {
												s.setPosition(Integer.parseInt(la[2]));
											}
											if(la.length>=4) {
												s.setChromosome(la[3]);
											}
											if(la.length>=5) {
												s.setLocation(la[4]);
											}
											if(la.length>=6) {
												s.setValidationClass(la[5]);
											}

										} catch (NumberFormatException ex) {
											nerrors++;
											ex.printStackTrace();
											System.err.println("SNPPicker:WARNING: format conversion error for line :"+ l+" while reading genetic score file -- skipping line");
											System.err.flush();
											throw new Exception("Parsing exceptions not tolerated for user 3-6-columns format "+scorefile);
										}
									}
							}
						} // if not start comment
					} // while
				} catch (Exception e) {
					e.printStackTrace();
					System.err.println("SNPPicker:"+e.getMessage());
					System.err.println("SNPPicker:ERROR: IO Exception while reading scorefile: " + scorefile);
					System.err.flush();
					try {
						if (in != null) {
							//flush and close both "input" and its underlying FileReader
							in.close();
						}
					} catch (IOException e2) {
						e2.printStackTrace();
					}
					System.out.flush();
					System.err.flush();
					System.exit(-1);
				}
			} catch (Exception ex) {
				System.err.println(ex.getMessage());
				ex.printStackTrace();
				try {
					if (in != null) {
						//flush and close both "input" and its underlying FileReader
						in.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
				System.err.println("SNPPicker:ERROR: File Not Found Exception while reading scorefile: " + scorefile);
				System.err.flush();
				System.out.flush();
				System.exit(-1);
			}
			try {
				if (in != null) {
					//flush and close both "input" and its underlying FileReader
					in.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		}
		
		private static int obligate_fileid=0;
		private static void processObligateInclude(String obligateIncludeFile,boolean notToBeGenotyped) throws Exception {
			obligate_fileid++;
			//String obligate_fileid_str = Integer.toString(obligate_fileid);
			//int obligate_bin=0; // need to create fake bins for obligates.
			
			BufferedReader in = null;
			File f = new File(obligateIncludeFile);
		
			//use buffering, reading one line at a time
			//FileReader always assumes default encoding is OK!
			in = new BufferedReader(new FileReader(f));
			String l = null;

			while ((l = in.readLine()) != null) {
				if (!l.startsWith("#")) {
					String[] line = Utils.split(l,',');
					String sid=line[0];
					if(sid!=null) {
						sid = sid.trim();
						sid = sid.toLowerCase();
					}
					Snp s = Snp.getSnpByName(sid);
					if(s==null) {
						s= Snp.getSnpByDbsnpid(sid);
					}
					if(s!=null) {
						if(s.isExcluded())  {
							if(!s.isFixed()) {
								System.err.println("SNPPicker:ERROR: "+sid+" was specified as both obligate and excluded in input files; remove it from one of the files\n");
								System.err.flush();
								System.out.flush();
								in.close();
								System.exit(-1);
							} else {
								if(SNPPicker.minScore!=-99.0 && s.getScore()<SNPPicker.minScore) {
									if(s.getScore()==-99.0) {
										System.err.println("SNPPicker:WARNING: "+sid+" is obligate, but has been excluded because Illumina score is -99 and the user specified a minimum score of "+SNPPicker.minScore);		
									} else {
										System.err.println("SNPPicker:WARNING: "+sid+" is obligate, but has been excluded by user-specified criteria - score ("+s.getScore()+"<"+SNPPicker.minScore+")");
									}
								} else {
									System.err.println("SNPPicker:WARNING: "+sid+" is obligate, but has been excluded by some user-specified criteria(not score)");	
								}
								System.err.flush();
								s.setObligate(true);
								s.setSelected(false, true); // unselected
								s.setExcluded(true);
								s.setFixed(true);
							}
						} else { // !s.isExcluded()
							s.setObligate(true); // also sets the selected flag and the selectedSnpIds arrays.
							if(s.getNbins()==0 && !notToBeGenotyped) {
								Population obligPop=Population.getPopByName("obligate");
								if(obligPop==null) {
									obligPop = new Population("obligate");
								}
								int obligPopId = obligPop.getId();
								SNPPicker.obligates_cnt++;
								String binname = "obligate-1:" +String.valueOf(SNPPicker.obligates_cnt);
								Snp.addSnpEdge(s.getSnpName(), binname, obligPopId);
							}
							
							
							if(SNPPicker.minScore==-99 || s.getScore()>=SNPPicker.minScore) {
								s.setSelected(true,true); // set SNP and bin to true;
								// If the obligate is later found to be too close to other SNPs
								// a fake bin will get added in main() of SNPPicker.
							} else { // obligate with score below threshold.
								s.setExcluded(true);
								s.setFixed(true);
							}
						}
					} else { // s==null
						s = new Snp(-1,sid.toLowerCase(),-1);
						System.err.println("SNPPicker:WARNING: "+sid+" is obligate, but is not in the annotation input file or genotype files\n");
						System.err.flush();
						if(sid.toLowerCase().startsWith("rs")) {
							s.setDbsnpid(sid.toLowerCase());
						} else {
							try{
								int pos = Integer.parseInt(sid);
								if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
									s.setChromosome(SNPPicker.chromosome);
								}
								s.setPosition(pos);
							} catch (Exception e) {	
							}
						}
						if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
							s.setChromosome(SNPPicker.chromosome);
						}
						s.setScore(SNPPicker.defaultScore);
						SNPPicker.obligates_cnt++;
						// Score doesn't matter if SNP was genotyped on another platform.
						if((!notToBeGenotyped) && SNPPicker.minScore!=-99 && s.getScore()<SNPPicker.minScore) {
							System.err.println("SNPPicker:WARNING: "+sid+" is obligate, but has been excluded by score criteria because no score was provided (default score is "+SNPPicker.defaultScore+") ("+s.getScore()+"<"+SNPPicker.minScore+")");
							s.setObligate(true);
							s.setSelected(false, true);
							s.setExcluded(true);
							s.setFixed(true);
						} else {
							s.setObligateButNotGenotyped(notToBeGenotyped);
							s.setObligate(true); // Must Happen before selecting or adding edge
							
							if(!notToBeGenotyped) {
								Population obligPop=Population.getPopByName("OBLIGATE");
								if(obligPop==null) {
									obligPop = new Population("OBLIGATE");
								}
								int obligPopId = obligPop.getId();
							
								String binname = "obligate-1:" +String.valueOf(SNPPicker.obligates_cnt);
								Snp.addSnpEdge(s.getSnpName(), binname, obligPopId);
							}
							s.setSelected(true, true);
						}
					}
					if(s!=null) {
						s.setObligateButNotGenotyped(notToBeGenotyped);
					}
				}
			}
			in.close();
		}
		
		private static void processObligateExclude(String obligateExcludeFile) throws Exception {
			BufferedReader in = null;
			File f = new File(obligateExcludeFile);
	
			//use buffering, reading one line at a time
			//FileReader always assumes default encoding is OK!
			in = new BufferedReader(new FileReader(f));
			String l = null;

			while ((l = in.readLine()) != null) {
				if (!l.startsWith("#")) {
					String[] line = Utils.split(l,',');
					String sid=line[0];
					sid = (sid==null ? "" : sid.toLowerCase());
					Snp s = Snp.getSnpByName(sid);
					if(s==null) {
						s= Snp.getSnpByDbsnpid(sid);
					}
					if(s!=null) {
						if(s.isObligate() && !s.isExcluded()) {
							throw new Exception("SNPPicker:ERROR"+sid+" set to Obligate but is both obligate and excluded: "+sid);
						} else {
							s.setExcluded(true);
						}
					}  else {
						System.err.println("SNPPicker:WARNING: "+sid+" is obligate-exclude, but is not in the annotation input file \n");
						System.err.flush();
	
						s = new Snp(-1,sid,-1);
						s.setExcluded(true);
						if(sid!=null && sid.toLowerCase().startsWith("rs")) {
							s.setDbsnpid(sid);
						} else if(sid!=null) {
							try{
								int pos = Integer.parseInt(sid);
								if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
									s.setChromosome(SNPPicker.chromosome);
								}
								s.setPosition(pos);
							} catch (Exception e) {
								
							}
							
						}
						if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
							s.setChromosome(SNPPicker.chromosome);
						}
						s.setScore(-1.0);
					}
				}
			}
			in.close();
		}
		
		/**
		 * Create rules for the Number of Snps per Bin (N S B)
		 * @param NSBRules
		 */
		public static void processNSBRules(String NSBRules) {

			String rangeStr= "-";
			Pattern rangePat = Pattern.compile(rangeStr);
			String[] rangeRules = Utils.split(NSBRules,',');
			int[] lowerLim = new int[rangeRules.length];
			int[] upperLim = new int[rangeRules.length];
			int[] nsbLim= new int[rangeRules.length];
			//format is 1-10=2
			for(int i=0;i<rangeRules.length;i++) {
				String s = rangeRules[i];
				String[] rulePair = Utils.split(s,'=');
				if(rulePair.length!=2) {
					System.err.println("SNPPicker.ProcessNSBRules: Invalid format for rule: need 1-4=1,5-Inf=2");
					
				}
				String[] rangePair = rangePat.split(rulePair[0]);
				lowerLim[i]=intFromStr(rangePair[0]);
				if(rangePair.length==2) {
					upperLim[i]=intFromStr(rangePair[1]);
				} else {
					upperLim[i]=lowerLim[i];
				}
				nsbLim[i]=intFromStr(rulePair[1]);
		//		if(SNPPicker.verbose) {
					System.out.println("SNPPicker:INFO: rules: "+lowerLim[i]+"-"+upperLim[i]+"==>"+nsbLim[i]+" tags");
		//		}
			}
			int nbins = Bin.getNbins();
			for (int binid=1;binid<=nbins;binid++) {
				Bin b = Bin.getBinById(binid);
				if(b!=null) {
					int nSites = b.getNSites();
					boolean overrule=false;
					if(SNPPicker.obligateIncludeNGFileOverRule) {
						// XXX - This piece of code won't be useful as
						// setNSB is called before obligates are loaded.
						// obligates already genotyped make a bin 100% covered.
						Snp[] snps = b.getSnps();
						if(snps!=null) {
							for(int i=0;i<snps.length;i++) {
								Snp s = snps[i];
								if(s!=null && s.isObligateButNotGenotyped()) {
									overrule=true;
								}
							}
						}
					}
					if(overrule) {
						b.setNSB(1); // 
					} else {
						int nsb=1;
						for(int k=0;k<rangeRules.length;k++) {
							if(nSites>=lowerLim[k] && nSites<=upperLim[k]) {
								nsb=nsbLim[k];
								k=rangeRules.length-1;
							}
						}
						if(SNPPicker.verbose) {
							String bname = b.getName();
							System.out.println("SNPPicker:INFO: bin "+bname+", sites="+nSites+" ==> needs "+nsb+" tag SNPs");
						}
						int ntags = b.getNsnps();
						if(nsb<ntags) {
							b.setNSB(nsb);
						} else {
							b.setNSB(ntags);
						}
					}
					if(nSites<SNPPicker.minBin) {
						b.setNSB(0);
					}
				}
			}
		}
		
		private static int intFromStr(String val) {
			if(val==null || val.length()==0) {
				return 0;
			} else if ("Inf".equalsIgnoreCase(val)) {
				return Integer.MAX_VALUE;
			} else {
				try {
					return Integer.parseInt(val);
				} catch(Exception e) {
					e.printStackTrace();
					System.out.println(e.getMessage());System.out.flush();
					return -1;
				} 
			}
		}
	
		public static double getRiskFactor() {
			return riskFactor;
		}
	
		public static void setRiskFactor(double riskFactor) {
			SNPPicker.riskFactor = riskFactor;
		}
	
		public static boolean isGreedy() {
			return greedy;
		}
	
		public static void setGreedy(boolean greedy) {
			SNPPicker.greedy = greedy;
		}
	
		
		public static boolean readLDSelectTagzilla(Population t_pop,String fname,String fileid,boolean tagzilla,String mapFilename) throws Exception {
			int popid = t_pop.getId();
			String popname = t_pop.getName();
			
			HashMap<String,String> pos2rs = new HashMap<String,String>();
			String thisFileChr=null;
			try {
				BufferedReader in=null;
				BufferedReader mapin=null;
	
				String f2open=fname;
				try {
					in = t_pop.getBufferedReader(fname);
					System.out.println("SNPPicker:readLDSelectTagzilla reading bin file "+f2open);
				} catch (Exception e) {
						System.err.println(e.getMessage());
						System.err.println("SNPPicker:ERROR: error opening bin file "+f2open);
						System.err.flush();
						System.out.flush();
						System.exit(-1);
				}
				String geneId="";
				String source="";
				try {
					if(mapFilename!=null && mapFilename.length()>0) {
						File f = new File(mapFilename);
						if(f.exists()) {
							System.out.println(mapFilename + " exists");
							mapin =  new BufferedReader( new FileReader(f) );
							String line = null;
							while((line = mapin.readLine())!=null) {
								String[] aline = Utils.split(line,'\t');
								int rsindex=-1;
								int posindex=-1;
								int pos=-1;
								for(int i=0;i<aline.length;i++) {
									String test = aline[i];
									if(test!=null && test.length()>0) {
										if(test.startsWith("rs") || test.startsWith("RS") || test.startsWith("Rs") || test.startsWith("rS")) {
											rsindex=i;
										} else if (posindex==-1) {
											try {
												pos = Integer.parseInt(test);
												posindex=i;
											} catch (NumberFormatException ef) {
												pos=pos; // do nothing -- a possible breakpoint.
											}
										}
									}
								}
								if(posindex>=0) {
									String rsid=null;
									if(rsindex==-1) {// no "rs"-type string
										String id_rs_string =null;
										if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
											Snp s = Snp.getSnpByPos(pos, SNPPicker.chromosome);
											if(s!=null) {
												String rs = s.getSnpName();
												if(rs!=null && rs.length()>0 && rs.startsWith("rs")) {
													id_rs_string = rs.substring(2);
													try {
														int id_rs = Integer.parseInt(id_rs_string);
														rsid = rs;
													} catch (Exception nfe) {
														rsid=rsid; // stop for debugger
													}
												}
											}
										}
										if(rsid==null) {
											for(int i=0;i<aline.length && rsindex==-1;i++) {
												if(i!=posindex) {
													if(aline[i].length()>0) {
														rsindex=i;
														rsid = aline[i];
													}
												}
											}
										}
										if(rsid==null) {
											rsid = id_rs_string; // Take Any name if no rs or no name from file.
										}
									} else { //rsindex>=0
										rsid = aline[rsindex];
										if(rsid.toLowerCase().equals("rs1800745") || pos==22733170) {
											pos+=(1-1);
										}
										Snp s = Snp.getSnpByName(rsid);
										if(s!=null) { //already loaded
											if(s.getPosition()!=pos) {
												if(pos<0) {
													// Error position in result file.
													throw new java.lang.Error("SNPPicker: Error loading "+mapFilename+", for snp "+rsid+", conflicting snp position : old =" + s.getPosition()+", in this file ="+pos);
													// pos=s.getPosition(); 
												}  else if (s.getPosition()==-99) {// position from annotation was missing
													s.setPosition(pos); // update position
												} else {
													System.err.println("SNPPicker: SEVERE WARNING: Error loading "+mapFilename+", for snp "+rsid+", conflicting snp position : old =" + s.getPosition()+", in this file ="+pos);
													System.err.flush();
													s.setPosition(pos); // Since the file has the data, must match by data position not annotation position.
																		// XXX Only Problem is if two data files have different positions.
													
												}
											}
										}
										if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0 && pos >0) {
											Snp s2=Snp.getSnpByPos(pos, SNPPicker.chromosome);
											if(s2!=null) {
												if(s2.getDbsnpid()!=null && !s2.getDbsnpid().equals(rsid.toLowerCase())) {
													System.err.println("SNPPicker: SEVERE WARNING: During loading of "+mapFilename+", for snp "+rsid+", conflicting snp names for SNP already loaded (from data or annotation)at same position : old =" + s2.getDbsnpid()+", in this file ="+rsid);
													if(s!=null && s2!=s && (s.getChromosome()==s2.getChromosome() || (s.getChromosome().equals("-99") || s2.getChromosome().equals("-99")))) {
														// Two different Snp Object with the same position .. 
														// so take the data name and position.
														if(s.getNbins()>0 && s2.getNbins()==0) {
															Snp.deleteByName(s2.getSnpName(), true);
															s2=s;
														} else if (s2.getNbins()>=0 && s.getNbins()==0) {
															Snp.deleteByName(s.getSnpName(), true);
														}	else {
															throw new Exception("SNPPicker: ERROR: Two snps with same position, both have results: "+s.getSnpName()+","+s2.getSnpName()+" at pos "+pos+" on chromosome "+s.getChromosome());
														}
													}
													if(s2.getNbins()>0) {
														Snp.addSnpNameSynonym(s2, rsid);
													} else {
														s2.setDbsnpid(rsid);// Set to that of file .. since the genotypes will have that dbSNP id.
														s2.setSnpName(rsid);
													}
												}
											}
										}
									}
									if(rsid!=null) {
										pos2rs.put(aline[posindex],rsid);
									}
								}
							}
							mapin.close();
							// SNPApp Mayo format, try to get source and geneid
							String[] unixArray = Utils.split(mapFilename,'/');
							String[] windowsArray = Utils.splitRegexp(mapFilename,"\\\\");
							//System.out.println("unixArray.length "+unixArray.length+", windowsArray.length="+windowsArray.length);
							//System.out.flush();
							if(unixArray.length>windowsArray.length) {
								if(unixArray.length>2) {
									geneId =unixArray[unixArray.length-2];
									source =unixArray[unixArray.length-3];
								}
							} else {
								if(windowsArray.length>2) {
									geneId=windowsArray[windowsArray.length-2];
									source =windowsArray[windowsArray.length-3];
								}
							}
							
					 } else {
							System.out.println("SNPPicker:INFO: " +mapFilename + " does not exists");
						}
					}
				} catch (Exception e) {
						System.err.println(e.getMessage());
						System.err.println("SNPPicker:ERROR: error opening file "+mapFilename);
						System.err.flush();
						System.out.flush();
						throw(e);
				}
				
				
				String l = null;
				String sitePatternStr = "^Bin ([0-9]+)[\\t, ]+.*sites: ([0-9]+).*$";
				Pattern sitePattern = Pattern.compile(sitePatternStr);
		
				String patternStr = "^Bin ([0-9]+)[\\t, ]+TagSnps: (.*)$";
				String otherSnpsStr = "^Bin ([0-9]+)[\\t, ]+other_snps: (.*)$";
				
				Pattern tagsnpPat = Pattern.compile(patternStr);
				Pattern otherSnpsPat = Pattern.compile(otherSnpsStr);
				int nsites=0;
	
				Pattern idsPat = Pattern.compile("[ ]+");
				while ((l = in.readLine()) != null) {
					Matcher siteMatcher = sitePattern.matcher(l);
					if(siteMatcher.find()) {
						String nsitesStr = siteMatcher.group(2);
						nsites = Integer.parseInt(nsitesStr);
					} else {
						Matcher matcher = tagsnpPat.matcher(l);
						Matcher otherMatcher = otherSnpsPat.matcher(l);
						boolean findTag = matcher.find();
						boolean findOther = otherMatcher.find();
						if (findTag || findOther) { // Ignore all other lines
							String[] tags = null;
							if(findTag) {
								tags=Utils.splitPattern(matcher.group(2),idsPat);
							} else {
								tags=Utils.splitPattern(otherMatcher.group(2),idsPat);
							}
							String prefix = popname + "-" + fileid+":";
							String filebinname =null;
							if(findTag) {
								filebinname =matcher.group(1);
							} else {
								filebinname = otherMatcher.group(1);
							}
							String binname = prefix+filebinname;
							String[] snpNames = null;
							String[] locations = null;
							int[] positions =null;
							int binid=-1;
							if(tagzilla) {
								snpNames=tags; // tagzilla takes rsids as names.
							} else {
								// for ld-select have to parse position out of Snp
								snpNames = new String[tags.length];
								locations = new String[tags.length];
								positions = new int[tags.length];
								for (int j = 0; j < tags.length; j++) {
									snpNames[j]=null;
									locations[j]=null;
									if (tags[j].length() > 0 && !tags[j].equals(" ")) {
										// Break the tag name = position-code
										String[] nameList = Utils.split(tags[j],'-');
										String posStr = nameList[nameList.length-1];
										int position=-1;
										Snp s=null;
										try {
											position = Integer.parseInt(posStr);
											if(pos2rs.containsKey(posStr)) { // use Map rsid or other Text Identifier
												snpNames[j] = (String) pos2rs.get(posStr);
												if(snpNames[j]!=null) {
													snpNames[j]=snpNames[j].toLowerCase();
													// this will only work if SNP was previously loaded and name set.
													s = Snp.getSnpByName(snpNames[j]);
													// Define File Level Chromosome
													if(s!=null && (thisFileChr==null || thisFileChr.length()==0)) {
														thisFileChr = s.getChromosome();
														if(thisFileChr!=null && thisFileChr.length()>0 && SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0 && !thisFileChr.equalsIgnoreCase(SNPPicker.chromosome)) {
															System.err.println("SNPPicker:readLDSelectTagzilla: WARNING : SNP("+s.getSnpName()+"),pos="+position+", chromosome annotation ("+thisFileChr+") differs than user-supplied chromosome ("+SNPPicker.chromosome+")");
														}
													}
												}
											}
											if(s==null) { // new SNP  with pos2rs or SNP without pos2rs
												if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
													s = Snp.getSnpByPos(position,SNPPicker.chromosome);											
												} else if(thisFileChr!=null && thisFileChr.length()>0) {
													s = Snp.getSnpByPos(position,thisFileChr);
												}
												if(s!=null) {// old SNP but without pos2rs 
													         // OR new SNP with a position-based match but without a name match.
													if(snpNames[j]!=null && snpNames[j].length()>0) {
														snpNames[j]=snpNames[j].toLowerCase();
														// new SNP with a position-based match but without a name match.
														// Check if there is a name conflict. If the old SNP
														// was merely without a name then assign the name by position.
														if(thisFileChr==null || thisFileChr.length()==0) {
															// chromosome and position match ==> synonym.
															Snp.addSnpNameSynonym(s,snpNames[j]);
														} else {
															// position match only (no Chromosome info).
															String oldSnpName = s.getSnpName().toLowerCase();
															String newSnpName = snpNames[j].toLowerCase();
															if(oldSnpName.startsWith("rs") && newSnpName.startsWith("rs")) {
																if(!oldSnpName.equals(newSnpName)) {
																	// I am going to assume that it is much more likely to have
																	// different rsids for the same SNP than to have 2 SNPs on
																	// different chromosomes with the same basepair position.
																	System.err.println("SNPPicker:readLDSelectTagzilla: WARNING: SNP has/appears to have two rsid ("+oldSnpName+","+newSnpName+"), pos ="+position+", in file "+fname+", in chromosome "+s.getChromosome());
																	// Switch to genotype ma,e/
																	s.setDbsnpid(newSnpName);
																	s.setSnpName(newSnpName);
																	Snp.addSnpNameSynonym(s,oldSnpName);
																}
															} else if((!oldSnpName.startsWith("rs")) && newSnpName.startsWith("rs")) {
																s.setDbsnpid(newSnpName);
																s.setSnpName(newSnpName);
																Snp.addSnpNameSynonym(s,oldSnpName);
															}
														}
													}// snpNames[j]!=null
												}//s!=null
												s=null;
											}
										} catch (NumberFormatException e) {
											System.err.println("SNPPicker:ERROR: Invalid position line:"+l+" in ldselect file "+fname+"\n");
											System.err.flush();
											System.out.flush();
											System.exit(-1);
										}
										String snpName=null;
										if(s!=null) {//already loaded SNP and assigned it a name.
											snpName=s.getSnpName();
											positions[j]=s.getPosition(); // reload common position to avoid data-source dependent position shifts.
										} else { // existing SNP - no pos2rs; new SNP - with or without pos2rs
											if(snpNames[j]==null || snpNames[j].length()==0) { // no pos2rs
												snpName = posStr; // ==> snp name will be position 
											} else { // new SNP with pos2rs
												snpName = snpNames[j]; // if snpNames[j]!=null ==> this SNP name can retrieve a SNP.
											}
											positions[j]=position;
										}
										snpNames[j]=snpName;
										if(nameList.length==2) {// format ??-position
											String location = (String)ldsLoc2Loc.get(nameList[0]);
											locations[j]=location;
										} else {
											locations[j]=null;
										}
									} else {
										snpNames[j]=null;
										locations[j]=null;
										positions[j]=-1;
									}
								} //for
							}
							
							// Check if any SNPs in that bin are already part of another bin for this population.
							int currpopid=popid;
							Bin b = Bin.getNonCollidingBin(binname,snpNames,findTag,popid,fileid,filebinname,geneId,source,true);
								
							if(b!=null) {
								binid = b.getId();
								currpopid =b.getPopid();
								binname = b.getName();
							}							
							
							
							if(snpNames!=null && snpNames.length>0) {

								String firstSnpName=null;
								for (int j = 0; j < snpNames.length; j++) {
									if (snpNames[j]!=null && snpNames[j].length() > 0) {
										snpNames[j]=snpNames[j].toLowerCase();
										if(firstSnpName==null) {
											firstSnpName=snpNames[j];
										}
										// add Snp and bin for pop "i+1"
										// Snp method will take care of creating bins and binedges and clustering
										Snp s = null;
										boolean snpIsNew=false;
										if(findTag) {
											s = Snp.getSnpByName(snpNames[j]);
											// We're trying to find any possible SNP
											// to prevent addSNPEdge from adding
											// SNPS unnessarely.
											if(s==null) {
												if(positions!=null && positions[j]!=-1) {
													String tmpChr = (SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) ? SNPPicker.chromosome :(thisFileChr==null ? "": thisFileChr);
													s=Snp.getSnpByPos(positions[j],tmpChr);
													if(s==null && tmpChr.length()>0) {
														s=Snp.getSnpByPos(positions[j],"");
													}
													if(s==null) {
														snpIsNew=true;
													} else {
														// Snp with different name at same position
														Snp.addSnpNameSynonym(s, snpNames[j]);
													}
												} else {
													snpIsNew=true;
												}
											}
											System.out.println("Calling AddSnpEdge:" + binname + ",tag="+ tags[j]+ ", snp="+snpNames[j]+",popid="+currpopid);
											Snp.addSnpEdge(snpNames[j], binname, currpopid);// Bin Should Exist.
											s = Snp.getSnpByName(snpNames[j]);
											if(snpNames[j].startsWith("rs") && snpNames[j].length()>3) {
												try {
													int idint = Integer.parseInt(snpNames[j].substring(2));
													s.setDbsnpid(snpNames[j].toLowerCase());// looks like a dbsnpid.									
												} catch (Exception e) {
													e=null;// Just validating the dbsnpid format
												}
											}
										} else {
											s = Snp.getSnpByName(snpNames[j]);
											if(s==null && snpNames[j]!=null) {
												s = new Snp(currpopid,snpNames[j],-1);
												snpIsNew=true;
											}
										}
										
										if(locations!=null && locations[j]!=null && locations[j].length()>0) {
											if(s==null) {
												s=Snp.getSnpByName(snpNames[j]);
											}
											s.setLocation(locations[j]);
										}
										if(positions!=null && positions[j]!=-1) {
											if(s==null) {
												s=Snp.getSnpByName(snpNames[j]);
											}
											if(s.getPosition()<=0) {
												if(SNPPicker.chromosome!=null && SNPPicker.chromosome.length()>0) {
													s.setChromosome(SNPPicker.chromosome);
												} else if(thisFileChr!=null && thisFileChr.length()>0) {
													s.setChromosome(thisFileChr);
												}
												s.setPosition(positions[j]);
											} else {
												if(positions[j]!=s.getPosition()) {
													System.err.println("SNPPicker: readLDSelectTagzilla: ERROR : loaded position different than existing SNP position "+snpNames[j]+", existing ="+s.getPosition()+", loaded ="+positions[j]);
												}
											}
										}
				
									} // if(snpNames..)
									
								} // for
								
								if(firstSnpName!=null && SNPPicker.computeUtilityOnly && ! SNPPicker.doNotPick ) {
									// pick first tag SNP per Bin.
									Snp s = Snp.getSnpByName(firstSnpName);
									if(s!=null && ! SNPPicker.doNotPick ) {
										s.setSelected(true, true);
									}
								}
							}
							if(findTag) {
								b.setNSites(nsites);
								b.setGeneId(geneId);
								b.setSource(source);
							} 
						}
					}
				}
				t_pop.closeFile();
			} catch (IOException e) {
				System.err.println("Error: " + e);
				System.err.println("SNPPicker:ERROR: IO Exception while reading file "+fname);
				e.printStackTrace();
				System.err.flush();
				System.out.flush();
				System.exit(-1);
			} catch(Exception e) {
				System.err.println("Error: " + e);
				e.printStackTrace();
				System.err.println("SNPPicker:ERROR: non-IO Exception while processing file "+fname);
				System.err.flush();
				System.out.flush();
				System.exit(-1);
				
			} 
	
			System.out.flush();
			System.err.flush();
			return true;
		}
	
	/**
	 * Read Tagger format from 1) Running Tagger and selecting Tagger Tab .. then
	 *                         2) File Menu->Export current tab to Text
	 *                         
	 *                         Since tagger does not really gives us full bins with alternate SNPs
	 *                         we will use transitivity to make a conservative guess
	 *                         e.g a SNP is a tag if it's r2_thisSNP*min(r2_Bin)>r2_cutoff
	 * @param t_pop
	 * @param fname
	 * @param prefix
	 * @return
	 */
	public static boolean readTagger(Population t_pop,String fname,String fileid) throws Exception  {
		// In first part of file, just create SNPs so can store R^2 (in Hash) and count the number of "pre"-bins on each SNP(in this file)
		// Wait until second part of File before creating bin, so can 
		//      1 - compute minimum_r^2 for the bin... and calculate nSites.
		//      2 - Decide which SNPs are "tags" for that bin  if it's r2_thisSNP*min(r2_Bin)>r2_cutoff
		//                  or if this is a "multi-SNP test" .. set the SNPs as obligates and fixed.
		//      3  - Decrement pre-bin count for SNPs that are not tag for that bin.
		//      4 - If SNPs that are not tags do not have existing bins and pre-bin-count==0 ==> Delete That Snp.
		//      5 - If at least 1 remaining tagSNP has a bin assignment for this pop,  use the dummy pop, or keep creating dummy pops if more overlap
		//      6 - 
		
		int popid = t_pop.getId();
		String prefix = t_pop.getName() + "-" + fileid+":";
		// Reset all Pre-Bins and R2 for existing Snps.
		
		{
			for(int i=0;i<Snp.getNsnps();i++) {
				Snp s = Snp.getSnpById(i);
				if(s!=null) {
					s.resetR2();
					s.setPreBin(0);
				}
			}
		
		}
		
		try {
			BufferedReader in =null;
			try{
				in = t_pop.getBufferedReader(fname);
				System.out.println("SNPPicker: readTagger reading bin file "+fname);
			} catch (Exception e) {
				System.err.println(e.getMessage());
				System.err.println("SNPPicker:ERROR: error opening file "+fname);
				System.err.flush();
				System.out.flush();
				System.exit(-1);
			}
			String l = null;
			Pattern r2Pattern = Pattern.compile("^([^\\t]+)\\t([^\\t]+)\\t([0-9,.])+$"); // Pattern for 3 columns, first part of file.
			Pattern binPattern = Pattern.compile("^([^\\t]+)\\t([^\\t]*)$"); // Pattern for 2 columns, note last field can be empty
			Pattern multiPat = Pattern.compile("^([^ ]) : ([ACGT])+$"); // Split the Test Field.
			while ((l = in.readLine()) != null) {
				if(!l.startsWith("#")) {
					Matcher r2Matcher = r2Pattern.matcher(l);
					if(r2Matcher.find()) {// 3 fields... first part of file
						// create bins with name given by "best test" (2nd field)
						String snpField = r2Matcher.group(1);
						if(snpField!=null && snpField.length()>0 && !snpField.equals("Allele")) {
							snpField = snpField.toLowerCase();
							String testField = r2Matcher.group(2);
							String r2Field = r2Matcher.group(3);
							double r2=0.0;
							try {
								r2 = Double.parseDouble(r2Field);
							} catch (Exception nfe) {
							}
							Matcher multiMatcher = multiPat.matcher(testField);
							String binname=prefix+testField;
							if(multiMatcher.find()) {// multi-SNP tests
								String snpsstr = multiMatcher.group(1); // Snps list.
								// Don't need r2, infact, set it to 0, so fails.
								String[] snps = Utils.split(snpsstr,',');
								// register complex SNPs
								for(int j=0;j<snps.length;j++){
									if(snps[j]!=null && snps[j].length()>0) {
										snps[j]=snps[j].toLowerCase();
										Snp s = Snp.getSnpByName(snps[j]);
										if(s!=null) {
											//									PreBin is a way to keep track of the number of new Bins overlapping this SNP.
											//									since a SNP in a pattern can also be in an independent bin.
										} else {
											s = new Snp(popid,snps[j],-1);
										}
										s.setR2(0.0d,binname);
										s.incrementPreBin();
										if(SNPPicker.computeUtilityOnly && !SNPPicker.obligateUtilityOnly) {
											// pick first tag SNP per Bin.
											if(!SNPPicker.doNotPick) {
												s.setSelected(true, true);
											}
										}
									}
								}
							}
							// make sure  we collect Snps in the bin other and their r2
							Snp s = Snp.getSnpByName(snpField);
							if(s==null) {
								s = new Snp(popid,snpField,-1);
							}
							s.setR2(r2,binname);
							s.incrementPreBin();
							if(SNPPicker.computeUtilityOnly && !SNPPicker.obligateUtilityOnly) {
								// pick first tag SNP per Bin.
								if(!SNPPicker.doNotPick) {
									s.setSelected(true, true);
								}
							}
						}
					} else {// 2nd part of file
						Matcher binMatcher = binPattern.matcher(l);
						if(binMatcher.find()) {
							String testField = binMatcher.group(1);
							if(!testField.equals("Test")) {
								String taggedField = binMatcher.group(2);
								String[] snps = null;
								if(taggedField!=null && taggedField.length()>0 ) {
									snps=Utils.split(taggedField,',');
								} else {
									snps = new String[0]; // triplet pattern not tagging any SNPs
								}
								int nTotalSites = snps.length;
								int nsites = snps.length;
								String binname=prefix+testField;
								double minR2=1.0d;
								for(int i=0;i<nsites;i++) {
									Snp s = Snp.getSnpByName(snps[i]);
									double r2=s.getR2(binname);
									if(r2<minR2) {minR2=r2;}
								}
							
								Matcher multiMatcher = multiPat.matcher(testField);
								boolean isMulti=false;
								String[] multis = null;
	
								if(multiMatcher.find()) {
									isMulti=true;
									multis = Utils.split(multiMatcher.group(1),',');
									int nadd=0;
									boolean[] addThose=new boolean[multis.length];
									//XXXXXXX Add multis to snps
									for(int j=0;j<multis.length;j++) {
										addThose[j]=true;
										for(int k=0;k<nsites;k++) {
											if(multis[j].equals(snps[k])) {
												addThose[j]=false;
												Snp s = Snp.getSnpByName(snps[k]);
												s.decrementPreBin(); // increased it twice.
												break;
											}
										}
										if(addThose[j]) {nadd++;}
									}
									if(nadd>0) {// Some multi-SNP tests were not tagging themselves.
										String[] newsnps = new String[nadd+snps.length];
										for(int j=0;j<nsites;j++) {newsnps[j]=snps[j];}
										nadd=0;
										for(int j=0;j<multis.length;j++) {
											if(addThose[j]) {snps[nsites+ nadd]=multis[j];nadd++;}
										}
										snps=newsnps;
									}
									nTotalSites=snps.length+nadd;
								}
								boolean[] obligates = new boolean[nTotalSites];
								boolean[] keepAsTag = new boolean[nTotalSites];
								// Figure out which SNPs to keep as tags.
								for(int i=0;i<nTotalSites;i++) {
									obligates[i]=false;
									Snp s = Snp.getSnpByName(snps[i]);

									double r2=s.getR2(binname);
									keepAsTag[i]=false;
									if(isMulti) {
										boolean thisIsMulti=false;
										for(int j=0;j<multis.length;j++) {
											if(snps[i].equals(multis[j])) {
												thisIsMulti=true;
												break;
											}
										}
										if(thisIsMulti) {
											keepAsTag[i]=true;
											obligates[i]=true;
										} else {
											keepAsTag[i]=false;
										}
									}
									if(r2*minR2>SNPPicker.rsquare) {
										keepAsTag[i]=true;
									}
									s.decrementPreBin(); // Since we've processed this SNP in this bin, remove protection from deletion
									if(keepAsTag[i]) {
										if(obligates[i] && !SNPPicker.doNotPick) { // only for multi
											s.setObligate(true); // also sets isSelected() and selectedSnpIds
											s.setSelected(true, true);
											s.setFixed(true);
											s.setFixed_multi_test(true);
										}
									} else {// SNP in this bin is not a tag..
										if(s.getNbins()==0 && s.getPreBin()==0) {
											if(SNPPicker.nOPA>0 && (!s.isObligate()) && (!s.isFixed())) {
												// Pre-bin is so that we do not delete a SNP prematurely.
												Snp.deleteByName(snps[i],false);
											}
										}
									}
								}//for .. nTotalSites
	
								Population new_t_pop=t_pop;
								// Assign a Pop and a Binid for this Bin.
								// If a Bin was already assigned to ANY snps in that bin
								// then use a Temp Bin. Deals with multi and also
								//  with overlap caused by bins from different and overlapping
								// population sources.
								if(!checkIfSnpsHaveBinForThatPop(snps,t_pop)) {
									int i=0;
									String popname = t_pop.getName();
									String newpop = popname+":Dummy:"+Integer.toString(i);
									new_t_pop=Population.getPopByName(newpop);
									if(new_t_pop==null) {
										new_t_pop = new Population();
										new_t_pop.setName(newpop);
									}
									while(!checkIfSnpsHaveBinForThatPop(snps,new_t_pop)) {
										newpop = popname+":Dummy:"+Integer.toString(++i);
										if(Population.getPopByName(newpop)==null) {
											new_t_pop = new Population();
											new_t_pop.setName(newpop);
										}
									}
								}
								int newpopid = new_t_pop.getId();
								int nTags=0;
								for(int i=0;i<nTotalSites;i++) {
									if(keepAsTag[i]) {
										nTags++;
										Bin b = Bin.getBinByName(binname);
										if(b==null) {
											b = new Bin(binname,newpopid,popid);
										} else {
											b.setPopId(newpopid);
											b.setBasePopId(popid);
										}
										binname = b.getName();
										Snp.addSnpEdge(snps[i], binname, newpopid);
										Snp s = Snp.getSnpByName(snps[i]);
										if(s!=null && snps[i]!=null && snps[i].startsWith("rs")) {
											try {
												int idint = Integer.parseInt(snps[i].substring(2));
												s.setDbsnpid(snps[i].toLowerCase());// looks like a dbsnpid.									
											} catch (Exception e) {
												e=null;// Just validating the dbsnpid format
											}
										}
									}
								}
								// set NSites
								Bin b = Bin.getBinByName(binname);
								if(b!=null) {
									b.setNSites(nsites);
									if(nsites<SNPPicker.minBin) {
										if(SNPPicker.nOPA!=0) {
											System.out.println("Bin "+binname+ " has only "+nsites+" SNPs, which is less than cutoff of "+SNPPicker.minBin+"\n");
											Bin.deleteByName(binname,true);
										}
									}
								} else {
									System.err.println("SNPPicker:ERROR: readMayoTabular: Bug in addSnpEdge .. there should have been a bin created for "+binname);
									System.err.flush();
									System.out.flush();
									System.exit(-1);
								}
								if(nTags==0) {
									// Bin without tag
									System.err.println("SNPPicker:WARNING: Bin "+binname+" had no tags above frequency cutoff\n");
									System.err.flush();
									Bin.deleteByName(binname,true);
								}
								
							}// !testField.equals("Test")
						} // binMatcher.find() binMatches pattern for 2nd part of file
					}// else 2nd part of file
				}// startsWith("#"
			} // readline
			t_pop.closeFile();
		} catch (IOException e) {
			e.printStackTrace();
			System.err.println("SNPPicker:ERROR: IO Exception reading " + fname+"\n"+e.getMessage());
			System.err.flush();
			System.out.flush();
			System.exit(-1);
		}  catch (Exception e) {
			System.err.println("SNPPicker:ERROR: unexpected error reading "+fname+" in Mayo Tabular format");
			e.printStackTrace();
			System.err.flush();
			System.out.flush();
			System.exit(-1);
		}
		return true;
	}
	static int GENE_CONFIG=0;
	static int GENEID_CONFIG=1;
	static int REGION_CONFIG=0;
	static int SOURCE_CONFIG=2;
	static int BUILD_CONFIG=3;
	static int CHR_CONFIG=4;
	static int POS_CONFIG=5;
	static int NAME_CONFIG=6;
	static int RSID_CONFIG=7;
	static int BIN_CONFIG=8;
	static int TAG_CONFIG=9; // wether the SNP is a tag for a bin.
	static int MAF_CONFIG=10;
	static int GENOTYPE_CONFIG=11;
	static int LOC_CONFIG=12;
	static int ILLUMINASCORE_CONFIG=13;
	// 14 is num_beads
	static int BINS_NAMES_CONFIG= 15;
	static int NSITES_CONFIG= 16;
	static int NOTE_CONFIG= 17;
	static int POPULATIONS_CONFIG= 17;
	
	static String GENE_STR="hugo_gene_name";
	static String REGION_STR="region_name";
	static String GENEID_STR="entrez_gene_id";
	static String SOURCE_STR="snp_source";
	static String BUILD_STR="genome_build";
	static String CHR_STR="chromosome";
	static String POS_STR="chr_pos_bp";
	static String NAME_STR="source_id";
	static String RSID_STR="dbsnp_rsid";
	static String BIN_STR="ld_bin";
	static String TAG_STR="tag_snp";
	static String MAF_STR="maf";
	static String GENOTYPE_STR="genotype";
	static String LOC_STR="location_in_gene";
	static String ILLUMINASCORE_STR="assay_score";
	
	static String BINS_NAMES_STR="bins";
	static String NSITES_STR="nsites";
	static String NOTE_STR="note";
	static String POPULATIONS_STR = "populations";
	
	
	/* gene based:
	 * hugo_gene_name	entrez_gene_id	snp_source	genome_build	chromosome	chr_pos_bp	source_id	dbsnp_rsid	ld_bin	tag_snp	maf	genotype	location_in_gene	assay_score [bins_names] [nsites]
	
	 * region-based
	 * region_name	snp_source	genome_build	chromosome	chr_pos_bp	source_id	dbsnp_rsid	ld_bin	tag_snp	maf	genotype	location_in_gene	assay_score
	
	 * old format=
	 * binid==0 means skip SNP
	 * Mayo Gene	Gene Id	source	build	chr	position	snp id	rsid	ld bin	tag snp	maf	genotype	location	Illumina Score
	 */
	
	public static boolean readMayoTabular(Population t_pop,String fname,String fileid) throws Exception {
		int popid = t_pop.getId();
		String pop_string= t_pop.getName();
		HashMap<String,Integer> binSites = new HashMap<String,Integer>();
		HashMap<String,Integer> binTags = new HashMap<String,Integer>();
		HashMap<String,String> binGene = new HashMap<String,String>();
		HashMap<String,String> binGeneid = new HashMap<String,String>();
		HashMap<String,String> binSource = new HashMap<String,String>();

		Pattern binPattern = Pattern.compile("([^-]+)-([^-,:]+):(.*)");
		String patternStr = "\\t";
		Pattern linePat = Pattern.compile(patternStr);
		int nextbin=1;
		int format=0;
		int GENE=0;
		int GENEID=1;
		int REGION=0;
		int SOURCE=2;
		int BUILD=3;
		int CHR=4;
		int POS=5;
		int NAME=6;
		int RSID=7;
		int BIN=8;
		int TAG=9; // wether the SNP is a tag for a bin.
		int MAF=10;
		int GENOTYPE=11;
		int LOC=12;
		int ILLUMINASCORE=13;
		// 14 is num_beads
		int BINS_NAMES = 15;
		int NSITES = 16;
		int NOTE = 17;
		int POPULATIONS = 17;


		try {
			BufferedReader in =null;
			try{
				in = t_pop.getBufferedReader(fname);
				System.out.println("SNPPicker:readMayoTabular reading bin file "+fname);
				System.out.flush();
			} catch (Exception e) {
				System.err.println(e.getMessage());
				System.err.println("SNPPicker:ERROR: error opening file "+fname);
				System.err.flush();
				System.out.flush();
				System.exit(-1);
			}
			String l = null;
			//boolean isTag=false;
	readfile:
			while ((l = in.readLine()) != null) {
				String l2 = l.toLowerCase();
				if(l2.startsWith(GENE_STR) || l2.startsWith(REGION_STR)) {
							String[] sline = Utils.splitPattern(l2,linePat);
							if(l2.startsWith(GENE_STR)) {
								GENE = checkHeader(sline,GENE_CONFIG,GENE_STR);
								GENEID = checkHeader(sline,GENEID_CONFIG,GENEID_STR);
								REGION=GENE;
							} else {
								REGION = checkHeader(sline,REGION_CONFIG,REGION_STR);
								GENE=REGION;
								GENEID=REGION;
							}
							SOURCE = checkHeader(sline,SOURCE_CONFIG, SOURCE_STR);
							BUILD = checkHeader(sline,BUILD_CONFIG,BUILD_STR);
							CHR = checkHeader(sline,CHR_CONFIG,CHR_STR);
							POS = checkHeader(sline,POS_CONFIG,POS_STR);
							NAME = checkHeader(sline,NAME_CONFIG,NAME_STR);
							RSID = checkHeader(sline,RSID_CONFIG,RSID_STR);
							BIN = checkHeader(sline,BIN_CONFIG,BIN_STR);
							if(BIN<0) {// suppor t old files with buggy format.
								BIN = checkHeader(sline,8,"ld bin");
							}
							if(SOURCE<0) {// support old files with buggy format.
								SOURCE = checkHeader(sline,2,"snp source");
							}
							TAG = checkHeader(sline,TAG_CONFIG,TAG_STR);
							MAF = checkHeader(sline,MAF_CONFIG,MAF_STR);
							GENOTYPE = checkHeader(sline,GENOTYPE_CONFIG,GENOTYPE_STR);
							LOC = checkHeader(sline,LOC_CONFIG,LOC_STR);
							ILLUMINASCORE = checkHeader(sline,ILLUMINASCORE_CONFIG,ILLUMINASCORE_STR);
							if(sline.length>BINS_NAMES_CONFIG) {
								BINS_NAMES= checkHeader(sline,BINS_NAMES_CONFIG,BINS_NAMES_STR);
							}
							if(sline.length>NSITES_CONFIG) {
								NSITES= checkHeader(sline,NSITES_CONFIG,NSITES_STR);
							}
							if(sline.length>POPULATIONS_CONFIG) {
								POPULATIONS = checkHeader(sline,POPULATIONS_CONFIG,POPULATIONS_STR);
								if(POPULATIONS>=0) {
									format=1;
								}
							}
							if(sline.length>NOTE_CONFIG) {
								NOTE = checkHeader(sline,NOTE_CONFIG,NOTE_STR);
								if(NOTE>=0) {
									format=2;
								}

							}
							
				} else if(!(l.startsWith("#"))) {
					String[] line = Utils.splitPattern(l,linePat);
					String chrom = line[CHR];
					if(chrom!=null) {
						chrom = chrom.toUpperCase();
					}
					String posStr =  line[POS];
					int pos =-1;
					String snpname= line[NAME];
					if(snpname!=null) {
						snpname = snpname.toLowerCase();
					}
					String dbsnpid = line[RSID];
					if(chrom==null || chrom.length()==0 || "null".equalsIgnoreCase(chrom) || "-99".equalsIgnoreCase(chrom)) {
						chrom=SNPPicker.chromosome; // default chromosome... if there is one.
					}
					if(chrom==null) {
						chrom="";
					}
					Snp s=null;
					if(s==null && snpname!=null && snpname.length()>0) {
						try {
							pos = Integer.parseInt(snpname);								
						} catch (Exception nfe) { // Not a number ==> first priority is snpname
							s=Snp.getSnpByName(snpname);
						}
					}
					if(s==null && dbsnpid!=null && dbsnpid.length()>0) {// next priority is dbsnp
						s=Snp.getSnpByName(dbsnpid);
					}
					if(s==null && snpname!=null && snpname.length()>0) {// last is "name"
						s=Snp.getSnpByName(snpname);
					}
					
					if(posStr==null || posStr.length()==0 || "null".equalsIgnoreCase(posStr) || "-99".equalsIgnoreCase(posStr)) {
						pos=-99;
						if(s!=null) {
							pos = s.getPosition();
							if(chrom.length()==0) {
								chrom = s.getChromosome();
							}
						}	
					} else {
						try {
							pos = Integer.parseInt(posStr);
							if(pos>=0 && chrom.length()>0) {
								Snp s2=Snp.getSnpByPos(pos, chrom);
								if(s2!=null) {
									s=s2;
								}
							} 
							if(s!=null && chrom.length()==0) {
									chrom = s.getChromosome();
							}
						} catch (Exception nfe) {
						}
					}
					
					boolean foundFreq=false;
					String freqStr = line[MAF];
					double freq = 0.0d;
					if(freqStr!=null && freqStr.length()>0) {
						try {
							freq = Double.parseDouble(freqStr);
							foundFreq=true;
						} catch(Exception e) {
							freq=0.0d; // stop point for debugger
						}
					}
					String bin_number = line[BIN]; // From SNpApp
	
					if(NOTE>=0 && line.length>NOTE) {
						String note = line[NOTE];
						if(note!=null && note.startsWith("No_SNP_Selected")) {
							continue readfile; // Empty bin not tied to a SNP - convenience output from SNPPicker
						}
					}
					
					if("0".equals(bin_number) && SNPPicker.nOPA!=0 && !SNPPicker.computeUtilityOnly) { 
						continue readfile; 
						// This SNP is not a tagging SNP for a bin (or has maf too low)
						// Keep going if we need to use all SNPs to exclude overlapping SNPS (nOPA==0)
						// or if want to compute utility only.
					}
					//	XXX For SNPPicker or multipop format, must use a field other than the [BIN] field, which is from SNPApp.
					// BINS_NAMES and BINS_NAMES_STR
					if(BINS_NAMES>=0 && line.length>BINS_NAMES) {
						String bn = line[BINS_NAMES];
						if(bn!=null && bn.length()>0) {
							bin_number = bn;
						}
					}

	// Here we're trying to support two formats.
	//     The native SNPApp (Mayo -D. Rider & J. Johnson) outputs a binid that is non uniq, 
	//				since the bin information as an integer binid with an implicit placement
	//                     within a geneid(based on order), a source, and a population (separate files)
					String fileid_string;
					String[] binnames=null;
					String[] tagFlags=null;
					String[] binsource=null;
					String[] bingene=null;
					String[] bingeneid=null;
					String[] nSitesArr = null;
					String[] snpNames = new String[1];
					

					try {
						Integer.parseInt(bin_number);
						// if the code doesn't "except", the bin number is from SNPApp.
						// fileid is now the inputfilename with special characters removed.
						String tagFlag = line[TAG];
						if(!("1".equals(tagFlag) || "0".equals(tagFlag) || tagFlag==null || tagFlag.length()==0 )) {
							System.err.println("SNPpicker:ERROR: Invalid TAG format for mayo tabular: , expect a 0 or 1 for line \n"+l);
							System.err.flush();
							System.out.flush();
							System.exit(-1);
						} else if ( tagFlag==null || tagFlag.length()==0 ) {
							tagFlag="0";
						}
						
						tagFlags = new String[1];
						tagFlags[0] = tagFlag;
						bingene = new String[1];
						bingene[0]=line[GENE];
						bingeneid = new String[1];
						bingeneid[0]=line[GENEID];
						binsource =  new String[1];
						binsource[0]=line[SOURCE];
						
						fileid_string=line[GENE]+"|"+line[GENEID]+";"+fileid+"/"+chrom;
						binnames = new String[1];
						String filepop = pop_string;
						if(POPULATIONS>=0 && line[POPULATIONS].length()>0) {
							filepop = line[POPULATIONS];
						}
						binnames[0]=filepop +"-"+fileid_string+":"+bin_number;
					} catch (Exception ec) {
						if(format==2 || format==1) {
							// See if this is the format output by SNPPicker.java or runMultipop.pl
							binnames = Utils.split(bin_number,',');
							String b1=binnames[0];
							//t_pop.getName() + "-" + fileid+":"+binid;
							Matcher m = binPattern.matcher(b1);
							if(!m.find()) {
								System.err.println("SNPpicker:ERROR: Invalid bin format for mayo tabular: expect an integer or the output of SNPPicker:"+bin_number);
								System.err.flush();
								System.out.flush();
								System.exit(-1);
							}
							if(line[TAG]==null || line[TAG].length()==0) {
								line[TAG]="0";
							}
							tagFlags = Utils.split(line[TAG],',');
							if(tagFlags.length==1 && binnames.length>1) {
								// if TAG is only of length==1, convert to a vector
								String tagFlag0=tagFlags[0];
								tagFlags = new String[binnames.length];
								for(int itf=0;itf<binnames.length;itf++) {
									tagFlags[itf]=tagFlag0;
								}
							} else if(tagFlags.length>1 && binnames.length!=tagFlags.length) {
								System.err.println("SNPpicker:ERROR: Invalid TAG and BIN format for mayo tabular: , expect the same number of bins and tag \n"+l);
								System.err.flush();
								System.out.flush();
								System.exit(-1);
							} else {
								// same length vector or both of length 1.
							}
							bingene = Utils.split(line[GENE],',');

							if(bingene.length==1 && binnames.length>1) {
								// if bingene is only of length==1, convert to a vector
								bingene = new String[binnames.length];
								for(int itf=0;itf<binnames.length;itf++) {bingene[itf]=line[GENE];}
							} else if(bingene.length!=1 && binnames.length!=bingene.length) {
								System.err.println("SNPpicker:ERROR: Invalid GENE and BIN format for mayo tabular: , expect the same number of genes and binnames\n"+l);
								System.err.flush();
								System.out.flush();
								System.exit(-1);
							} else {
								// same length vector or both of length 1.
							}
							bingeneid = Utils.split(line[GENEID],',');
							if(bingeneid.length==1 && binnames.length>1) {
								// if bingeneid is only of length==1, convert to a vector
								bingeneid = new String[binnames.length];
								for(int itf=0;itf<binnames.length;itf++) {bingeneid[itf]=line[GENEID];}
							} else if(bingeneid.length!=1 && binnames.length!=bingeneid.length) {
								System.err.println("SNPpicker:ERROR: Invalid GENEID and BIN format for mayo tabular: , expect the same number of geneids and bins \n"+l);
								System.err.flush();
								System.out.flush();
								System.exit(-1);
							} else {
								// same length vector or both of length 1.
							}
							binsource= Utils.split(line[SOURCE],',');
							if(binsource.length==1 && binnames.length>1) {
								// if binsource is only of length==1, convert to a vector
								binsource = new String[binnames.length];
								for(int itf=0;itf<binnames.length;itf++) {binsource[itf]=line[SOURCE];}
							} else if(binsource.length!=1 && binnames.length!=binsource.length) {
								System.err.println("SNPpicker:ERROR: Invalid SOURCE and BIN format for mayo tabular: , expect the same number of source and binnames \n"+l);
								System.err.flush();
								System.out.flush();
								System.exit(-1);
							} else {
								// same length vector or both of length 1.
							}
							if(NSITES>=0 && line.length>NSITES) {
								if(line[NSITES].length()>0) {
									String nSitesString = line[NSITES];
									nSitesArr = Utils.split(nSitesString,',');
									if(nSitesArr.length==1 && binnames.length>1) {
										// if binsource is only of length==1, convert to a vector
										nSitesArr = new String[binnames.length];
										for(int itf=0;itf<binnames.length;itf++) {nSitesArr[itf]=nSitesString;}
									} else if(nSitesArr.length!=1 && binnames.length!=nSitesArr.length) {
										System.err.println("SNPpicker:ERROR: Invalid NSITES and BIN format for mayo tabular: , expect the same number of bins and sites counts \n"+l);
										System.err.flush();
										System.out.flush();
										System.exit(-1);
									} else {
										// same length vector or both of length 1.
									}
								}	
							}
							// binnumber 0, means that the SNP had maf<cutoff if SNP comes from SNPApp

							String old_maf = null;
							if(s!=null) {
								old_maf = s.getMAFString();
								try {
									double oldmaf = Double.parseDouble(old_maf);
									foundFreq=true;
									freq=oldmaf;
								} catch (Exception nfe) {}
							}
							if(MAF>=0 && line[MAF].length()>0) {
								String[] mafs = Utils.split(line[MAF],',');
								for(int kk=0;kk<mafs.length;kk++) {
									String new_maf = mafs[kk];
									String save_maf = old_maf;

									if(old_maf==null || old_maf.length()==0 || "-".equals(old_maf)) {
										save_maf = new_maf;
									} else if(new_maf==null || new_maf.length()==0 || "-".equals(new_maf)) {
										save_maf = old_maf;
									} else {
										save_maf = new_maf;
									}
									double oldmaf =0.0d;
									try {
										oldmaf = Double.parseDouble(old_maf);
										foundFreq=true;
										freq=oldmaf;
									} catch (Exception nfe) {
										oldmaf=0.0;
									}
									double newmaf =0.0d;
									try {
										newmaf = Double.parseDouble(new_maf);
										foundFreq=true;
									} catch (Exception nfe) {
									}
									if(oldmaf<newmaf) {
										save_maf = new_maf;
										freq=newmaf;
									} else {
										save_maf = old_maf;
										freq=oldmaf;
									}
									old_maf = save_maf;
									oldmaf=freq;
								}
								if(s!=null) {
									s.setupMAFString(old_maf); // will only keep the highest maf
								}
							}
						}
					} // end of try-catch block around bin names

					if(s!=null) {
						s.updateSnpName(snpname,dbsnpid);
						snpname = s.getSnpName();
					} else {
						// try to prevent addSNPEdge from adding bins by name
						// by trying every possible way to look for a SNP.
						if(snpname==null || snpname.length()==0) {
							if(dbsnpid!=null && dbsnpid.length()>0) {
								snpname=dbsnpid;
							} else {
								snpname = chrom+"-"+Integer.toString(pos);
							}
							if(s==null) {
								s=Snp.getSnpByName(snpname);
								if(s!=null) {
									snpname = s.getSnpName();
								}
							}
						}
						if(s==null) {
							s=Snp.getSnpByPos(pos,chrom);
							if(s!=null) {
								snpname = s.getSnpName();
							}
						}
					}
					// XXX Must Find the best place to create SNPs that do not exists
					// and make sure that every SNP loaded here has a position,rsid,etc...
					snpNames[0]=snpname;
					
					if(SNPPicker.computeUtilityOnly || (!"0".equals(bin_number)) || SNPPicker.nOPA==0 ) {// Skip SNPs that did not bin (e.g. too low maf)
												  // a "0" bin_number comes from the mayo SNPApp pipeline. It cannot come as
						                          // a bin string output by SNP Picker (so do not use binnames[] here!)
										// nOPA==0 means that we have to know about any SNP nearby.
						if((SNPPicker.computeUtilityOnly)|| (!foundFreq) ||  freq>=SNPPicker.minMAF) {// Normally SNP frequency filtering should be done outside
										// Currently, there is no MAF variable required from user.
							int bincountforsnp=0; // want to make sure that we create a SNP only once.
							String binidpat = "^[^-]+-([^:]+):([0-9]+)$";
							Pattern binidPat = Pattern.compile(binidpat);
							
							int newpopid = 1;
							// for nOPA==0, let non-binned SNPs through so can use the proximity exclusion.
							// but they do not have any bin information.. this if.. should not be necessary, but it's more maintainable..
							if(!"0".equals(bin_number)) {
								for(int kk=0;kk<binnames.length;kk++) {
									newpopid = popid; // default from calling functions
									String binname = binnames[kk];
									Matcher m = binidPat.matcher(binname);
									String filebinname=Integer.toString(nextbin);
									nextbin++;
									String thisfileid=fileid;
									if(m.find()) {
											filebinname = m.group(2);	
											thisfileid=m.group(1);
									}
									Integer	siteCount = null;
									if(nSitesArr==null) {// mayotabular format does not have this field.
										Bin btmp = Bin.getBinByName(binname);
										String newbinname = binname;
										if(btmp!=null) {
											newbinname = btmp.getName();
										}
										siteCount =(Integer) binSites.get(newbinname);
										if(siteCount==null) {
											siteCount = Integer.valueOf(1);
										} else {
											siteCount = Integer.valueOf(siteCount.intValue()+1);
										}
									} else {
										int nsites=1;
										try {
											nsites =Integer.parseInt(nSitesArr[kk]);
										} catch(Exception nfe) {
											nsites=1;// stop-point for debugger
										}
										siteCount = Integer.valueOf(nsites);
									}
									
									// When loading SNPs selected somewhere else, don't load
										// SNPs if they are not "selected"
										// all SNPs (except obligates) are tagSNP for a bin.
										// if a SNP is not a tagSNP for a bin, then we don't actually
										// care if that SNP is in a bin.
									String newbinname=binname;
									int a=1;
									if(binname.equals("AFR-GPC6|10082;SNPApp_AFR_0.90_0.05_1228_1232Hapmap10082ldselect.out/13:38") ||
											binname.equals("CEU-GPC6|10082;SNPApp_EUR_0.90_0.05_1228_1231Hapmap10082ldselect.out/13:34") ||
											binname.equals("AFR-GPC6|10082;SNPApp_AFR_0.90_0.05_1228_1232Hapmap10082ldselect.out/13:536") ||
											binname.equals("CEU-STAT1|6772;SNPApp_EUR_0.90_0.05_1228_1231Hapmap6772ldselect.out/2:18") ||
											binname.equals("AFR-STAT1|6772;SNPApp_AFR_0.90_0.05_1228_1232Hapmap6772ldselect.out/2:35")
									) {
										a++; // debugger breakpoint.
									}
									if(tagFlags[kk].equals("1")){//isTag=true;
										boolean isTag=true;
										Matcher mb = binPattern.matcher(binname);
										String popname=null;
										newpopid = popid;
										if(mb.find()) {
											popname = mb.group(1);
	//										System.out.println("Found pop="+popname);System.out.flush();
											if(popname!=null && popname.length()>0) {
												Population binpop = Population.getPopByName(popname);
												if(binpop==null) {
													System.out.println("SNPPicker:readMayoTabular:NOTE: Adding new pop because of bin="+binname);
													System.out.flush();
													binpop = new Population(popname);
												}
												newpopid = binpop.getId();
											}
										} else {
											System.err.println("SNPPicker:WARNING Error parsing binname: "+binname);
											System.err.flush();
										}
										//System.out.print("i");System.out.flush();
										Bin b = null;
										if(format==2) {
											b= Bin.getBinByName(binname);
										}
										if(b==null) {
											b = Bin.getNonCollidingBin(binname,snpNames,isTag,newpopid,thisfileid,filebinname,bingeneid[kk],binsource[kk],false); // last false, means we are feeding SNPs to the bin, one tagSNP at a time.
										}
										newbinname = b.getName();
										//System.out.print("o");System.out.flush();
										newpopid =b.getPopid();
										Snp.addSnpEdge(snpname, newbinname, newpopid);
										//System.out.print("a");System.out.flush();
										//System.out.println("For "+snpname +" adding "+binname+" in pop "+popname+" with popid="+newpopid);
										if(s==null) {
											s = Snp.getSnpByName(snpname);
											s.updateSnpName(snpname,dbsnpid);
											snpname = s.getSnpName();
										}
										if(s!=null && snpname!=null && snpname.startsWith("rs")) {
											try {
												Integer.parseInt(snpname.substring(2));
												s.setDbsnpid(snpname.toLowerCase());// looks like a dbsnpid.									
											} catch (Exception e) {
												e=null;// Just validating the dbsnpid format
											}
										}
										bincountforsnp++;
										Integer tagsCount =null;
										if(!(newbinname.equalsIgnoreCase(binname))) {
											tagsCount = (Integer) binTags.get(binname);
											binTags.remove(binname);
										} else {
											tagsCount = (Integer) binTags.get(newbinname);
										}
										if(tagsCount==null) {
											tagsCount = Integer.valueOf(1);
										} else {
											tagsCount = Integer.valueOf(tagsCount.intValue()+1);
										}
										binTags.put(newbinname,tagsCount);
									} // loop over tagFlags==1
									// XXX .. the GENE,GENEID,SOURCE assigned to a SNP should be assigned to a bin
									binSites.put(newbinname,siteCount);
									binGene.put(newbinname, bingene[kk]);
									binGeneid.put(newbinname, bingeneid[kk]);
									binSource.put(newbinname, binsource[kk]);
	
									if(!newbinname.equals(binname)) {
										binSites.remove(binname);
										binGene.remove(binname);
										binGeneid.remove(binname);
										binSource.remove(binname);
									}

								} // loop over bins for that SNP
								//System.out.println("e");System.out.flush();
								if(s==null) {
									if(SNPPicker.computeUtilityOnly ) {
										System.err.println("snull");
										System.err.flush();
										// Even SNPs with no tagsFlag must be accounted for.
										s= new Snp(0,snpname,-1); // even if this SNP is part of a bin, we only put in bins, SNPs
																	// that are tags (or selected by application).. 
																	// because that's how SNPPicker is designed.. only care about tagSNPs.
										s.updateSnpName(snpname,dbsnpid);
										snpname = s.getSnpName();
									} else {
										// means no tagFlag was selected .. which is an error
										System.err.println("SNPPicker.readMayoTabular::WARNING: SNP "+snpname+" was listed as having multiple bins, but not being a tag for any of them!\n");
									}
								}
							} else {// Skip Bin data counting for SNPs that were not binned.
								// Can only get here if computeUtilityOnly is true and bin_number==0
								// This SNP is not part of a bin, but it may be selected (e.g. obligate)
								// System.out.println("s");System.out.flush();
								s = Snp.getSnpByName(snpname);
								if(s==null) {
									s = new Snp(0,snpname,-1); // no pop, no bin
									s.updateSnpName(snpname,dbsnpid);
									snpname = s.getSnpName();
								}
							}
							if(s==null) {
								s = Snp.getSnpByName(snpname);
								if(s==null ) {
									// This SNP has no bin for which it is a tag in any population, so assign
									// it to the default.
									s = new Snp(0,snpname,-1);// use default (first) population
								}	
							}
							if(SNPPicker.computeUtilityOnly && !SNPPicker.obligateUtilityOnly) {
								boolean tagFlagFALSE=true;
//								for(int ii=0;ii<tagFlags.length;ii++) {
//									if("1".equals(tagFlags[ii])) {
//										tagFlagFALSE=false; // if any flags is true, then tagFlag(for SNP) is true;
//									}
//								}
								if(NOTE>=0 && line.length>NOTE) {
									String note = line[NOTE];
									if(note!=null) {
										note = note.toLowerCase();
										if(note!=null && ((note.indexOf("excl")>=0)||(note.startsWith("not")))) {
											tagFlagFALSE=true;
											if(note.indexOf("excl")>=0) {
												s.setExcluded(true);
											}
										}
										if( note.startsWith("fixed") || note.equals("tagsnp") || note.equalsIgnoreCase("obligate") || note.equals("obligate_fixed_proximity")) {
											tagFlagFALSE=false;
											if(note.startsWith("obligate")) {
												s.setObligate(true);
											} else if (note.startsWith("fixed")) {
												s.setFixed(true);
											}
										} else if (note.startsWith("excluded")){
											s.setExcluded(true);
										}
									}
								}
								if(!tagFlagFALSE) {
									s.setSelected(true, true);
								} else {
									s.setSelected(false, true);
								}
								
							} else {
								// don't select the SNP, we're just loading it.
							}
							
							
							String locStr = line[LOC];
							s.setLocation(locStr);
							s.setChromosome(chrom);
							s.setPosition(pos);
							String geno = line[GENOTYPE];
							s.setAlleles(geno);
							s.setBuild(line[BUILD]);
							
							// XXX .. the GENE,GENEID,SOURCE assigned to a SNP should be assigned to a bin
	
							// XXX MAF should be one per SNP-population combination.
							// so will keep highest.
							if(MAF!=-1 && line[MAF].length()>0) {
								String[] mafs = Utils.split(line[MAF],',');
								String old_maf = s.getMAFString();
								
								String new_maf = Utils.uniq(mafs)[0];
								String save_maf = new_maf;
								if(old_maf==null || old_maf.length()==0) {
									 save_maf = new_maf;
								} else if(new_maf==null || new_maf.length()==0) {
									save_maf = old_maf;
								} else {
									double oldmaf =0.0d;
									try {
										oldmaf = Double.parseDouble(old_maf);
										double newmaf =0.0d;
										try {
											newmaf = Double.parseDouble(new_maf);
											if(oldmaf>newmaf) {
												save_maf = old_maf;
											}
										} catch (Exception e) {
										}
									} catch (Exception nfe) {
									}
								}
								s.setupMAFString(save_maf); // will only keep first maf
							}
							if(ILLUMINASCORE>=0 && line.length>ILLUMINASCORE) {
								if(line[ILLUMINASCORE].length()>0) {
									double ilscore=0.0;
									try {
										 ilscore = Double.parseDouble(line[ILLUMINASCORE]);
									} catch (Exception nfe) {
										
									}
									if(ilscore>s.getScore()) {
										// don't load no-scores to avoid overwriting.
										s.setScore(ilscore);
									}
								}
							}
						}
					}
				}
			}
			
			
			
			// Loop over all Bins, update site Count

			Set<Map.Entry<String,Integer>> binset = binSites.entrySet();
			Iterator<Map.Entry<String,Integer>> it = binset.iterator();
			while(it.hasNext()) {
				Map.Entry<String,Integer> me = it.next();
				String binname = me.getKey();
				Bin b = Bin.getBinByName(binname);
				if(b!=null) {
					int nsites = me.getValue().intValue();
					b.setNSites(nsites);
					if(nsites<SNPPicker.minBin) {
						if(SNPPicker.nOPA!=0) {
							System.out.println("Bin "+binname+ " has only "+nsites+" SNPs, which is less than cutoff of "+SNPPicker.minBin+"\n");
							System.out.flush();
							Bin.deleteByName(binname,true);
							continue;
						}
					}
					b.setGene(binGene.get(binname));
					b.setGeneId(binGeneid.get(binname));
					b.setSource(binSource.get(binname));
				} else if(!SNPPicker.computeUtilityOnly) {
					System.err.println("SNPPicker:WARNING: readMayoTabular: No Tags meeting maf cutoff("+SNPPicker.minMAF+") and/or no SNP selected as tag for "+binname);
					System.err.flush();
				}
				if(binTags.containsKey(binname)) {
					// at least 1 tag/bin
				} else {
					// Bin without tag
					if(!SNPPicker.computeUtilityOnly) {
						System.err.println("SNPPicker:WARNING: Bin "+binname+" had no tags above frequency cutoff\n");
						System.err.flush();
						Bin.deleteByName(binname,true);
					}
				}
			}
			//System.out.println("eu");System.out.flush();
		} catch(IOException e) {
			System.err.println("SNPPicker:ERROR: IO Exception reading "+fname+" in Mayo Tabular format");
			e.printStackTrace();
			System.err.flush();
			System.out.flush();
			System.exit(-1);
		} catch (Exception e) {
			System.err.println("SNPPicker:ERROR: unexpected error reading "+fname+" in Mayo Tabular format");
			e.printStackTrace();
			System.err.flush();
			System.out.flush();
			System.exit(-1);
		}
		System.out.println("SNPPicker:readMayoTabular finished reading bin file "+fname);
		System.out.flush();
		return true;
	}
	
		
		/**
		 * returns true if ANY of the Snps have a bin in that pop
		 * @param snps
		 * @param t_pop
		 * @return
		 */
		private static boolean checkIfSnpsHaveBinForThatPop(String[] snps,Population t_pop) {
			int nsites=snps.length;
			int pid = t_pop.getId();
			for(int i=0;i<nsites;i++) {
				Snp s = Snp.getSnpByName(snps[i]);
				if(s!=null) {
					int [] bins4pop=s.getBins();
					if(bins4pop[pid]>0) {return true;}
				}
			}
			return false;
		}
	
		/**
		 * 
		 * @param id
		 * @param opos
		 * @param range
		 * @return true if the ID looks like a position
		 */
		public static boolean idLooksLikePos(String id, int opos,int range) {
			int pos=-1;
			try {
				pos = Integer.parseInt(id);
			} catch (NumberFormatException nfe) {
				return false;
			}
			if(pos>0 &&  Math.abs(pos-opos)<range) {
				return true;
			}
			return false;
		}
		
		public static void usage() {
			System.err.println("Usage: java -jar CommonSnp <configuration options>  -s scorefile -s another_scorefile -p popname1  -it|-il|-im|-iz tagfile1 -p popname2 [-it|-il|-im|-iz tagfile2 ] <other options>\n");
			System.err.println(
			 "\t-iz is for tagzilla format files\n"+
			 "\t-il is for ldselect format files\n"+
			 "\t-im is for mayo tabular format files\n"+
			 "\t-it is for tagger(Haploview) format files\n"+
			 "\t\tTagger support is not optimal for r^2<1 since tagger does not output alternate tags or r^2.\n"+
			 "\t\tWe accept as tags SNPs that have r^2_to_the_tag*worst_r^2_in_bin>= r^2 cutoff."+
			 "\tMultiple input files per populations can be specified, but they have to repeat the -p flag\n"+
			 "\tpopulations with different coverages can be mixed, e.g. a perlegen caucasian and a hapmap caucasian\n"+
			 "\tcan be mixed. Input files in the same population are allowed to overlap.\n\n");
			System.err.println(
			"-s scorefile  (Illumina Format, or as per -propertyfile, or 3-6 column format {	snpname,score,pos,chr,location, validation_class)}\n"+
			"\tcontains the snpid, a designability flag (0,0.5,1), and a position. If a SNP is not in this file, it assumes the default score]\n"+
			"\tscorefile should only contains SNPs relevant for the population of interest, but\n"+
			"\tshould contain SNPs with freq>0 (and thus above user cut-off) if they need to be\n"+
			"\tconsidered for snpUnderProbeDistance>0 tooClose test.\n"+
			"[-f obligate_include_file]\n\t(f=forced in) file containing snp ids of snps that must be included] a SNP cannot be both obligate include and exclude.\n"+
			"[-x obligate_exclude_file]\n\t(eXclude) file containing snp ids of snps that must never be picked. a SNP cannot be both obligate include and exclude\n"+		
			"[-S default_score] (long form is -defaultscore score) Default score, if a SNP is not in the scorefile. \n"+
			"[-V default_validation_class] Default validation class string (1,2, or 3. Default is 1 (3 is better))\n"+
			"[-c config_file] :XML File listing the rules for assigning Probabilities to Scores (Default are for Illumina)\n"+
			"[-cpu max_millisecs_cluster (default 300000(300s))]\n"+
			"[-X basepairs] : Minimum number of base pairs between SNPS(60).. unless they can be assigned to multiple OPA's(nOPA>1). Please set to 0 for infinium I or infinium II.\n"+
			"[-nOPA nOPA] : Number of different assay batches (OPA's for Illumina) where the overlapping SNPS can be distributed]\n\t -1 turn off any proximity checking (as if -X 0) and 0 rejects any SNPS with known (from annotation file+data) overlap with any other SNP(to avoid SNP under the probe problems).\n"+
			"[-minscore double] :Minimum score to consider for a tagsnp. This is the first filter to be applied. Obligates that do not meet this filter are rejected.\n"+
			"[-defaultscore double ] Default Score for SNPs with no information. SNPs assigned this score will not get filtered by the minimum score."+
			"[-rsquare double]	r^2 that was used in binning SNPs. Needed for Tagger file processing, but can be set to 1.0 for conservative Tagger alternates\n"+
			"[-r ruleString] rules for Maximum Number of Snp/bin format e.g. -r \"1-9=1,10-19=2,11-Inf=3\"\n"+
			"[-minP prob] Mininum probability per bin.(default 1.0) If this probability is met, than not all tagSNPs specified according to the rules (-r option) will be selected.\n"+
			"[-maf minmaf] Mininum frequency (Default is 0.05)\n"+
			"[-g T|F]T or F (TRUE of FALSE, default TRUE): If T, start by minimizing number of total tags, otherwise pick most assayable tags first. Should mostly matter when clusters are very complex and when CPU time limit is reached.\n"+
			"[-maxpop nn] Override defaults for Maximum Number of Population, including dummy population for overlapping data (e.g. overlapping genes). Default is 30, reduce for speedup.\n"+
			"[-minbinsize nn] Only require SNPs for bins with at least that many sites. A bin may still end up with a SNP if it overlaps another bin in a larger population.\n"+
			"[-riskFactor double] set to Negative Number to favor against low-scoring SNPs\n"+
			"[-chr chromosome] Default and If want to filter out annotation file by Chromosome\n"+
			"[-infinium2] For Illumina Infinium II array: If set, this will use bead type, prefering SNPs that use a single bead. Bead count is inferred from alleles in annotation file. \n"+
			"[-nooptimal] Default is to do optimal Search for solution after the initial greedy seed.\n" +
			"[-computeutilityonly] Read-in pre-computed solutions and only output the utility. Used to compare other tools\n"+
			"[-propertyfile java_property_file] Read-in java configuration file to define the fields of the annotation file\n"+
			"[-obligatesnotinpanel filename] If genotypes will or have been genotyped in some other panel, they do not need to participate in SNPsTooClose"+
			"[-obligatesnotinpanl_done] Obligates not in panel have already been successfully genotypes ==> override multi-snp per bin rules (now only need this one)"+
			"[-verbose] Provides lots of output for debugging and to justify every decision"+
			"[-obligateutilityonly] only use obligates as set SNPs and compute utility"
			+"[-donotpick] use with compute utility only to avoid first SNP per bin to be selected. Need to provide an obligate file for anything useful to happen.\n" +
			"[-noopt turoff the final step of looking for an optimal solution]"+
			"[-randomcheck n (default " +Integer.toString(SNPPicker.nRandomComplex) +") If switch to approximate solution, check cluster using random solutions"
			);
			
		}

		/**
		 * @return the NSBRules
		 */
		public static String getNSBRules() {
			return NSBRules;
		}


	}
	
