package edu.mayo.genotype;
/**
 * @author Original code pete kirkham
 * Downloaded 2007 from http://forum.java.sun.com/thread.jspa?threadID=5133480&tstart=45
 * posted in the public domain with no license or copyright labels.
 * @author Hugues Sicotte
 * 	recoded to accept negatives.
 */

import java.util.*;
public class PowerSet<T> extends AbstractCollection<PowerSet<T>.BitMaskSet> implements Collection<PowerSet<T>.BitMaskSet> {
	private final T[] 		elts;
	private final int	size;
	private final long trueSize;
	private final int 		hashCode;
	private final int		n;
	private final boolean reverse;
	// Maximum recommended size for n (since java int is 4 byte long
	// already for 25 bits, this takes 8 secs.
	private static final int intsize=31;
	public static int getMax() {return intsize;}
	
	public PowerSet (Set<T> source) throws Exception  {
		this.n = source.size();
		this.elts = (T[]) source.toArray();
		if(n<32) {
			this.size = 1 << n; // in Java, the << only looks at the first 5 bits of n.
		} else if (n==32) {
			this.size=0;
		} else {
			throw new Exception("Too Many Elements for PowerSet 2^" +n);
		}
		this.trueSize=1L<<n;
		this.hashCode = (1 << (n-1)) * Arrays.hashCode(this.elts);
		this.reverse=false;
	}
	public PowerSet (Set<T> source,boolean reverseDirectionOfCounting) throws Exception {
		this.n = source.size();
		this.elts = (T[]) source.toArray();
		if(n<32) {
			this.size = 1 << n; // in Java, the << only looks at the first 5 bits of n.
		} else if (n==32)  {
			this.size=0;
		} else {
			throw new Exception("Too Many Elements for PowerSet 2^" +n);
		}
		this.trueSize=1L<<n;
		if(n==0) {
			this.hashCode=0;
		} else {
			this.hashCode = (1 << (n-1)) * Arrays.hashCode(this.elts);
		}
		this.reverse=reverseDirectionOfCounting;

	}
 
	public int hashCode () { return this.hashCode; }
 
	public boolean equals (Object e) {
		return false;
	}
	/*
	 * size will return wrong size if list has 32 elements
	 * @see java.util.AbstractCollection#size()
	 */
	public int size () {
		return size;
	}
	/*
	 * size will return wrong size if list has 32 elements
	 * @see java.util.AbstractCollection#size()
	 */
	public long trueSize () {
		return trueSize;
	}
	
 
public 	class BitMaskSet  extends AbstractCollection<T>  implements Set<T>  {
		final int mask;
		BitMaskSet (int mask) {
			this.mask = mask;
		}
 
		public int hashCode () {
			int hashCode = 0;
 
			for (int i = 0, mask = this.mask; mask > 0; mask >>>= 1, ++i) {
				if ((mask&1)==1) hashCode += elts[i].hashCode();
			}
 
			return hashCode;
		}
 
		public int size () {
			int _size = 0;
 
			for (int _mask = BitMaskSet.this.mask; _mask != 0; _mask >>>= 1) {
				_size += ( _mask&1);
			}
			return _size;
		}
 
		public Iterator<T> iterator () {
			return new Iterator<T> () {
				int i = 0;
				int _mask = BitMaskSet.this.mask;
 
				public T next () {
					while ((_mask&1)==0) {
						++i;
						_mask >>>= 1;
					}
 
					final T next = elts[i];
 
					++i;
					_mask >>>= 1;
 
					return next;
				}
 
				public boolean hasNext () {
					return _mask != 0;
				}
 
				public void remove () {
					throw new UnsupportedOperationException();
				}
			};
		}
	} // end of BitMaskSet<T> Class
 
	public Iterator<PowerSet<T>.BitMaskSet> iterator () {
		return new Iterator<PowerSet<T>.BitMaskSet> () {
			int i = 0;
			long nvals=0L;
			
			public BitMaskSet next () {
				int old_mask = i;
				i++;
				nvals++;
				if(reverse) {
					return new BitMaskSet(~old_mask);
				} else {
					return new BitMaskSet(old_mask);
				}
			}
 
			public boolean hasNext () {
				return nvals < trueSize;
			}
 
			public void remove () {
				throw new UnsupportedOperationException();
			}
		};
	}

}

/*
 * Example of using it.
	private static ArrayList[] findSubsets(Object[] snplist) {
		// Assume that we have Snp objects.
		// Don't try this on more than 32 objects.
		// it takes <8seconds for 25 objects
		ArrayList l = null;
		if(snplist!=null && snplist.length>0) {
			 int size = snplist.length; // You probably don't want more than 32
			 l = new ArrayList(2^size);
			  LinkedHashSet<Integer> s = new LinkedHashSet<Integer>();
			  for (int i = 0;i<size;i++ )
				s.add(new Integer(i));
			  PowerSet<Integer> pow = new PowerSet<Integer>(s);
			  Iterator<Set<Integer>> it = pow.iterator();
			  while(it.hasNext()) {
			  	edu.mayo.genotype.PowerSet.BitMaskSet bm = (edu.mayo.genotype.PowerSet.BitMaskSet) it.next();
			  	int nelems = bm.size();
			  	int[] indexes = new int[nelems];
			  	Iterator<Integer> itp = bm.iterator();
			  	int i=0;
			  	while(itp.hasNext()) {
			  		indexes[i++] = itp.next().intValue();
			  	}
			  	l.add(indexes);
			  }
			
		}
		return l;
	}
 */




