package edu.mayo.genotype;
import java.io.*;
import java.util.ArrayList;

public class Population {
    private static int npop=0;

    private static int indexSize=0;
    private static Object[] popIndex =null; // Rebuildable index of all Populations

    private int id=0;
    private String name=null;;
    private int nbins=0;
    private ArrayList<String> filenames= new ArrayList<String>();
    private String r2File=null;
    private BufferedReader input=null;
    private ArrayList<String> formats=null; // ld-select,tagger,tagzilla,mayotabular

    /** 
     * Formats for the input file
     * tagzilla
     * ld-select
     * tagger
     * mayotabular
     */
    public ArrayList<String> getFormats() {
		return formats;
	}
	public void setFormats(ArrayList<String> formats) {
		this.formats = formats;
	}
	public Population() {
		npop+=1;
		this.id=npop;
		updateIndex(this);
		this.formats = new ArrayList<String>();
	}
	public Population(String newname) {
		npop+=1;
		this.id=npop;
		updateIndex(this);
		this.formats = new ArrayList<String>();
		this.name=newname;
	}
	  private static void updateIndex(Population newPop) {
		  if(popIndex==null) {
			  indexSize=10;
			  popIndex = new Object[indexSize];
			  for(int i=1;i<indexSize;i++) {
				  popIndex[i]=null;
			  }
		  } else if (npop>indexSize) {
			  int newIndexSize=indexSize+1000;
			  Object[] tmp = new Object[newIndexSize];
			  int i=0;
			  for(;i<indexSize;i++) {
				  tmp[i]=popIndex[i];
			  }
			  for(;i<newIndexSize;i++) {
				  tmp[i]=null;
			  }
			  popIndex=tmp;
			  indexSize=newIndexSize;
		  }
		  popIndex[npop-1]=newPop;
	  }

	  public static Population getPopById(int id) {
		    if(popIndex==null) {
		    	return null;
		    }
		  	return (Population) popIndex[id-1];
	  }
	public static Population getPopByName(String inName) {
			Population p = null;
			if(popIndex==null) {
				return null;
			}
			for(int i=0;i<npop;i++) {
				String pname = ((Population) popIndex[i]).getName();
				if(pname!=null && pname.length()>0 && pname.equalsIgnoreCase(inName)) {
					p=(Population) popIndex[i];
					break;
				}
			}
			return p;
	  }
    
	public static void clear() {
		if(popIndex==null) {
			return;
		}
		for(int i=0;i<popIndex.length;i++) {
			popIndex[i]=null;
		}
		npop=0;
	}
    public void setNbins(int nb) {nbins=nb;}
    public int getNbins() {return nbins;}
    public void setName(String popname) {name=popname;}
    public String getName() {return name;}
    public int getId(){return id;}
    
    public void addFileName(String fname) {
    	this.filenames.add(fname);
    	this.formats.add("ld-select");
    }
    public void addFileName(String fname,String format) {
    	this.filenames.add(fname);
    	this.formats.add(format);
    }
    public ArrayList<String> getFileNames() {return filenames;}
    public static int getNPop() {return npop;}
    
    private void setBufferedReader(String filename) {
        try {
            if (input!= null) {
              //flush and close both "input" and its underlying FileReader
              input.close();
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        input=null;
    	
    	try {
    	  File f=new File(filename);
    	 
    	      //use buffering, reading one line at a time
    	      //FileReader always assumes default encoding is OK!
    	  input = new BufferedReader( new FileReader(f) );
    	} catch (FileNotFoundException ex) {
    	      ex.printStackTrace();

        }
    }
    public BufferedReader getBufferedReader() {return input;}
    public BufferedReader getBufferedReader(String fname) {
    	setBufferedReader(fname);
    	return input;
    }
    public void closeFile() {
    	try {
    		input.close();
    		
    	} catch(IOException ex) {
    		ex.printStackTrace();
    	}
    	input=null;
    }

	public String getR2File() {
		return r2File;
	}

	public void setR2File(String file) {
		r2File = file;
	}
	
	public String getOutputName() {
		String pname = this.getName();
		if(pname!=null) {
			int dpos = pname.indexOf(":DupFile");
			if(dpos>0) {
				// format is TRUEPOPNAME:DupFilenn 
				pname = pname.substring(0,dpos);
			}
		} else {
			pname="";
		}
		return pname;
	}
    
}