package edu.mayo.genotype;

/**
 * Class with static methods to generate permutations.
 * Permutations are generated by changing the "right-most" permutation first.
 * 
 * This code allows one to skip ahead in the permutation order.
 * 
 * Code not objectified on purpose to be able to use native int[] objects for performance.
 * 
 * @author Hugues Sicotte
 *
 * Note: This Class not used in current SNPPicker2 implementation, but it was well tested.
 */


public class Permutation {
	public static boolean isLastPerm(int[] pv ) {// permutation vector
		int n=pv[0];
		// Optimize for biggest cluster first, since they need the most speed
		if(n>5) {
			int finalpos=n+3+n-1;
			int cursol=n-1;
			for(int pos=n+3;pos<finalpos;pos++) { // no need to test last position
				if(pv[pos]!=cursol--) {
					return false; // fail early
				}
			}
			return true;
		}
		if(n==5) {if(pv[n+3]==4 && pv[n+4]==3 && pv[n+5]==2 && pv[n+6]==1) {return true;} else {return false;}}
		if(n==4) {if(pv[n+3]==3 && pv[n+4]==2 && pv[n+5]==1) {return true;} else {return false;}}
		if(n==3) {if(pv[n+3]==2 && pv[n+4]==1) {return true;} else {return false;}}
		if(n==2) {if(pv[n+3]==1) {return true;} else {return false;}}
		if(n==1) {return true;}
		return true;
	}
	/**
	 * 
	 * @param pv position 0 is "n", position n+3..n+3+n-1 is new permutation.
	 * @param override_pos increment this position. (override_pos>=n-2 has no effect)
	 * @return
	 */
	
	public static int[] nextPermutation(int[] pv, int override_pos) {
		int n=pv[0];
		if(n==1) {return pv;}// there is only one solution
		if(n==2) { // There is only one "next" solution .. override_pos does not apply
			pv[n+3]=1;
			pv[n+4]=0;
			return pv;
		}
		int p1 = pv[n+1];
		int p2 = pv[n+2];
		if(p1<p2 && override_pos!=-1 && override_pos>n-3) {
			pv[n+1]=p2;
			pv[n+2]=p1;
			pv[n+3+n-2]=p2;
			pv[n+3+n-1]=p1;
			// pair is already marked
			return pv;
		}
		// move previous to next value;
		int lastpos =n-3;
		// free up the pair
		pv[1+p1]=0;
		pv[1+p2]=0;

		
		boolean notFound=true;
		 // start search at next value
		if(override_pos>=0) {
			int i=override_pos+1;
			while(i<n-3) { // n-2 and n-1 have already been zero'ed (p1 and p2) 
				int chosenvalue = pv[n+3+i++];
				pv[1+chosenvalue]=0;
			}
			lastpos=override_pos;
			
		}
		
		while(notFound && lastpos>=0) {
			int plast = pv[n+3+lastpos];// get value at position we're trying to increment
			int i=plast+1;// search for an available bigger number
			pv[1+plast]=0; // release number we're going to increment
			while(notFound && i<n) {
				if(pv[1+i]==0) {
					notFound=false;
					pv[1+i]=1; // reserve it
					pv[n+3+lastpos]=i; // assign it as a solution
					// it remains to assign the pair
				} else {
					i++;
				}
			}
			if(notFound) {// move back one position in permutation pattern
				lastpos--;
			}
		}
		if(notFound) {
			// mark all pairs as used
			for(int i=0;i<n;i++) {pv[1+i]=1;}
			return pv;
		}
		// Fill up Rest of solution in increasing order
		int jleft=0; // scan through all flags for values
		for(int i=lastpos+1;i<n;i++) {
			notFound=true;
			while(notFound && jleft<n) {
				if(pv[1+jleft]==0) {
					pv[1+jleft]=1;
					pv[n+3+i]=jleft;
					notFound=false;
				}
			    jleft++;
			}
		}
		pv[n+1]=pv[pv.length-2];
		pv[n+2]=pv[pv.length-1];
		return pv;
		
	}
	
	
	public static String printPerm(int[] perm) {
		StringBuffer b = new StringBuffer();
		int n=perm[0];
		for(int i=n+3;i<perm.length;i++) {
			b.append(","+Integer.toString(perm[i]));
		}
		return b.toString().substring(1);
	}
	/* n=1 0
	 * n=2 0,1 : 1,0
	 * n=3 0,1,2 : 0,2,1 : 1,0,2 : 1,2,0 : 2,0,1 : 2,1,0
	 * n=4 0,1,2,3 : 0,1,3,2 : 0,2,1,3 : 0,2,3,1 : 0,3,1,2 : 0,3,2,1 : 1,0,2,3 : 1,0,3,2 : 1,2,0,3 : 1,2,3,0 ..
	 * n=5 0,1,2,3,4 : 0,1,2,4,3 : 0,1,2,4,3 : 0,1,3,2,4 : 0,1,3,4,2 : 0,1,4,2,3 : 0,1,4,3,2 : 0,2,
	 */
	public static boolean testPermutations() {
		String t1 =testPermutationsInternal(1);
		if(!t1.equals("0")) {
			System.err.println(t1);
			System.err.println("Failed permutation test for n=1");
			return false;
		}
		String t2 =testPermutationsInternal(2);
		if(!t2.equals("0,1 : 1,0")) {
			System.err.println(t2);
			System.err.println("Failed permutation test for n=2");
			return false;	
		}
		String t3 =testPermutationsInternal(3);
		if(!t3.equals("0,1,2 : 0,2,1 : 1,0,2 : 1,2,0 : 2,0,1 : 2,1,0")) { 
			System.err.println(t3);
			System.err.println("Failed permutation test for n=3");
			return false;
		}
		String t4 =testPermutationsInternal(4);
		String t4r="0,1,2,3 : 0,1,3,2 : 0,2,1,3 : 0,2,3,1 : 0,3,1,2 : 0,3,2,1 : 1,0,2,3 : 1,0,3,2 : 1,2,0,3 : 1,2,3,0 ";
		if(!t4.subSequence(0, t4r.length()).equals(t4r)) { 
			System.err.println(t4);
			System.err.println("Failed permutation test for n=4");
			return false;
		}
		String[] s5 = testPermutationsInternal(5).split(":");
		System.out.println("N=5 solutions");
		for(int i=0;i<s5.length;i++) {
			System.out.println(s5[i]);
		}
		return true;
	}
	public static  String testPermutationsInternal(int n) {
		int[] perm = Permutation.newPermutationVector(n);
		StringBuffer b = new StringBuffer(" : ");
		b.append(Permutation.printPerm(perm)); 
		while(!Permutation.isLastPerm(perm)) { 
			perm = Permutation.nextPermutation(perm,-1);
			b.append(" : ");
			b.append(Permutation.printPerm(perm)); 
		}
		return b.substring(3);
	}
	
	
	public static int[] resetPermutationVector(int[] pv) {
		int n=pv[0];
		for(int i=0;i<n;i++) {pv[n+3+i]=i;} // set initial solution
		int i=0;
		while(i<n) {//
			pv[1+i++]=1; //
		}
		// Set up Pair
		pv[n+1]=n-2;
		pv[n+2]=n-1;
		return pv;
	}
	public static int[] newPermutationVector(int psize) {
		int[] pv= new int[2*psize+3]; // First two positions are for housekeeping.
		pv[0]=psize;
		return Permutation.resetPermutationVector(pv);
	}
	
}
