package edu.mayo.genotype;
/**
 * Storage Object: An instance stores the state of the whole Cluster
 * 
 * @author Hugues Sicotte
 *
 */
public class ClusterState {
	private int[] edgeStatus=null; // 0 if Edge index is available for further selection, 1 otherwise
	private int[] binStatus=null; // 0 if Bin index is available for further selection, 1 otherwise
	private int[] edgeWeights=null; // Current edge weight 0,1,2 or bigger
	
	// Number of edgeStatus==0 that a bin has.
	private int[] binConnectivity = null;
	
	public int[] getBinConnectivity() {
		return binConnectivity;
	}
	public void setBinConnectivity(int[] binConnectivity) {
		this.binConnectivity = binConnectivity;
	}
	public int[] getBinStatus() {
		return binStatus;
	}
	public void setBinStatus(int[] binStatus) {
		this.binStatus = binStatus;
	}
	public int[] getEdgeStatus() {
		return edgeStatus;
	}
	public void setEdgeStatus(int[] edgeStatus) {
		this.edgeStatus = edgeStatus;
	}
	public ClusterState(Cluster c) {// Saves the state
		BinEdge[] edges = c.getEdges();
		Bin[] bins = c.getBins();
		int[] weights = c.getTemp_edgeWeights();
		edgeStatus = new int[edges.length];
		binStatus = new int[bins.length];
		edgeWeights = new int[weights.length];
		for(int i=0;i<edges.length;i++) {
			if(edges[i]!=null) {
				edgeStatus[i]=edges[i].getValidflag();
			}
		}
		for(int i=0;i<bins.length;i++) {
			if(bins[i]!=null) {
				binStatus[i]=bins[i].getStatus();
			}
		}
		for(int i=0;i<weights.length;i++) {
			edgeWeights[i]=weights[i];
		}
	}
	public ClusterState() { // Empty Constructor
		
	}
	
	public static ClusterState dup(ClusterState cs) {
		ClusterState csnew = new ClusterState();
		int[] oldEdgesStatus = cs.getEdgeStatus();
		int[] oldBinStatus = cs.getBinStatus();
		int[] oldWeights = cs.getEdgeWeights();
		
		int[] edgeStatus = new int[oldEdgesStatus.length];
		int[] binStatus = new int[oldBinStatus.length];
		int[] copyWeights = new int[oldWeights.length];
		for(int i=0;i<oldEdgesStatus.length;i++) {
			edgeStatus[i]=oldEdgesStatus[i];
		}
		for(int i=0;i<oldBinStatus.length;i++) {
			binStatus[i]=oldBinStatus[i];
		}
		for(int i=0;i<oldEdgesStatus.length;i++) {
			copyWeights[i]=oldWeights[i];
		}
		csnew.setEdgeStatus(edgeStatus);
		csnew.setBinStatus(binStatus);
		csnew.setEdgeWeights(copyWeights);
		
		return csnew;
	}
	public int[] getEdgeWeights() {
		return edgeWeights;
	}
	public void setEdgeWeights(int[] edgeWeights) {
		this.edgeWeights = edgeWeights;
	}
	

}
