package edu.mayo.genotype;

public class BinEdgeComp2 implements java.util.Comparator<BinEdge> {
	 public int compare(BinEdge be1, BinEdge be2)  {
	
		 if(be1==null && be2==null) {
			 return 0;
		 } else if (be1==null) {
			 return 1;
		 } else if (be2==null) {
			 return -1;
		 }
		  Snp s1 = be1.getMostReliableAvailableSnp();
		  Snp s2 = be2.getMostReliableAvailableSnp();
		  if(s1==null && s2==null) {
			  if(be1.getBinedgeid() < be2.getBinedgeid()) {
				  return -1;
			  } else if (be1.getBinedgeid() < be2.getBinedgeid()) {
				  return +1;
			  } else {
				  return 0;
			  }
		  } else if (s1==null) {
			  return +1;
		  } else if (s2==null) {
			  return -1;
		  }

		  double pro1 = s1.getSuccessProb();
		  double pro2 = s2.getSuccessProb();
		  if(pro1>pro2) {
			  return -1; // make bin-edges with max-pop-touching snps come first
		  } else if(pro1<pro2) {
			  return 1;
		  } else {
			 
			  double sco1 = s1.getScore();
			  double sco2 = s2.getScore();
			  if(sco1>sco2) {
				  return -1;
			  } else if(sco1<sco2) {
				  return 1;
			  }
			  int npop1 = s1.getNPop();
			  int npop2 = s2.getNPop();
			  if(npop1>npop2) {
				  return -1;
			  } else if (npop1<npop2) {
				  return 1;
			  }
			  
			  
			  Bin b11 = Bin.getBinById(be1.getBinid1());
			  Bin b12 = Bin.getBinById(be1.getBinid2());
			  Bin b21 = Bin.getBinById(be2.getBinid1());
			  Bin b22 = Bin.getBinById(be2.getBinid2());
			  int score1 = b11.getNbinedges()+b12.getNbinedges();
			  int score2 = b21.getNbinedges()+b22.getNbinedges();
			  if(score1>score2) {
				  return -1;
			  } else if (score1<score2) {
				  return 1;
			  } else {
				  // bin with lowest omaxscores should come first
				  double omaxscore11 = be1.getOmaxscore1();
				  double omaxscore12 = be1.getOmaxscore2();
				  double omaxscore21 = be2.getOmaxscore1();
				  double omaxscore22 = be2.getOmaxscore2();
				  double omaxscore1=omaxscore11+omaxscore12;
				  double omaxscore2 = omaxscore21+omaxscore22;
				  if(omaxscore1<omaxscore2) {
					  return -1;
				  } else if (omaxscore1>omaxscore2) {
					  return +1;
				  } else {
					  double mo1 = Math.max(omaxscore11,omaxscore12);
					  double mo2 = Math.max(omaxscore21,omaxscore22);
					  // bins with highest omax score shoudl come last
					  // so that highest scoring solutions are explored first.
					  if(mo1<mo2) {
						  return -1;
					  } else if (mo1>mo2) {
						  return 1;
					  } else {
						  // else make sure we have a consistent ordering
						  int beid1 = be1.getBinedgeid();
						  int beid2 = be2.getBinedgeid();
						  if(beid1<beid2) {
							  return -1;
						  } else if (beid1>beid2) {
							  return 1;
						  } else {
							  return 0;
						  }
						  
					  }
				  }
			  }
		  }
		 
	 }

}
