package test.edu.mayo.genotype;

import junit.framework.TestCase;
import java.util.LinkedHashSet;
import java.util.Iterator;
import java.lang.Integer;
import java.util.Set;
import edu.mayo.genotype.PowerSet;

public class PowerSetTest extends TestCase {

	public PowerSetTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public final void testPowerSetSetOfTBoolean() {

		edu.mayo.genotype.Population pop = new edu.mayo.genotype.Population();
		edu.mayo.genotype.Bin b = null;
		try { 
			b= new edu.mayo.genotype.Bin("bin1", pop.getId(),pop.getId());
		} catch (Exception e) {
			e.printStackTrace();
		}
		edu.mayo.genotype.Snp s = new edu.mayo.genotype.Snp(pop.getId(),"test",b.getId());
		LinkedHashSet<Integer> ss = new LinkedHashSet<Integer>();
		for(int i=0;i<32;i++) {
			ss.add(new Integer(i));
		}

		edu.mayo.genotype.PowerSet<Integer> pow =null;
		try {
			pow = new  edu.mayo.genotype.PowerSet<Integer>(ss,false);
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		
		assertEquals(0,pow.size()); // bug for 32 bits.
		assertEquals(1L<<32,pow.trueSize()); //true number of elements
		
		
		Iterator <PowerSet<Integer>.BitMaskSet> it = pow.iterator();

		assertTrue(it.hasNext());
		// 0
		edu.mayo.genotype.PowerSet<Integer>.BitMaskSet bm =it.next();
		assertEquals(0,bm.size());
		assertTrue(it.hasNext());

		//1 
		bm =  it.next();
		assertEquals(1,bm.size());
		Iterator<Integer> itp = bm.iterator();
		assertTrue(itp.hasNext());
		Integer ii = itp.next();
		assertEquals(0,ii.intValue());

		//2
		bm = it.next();
		assertEquals(1,bm.size());
		itp = bm.iterator();
		assertTrue(itp.hasNext());
		ii = itp.next();
		assertEquals(1,ii.intValue());

		//3
		bm = it.next();
		assertEquals(2,bm.size());
		itp = bm.iterator();
		assertTrue(itp.hasNext());
		int[] storage = new int[2];
		ii = itp.next();
		storage[ii.intValue()]=1;
		assertTrue(itp.hasNext());
		ii = itp.next();
		storage[ii.intValue()]=1;

		assertEquals(2,storage[0]+storage[1]);


		// Counting Backwards.
		edu.mayo.genotype.PowerSet<Integer> powr=null ;
		try {
			powr = new  edu.mayo.genotype.PowerSet<Integer>(ss,true);
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		assertEquals(0,powr.size()); // bug for 32 bits.
		assertEquals(1L<<32,powr.trueSize()); //true number of elements
		
		Iterator <PowerSet<Integer>.BitMaskSet> itr = powr.iterator();
		assertTrue(itr.hasNext());
		// FFFF has 32 bits set FFFE 11111111111111 11
		bm =itr.next();
		assertEquals(32,bm.size());
		
		
		assertTrue(itr.hasNext());

		//FFFE 11111111111111 10
		bm =  itr.next();
		assertEquals(31,bm.size());
		itp = bm.iterator();
		assertTrue(itp.hasNext());
		ii = itp.next();
		assertEquals(1,ii.intValue()); /// 0th bit is zero

		//FFFD 11111111111111 01
		bm = itr.next();
		assertEquals(31,bm.size());
		itp = bm.iterator();
		assertTrue(itp.hasNext());
		ii = itp.next();
		assertEquals(0,ii.intValue());
		ii = itp.next();
		assertEquals(2,ii.intValue());
		
		//FFFC  11111111111111 00
		bm = itr.next();
		assertEquals(30,bm.size());
		itp = bm.iterator();
		assertTrue(itp.hasNext());
		ii = itp.next();
		assertEquals(2,ii.intValue());
		ii = itp.next();
		assertEquals(3,ii.intValue());




		
		

	}

}
