package edu.mayo.genotype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Set;
import java.util.List;

public class SolutionTracker  {
	private double _score=-Double.MAX_VALUE;
	private double _sumFuncClass=0.0;
	private int _ntags=0;
	private boolean _hasSolution=false;
	private int _nbins=0;
	private boolean _hasCompleteSolution=false;
	private int _nNecessaryButNotPicked=0; // Number of SNPs that are necessary but were not in this solution
	private double _totScore=0.0;
	private int _tried=0; // number of times tried to compare this solution.
	
	private int _snpsFullfillingQuota=0;
	private int _nMissing=0;
	private int _nObligates=0;
	private int _maxObligates=0; // If there are too-close clusters of obligates only,
					    // maxObligates is the result of applying the OPA assigning algorithm to
	                    // the obligates only.
	int _nbeads=0;
	
	public SolutionTracker() {
		
	}
	public void setNBeads(int nbeads) {
              this._nbeads = nbeads;
	}
	public int getNBeads() {
		return this._nbeads;
	}
	public void incTried() {_tried++;}
	public int getTried() {return _tried;}
	public int getNtags() {
		return this._ntags;
	}
	public void setNtags(int ntags) {
		this._ntags = ntags;
	}
	public double getScore() {
		return this._score;
	}
	public void setScore(double score) {
		this._score = score;
		this._hasSolution=true;
	}
	public double getSumFuncClass() {
		return this._sumFuncClass;
	}
	public void setSumFuncClass(double sumFuncClass) {
		this._sumFuncClass = sumFuncClass;
	}
	public boolean hasSolution() {
		return this._hasSolution;
	}
	public void setHasSolution(boolean hasSolution) {
		this._hasSolution = hasSolution;
	}
	public int getNbins() {
		return this._nbins;
	}
	public void setNbins(int nbins) {
		this._nbins = nbins;
	}
	public void setHasCompleteSolution() {
		_hasCompleteSolution=true;
	}
	public boolean hasCompleteSolution() {
		return this._hasCompleteSolution;
	}
	public boolean isHasCompleteSolution() {
		return this._hasCompleteSolution;
	}
	public void setHasCompleteSolution(boolean hasCompleteSolution) {
		this._hasCompleteSolution = hasCompleteSolution;
	}
	public int getNNecessaryButNotPicked() {
		return this._nNecessaryButNotPicked;
	}
	public void setNNecessaryButNotPicked(int necessaryButNotPicked) {
		this._nNecessaryButNotPicked = necessaryButNotPicked;
	}
	public double getTotScore() {
		return this._totScore;
	}
	public void setTotScore(double totScore) {
		this._totScore = totScore;
	}
	public int getSnpsFullfillingQuota() {
		return this._snpsFullfillingQuota;
	}
	public void setSnpsFullfillingQuota(int snpsFullfillingQuota) {
		this._snpsFullfillingQuota = snpsFullfillingQuota;
	}
	public int getNMissing() {
		return this._nMissing;
	}
	public void setNMissing(int missing) {
		this._nMissing = missing;
	}
	
	
	
	
	/**
	 * Update the Best Score in the solution Tracker Object
	 * a complete solution is one that covers all bins.
	 * a super-complete solution also includes all obligates.(if there are collisions)
	 * @param binsToPick
	 * @param soln
	 */
	public static int updateTmpScore(Bin[] binsToPick,SolutionTracker soln) {
		//if this is the last bin, last SNP processed, look to see if this is
		// the best scoring solution. (only add up scores in danger_zone)
		//   Score by Summing over bins
		if(SNPPicker.verbose) {
			System.out.println("entering updateTmpScore");System.out.flush();
		}

		
		HashMap<Bin,Integer> bins2pick =new HashMap<Bin,Integer>();
		for(int k=0;k<binsToPick.length;k++) {
			Bin bp=binsToPick[k];
			if(bp!=null) {
				if(!bins2pick.containsKey(bp)) {
					bins2pick.put(bp,Integer.valueOf(1));
				} else {
					// Here we count the count of bins in binsToPick in order to figure out b.getNSB()
					// This allows us to "delete" bins from the recursive chain if the upper level SNPs satisfy
					// the minimum probability condition with less than NSB snps(Number of Snps per Bin)
					bins2pick.put(bp, Integer.valueOf((bins2pick.get(bp)).intValue()+1));
				}
			}
		}
		
		return updateTmpScore(bins2pick,soln);
	}
	
	
	/**
	 * Update the Best Score in the solution Tracker Object
	 * a complete solution is one that covers all bins.
	 * a super-complete solution also includes all obligates.(if there are collisions)
	 * This version only requires one copy of each bin in the list and takes the NSB from the b.getNSB()
	 * @param binsToPick
	 * @param soln
	 */
	public static int updateTmpScore2(Bin[] binsToPick,SolutionTracker soln) {
		//if this is the last bin, last SNP processed, look to see if this is
		// the best scoring solution. (only add up scores in danger_zone)
		//   Score by Summing over bins
		if(SNPPicker.verbose) {
			System.out.println("entering updateTmpScore");System.out.flush();
		}

		
		HashMap<Bin,Integer> bins2pick =new HashMap<Bin,Integer>();
		for(int k=0;k<binsToPick.length;k++) {
			Bin bp=binsToPick[k];
			if(bp!=null) {
				if(!bins2pick.containsKey(bp)) {
					bins2pick.put(bp,Integer.valueOf(bp.getNSB()));
				}
			}
		}
		
		return updateTmpScore(bins2pick,soln);
	}

	

	public static int updateTmpScore(HashMap<Bin,Integer> bins2pick,SolutionTracker soln) {
		 
		 return updateTmpScore(bins2pick,soln,true);
	 }
	
	
	/**
	 * Update the Best Score in the solution Tracker Object
	 * a complete solution is one that covers all bins.
	 * a super-complete solution also includes all obligates.(if there are collisions)
	 * @param bins2Pick
	 * @param soln
	 */
	public static int updateTmpScore(HashMap<Bin,Integer> bins2pick,SolutionTracker soln,boolean saveSolution) {
		//if this is the last bin, last SNP processed, look to see if this is
		// the best scoring solution. (only add up scores in danger_zone)
		//   Score by Summing over bins
		if(SNPPicker.verbose) {
			System.out.println("entering");System.out.flush();
		}
		if(bins2pick==null) return 0;
		Set<Map.Entry<Bin,Integer>> b2pes=bins2pick.entrySet();
		if(b2pes==null || b2pes.size()==0) {
			return 0;
		}
		
		double score = 0.0; // total bin score summed (weight of bin size and probability)
		double totscore=0.0; // SNP RAW Score, not weighted probability.
		double sumFuncClass=0.0;
		soln.incTried();
		int ns2p=0;	

		int hashSize=20;
		if(bins2pick!=null) {
			hashSize=2*bins2pick.size();
		}
		HashMap<Snp,Integer> countSnps=new HashMap<Snp,Integer>(hashSize);
		HashMap<String,String> countNecessary=new HashMap<String,String>(hashSize);
		HashMap<String,String> countMissingObligates=new HashMap<String,String>(hashSize);
		HashMap<String,String> countObligates=new HashMap<String,String>(hashSize);
		HashSet<Integer> countBins = new HashSet<Integer>(hashSize);
		
		Iterator<Map.Entry<Bin,Integer>> itb = b2pes.iterator();
		boolean completeSoln=true;

		int total_snps_needed=0;
		int nMissing=0;
		StringBuffer snpString = new StringBuffer();
		int nrSnpsbeads=0;
		while(itb.hasNext()) {
			Map.Entry<Bin,Integer> me = (Map.Entry<Bin,Integer>) itb.next();
			Bin bp = me.getKey();
			Integer ibp =  me.getValue();
			int needed = ibp.intValue();
		
			total_snps_needed+=needed; // Maximum needed - not taking overlap into account.

			int nSelected=0;
			int nAdditionalSelected=0;
			Snp[] tss=bp.getSnps();
			int navail=0;
			if(tss!=null) {
				score+= bp.getBinTmpScore(); // Proper Probability based Score with risk factor included
				for(int i=0;i<tss.length;i++) {
					Snp s = tss[i];
					if(s!=null && !s.isExcluded()) {
						String sid = Integer.toString(s.getId());
 						if(!(s.isTmpSelected()  ||  s.isObligateButNotGenotyped())) {
							if(s.isUniquelyCovers())  {
								countNecessary.put(sid,"1"); // Necessary SNPs (for at least one bin) not in solution
							}
						}
						if(!(s.isObligateButNotGenotyped())) {// Excluded alredy filtered out
							navail++; // SNP available for picking (Includes Fixed SNPs.. which will be pickable later)
						}
						if(s.isObligate()) {
							if(!s.isTmpSelected() ) {
								countMissingObligates.put(sid,"1");
							} else  {
								countObligates.put(sid,"1");
							}
						}
						if((s.isTmpSelected())  ) {
							if(!countSnps.containsKey(s)) {
								countSnps.put(s,Integer.valueOf(1));
								nAdditionalSelected++; // not already selected by another bin.
								totscore+=s.getScore(); // RAW SNP Score, not weighted probability.
								nrSnpsbeads+=s.getNI2beads();
								snpString.append(",");
								snpString.append(s.getSnpName());
							}
							nSelected++; // includes selected obligates
						}
					}
				} //for
			} // if (tss!=null)

			if(nSelected>0) {
				countBins.add(Integer.valueOf(bp.getId()));
			}
			if(nSelected<needed) {// less than requested
				// This counting takes into account overlapping bins with SNPs in common
				if(SNPPicker.minP<1.0d && bp.getTmpProb()>= SNPPicker.minP) {
					// Solution remains complete.
				} else {
					int incMissing = Math.max(0,Math.min(needed,navail)-nSelected);
					if(incMissing>0 ) {
						completeSoln=false; //irreversible: If any bin is partially covered==> incomplete solution.
						nMissing +=incMissing;
					}
				}
				ns2p+=nAdditionalSelected;
			} else {
				ns2p+=Math.min(nAdditionalSelected,needed); // only add to nb2p as much as needed to not reward solutions with too many SNPs.
			}
			sumFuncClass+=bp.getTmpSumFuncClass(); // Higher Class is better.

		} // while(itb.hasNext

		int bins1covered=countBins.size();
		
		int nrSnps = countSnps.size(); //## Number of selected Beads
		if(nrSnps==0) {
			if(SNPPicker.verbose) {
				System.out.println("SNPPicker: no snps selected");System.out.flush();
			}
			return 0;
		}		
		int missingObligates = countMissingObligates.size();
		int tnObligates = countObligates.size();

		if(nrSnpsbeads>0) {
			totscore=totscore/((double)nrSnpsbeads); // This totscore does not compound probabilities
			score = score/((double)nrSnpsbeads); // Proper Bin Score per bead
		} else {
			totscore=0.0d;
			score=0.0d;
		}
//		int nNecessaryButNotPicked = countNecessary.size();

		// bigger nb2p is better.
//		if(SNPPicker.verbose) {
//			System.out.println("Snps selected="+nrSnps+",snp needed="+total_snps_needed+",snps fulfilling the need="+ns2p+",missing obligates="+countMissingObligates.size()+",bins needed="+bins2pick.size()+",bins covered="+bins1covered+",snps necessary_not_picked="+nNecessaryButNotPicked+",func="+sumFuncClass+",snpscores="+totscore);
//		}
		String msg="";
		if(!soln.hasSolution()) {
			//msg="new solution";
		} else if (soln.getNbins()>bins1covered) {
			return 0;// old solution had better coverage
		} else if(soln.getNbins()<bins1covered) {
			// new solution has better coverage
		} else  {//if(soln.getNbins()==bins1covered)
			if(soln.getNObligates() >tnObligates) {
				return 0;
			} else if(soln.getNObligates() <tnObligates) {
				//msg="better obligate coverage";
			} else {
				// nNecessaryButNotPicked and nMissing work together with score.
				// There is no guaranty that a necessary SNP is actually pickable, but all solutions
				// will have the same constraint.
//				if(nNecessaryButNotPicked>soln.getNNecessaryButNotPicked()){
//					return 0;
//				} else if (nNecessaryButNotPicked<soln.getNNecessaryButNotPicked()) {
//					//msg="Better coverage";
//				} else { 
					if(nMissing>soln.getNMissing()){
						return 0;
					} else if (nMissing<soln.getNMissing()) {
						//msg="Better coverage";
					} else { 

						if(soln.getScore()>score) {
							return 0;
						} else if(soln.getScore()<score) {

						} else {// score equa
							if(sumFuncClass>soln.getSumFuncClass()) {
								msg="better functional score";
							} else if (sumFuncClass<soln.getSumFuncClass()){
								return 0;
							} else {
								if(nrSnpsbeads>soln.getNBeads()) {
									return 0;
								} else if (nrSnpsbeads<soln.getNBeads()){
									//msg="less beads";
								} else {
									if(totscore <soln.getTotScore()) {
										return 0;
									} else if (totscore >soln.getTotScore()) {
										//msg="better totscore";
									} else {
										return 0; // tied - keep first solution.
									}
								}
							}
						}

					}
				//}
			}
		}
		 

		boolean solutionOK=true;

		// Make sure this solution does not violate the nOPA constraint.
		if(SNPPicker.tooClose!=0 && SNPPicker.nOPA>=0) {
			int needOPA = Snp.nOPAForTmpSolution(bins2pick,true,SNPPicker.nOPA); // Count Number of OPA needed to store without conflict Stop early as soon as reach nOPA
			if((SNPPicker.nOPA>0 && needOPA>SNPPicker.nOPA) || (SNPPicker.nOPA==0 && needOPA>1)) {
				solutionOK=false;
			}
		}
		
		if(solutionOK) {
			// We're taking this solution ... whether complete or partial.
			soln.setHasSolution(true);
			soln.setNObligates(tnObligates);
			soln.setNMissing(nMissing);
			soln.setScore(score);
			soln.setSumFuncClass(sumFuncClass);
			soln.setNtags(nrSnps);
			soln.setNbins(bins1covered);
			soln.setSnpsFullfillingQuota(ns2p);
 //			soln.setNNecessaryButNotPicked(nNecessaryButNotPicked);
			soln.setTotScore(totscore);
			soln.setNBeads(nrSnpsbeads);
			if(saveSolution) {
				SolutionTracker.moveToBestSoFar(bins2pick);
			}
//			if(SNPPicker.verbose) {
//				System.out.println("covered bins="+bins1covered+",included obligates="+tnObligates+"(missing obligs="+missingObligates+"), nMissing="+nMissing+",necessarynotpicked="
//						+nNecessaryButNotPicked +", score="+score+", sumFuncClass="+sumFuncClass+",totscore="+totscore);
//			}
			if(completeSoln) { // Complete Solution
				soln.setHasCompleteSolution(true);
				if(SNPPicker.verbose) {
					System.out.println("soln_track: exiting: found Complete Solution with selected SNPs="+(snpString.length()>0 ? snpString.substring(1) : "NONE!"));
				}
				return 1;
			}
			//		if(SNPPicker.verbose) {
			if(!msg.equals("first solution")) {
				if(SNPPicker.verbose) {
					System.out.println("soln_track: "+msg+" : found solution with selected SNPs="+(snpString.length()>0 ? snpString.substring(1) : "NONE!"));
				}
			}
			soln.setHasCompleteSolution(false);
			return 1; // partial solution .. but better
		} else {
			return 0;
		}

	}
	
	public static void moveToBestSoFar(HashMap<Bin,Integer>  bins2pick) {
		{
			Iterator<Bin> itb2 = bins2pick.keySet().iterator();
			while(itb2.hasNext()) {
				Bin bp=itb2.next();
				bp.pickBestSoFar(true);
			}
		}
	}
	
	
	/**
	 * Initializes OPA id to avoid conflicts in Obligates 
	 */
	public void computeMaxObligates(List<Snp> snpsInCluster) {
		if(snpsInCluster==null || snpsInCluster.size()==0) {
			this._maxObligates=0;
			return;
		}
		TreeSet<Snp> sortedByPosAll = new TreeSet<Snp>(new SnpOrderComparator());
		for(int i=0;i<snpsInCluster.size();i++) {
			Snp s = (Snp) snpsInCluster.get(i);
			if(s!=null && s.isObligate() && !s.isExcluded()) {
				sortedByPosAll.add(s);
			}
		}

		Iterator<Snp> its =sortedByPosAll.iterator();
		Snp[] ssnps = new Snp[sortedByPosAll.size()];

		int i=0;
		while(its.hasNext()) {
			Snp s =  its.next();
			ssnps[i++]=s;
			s.resetTmpSolution(false); // otherwise countInTmpSelWin won't work.
			s.setOPAid(-1);
		}
		int maxOPA=0; // This code will find out the minimum number of OPA's it would take to fit all those too-close SNPs.
		int nOPA = SNPPicker.getNOPA();
		HashMap<Integer,Integer> cntInOPA = new HashMap<Integer,Integer>();
		for(int j=0;j<i;j++) {
			Snp s = ssnps[j];
			// count obligates (selected or not) in window.
			if(s!=null) {
				if(s.isExcluded()) {
					s.setOPAid(-1);
				} else {
					// Find the window around the SNP with the maximum of selected/obligates.
					int nin = Snp.countTmpSelInWin(ssnps,j,SNPPicker.tooClose,true);// Count selected/obligates in window.
					int opaid=0;
					
					while(nin>nOPA) {
						opaid++;
						s.setOPAid(opaid);
						nin = Snp.countInSameOPa(ssnps,j,SNPPicker.tooClose,opaid,true); // include all non-excluded obligates.. 
					}
					// opaid 0 means no-conflicts, opaid!=0 means exclusive sets.
					s.setOPAid(opaid);
					if(opaid>maxOPA) {
						maxOPA=opaid;
					}
				}
			}
		}
		this._maxObligates = maxOPA;

	} // computeMaxObligates
	public int getNObligates() {
		return this._nObligates;
	}
	public void setNObligates(int obligates) {
		this._nObligates = obligates;
	}

	

	
}
