package edu.mayo.genotype;

import java.util.Comparator;
import java.util.ArrayList;


/**
 * 
 * @author hugues sicotte
 *
 */
public class SnpTooCloseBinOrderComparator implements Comparator<Bin> {
	/*
    create binTopick = Array of binids to pick a Snp from. (if have Nsb>1, put Nsb copies of Bin in List)
    				   Order is Bins with only 1 choice
    				   then bins with minimum amount of alternative to putting their SNPs in the danger zone(e.g. bins who have to pick the most of their SNPs in the danger zone)
					   and minimal number of alternative SNPs to pick in the danger zone
    				   minimal snps_available_for_picking_not_in_dangerzone-Nsb .. if negative ==> must pick Snps in Danger zone
    				   .. If positive or 0 ==> don't Have to pick Snp in danger zone
    				   then, if equal, minimal snps_in_danger_zone
    				   then the bins with minimal Snps_not_in_danger zone.
    				   
    				   
    				   If a Bin is full, exclude from binToPick list.
   
	 */
	ArrayList<Snp> snpsInDangerZone = null; // Array of Snp objects in Danger Zone.
	
	public SnpTooCloseBinOrderComparator(ArrayList<Bin> binList,Snp[] snpsInDangerZ) {
		this.snpsInDangerZone = new ArrayList<Snp>();
		if(snpsInDangerZ!=null) {
			for(int i=0;i<snpsInDangerZ.length;i++) {
				Snp s = snpsInDangerZ[i];
				if(s!=null) {
					this.snpsInDangerZone.add(snpsInDangerZ[i]);
				}
			}
		}
	}
	
	private int getAvailableSnpsInDangerZone(Bin b) {
		int[] ss = b.getAvailableSnpIds(false);
		if(ss==null) {
			return 0;
		}
		int nInDanger = 0;
		
		for(int i=0;i<ss.length;i++) {
			for(int j=0;j<snpsInDangerZone.size();j++) {
				if(((Snp) snpsInDangerZone.get(j)).getId() == ss[i]) {
					nInDanger++;
					break;
				}
			}
		}
		return nInDanger;
	}
	
	private int getAvailableSnpsNotInDangerZone(Bin b) {
		int[] ss = b.getAvailableSnpIds(false);
		if(ss==null) {
			return 0;
		}
		int nInDanger = ss.length;
		
		for(int i=0;i<ss.length;i++) {
			for(int j=0;j<snpsInDangerZone.size();j++) {
				if(((Snp) snpsInDangerZone.get(j)).getId() == ss[i]) {
					nInDanger--;
					break;
				}
			}
		}
		return nInDanger;
	}
	
	public int compare(Bin b1, Bin b2) {


		int b1nd = getAvailableSnpsNotInDangerZone(b1);
		int b2nd = getAvailableSnpsNotInDangerZone(b2);
		int nsb1 = b1.getNSB();
		int nsb2 = b2.getNSB();
		
		int extrasnps1 = nsb1-b1nd;
		int extrasnps2 = nsb2-b2nd;
		if(extrasnps1>extrasnps2) { // most choices
			return -1;
		} else if (extrasnps1<extrasnps2) { // least choices
			return 1;
		} else {
			int b1d = getAvailableSnpsInDangerZone(b1);
			int b2d = getAvailableSnpsInDangerZone(b2);
			if(b1d<b2d) { // least # of snps to pick in danger zone
				return -1;
			} else if(b1d>b2d) {
				return +1;
			} else {
				if(b1d>b2d) { // least # of snps to pick in danger zone
					return -1;
				} else if(b1d<b2d) {
					return +1;
				} else {
					if(nsb1<nsb2) {
						return -1;
					} else if (nsb1>nsb2) {
						return +1;
					} else {
						int id1 = b1.getId();
						int id2 = b2.getId();
						if(id1<id2) {
							return -1;
						} else if (id1>id2) {
							return +1;
						} else {
							return 0;
						}
					}
				}
			}
		}
		
	}

}
