package edu.mayo.genotype;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Properties;
public class  SnpScorer {
		private static HashMap<String,Float> classMappings=new HashMap<String,Float>();
		/*
		Default Snp categories were selected using the SIFT/polyphen categorization as well as dbSNP and other tools.
		1+(importance)(1/(r^2)-1)/10  [should use exact r^2, but in this implementation, use parameter r^2]

		importance	Snp Categories (they are arbitrary, since any String defined in configfile will override]
				15		nonsyn-linked				Linked to a disease (suggest use obligate instead)
				10		nonsyn-intolerant			computational prediction of intelorance
				10		nonsyn-probablydamaging		computational prediction of intelorance.
				10		nonsyn-possiblydamaging
				10		coding-nonsyn                     (unknown syn)
				8		nonsyn-tolerant
				8		nonsyn-benign
				8		splice
				5		factor
				5		polyasignal
				5		initiation
				5		genomicconserved
				4		coding						unknown wether SYN or non-syn
				4		3UTR
				3		5UTR
				3		UTR							Illumina category.. how come they don't know which UTR?
				2		flanking_3UTR				Illumina category
				2		flanking_5UTR				Illumina category
				2		coding-SYNON							synonymous substitution
				1		intron
				0		unspecified					This is the default for no preference.
				-1		repeat        				(Hard to genotype)
				-1		microsat      				(hard to genotype)
				-1		lowcomplexity  				(hard to genotype)
				-5		indel						impossible to genotype on most platforms.
				-5		msnp						impossible to genotype on most platforms
*/
		static {
			
// These can be overwritten in "Main" -- Note that they are tied to mapping to ld-select classes.
			classMappings.put("nonsyn-linked",new Float(1.0*15));
			classMappings.put("nonsyn-intolerant",new Float(1.0*10));
			classMappings.put("nonsyn-probablydamaging",new Float(1.0*10));
			classMappings.put("nonsyn-possiblydamaging",new Float(1.0*10));
			classMappings.put("coding-nonsyn",new Float(1.0*10));
			classMappings.put("nonsyn",new Float(1.0*10));
			classMappings.put("nonsyn-tolerant",new Float(1.0*8));
			classMappings.put("nonsyn-benign",new Float(1.0*8));
			classMappings.put("splice",new Float(1.0*8));
			classMappings.put("factor",new Float(1.0*5));
			classMappings.put("polyasignal",new Float(1.0*5));
			classMappings.put("initiation",new Float(1.0*5));
			classMappings.put("genomicconserved",new Float(1.0*5));
			classMappings.put("coding",new Float(1.0*4));
			classMappings.put("coding-unknown",new Float(1.0*4));
			classMappings.put("3utr",new Float(1.0*4));
			classMappings.put("5utr",new Float(1.0*3));
			classMappings.put("utr",new Float(1.0*3));
			classMappings.put("flanking_3utr",new Float(1.0*2));
			classMappings.put("flanking_5utr",new Float(1.0*2));
			classMappings.put("flanking",new Float(1.0*2));
			classMappings.put("coding-synon",new Float(1.0*2));
			classMappings.put("synon",new Float(1.0*2));
			classMappings.put("intron",new Float(1.0*1));
			classMappings.put("unknown",new Float(0.0));
			classMappings.put("repeat",new Float(-1.0));
			classMappings.put("microsat",new Float(-1.0));
			classMappings.put("lowcomplexity",new Float(-1.0));
			classMappings.put("indel",new Float(-5.0));
			classMappings.put("msnp",new Float(-5.0));
			
		}
		public SnpScorer() {
		}
		public static HashMap getClassMapping(){ 
			return classMappings;
		}
		/**
		 * 
		 * @param map containing Float and indexed by a String.
		 */
		public static void setClassMapping(HashMap map){
			classMappings = map;
		}
		/**
		 * Compute the modified Score for a SNP relative to a other Snps in that bin.
		 * @param s
		 * @param rsquare
		 * @return
		 */
		public static double scoreSnp(Snp s,double rsquare) {
			// Will access the Bin information if it needs it.
			/*
			Default Snp categories were selected using the SIFT/polyphen categorization as well as dbSNP and other tools.
			1+(importance)(1/(r^2)-1)/10  [should use exact r^2, but in this implementation, use parameter r^2]
			 */
			double cm = getLocationClassScore(s.getLocation());
			double f=1.0+cm*(1.0/rsquare-1.0)/10;
			return f;
		}
		public static double getLocationClassScore(String tlocationClass) {
			String locClass = tlocationClass;
			if(tlocationClass!=null) {
				locClass = locClass.toLowerCase();
			}
			Float f = null;
			if(classMappings.containsKey(locClass)){
				f=(Float)classMappings.get(locClass);
			}
			if(f!=null) {
				return f.doubleValue();
			} else {
				return 0.0;
			}
		}
		/**
		 * 
		 * @return a hashmap with the ldselect mappings.
		 */
		public static HashMap<String,String> readClassMappings(Properties props,Set<String> ldselectKeys) throws Exception {
			Set propKeys = props.keySet();
			HashMap<String,String> ldSelectMappings = new HashMap<String,String>();
			HashMap<String,Float> newClassMappings = new HashMap<String,Float>();
			Iterator<String> it = propKeys.iterator();
			while(it.hasNext()) {
				String key = it.next();
				String val = props.getProperty(key);
				if(ldselectKeys.contains(key)) {
					ldSelectMappings.put(key, val);
				} else {
					try {
						newClassMappings.put(key, Float.parseFloat(val));
					} catch (Exception e) {
						System.err.println("Invalid Float format "+val+" in property file for functional Class Mappings");
						System.err.flush();
						throw new Exception("SNPPicker::edu.mayo.genotype.SnpScorer.readClassMappings: Invalid Float format "+val+" in property file for functional Class Mappings");
					}
				}
			}
			SnpScorer.setClassMapping(newClassMappings);
			return ldSelectMappings;
		}
		
}
